/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class JurisdictionUtilities {
    public static Coding getJurisdictionCodingFromLocale(String s) {
        String v = JurisdictionUtilities.getJurisdictionFromLocale(s);
        return v == null ? null : CodeSystemUtilities.readCoding(v);
    }

    public static String getJurisdictionFromLocale(String s) {
        if (s == null) {
            return null;
        }
        if (Utilities.existsInList((String)s.toUpperCase(), (String[])new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BQ", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CW", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MF", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "SS", "ST", "SV", "SX", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW"})) {
            return "urn:iso:std:iso:3166#" + s.toUpperCase();
        }
        switch (s) {
            case "uv": {
                return "http://unstats.un.org/unsd/methods/m49/m49.htm#001";
            }
            case "world": {
                return "http://unstats.un.org/unsd/methods/m49/m49.htm#001";
            }
            case "global": {
                return "http://unstats.un.org/unsd/methods/m49/m49.htm#001";
            }
        }
        return null;
    }

    public static String displayJurisdiction(String s) {
        return JurisdictionUtilities.displayJurisdiction(CodeSystemUtilities.readCoding(s));
    }

    public static String displayJurisdictionShort(String s) {
        String d = JurisdictionUtilities.displayJurisdiction(CodeSystemUtilities.readCoding(s));
        if (d.contains("(")) {
            d = d.substring(0, d.indexOf("(")).trim();
        }
        return d;
    }

    public static String displayJurisdictionShort(Coding c) {
        String d = JurisdictionUtilities.displayJurisdiction(c);
        if (d.contains("(")) {
            d = d.substring(0, d.indexOf("(")).trim();
        }
        return d;
    }

    public static String displayJurisdiction(Coding c) {
        if (c == null) {
            return "No Jurisdiction";
        }
        switch (c.getSystem()) {
            case "http://unstats.un.org/unsd/methods/m49/m49.htm": {
                return JurisdictionUtilities.region(c);
            }
            case "urn:iso:std:iso:3166": {
                return JurisdictionUtilities.country(c);
            }
            case "urn:iso:std:iso:3166:-2": {
                if (c.getCode().charAt(0) <= 'E') {
                    return JurisdictionUtilities.stateAE(c);
                }
                if (c.getCode().charAt(0) <= 'L') {
                    return JurisdictionUtilities.stateFL(c);
                }
                if (c.getCode().charAt(0) <= 'R') {
                    return JurisdictionUtilities.stateMR(c);
                }
                return JurisdictionUtilities.stateSZ(c);
            }
        }
        return "Unknown Jurisdiction '" + c.getSystem() + "#" + c.getCode() + "'";
    }

    private static String stateAE(Coding c) {
        switch (c.getCode()) {
            case "AD-02": {
                return "Canillo (Andorra)";
            }
            case "AD-03": {
                return "Encamp (Andorra)";
            }
            case "AD-04": {
                return "La Massana (Andorra)";
            }
            case "AD-05": {
                return "Ordino (Andorra)";
            }
            case "AD-06": {
                return "Sant Juli\u00e0 de L\u00f2ria (Andorra)";
            }
            case "AD-07": {
                return "Andorra la Vella (Andorra)";
            }
            case "AD-08": {
                return "Escaldes-Engordany (Andorra)";
            }
            case "AE-AJ": {
                return "'Ajm\u0101n (United Arab Emirates)";
            }
            case "AE-AZ": {
                return "Ab\u016b Z\u0327aby (United Arab Emirates)";
            }
            case "AE-DU": {
                return "Dubayy (United Arab Emirates)";
            }
            case "AE-FU": {
                return "Al Fujayrah (United Arab Emirates)";
            }
            case "AE-RK": {
                return "Ra's al Khaymah (United Arab Emirates)";
            }
            case "AE-SH": {
                return "Ash Sh\u0101riqah (United Arab Emirates)";
            }
            case "AE-UQ": {
                return "Umm al Qaywayn (United Arab Emirates)";
            }
            case "AF-BAL": {
                return "Balkh (Afghanistan)";
            }
            case "AF-BAM": {
                return "B\u0101my\u0101n (Afghanistan)";
            }
            case "AF-BDG": {
                return "B\u0101dgh\u012bs (Afghanistan)";
            }
            case "AF-BDS": {
                return "Badakhsh\u0101n (Afghanistan)";
            }
            case "AF-BGL": {
                return "Baghl\u0101n (Afghanistan)";
            }
            case "AF-DAY": {
                return "D\u0101ykund\u012b (Afghanistan)";
            }
            case "AF-FRA": {
                return "Far\u0101h (Afghanistan)";
            }
            case "AF-FYB": {
                return "F\u0101ry\u0101b (Afghanistan)";
            }
            case "AF-GHA": {
                return "Ghazn\u012b (Afghanistan)";
            }
            case "AF-GHO": {
                return "Gh\u014dr (Afghanistan)";
            }
            case "AF-HEL": {
                return "Helmand (Afghanistan)";
            }
            case "AF-HER": {
                return "Her\u0101t (Afghanistan)";
            }
            case "AF-JOW": {
                return "Jowzj\u0101n (Afghanistan)";
            }
            case "AF-KAB": {
                return "K\u0101bul (Afghanistan)";
            }
            case "AF-KAN": {
                return "Kandah\u0101r (Afghanistan)";
            }
            case "AF-KAP": {
                return "K\u0101p\u012bs\u0101 (Afghanistan)";
            }
            case "AF-KDZ": {
                return "Kunduz (Afghanistan)";
            }
            case "AF-KHO": {
                return "Kh\u014dst (Afghanistan)";
            }
            case "AF-KNR": {
                return "Kunar (Afghanistan)";
            }
            case "AF-LAG": {
                return "Laghm\u0101n (Afghanistan)";
            }
            case "AF-LOG": {
                return "L\u014dgar (Afghanistan)";
            }
            case "AF-NAN": {
                return "Nangarh\u0101r (Afghanistan)";
            }
            case "AF-NIM": {
                return "N\u012bmr\u014dz (Afghanistan)";
            }
            case "AF-NUR": {
                return "N\u016brist\u0101n (Afghanistan)";
            }
            case "AF-PAN": {
                return "Panjshayr (Afghanistan)";
            }
            case "AF-PAR": {
                return "Parw\u0101n (Afghanistan)";
            }
            case "AF-PIA": {
                return "Paktiy\u0101 (Afghanistan)";
            }
            case "AF-PKA": {
                return "Pakt\u012bk\u0101 (Afghanistan)";
            }
            case "AF-SAM": {
                return "Samang\u0101n (Afghanistan)";
            }
            case "AF-SAR": {
                return "Sar-e Pul (Afghanistan)";
            }
            case "AF-TAK": {
                return "Takh\u0101r (Afghanistan)";
            }
            case "AF-URU": {
                return "Uruzg\u0101n (Afghanistan)";
            }
            case "AF-WAR": {
                return "Wardak (Afghanistan)";
            }
            case "AF-ZAB": {
                return "Z\u0101bul (Afghanistan)";
            }
            case "AG-03": {
                return "Saint George (Antigua and Barbuda)";
            }
            case "AG-04": {
                return "Saint John (Antigua and Barbuda)";
            }
            case "AG-05": {
                return "Saint Mary (Antigua and Barbuda)";
            }
            case "AG-06": {
                return "Saint Paul (Antigua and Barbuda)";
            }
            case "AG-07": {
                return "Saint Peter (Antigua and Barbuda)";
            }
            case "AG-08": {
                return "Saint Philip (Antigua and Barbuda)";
            }
            case "AG-10": {
                return "Barbuda (Antigua and Barbuda)";
            }
            case "AG-11": {
                return "Redonda (Antigua and Barbuda)";
            }
            case "AI-AI": {
                return "Anguilla (Anguilla)";
            }
            case "AL-01": {
                return "Berat (Albania)";
            }
            case "AL-02": {
                return "Durr\u00ebs (Albania)";
            }
            case "AL-03": {
                return "Elbasan (Albania)";
            }
            case "AL-04": {
                return "Fier (Albania)";
            }
            case "AL-05": {
                return "Gjirokast\u00ebr (Albania)";
            }
            case "AL-06": {
                return "Kor\u00e7\u00eb (Albania)";
            }
            case "AL-07": {
                return "Kuk\u00ebs (Albania)";
            }
            case "AL-08": {
                return "Lezh\u00eb (Albania)";
            }
            case "AL-09": {
                return "Dib\u00ebr (Albania)";
            }
            case "AL-10": {
                return "Shkod\u00ebr (Albania)";
            }
            case "AL-11": {
                return "Tiran\u00eb (Albania)";
            }
            case "AL-12": {
                return "Vlor\u00eb (Albania)";
            }
            case "AL-BR": {
                return "Berat (Albania)";
            }
            case "AL-BU": {
                return "Bulqiz\u00eb (Albania)";
            }
            case "AL-DI": {
                return "Dib\u00ebr (Albania)";
            }
            case "AL-DL": {
                return "Delvin\u00eb (Albania)";
            }
            case "AL-DR": {
                return "Durr\u00ebs (Albania)";
            }
            case "AL-DV": {
                return "Devoll (Albania)";
            }
            case "AL-EL": {
                return "Elbasan (Albania)";
            }
            case "AL-ER": {
                return "Kolonj\u00eb (Albania)";
            }
            case "AL-FR": {
                return "Fier (Albania)";
            }
            case "AL-GJ": {
                return "Gjirokast\u00ebr (Albania)";
            }
            case "AL-GR": {
                return "Gramsh (Albania)";
            }
            case "AL-HA": {
                return "Has (Albania)";
            }
            case "AL-KA": {
                return "Kavaj\u00eb (Albania)";
            }
            case "AL-KB": {
                return "Kurbin (Albania)";
            }
            case "AL-KC": {
                return "Ku\u00e7ov\u00eb (Albania)";
            }
            case "AL-KO": {
                return "Kor\u00e7\u00eb (Albania)";
            }
            case "AL-KR": {
                return "Kruj\u00eb (Albania)";
            }
            case "AL-KU": {
                return "Kuk\u00ebs (Albania)";
            }
            case "AL-LB": {
                return "Librazhd (Albania)";
            }
            case "AL-LE": {
                return "Lezh\u00eb (Albania)";
            }
            case "AL-LU": {
                return "Lushnj\u00eb (Albania)";
            }
            case "AL-MK": {
                return "Mallakast\u00ebr (Albania)";
            }
            case "AL-MM": {
                return "Mal\u00ebsi e Madhe (Albania)";
            }
            case "AL-MR": {
                return "Mirdit\u00eb (Albania)";
            }
            case "AL-MT": {
                return "Mat (Albania)";
            }
            case "AL-PG": {
                return "Pogradec (Albania)";
            }
            case "AL-PQ": {
                return "Peqin (Albania)";
            }
            case "AL-PR": {
                return "P\u00ebrmet (Albania)";
            }
            case "AL-PU": {
                return "Puk\u00eb (Albania)";
            }
            case "AL-SH": {
                return "Shkod\u00ebr (Albania)";
            }
            case "AL-SK": {
                return "Skrapar (Albania)";
            }
            case "AL-SR": {
                return "Sarand\u00eb (Albania)";
            }
            case "AL-TE": {
                return "Tepelen\u00eb (Albania)";
            }
            case "AL-TP": {
                return "Tropoj\u00eb (Albania)";
            }
            case "AL-TR": {
                return "Tiran\u00eb (Albania)";
            }
            case "AL-VL": {
                return "Vlor\u00eb (Albania)";
            }
            case "AM-AG": {
                return "Aragac\u0323otn (Armenia)";
            }
            case "AM-AR": {
                return "Ararat (Armenia)";
            }
            case "AM-AV": {
                return "Armavir (Armenia)";
            }
            case "AM-ER": {
                return "Erevan (Armenia)";
            }
            case "AM-GR": {
                return "Ge\u0121ark'unik' (Armenia)";
            }
            case "AM-KT": {
                return "Kotayk' (Armenia)";
            }
            case "AM-LO": {
                return "Lo\u1e59i (Armenia)";
            }
            case "AM-SH": {
                return "\u0160irak (Armenia)";
            }
            case "AM-SU": {
                return "Syunik' (Armenia)";
            }
            case "AM-TV": {
                return "Tavu\u0161 (Armenia)";
            }
            case "AM-VD": {
                return "Vayo\u0107 Jor (Armenia)";
            }
            case "AO-BGO": {
                return "Bengo (Angola)";
            }
            case "AO-BGU": {
                return "Benguela (Angola)";
            }
            case "AO-BIE": {
                return "Bi\u00e9 (Angola)";
            }
            case "AO-CAB": {
                return "Cabinda (Angola)";
            }
            case "AO-CCU": {
                return "Kuando Kubango (Angola)";
            }
            case "AO-CNN": {
                return "Cunene (Angola)";
            }
            case "AO-CNO": {
                return "Kwanza Norte (Angola)";
            }
            case "AO-CUS": {
                return "Kwanza Sul (Angola)";
            }
            case "AO-HUA": {
                return "Huambo (Angola)";
            }
            case "AO-HUI": {
                return "Hu\u00edla (Angola)";
            }
            case "AO-LNO": {
                return "Lunda Norte (Angola)";
            }
            case "AO-LSU": {
                return "Lunda Sul (Angola)";
            }
            case "AO-LUA": {
                return "Luanda (Angola)";
            }
            case "AO-MAL": {
                return "Malange (Angola)";
            }
            case "AO-MOX": {
                return "Moxico (Angola)";
            }
            case "AO-NAM": {
                return "Namibe (Angola)";
            }
            case "AO-UIG": {
                return "U\u00edge (Angola)";
            }
            case "AO-ZAI": {
                return "Zaire (Angola)";
            }
            case "AQ-AQ": {
                return "Antarctica (Antarctica)";
            }
            case "AR-A": {
                return "Salta (Argentina)";
            }
            case "AR-B": {
                return "Buenos Aires (Argentina)";
            }
            case "AR-C": {
                return "Ciudad Aut\u00f3noma de Buenos Aires (Argentina)";
            }
            case "AR-D": {
                return "San Luis (Argentina)";
            }
            case "AR-E": {
                return "Entre R\u00edos (Argentina)";
            }
            case "AR-F": {
                return "La Rioja (Argentina)";
            }
            case "AR-G": {
                return "Santiago del Estero (Argentina)";
            }
            case "AR-H": {
                return "Chaco (Argentina)";
            }
            case "AR-J": {
                return "San Juan (Argentina)";
            }
            case "AR-K": {
                return "Catamarca (Argentina)";
            }
            case "AR-L": {
                return "La Pampa (Argentina)";
            }
            case "AR-M": {
                return "Mendoza (Argentina)";
            }
            case "AR-N": {
                return "Misiones (Argentina)";
            }
            case "AR-P": {
                return "Formosa (Argentina)";
            }
            case "AR-Q": {
                return "Neuqu\u00e9n (Argentina)";
            }
            case "AR-R": {
                return "R\u00edo Negro (Argentina)";
            }
            case "AR-S": {
                return "Santa Fe (Argentina)";
            }
            case "AR-T": {
                return "Tucum\u00e1n (Argentina)";
            }
            case "AR-U": {
                return "Chubut (Argentina)";
            }
            case "AR-V": {
                return "Tierra del Fuego (Argentina)";
            }
            case "AR-W": {
                return "Corrientes (Argentina)";
            }
            case "AR-X": {
                return "C\u00f3rdoba (Argentina)";
            }
            case "AR-Y": {
                return "Jujuy (Argentina)";
            }
            case "AR-Z": {
                return "Santa Cruz (Argentina)";
            }
            case "AS-AS": {
                return "American Samoa (American Samoa)";
            }
            case "AT-1": {
                return "Burgenland (Austria)";
            }
            case "AT-2": {
                return "K\u00e4rnten (Austria)";
            }
            case "AT-3": {
                return "Nieder\u00f6sterreich (Austria)";
            }
            case "AT-4": {
                return "Ober\u00f6sterreich (Austria)";
            }
            case "AT-5": {
                return "Salzburg (Austria)";
            }
            case "AT-6": {
                return "Steiermark (Austria)";
            }
            case "AT-7": {
                return "Tirol (Austria)";
            }
            case "AT-8": {
                return "Vorarlberg (Austria)";
            }
            case "AT-9": {
                return "Wien (Austria)";
            }
            case "AU-ACT": {
                return "Australian Capital Territory (Australia)";
            }
            case "AU-NSW": {
                return "New South Wales (Australia)";
            }
            case "AU-NT": {
                return "Northern Territory (Australia)";
            }
            case "AU-QLD": {
                return "Queensland (Australia)";
            }
            case "AU-SA": {
                return "South Australia (Australia)";
            }
            case "AU-TAS": {
                return "Tasmania (Australia)";
            }
            case "AU-VIC": {
                return "Victoria (Australia)";
            }
            case "AU-WA": {
                return "Western Australia (Australia)";
            }
            case "AW-AW": {
                return "Aruba (Aruba)";
            }
            case "AX-AX": {
                return "\u00c5land Islands (\u00c5land Islands)";
            }
            case "AZ-ABS": {
                return "Ab\u015feron (Azerbaijan)";
            }
            case "AZ-AGA": {
                return "A\u011fstafa (Azerbaijan)";
            }
            case "AZ-AGC": {
                return "A\u011fcab\u04d9di (Azerbaijan)";
            }
            case "AZ-AGM": {
                return "A\u011fdam (Azerbaijan)";
            }
            case "AZ-AGS": {
                return "A\u011fda\u015f (Azerbaijan)";
            }
            case "AZ-AGU": {
                return "A\u011fsu (Azerbaijan)";
            }
            case "AZ-AST": {
                return "Astara (Azerbaijan)";
            }
            case "AZ-BA": {
                return "Bak\u0131 (Azerbaijan)";
            }
            case "AZ-BAB": {
                return "Bab\u0259k (Azerbaijan)";
            }
            case "AZ-BAL": {
                return "Balak\u0259n (Azerbaijan)";
            }
            case "AZ-BAR": {
                return "B\u0259rd\u0259 (Azerbaijan)";
            }
            case "AZ-BEY": {
                return "Beyl\u0259qan (Azerbaijan)";
            }
            case "AZ-BIL": {
                return "Bil\u0259suvar (Azerbaijan)";
            }
            case "AZ-CAB": {
                return "C\u0259bray\u0131l (Azerbaijan)";
            }
            case "AZ-CAL": {
                return "C\u0259lilabad (Azerbaijan)";
            }
            case "AZ-CUL": {
                return "Culfa (Azerbaijan)";
            }
            case "AZ-DAS": {
                return "Da\u015fk\u0259s\u0259n (Azerbaijan)";
            }
            case "AZ-FUZ": {
                return "F\u00fczuli (Azerbaijan)";
            }
            case "AZ-GA": {
                return "G\u04d9nc\u04d9 (Azerbaijan)";
            }
            case "AZ-GAD": {
                return "G\u0259d\u0259b\u0259y (Azerbaijan)";
            }
            case "AZ-GOR": {
                return "Goranboy (Azerbaijan)";
            }
            case "AZ-GOY": {
                return "G\u00f6y\u00e7ay (Azerbaijan)";
            }
            case "AZ-GYG": {
                return "G\u00f6yg\u00f6l (Azerbaijan)";
            }
            case "AZ-HAC": {
                return "Hac\u0131qabul (Azerbaijan)";
            }
            case "AZ-IMI": {
                return "\u0130mi\u015fli (Azerbaijan)";
            }
            case "AZ-ISM": {
                return "\u0130smay\u0131ll\u0131 (Azerbaijan)";
            }
            case "AZ-KAL": {
                return "K\u0259lb\u0259c\u0259r (Azerbaijan)";
            }
            case "AZ-KAN": {
                return "K\u01ddng\u01ddrli (Azerbaijan)";
            }
            case "AZ-KUR": {
                return "K\u00fcrd\u0259mir (Azerbaijan)";
            }
            case "AZ-LA": {
                return "L\u04d9nk\u04d9ran (Azerbaijan)";
            }
            case "AZ-LAC": {
                return "La\u00e7\u0131n (Azerbaijan)";
            }
            case "AZ-LAN": {
                return "L\u0259nk\u0259ran (Azerbaijan)";
            }
            case "AZ-LER": {
                return "Lerik (Azerbaijan)";
            }
            case "AZ-MAS": {
                return "Masall\u0131 (Azerbaijan)";
            }
            case "AZ-MI": {
                return "Ming\u04d9\u00e7evir (Azerbaijan)";
            }
            case "AZ-NA": {
                return "Naftalan (Azerbaijan)";
            }
            case "AZ-NEF": {
                return "Neft\u00e7ala (Azerbaijan)";
            }
            case "AZ-NV": {
                return "Nax\u00e7\u0131van (Azerbaijan)";
            }
            case "AZ-NX": {
                return "Nax\u00e7\u0131van (Azerbaijan)";
            }
            case "AZ-OGU": {
                return "O\u011fuz (Azerbaijan)";
            }
            case "AZ-ORD": {
                return "Ordubad (Azerbaijan)";
            }
            case "AZ-QAB": {
                return "Q\u04d9b\u04d9l\u04d9 (Azerbaijan)";
            }
            case "AZ-QAX": {
                return "Qax (Azerbaijan)";
            }
            case "AZ-QAZ": {
                return "Qazax (Azerbaijan)";
            }
            case "AZ-QBA": {
                return "Quba (Azerbaijan)";
            }
            case "AZ-QBI": {
                return "Qubadl\u0131 (Azerbaijan)";
            }
            case "AZ-QOB": {
                return "Qobustan (Azerbaijan)";
            }
            case "AZ-QUS": {
                return "Qusar (Azerbaijan)";
            }
            case "AZ-SA": {
                return "\u015e\u04d9ki (Azerbaijan)";
            }
            case "AZ-SAB": {
                return "Sabirabad (Azerbaijan)";
            }
            case "AZ-SAD": {
                return "S\u04d9d\u04d9r\u04d9k (Azerbaijan)";
            }
            case "AZ-SAH": {
                return "\u015eahbuz (Azerbaijan)";
            }
            case "AZ-SAK": {
                return "\u015e\u04d9ki (Azerbaijan)";
            }
            case "AZ-SAL": {
                return "Salyan (Azerbaijan)";
            }
            case "AZ-SAR": {
                return "\u015e\u04d9rur (Azerbaijan)";
            }
            case "AZ-SAT": {
                return "Saatl\u0131 (Azerbaijan)";
            }
            case "AZ-SBN": {
                return "\u015eabran (Azerbaijan)";
            }
            case "AZ-SIY": {
                return "Siy\u04d9z\u04d9n (Azerbaijan)";
            }
            case "AZ-SKR": {
                return "\u015e\u04d9mkir (Azerbaijan)";
            }
            case "AZ-SM": {
                return "Sumqay\u0131t (Azerbaijan)";
            }
            case "AZ-SMI": {
                return "\u015eamax\u0131 (Azerbaijan)";
            }
            case "AZ-SMX": {
                return "Samux (Azerbaijan)";
            }
            case "AZ-SR": {
                return "\u015eirvan (Azerbaijan)";
            }
            case "AZ-SUS": {
                return "\u015eu\u015fa (Azerbaijan)";
            }
            case "AZ-TAR": {
                return "T\u04d9rt\u04d9r (Azerbaijan)";
            }
            case "AZ-TOV": {
                return "Tovuz (Azerbaijan)";
            }
            case "AZ-UCA": {
                return "Ucar (Azerbaijan)";
            }
            case "AZ-XA": {
                return "Xank\u04d9ndi (Azerbaijan)";
            }
            case "AZ-XAC": {
                return "Xa\u00e7maz (Azerbaijan)";
            }
            case "AZ-XCI": {
                return "Xocal\u0131 (Azerbaijan)";
            }
            case "AZ-XIZ": {
                return "X\u0131z\u0131 (Azerbaijan)";
            }
            case "AZ-XVD": {
                return "Xocav\u04d9nd (Azerbaijan)";
            }
            case "AZ-YAR": {
                return "Yard\u0131ml\u0131 (Azerbaijan)";
            }
            case "AZ-YE": {
                return "Yevlax (Azerbaijan)";
            }
            case "AZ-YEV": {
                return "Yevlax (Azerbaijan)";
            }
            case "AZ-ZAN": {
                return "Z\u04d9ngilan (Azerbaijan)";
            }
            case "AZ-ZAQ": {
                return "Zaqatala (Azerbaijan)";
            }
            case "AZ-ZAR": {
                return "Z\u04d9rdab (Azerbaijan)";
            }
            case "BA-01": {
                return "Unsko-sanska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-02": {
                return "Posavska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-03": {
                return "Tuzlanska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-04": {
                return "Zeni\u010dko-dobojska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-05": {
                return "Bosansko-podrinjska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-06": {
                return "Srednjobosanska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-07": {
                return "Hercegova\u010dko-neretvanska \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-08": {
                return "Zapadnohercegova\u010dka \u017eupanija (Bosnia and Herzegovina)";
            }
            case "BA-09": {
                return "Kanton Sarajevo (Bosnia and Herzegovina)";
            }
            case "BA-10": {
                return "Kanton br. 10 (Bosnia and Herzegovina)";
            }
            case "BA-BIH": {
                return "Federacija Bosne i Hercegovine (Bosnia and Herzegovina)";
            }
            case "BA-BRC": {
                return "Br\u010dko distrikt (Bosnia and Herzegovina)";
            }
            case "BA-SRP": {
                return "Republika Srpska (Bosnia and Herzegovina)";
            }
            case "BB-01": {
                return "Christ Church (Barbados)";
            }
            case "BB-02": {
                return "Saint Andrew (Barbados)";
            }
            case "BB-03": {
                return "Saint George (Barbados)";
            }
            case "BB-04": {
                return "Saint James (Barbados)";
            }
            case "BB-05": {
                return "Saint John (Barbados)";
            }
            case "BB-06": {
                return "Saint Joseph (Barbados)";
            }
            case "BB-07": {
                return "Saint Lucy (Barbados)";
            }
            case "BB-08": {
                return "Saint Michael (Barbados)";
            }
            case "BB-09": {
                return "Saint Peter (Barbados)";
            }
            case "BB-10": {
                return "Saint Philip (Barbados)";
            }
            case "BB-11": {
                return "Saint Thomas (Barbados)";
            }
            case "BD-01": {
                return "Bandarban (Bangladesh)";
            }
            case "BD-02": {
                return "Barguna (Bangladesh)";
            }
            case "BD-03": {
                return "Bogra (Bangladesh)";
            }
            case "BD-04": {
                return "Brahmanbaria (Bangladesh)";
            }
            case "BD-05": {
                return "Bagerhat (Bangladesh)";
            }
            case "BD-06": {
                return "Barisal (Bangladesh)";
            }
            case "BD-07": {
                return "Bhola (Bangladesh)";
            }
            case "BD-08": {
                return "Comilla (Bangladesh)";
            }
            case "BD-09": {
                return "Chandpur (Bangladesh)";
            }
            case "BD-10": {
                return "Chittagong (Bangladesh)";
            }
            case "BD-11": {
                return "Cox's Bazar (Bangladesh)";
            }
            case "BD-12": {
                return "Chuadanga (Bangladesh)";
            }
            case "BD-13": {
                return "Dhaka (Bangladesh)";
            }
            case "BD-14": {
                return "Dinajpur (Bangladesh)";
            }
            case "BD-15": {
                return "Faridpur (Bangladesh)";
            }
            case "BD-16": {
                return "Feni (Bangladesh)";
            }
            case "BD-17": {
                return "Gopalganj (Bangladesh)";
            }
            case "BD-18": {
                return "Gazipur (Bangladesh)";
            }
            case "BD-19": {
                return "Gaibandha (Bangladesh)";
            }
            case "BD-20": {
                return "Habiganj (Bangladesh)";
            }
            case "BD-21": {
                return "Jamalpur (Bangladesh)";
            }
            case "BD-22": {
                return "Jessore (Bangladesh)";
            }
            case "BD-23": {
                return "Jhenaidah (Bangladesh)";
            }
            case "BD-24": {
                return "Jaipurhat (Bangladesh)";
            }
            case "BD-25": {
                return "Jhalakati (Bangladesh)";
            }
            case "BD-26": {
                return "Kishoreganj (Bangladesh)";
            }
            case "BD-27": {
                return "Khulna (Bangladesh)";
            }
            case "BD-28": {
                return "Kurigram (Bangladesh)";
            }
            case "BD-29": {
                return "Khagrachari (Bangladesh)";
            }
            case "BD-30": {
                return "Kushtia (Bangladesh)";
            }
            case "BD-31": {
                return "Lakshmipur (Bangladesh)";
            }
            case "BD-32": {
                return "Lalmonirhat (Bangladesh)";
            }
            case "BD-33": {
                return "Manikganj (Bangladesh)";
            }
            case "BD-34": {
                return "Mymensingh (Bangladesh)";
            }
            case "BD-35": {
                return "Munshiganj (Bangladesh)";
            }
            case "BD-36": {
                return "Madaripur (Bangladesh)";
            }
            case "BD-37": {
                return "Magura (Bangladesh)";
            }
            case "BD-38": {
                return "Moulvibazar (Bangladesh)";
            }
            case "BD-39": {
                return "Meherpur (Bangladesh)";
            }
            case "BD-40": {
                return "Narayanganj (Bangladesh)";
            }
            case "BD-41": {
                return "Netrakona (Bangladesh)";
            }
            case "BD-42": {
                return "Narsingdi (Bangladesh)";
            }
            case "BD-43": {
                return "Narail (Bangladesh)";
            }
            case "BD-44": {
                return "Natore (Bangladesh)";
            }
            case "BD-45": {
                return "Nawabganj (Bangladesh)";
            }
            case "BD-46": {
                return "Nilphamari (Bangladesh)";
            }
            case "BD-47": {
                return "Noakhali (Bangladesh)";
            }
            case "BD-48": {
                return "Naogaon (Bangladesh)";
            }
            case "BD-49": {
                return "Pabna (Bangladesh)";
            }
            case "BD-50": {
                return "Pirojpur (Bangladesh)";
            }
            case "BD-51": {
                return "Patuakhali (Bangladesh)";
            }
            case "BD-52": {
                return "Panchagarh (Bangladesh)";
            }
            case "BD-53": {
                return "Rajbari (Bangladesh)";
            }
            case "BD-54": {
                return "Rajshahi (Bangladesh)";
            }
            case "BD-55": {
                return "Rangpur (Bangladesh)";
            }
            case "BD-56": {
                return "Rangamati (Bangladesh)";
            }
            case "BD-57": {
                return "Sherpur (Bangladesh)";
            }
            case "BD-58": {
                return "Satkhira (Bangladesh)";
            }
            case "BD-59": {
                return "Sirajganj (Bangladesh)";
            }
            case "BD-60": {
                return "Sylhet (Bangladesh)";
            }
            case "BD-61": {
                return "Sunamganj (Bangladesh)";
            }
            case "BD-62": {
                return "Shariatpur (Bangladesh)";
            }
            case "BD-63": {
                return "Tangail (Bangladesh)";
            }
            case "BD-64": {
                return "Thakurgaon (Bangladesh)";
            }
            case "BD-A": {
                return "Barisal (Bangladesh)";
            }
            case "BD-B": {
                return "Chittagong (Bangladesh)";
            }
            case "BD-C": {
                return "Dhaka (Bangladesh)";
            }
            case "BD-D": {
                return "Khulna (Bangladesh)";
            }
            case "BD-E": {
                return "Rajshahi (Bangladesh)";
            }
            case "BD-F": {
                return "Rangpur (Bangladesh)";
            }
            case "BD-G": {
                return "Sylhet (Bangladesh)";
            }
            case "BE-BRU": {
                return "Brussels Hoofdstedelijk Gewest (Belgium)";
            }
            case "BE-VAN": {
                return "Antwerpen (Belgium)";
            }
            case "BE-VBR": {
                return "Vlaams-Brabant (Belgium)";
            }
            case "BE-VLG": {
                return "Vlaams Gewest (Belgium)";
            }
            case "BE-VLI": {
                return "Limburg (Belgium)";
            }
            case "BE-VOV": {
                return "Oost-Vlaanderen (Belgium)";
            }
            case "BE-VWV": {
                return "West-Vlaanderen (Belgium)";
            }
            case "BE-WAL": {
                return "wallonne, R\u00e9gion (Belgium)";
            }
            case "BE-WBR": {
                return "Brabant wallon (Belgium)";
            }
            case "BE-WHT": {
                return "Hainaut (Belgium)";
            }
            case "BE-WLG": {
                return "Li\u00e8ge (Belgium)";
            }
            case "BE-WLX": {
                return "Luxembourg (Belgium)";
            }
            case "BE-WNA": {
                return "Namur (Belgium)";
            }
            case "BF-01": {
                return "Boucle du Mouhoun (Burkina Faso)";
            }
            case "BF-02": {
                return "Cascades (Burkina Faso)";
            }
            case "BF-03": {
                return "Centre (Burkina Faso)";
            }
            case "BF-04": {
                return "Centre-Est (Burkina Faso)";
            }
            case "BF-05": {
                return "Centre-Nord (Burkina Faso)";
            }
            case "BF-06": {
                return "Centre-Ouest (Burkina Faso)";
            }
            case "BF-07": {
                return "Centre-Sud (Burkina Faso)";
            }
            case "BF-08": {
                return "Est (Burkina Faso)";
            }
            case "BF-09": {
                return "Hauts-Bassins (Burkina Faso)";
            }
            case "BF-10": {
                return "Nord (Burkina Faso)";
            }
            case "BF-11": {
                return "Plateau-Central (Burkina Faso)";
            }
            case "BF-12": {
                return "Sahel (Burkina Faso)";
            }
            case "BF-13": {
                return "Sud-Ouest (Burkina Faso)";
            }
            case "BF-BAL": {
                return "Bal\u00e9 (Burkina Faso)";
            }
            case "BF-BAM": {
                return "Bam (Burkina Faso)";
            }
            case "BF-BAN": {
                return "Banwa (Burkina Faso)";
            }
            case "BF-BAZ": {
                return "Baz\u00e8ga (Burkina Faso)";
            }
            case "BF-BGR": {
                return "Bougouriba (Burkina Faso)";
            }
            case "BF-BLG": {
                return "Boulgou (Burkina Faso)";
            }
            case "BF-BLK": {
                return "Boulkiemd\u00e9 (Burkina Faso)";
            }
            case "BF-COM": {
                return "Como\u00e9 (Burkina Faso)";
            }
            case "BF-GAN": {
                return "Ganzourgou (Burkina Faso)";
            }
            case "BF-GNA": {
                return "Gnagna (Burkina Faso)";
            }
            case "BF-GOU": {
                return "Gourma (Burkina Faso)";
            }
            case "BF-HOU": {
                return "Houet (Burkina Faso)";
            }
            case "BF-IOB": {
                return "Ioba (Burkina Faso)";
            }
            case "BF-KAD": {
                return "Kadiogo (Burkina Faso)";
            }
            case "BF-KEN": {
                return "K\u00e9n\u00e9dougou (Burkina Faso)";
            }
            case "BF-KMD": {
                return "Komondjari (Burkina Faso)";
            }
            case "BF-KMP": {
                return "Kompienga (Burkina Faso)";
            }
            case "BF-KOP": {
                return "Koulp\u00e9logo (Burkina Faso)";
            }
            case "BF-KOS": {
                return "Kossi (Burkina Faso)";
            }
            case "BF-KOT": {
                return "Kouritenga (Burkina Faso)";
            }
            case "BF-KOW": {
                return "Kourw\u00e9ogo (Burkina Faso)";
            }
            case "BF-LER": {
                return "L\u00e9raba (Burkina Faso)";
            }
            case "BF-LOR": {
                return "Loroum (Burkina Faso)";
            }
            case "BF-MOU": {
                return "Mouhoun (Burkina Faso)";
            }
            case "BF-NAM": {
                return "Namentenga (Burkina Faso)";
            }
            case "BF-NAO": {
                return "Nahouri (Burkina Faso)";
            }
            case "BF-NAY": {
                return "Nayala (Burkina Faso)";
            }
            case "BF-NOU": {
                return "Noumbiel (Burkina Faso)";
            }
            case "BF-OUB": {
                return "Oubritenga (Burkina Faso)";
            }
            case "BF-OUD": {
                return "Oudalan (Burkina Faso)";
            }
            case "BF-PAS": {
                return "Passor\u00e9 (Burkina Faso)";
            }
            case "BF-PON": {
                return "Poni (Burkina Faso)";
            }
            case "BF-SEN": {
                return "S\u00e9no (Burkina Faso)";
            }
            case "BF-SIS": {
                return "Sissili (Burkina Faso)";
            }
            case "BF-SMT": {
                return "Sanmatenga (Burkina Faso)";
            }
            case "BF-SNG": {
                return "Sangui\u00e9 (Burkina Faso)";
            }
            case "BF-SOM": {
                return "Soum (Burkina Faso)";
            }
            case "BF-SOR": {
                return "Sourou (Burkina Faso)";
            }
            case "BF-TAP": {
                return "Tapoa (Burkina Faso)";
            }
            case "BF-TUI": {
                return "Tui (Burkina Faso)";
            }
            case "BF-YAG": {
                return "Yagha (Burkina Faso)";
            }
            case "BF-YAT": {
                return "Yatenga (Burkina Faso)";
            }
            case "BF-ZIR": {
                return "Ziro (Burkina Faso)";
            }
            case "BF-ZON": {
                return "Zondoma (Burkina Faso)";
            }
            case "BF-ZOU": {
                return "Zoundw\u00e9ogo (Burkina Faso)";
            }
            case "BG-01": {
                return "Blagoevgrad (Bulgaria)";
            }
            case "BG-02": {
                return "Burgas (Bulgaria)";
            }
            case "BG-03": {
                return "Varna (Bulgaria)";
            }
            case "BG-04": {
                return "Veliko Tarnovo (Bulgaria)";
            }
            case "BG-05": {
                return "Vidin (Bulgaria)";
            }
            case "BG-06": {
                return "Vratsa (Bulgaria)";
            }
            case "BG-07": {
                return "Gabrovo (Bulgaria)";
            }
            case "BG-08": {
                return "Dobrich (Bulgaria)";
            }
            case "BG-09": {
                return "Kardzhali (Bulgaria)";
            }
            case "BG-10": {
                return "Kyustendil (Bulgaria)";
            }
            case "BG-11": {
                return "Lovech (Bulgaria)";
            }
            case "BG-12": {
                return "Montana (Bulgaria)";
            }
            case "BG-13": {
                return "Pazardzhik (Bulgaria)";
            }
            case "BG-14": {
                return "Pernik (Bulgaria)";
            }
            case "BG-15": {
                return "Pleven (Bulgaria)";
            }
            case "BG-16": {
                return "Plovdiv (Bulgaria)";
            }
            case "BG-17": {
                return "Razgrad (Bulgaria)";
            }
            case "BG-18": {
                return "Ruse (Bulgaria)";
            }
            case "BG-19": {
                return "Silistra (Bulgaria)";
            }
            case "BG-20": {
                return "Sliven (Bulgaria)";
            }
            case "BG-21": {
                return "Smolyan (Bulgaria)";
            }
            case "BG-22": {
                return "Sofia (Bulgaria)";
            }
            case "BG-23": {
                return "Sofia (Bulgaria)";
            }
            case "BG-24": {
                return "Stara Zagora (Bulgaria)";
            }
            case "BG-25": {
                return "Targovishte (Bulgaria)";
            }
            case "BG-26": {
                return "Haskovo (Bulgaria)";
            }
            case "BG-27": {
                return "Shumen (Bulgaria)";
            }
            case "BG-28": {
                return "Yambol (Bulgaria)";
            }
            case "BH-13": {
                return "Al Man\u0101mah (Bahrain)";
            }
            case "BH-14": {
                return "Al Jan\u016bb\u012byah (Bahrain)";
            }
            case "BH-15": {
                return "Al Mu\u1e29arraq (Bahrain)";
            }
            case "BH-16": {
                return "Al Wus\u0163\u00e1 (Bahrain)";
            }
            case "BH-17": {
                return "Ash Sham\u0101l\u012byah (Bahrain)";
            }
            case "BI-BB": {
                return "Bubanza (Burundi)";
            }
            case "BI-BL": {
                return "Bujumbura Rural (Burundi)";
            }
            case "BI-BM": {
                return "Bujumbura Mairie (Burundi)";
            }
            case "BI-BR": {
                return "Bururi (Burundi)";
            }
            case "BI-CA": {
                return "Cankuzo (Burundi)";
            }
            case "BI-CI": {
                return "Cibitoke (Burundi)";
            }
            case "BI-GI": {
                return "Gitega (Burundi)";
            }
            case "BI-KI": {
                return "Kirundo (Burundi)";
            }
            case "BI-KR": {
                return "Karuzi (Burundi)";
            }
            case "BI-KY": {
                return "Kayanza (Burundi)";
            }
            case "BI-MA": {
                return "Makamba (Burundi)";
            }
            case "BI-MU": {
                return "Muramvya (Burundi)";
            }
            case "BI-MW": {
                return "Mwaro (Burundi)";
            }
            case "BI-MY": {
                return "Muyinga (Burundi)";
            }
            case "BI-NG": {
                return "Ngozi (Burundi)";
            }
            case "BI-RT": {
                return "Rutana (Burundi)";
            }
            case "BI-RY": {
                return "Ruyigi (Burundi)";
            }
            case "BJ-AK": {
                return "Atakora (Benin)";
            }
            case "BJ-AL": {
                return "Alibori (Benin)";
            }
            case "BJ-AQ": {
                return "Atlantique (Benin)";
            }
            case "BJ-BO": {
                return "Borgou (Benin)";
            }
            case "BJ-CO": {
                return "Collines (Benin)";
            }
            case "BJ-DO": {
                return "Donga (Benin)";
            }
            case "BJ-KO": {
                return "Kouffo (Benin)";
            }
            case "BJ-LI": {
                return "Littoral (Benin)";
            }
            case "BJ-MO": {
                return "Mono (Benin)";
            }
            case "BJ-OU": {
                return "Ou\u00e9m\u00e9 (Benin)";
            }
            case "BJ-PL": {
                return "Plateau (Benin)";
            }
            case "BJ-ZO": {
                return "Zou (Benin)";
            }
            case "BL-BL": {
                return "St. Barth\u00e9lemy (St. Barth\u00e9lemy)";
            }
            case "BM-BM": {
                return "Bermuda (Bermuda)";
            }
            case "BN-BE": {
                return "Belait (Brunei Darussalam)";
            }
            case "BN-BM": {
                return "Brunei-Muara (Brunei Darussalam)";
            }
            case "BN-TE": {
                return "Temburong (Brunei Darussalam)";
            }
            case "BN-TU": {
                return "Tutong (Brunei Darussalam)";
            }
            case "BO-B": {
                return "El Beni (Bolivia)";
            }
            case "BO-C": {
                return "Cochabamba (Bolivia)";
            }
            case "BO-H": {
                return "Chuquisaca (Bolivia)";
            }
            case "BO-L": {
                return "La Paz (Bolivia)";
            }
            case "BO-N": {
                return "Pando (Bolivia)";
            }
            case "BO-O": {
                return "Oruro (Bolivia)";
            }
            case "BO-P": {
                return "Potos\u00ed (Bolivia)";
            }
            case "BO-S": {
                return "Santa Cruz (Bolivia)";
            }
            case "BO-T": {
                return "Tarija (Bolivia)";
            }
            case "BQ-BO": {
                return "Bonaire (Bonaire, Sint Eustatius and Saba)";
            }
            case "BQ-SA": {
                return "Saba (Bonaire, Sint Eustatius and Saba)";
            }
            case "BQ-SE": {
                return "Sint Eustatius (Bonaire, Sint Eustatius and Saba)";
            }
            case "BR-AC": {
                return "Acre (Brazil)";
            }
            case "BR-AL": {
                return "Alagoas (Brazil)";
            }
            case "BR-AM": {
                return "Amazonas (Brazil)";
            }
            case "BR-AP": {
                return "Amap\u00e1 (Brazil)";
            }
            case "BR-BA": {
                return "Bahia (Brazil)";
            }
            case "BR-CE": {
                return "Cear\u00e1 (Brazil)";
            }
            case "BR-DF": {
                return "Distrito Federal (Brazil)";
            }
            case "BR-ES": {
                return "Esp\u00edrito Santo (Brazil)";
            }
            case "BR-GO": {
                return "Goi\u00e1s (Brazil)";
            }
            case "BR-MA": {
                return "Maranh\u00e3o (Brazil)";
            }
            case "BR-MG": {
                return "Minas Gerais (Brazil)";
            }
            case "BR-MS": {
                return "Mato Grosso do Sul (Brazil)";
            }
            case "BR-MT": {
                return "Mato Grosso (Brazil)";
            }
            case "BR-PA": {
                return "Par\u00e1 (Brazil)";
            }
            case "BR-PB": {
                return "Para\u00edba (Brazil)";
            }
            case "BR-PE": {
                return "Pernambuco (Brazil)";
            }
            case "BR-PI": {
                return "Piau\u00ed (Brazil)";
            }
            case "BR-PR": {
                return "Paran\u00e1 (Brazil)";
            }
            case "BR-RJ": {
                return "Rio de Janeiro (Brazil)";
            }
            case "BR-RN": {
                return "Rio Grande do Norte (Brazil)";
            }
            case "BR-RO": {
                return "Rond\u00f4nia (Brazil)";
            }
            case "BR-RR": {
                return "Roraima (Brazil)";
            }
            case "BR-RS": {
                return "Rio Grande do Sul (Brazil)";
            }
            case "BR-SC": {
                return "Santa Catarina (Brazil)";
            }
            case "BR-SE": {
                return "Sergipe (Brazil)";
            }
            case "BR-SP": {
                return "S\u00e3o Paulo (Brazil)";
            }
            case "BR-TO": {
                return "Tocantins (Brazil)";
            }
            case "BS-AK": {
                return "Acklins (Bahamas)";
            }
            case "BS-BI": {
                return "Bimini (Bahamas)";
            }
            case "BS-BP": {
                return "Black Point (Bahamas)";
            }
            case "BS-BY": {
                return "Berry Islands (Bahamas)";
            }
            case "BS-CE": {
                return "Central Eleuthera (Bahamas)";
            }
            case "BS-CI": {
                return "Cat Island (Bahamas)";
            }
            case "BS-CK": {
                return "Crooked Island and Long Cay (Bahamas)";
            }
            case "BS-CO": {
                return "Central Abaco (Bahamas)";
            }
            case "BS-CS": {
                return "Central Andros (Bahamas)";
            }
            case "BS-EG": {
                return "East Grand Bahama (Bahamas)";
            }
            case "BS-EX": {
                return "Exuma (Bahamas)";
            }
            case "BS-FP": {
                return "City of Freeport (Bahamas)";
            }
            case "BS-GC": {
                return "Grand Cay (Bahamas)";
            }
            case "BS-HI": {
                return "Harbour Island (Bahamas)";
            }
            case "BS-HT": {
                return "Hope Town (Bahamas)";
            }
            case "BS-IN": {
                return "Inagua (Bahamas)";
            }
            case "BS-LI": {
                return "Long Island (Bahamas)";
            }
            case "BS-MC": {
                return "Mangrove Cay (Bahamas)";
            }
            case "BS-MG": {
                return "Mayaguana (Bahamas)";
            }
            case "BS-MI": {
                return "Moore's Island (Bahamas)";
            }
            case "BS-NE": {
                return "North Eleuthera (Bahamas)";
            }
            case "BS-NO": {
                return "North Abaco (Bahamas)";
            }
            case "BS-NS": {
                return "North Andros (Bahamas)";
            }
            case "BS-RC": {
                return "Rum Cay (Bahamas)";
            }
            case "BS-RI": {
                return "Ragged Island (Bahamas)";
            }
            case "BS-SA": {
                return "South Andros (Bahamas)";
            }
            case "BS-SE": {
                return "South Eleuthera (Bahamas)";
            }
            case "BS-SO": {
                return "South Abaco (Bahamas)";
            }
            case "BS-SS": {
                return "San Salvador (Bahamas)";
            }
            case "BS-SW": {
                return "Spanish Wells (Bahamas)";
            }
            case "BS-WG": {
                return "West Grand Bahama (Bahamas)";
            }
            case "BT-11": {
                return "Paro (Bhutan)";
            }
            case "BT-12": {
                return "Chhukha (Bhutan)";
            }
            case "BT-13": {
                return "Ha (Bhutan)";
            }
            case "BT-14": {
                return "Samtse (Bhutan)";
            }
            case "BT-15": {
                return "Thimphu (Bhutan)";
            }
            case "BT-21": {
                return "Tsirang (Bhutan)";
            }
            case "BT-22": {
                return "Dagana (Bhutan)";
            }
            case "BT-23": {
                return "Punakha (Bhutan)";
            }
            case "BT-24": {
                return "Wangdue Phodrang (Bhutan)";
            }
            case "BT-31": {
                return "Sarpang (Bhutan)";
            }
            case "BT-32": {
                return "Trongsa (Bhutan)";
            }
            case "BT-33": {
                return "Bumthang (Bhutan)";
            }
            case "BT-34": {
                return "Zhemgang (Bhutan)";
            }
            case "BT-41": {
                return "Trashigang (Bhutan)";
            }
            case "BT-42": {
                return "Monggar (Bhutan)";
            }
            case "BT-43": {
                return "Pemagatshel (Bhutan)";
            }
            case "BT-44": {
                return "Lhuentse (Bhutan)";
            }
            case "BT-45": {
                return "Samdrup Jongkha (Bhutan)";
            }
            case "BT-GA": {
                return "Gasa (Bhutan)";
            }
            case "BT-TY": {
                return "Trashi Yangtse (Bhutan)";
            }
            case "BV-BV": {
                return "Bouvet Island (Bouvet Island)";
            }
            case "BW-CE": {
                return "Central (Botswana)";
            }
            case "BW-CH": {
                return "Chobe (Botswana)";
            }
            case "BW-FR": {
                return "Francistown (Botswana)";
            }
            case "BW-GA": {
                return "Gaborone (Botswana)";
            }
            case "BW-GH": {
                return "Ghanzi (Botswana)";
            }
            case "BW-JW": {
                return "Jwaneng (Botswana)";
            }
            case "BW-KG": {
                return "Kgalagadi (Botswana)";
            }
            case "BW-KL": {
                return "Kgatleng (Botswana)";
            }
            case "BW-KW": {
                return "Kweneng (Botswana)";
            }
            case "BW-LO": {
                return "Lobatse (Botswana)";
            }
            case "BW-NE": {
                return "North East (Botswana)";
            }
            case "BW-NW": {
                return "North West (Botswana)";
            }
            case "BW-SE": {
                return "South East (Botswana)";
            }
            case "BW-SO": {
                return "Southern (Botswana)";
            }
            case "BW-SP": {
                return "Selibe Phikwe (Botswana)";
            }
            case "BW-ST": {
                return "Sowa Town (Botswana)";
            }
            case "BY-BR": {
                return "Bresckaja voblas\u0107 (Belarus)";
            }
            case "BY-HM": {
                return "Gorod Minsk (Belarus)";
            }
            case "BY-HO": {
                return "Gomel'skaja oblast' (Belarus)";
            }
            case "BY-HR": {
                return "Grodnenskaja oblast' (Belarus)";
            }
            case "BY-MA": {
                return "Mahilio\u016dskaja voblas\u0107 (Belarus)";
            }
            case "BY-MI": {
                return "Minskaja oblast' (Belarus)";
            }
            case "BY-VI": {
                return "Viciebskaja voblas\u0107 (Belarus)";
            }
            case "BZ-BZ": {
                return "Belize (Belize)";
            }
            case "BZ-CY": {
                return "Cayo (Belize)";
            }
            case "BZ-CZL": {
                return "Corozal (Belize)";
            }
            case "BZ-OW": {
                return "Orange Walk (Belize)";
            }
            case "BZ-SC": {
                return "Stann Creek (Belize)";
            }
            case "BZ-TOL": {
                return "Toledo (Belize)";
            }
            case "CA-AB": {
                return "Alberta (Canada)";
            }
            case "CA-BC": {
                return "British Columbia (Canada)";
            }
            case "CA-MB": {
                return "Manitoba (Canada)";
            }
            case "CA-NB": {
                return "New Brunswick (Canada)";
            }
            case "CA-NL": {
                return "Newfoundland and Labrador (Canada)";
            }
            case "CA-NS": {
                return "Nova Scotia (Canada)";
            }
            case "CA-NT": {
                return "Northwest Territories (Canada)";
            }
            case "CA-NU": {
                return "Nunavut (Canada)";
            }
            case "CA-ON": {
                return "Ontario (Canada)";
            }
            case "CA-PE": {
                return "Prince Edward Island (Canada)";
            }
            case "CA-QC": {
                return "Quebec (Canada)";
            }
            case "CA-SK": {
                return "Saskatchewan (Canada)";
            }
            case "CA-YT": {
                return "Yukon (Canada)";
            }
            case "CC-CC": {
                return "Cocos  Islands (Cocos  Islands)";
            }
            case "CD-BC": {
                return "Bas-Congo (Congo, The Democratic Republic Of The)";
            }
            case "CD-BN": {
                return "Bandundu (Congo, The Democratic Republic Of The)";
            }
            case "CD-EQ": {
                return "\u00c9quateur (Congo, The Democratic Republic Of The)";
            }
            case "CD-KA": {
                return "Katanga (Congo, The Democratic Republic Of The)";
            }
            case "CD-KE": {
                return "Kasai-Oriental (Congo, The Democratic Republic Of The)";
            }
            case "CD-KN": {
                return "Kinshasa (Congo, The Democratic Republic Of The)";
            }
            case "CD-KW": {
                return "Kasai-Occidental (Congo, The Democratic Republic Of The)";
            }
            case "CD-MA": {
                return "Maniema (Congo, The Democratic Republic Of The)";
            }
            case "CD-NK": {
                return "Nord-Kivu (Congo, The Democratic Republic Of The)";
            }
            case "CD-OR": {
                return "Orientale (Congo, The Democratic Republic Of The)";
            }
            case "CD-SK": {
                return "Sud-Kivu (Congo, The Democratic Republic Of The)";
            }
            case "CF-AC": {
                return "Ouham (Central African Republic)";
            }
            case "CF-BB": {
                return "Bam\u00efng\u00ef-Bangoran (Central African Republic)";
            }
            case "CF-BGF": {
                return "Bang\u00ee (Central African Republic)";
            }
            case "CF-BK": {
                return "Basse-Kotto (Central African Republic)";
            }
            case "CF-HK": {
                return "Haute-Kotto (Central African Republic)";
            }
            case "CF-HM": {
                return "Haut-Mbomou (Central African Republic)";
            }
            case "CF-HS": {
                return "Haute-Sangha / Mamb\u00e9r\u00e9-Kad\u00e9\u00ef (Central African Republic)";
            }
            case "CF-KB": {
                return "G\u00efr\u00efb\u00efng\u00ef (Central African Republic)";
            }
            case "CF-KG": {
                return "Kem\u00f6-G\u00efr\u00efb\u00efng\u00ef (Central African Republic)";
            }
            case "CF-LB": {
                return "Lobaye (Central African Republic)";
            }
            case "CF-MB": {
                return "Mbomou (Central African Republic)";
            }
            case "CF-MP": {
                return "\u00d6mb\u00ebl\u00e4-P\u00f6k\u00f6 (Central African Republic)";
            }
            case "CF-NM": {
                return "Nana-Mamb\u00e9r\u00e9 (Central African Republic)";
            }
            case "CF-OP": {
                return "Ouham-Pend\u00e9 (Central African Republic)";
            }
            case "CF-SE": {
                return "Sang\u00e4 (Central African Republic)";
            }
            case "CF-UK": {
                return "Ouaka (Central African Republic)";
            }
            case "CF-VK": {
                return "Vakaga (Central African Republic)";
            }
            case "CG-11": {
                return "Bouenza (Congo)";
            }
            case "CG-12": {
                return "Pool (Congo)";
            }
            case "CG-13": {
                return "Sangha (Congo)";
            }
            case "CG-14": {
                return "Plateaux (Congo)";
            }
            case "CG-15": {
                return "Cuvette-Ouest (Congo)";
            }
            case "CG-16": {
                return "Pointe-Noire (Congo)";
            }
            case "CG-2": {
                return "L\u00e9koumou (Congo)";
            }
            case "CG-5": {
                return "Kouilou (Congo)";
            }
            case "CG-7": {
                return "Likouala (Congo)";
            }
            case "CG-8": {
                return "Cuvette (Congo)";
            }
            case "CG-9": {
                return "Niari (Congo)";
            }
            case "CG-BZV": {
                return "Brazzaville (Congo)";
            }
            case "CH-AG": {
                return "Aargau (Switzerland)";
            }
            case "CH-AI": {
                return "Appenzell Innerrhoden (Switzerland)";
            }
            case "CH-AR": {
                return "Appenzell Ausserrhoden (Switzerland)";
            }
            case "CH-BE": {
                return "Bern (Switzerland)";
            }
            case "CH-BL": {
                return "Basel-Landschaft (Switzerland)";
            }
            case "CH-BS": {
                return "Basel-Stadt (Switzerland)";
            }
            case "CH-FR": {
                return "Freiburg (Switzerland)";
            }
            case "CH-GE": {
                return "Gen\u00e8ve (Switzerland)";
            }
            case "CH-GL": {
                return "Glarus (Switzerland)";
            }
            case "CH-GR": {
                return "Graub\u00fcnden (Switzerland)";
            }
            case "CH-JU": {
                return "Jura (Switzerland)";
            }
            case "CH-LU": {
                return "Luzern (Switzerland)";
            }
            case "CH-NE": {
                return "Neuch\u00e2tel (Switzerland)";
            }
            case "CH-NW": {
                return "Nidwalden (Switzerland)";
            }
            case "CH-OW": {
                return "Obwalden (Switzerland)";
            }
            case "CH-SG": {
                return "Sankt Gallen (Switzerland)";
            }
            case "CH-SH": {
                return "Schaffhausen (Switzerland)";
            }
            case "CH-SO": {
                return "Solothurn (Switzerland)";
            }
            case "CH-SZ": {
                return "Schwyz (Switzerland)";
            }
            case "CH-TG": {
                return "Thurgau (Switzerland)";
            }
            case "CH-TI": {
                return "Ticino (Switzerland)";
            }
            case "CH-UR": {
                return "Uri (Switzerland)";
            }
            case "CH-VD": {
                return "Vaud (Switzerland)";
            }
            case "CH-VS": {
                return "Valais (Switzerland)";
            }
            case "CH-ZG": {
                return "Zug (Switzerland)";
            }
            case "CH-ZH": {
                return "Z\u00fcrich (Switzerland)";
            }
            case "CI-01": {
                return "Lagunes (C\u00f4te D'Ivoire)";
            }
            case "CI-02": {
                return "Haut-Sassandra (C\u00f4te D'Ivoire)";
            }
            case "CI-03": {
                return "Savanes (C\u00f4te D'Ivoire)";
            }
            case "CI-04": {
                return "Vall\u00e9e du Bandama (C\u00f4te D'Ivoire)";
            }
            case "CI-05": {
                return "Moyen-Como\u00e9 (C\u00f4te D'Ivoire)";
            }
            case "CI-06": {
                return "18 Montagnes (C\u00f4te D'Ivoire)";
            }
            case "CI-07": {
                return "Lacs (C\u00f4te D'Ivoire)";
            }
            case "CI-08": {
                return "Zanzan (C\u00f4te D'Ivoire)";
            }
            case "CI-09": {
                return "Bas-Sassandra (C\u00f4te D'Ivoire)";
            }
            case "CI-10": {
                return "Dengu\u00e9l\u00e9 (C\u00f4te D'Ivoire)";
            }
            case "CI-11": {
                return "Nzi-Como\u00e9 (C\u00f4te D'Ivoire)";
            }
            case "CI-12": {
                return "Marahou\u00e9 (C\u00f4te D'Ivoire)";
            }
            case "CI-13": {
                return "Sud-Como\u00e9 (C\u00f4te D'Ivoire)";
            }
            case "CI-14": {
                return "Worodougou (C\u00f4te D'Ivoire)";
            }
            case "CI-15": {
                return "Sud-Bandama (C\u00f4te D'Ivoire)";
            }
            case "CI-16": {
                return "Agn\u00e9bi (C\u00f4te D'Ivoire)";
            }
            case "CI-17": {
                return "Bafing (C\u00f4te D'Ivoire)";
            }
            case "CI-18": {
                return "Fromager (C\u00f4te D'Ivoire)";
            }
            case "CI-19": {
                return "Moyen-Cavally (C\u00f4te D'Ivoire)";
            }
            case "CK-CK": {
                return "Cook Islands (Cook Islands)";
            }
            case "CL-AI": {
                return "Ays\u00e9n (Chile)";
            }
            case "CL-AN": {
                return "Antofagasta (Chile)";
            }
            case "CL-AP": {
                return "Arica y Parinacota (Chile)";
            }
            case "CL-AR": {
                return "Araucan\u00eda (Chile)";
            }
            case "CL-AT": {
                return "Atacama (Chile)";
            }
            case "CL-BI": {
                return "Biob\u00edo (Chile)";
            }
            case "CL-CO": {
                return "Coquimbo (Chile)";
            }
            case "CL-LI": {
                return "Libertador General Bernardo O'Higgins (Chile)";
            }
            case "CL-LL": {
                return "Los Lagos (Chile)";
            }
            case "CL-LR": {
                return "Los R\u00edos (Chile)";
            }
            case "CL-MA": {
                return "Magallanes (Chile)";
            }
            case "CL-ML": {
                return "Maule (Chile)";
            }
            case "CL-RM": {
                return "Regi\u00f3n Metropolitana de Santiago (Chile)";
            }
            case "CL-TA": {
                return "Tarapac\u00e1 (Chile)";
            }
            case "CL-VS": {
                return "Valpara\u00edso (Chile)";
            }
            case "CM-AD": {
                return "Adamaoua (Cameroon)";
            }
            case "CM-CE": {
                return "Centre (Cameroon)";
            }
            case "CM-EN": {
                return "Extr\u00eame-Nord (Cameroon)";
            }
            case "CM-ES": {
                return "East (Cameroon)";
            }
            case "CM-LT": {
                return "Littoral (Cameroon)";
            }
            case "CM-NO": {
                return "Nord (Cameroon)";
            }
            case "CM-NW": {
                return "Nord-Ouest (Cameroon)";
            }
            case "CM-OU": {
                return "Ouest (Cameroon)";
            }
            case "CM-SU": {
                return "South (Cameroon)";
            }
            case "CM-SW": {
                return "South-West (Cameroon)";
            }
            case "CN-11": {
                return "Beijing (China)";
            }
            case "CN-12": {
                return "Tianjin (China)";
            }
            case "CN-13": {
                return "Hebei (China)";
            }
            case "CN-14": {
                return "Shanxi (China)";
            }
            case "CN-15": {
                return "Nei Mongol (China)";
            }
            case "CN-21": {
                return "Liaoning (China)";
            }
            case "CN-22": {
                return "Jilin (China)";
            }
            case "CN-23": {
                return "Heilongjiang (China)";
            }
            case "CN-31": {
                return "Shanghai (China)";
            }
            case "CN-32": {
                return "Jiangsu (China)";
            }
            case "CN-33": {
                return "Zhejiang (China)";
            }
            case "CN-34": {
                return "Anhui (China)";
            }
            case "CN-35": {
                return "Fujian (China)";
            }
            case "CN-36": {
                return "Jiangxi (China)";
            }
            case "CN-37": {
                return "Shandong (China)";
            }
            case "CN-41": {
                return "Henan (China)";
            }
            case "CN-42": {
                return "Hubei (China)";
            }
            case "CN-43": {
                return "Hunan (China)";
            }
            case "CN-44": {
                return "Guangdong (China)";
            }
            case "CN-45": {
                return "Guangxi (China)";
            }
            case "CN-46": {
                return "Hainan (China)";
            }
            case "CN-50": {
                return "Chongqing (China)";
            }
            case "CN-51": {
                return "Sichuan (China)";
            }
            case "CN-52": {
                return "Guizhou (China)";
            }
            case "CN-53": {
                return "Yunnan (China)";
            }
            case "CN-54": {
                return "Xizang (China)";
            }
            case "CN-61": {
                return "Shaanxi (China)";
            }
            case "CN-62": {
                return "Gansu (China)";
            }
            case "CN-63": {
                return "Qinghai (China)";
            }
            case "CN-64": {
                return "Ningxia (China)";
            }
            case "CN-65": {
                return "Xinjiang (China)";
            }
            case "CN-71": {
                return "Taiwan (China)";
            }
            case "CN-91": {
                return "Hong Kong (China)";
            }
            case "CN-92": {
                return "Aomen (China)";
            }
            case "CO-AMA": {
                return "Amazonas (Colombia)";
            }
            case "CO-ANT": {
                return "Antioquia (Colombia)";
            }
            case "CO-ARA": {
                return "Arauca (Colombia)";
            }
            case "CO-ATL": {
                return "Atl\u00e1ntico (Colombia)";
            }
            case "CO-BOL": {
                return "Bol\u00edvar (Colombia)";
            }
            case "CO-BOY": {
                return "Boyac\u00e1 (Colombia)";
            }
            case "CO-CAL": {
                return "Caldas (Colombia)";
            }
            case "CO-CAQ": {
                return "Caquet\u00e1 (Colombia)";
            }
            case "CO-CAS": {
                return "Casanare (Colombia)";
            }
            case "CO-CAU": {
                return "Cauca (Colombia)";
            }
            case "CO-CES": {
                return "Cesar (Colombia)";
            }
            case "CO-CHO": {
                return "Choc\u00f3 (Colombia)";
            }
            case "CO-COR": {
                return "C\u00f3rdoba (Colombia)";
            }
            case "CO-CUN": {
                return "Cundinamarca (Colombia)";
            }
            case "CO-DC": {
                return "Distrito Capital de Bogot\u00e1 (Colombia)";
            }
            case "CO-GUA": {
                return "Guain\u00eda (Colombia)";
            }
            case "CO-GUV": {
                return "Guaviare (Colombia)";
            }
            case "CO-HUI": {
                return "Huila (Colombia)";
            }
            case "CO-LAG": {
                return "La Guajira (Colombia)";
            }
            case "CO-MAG": {
                return "Magdalena (Colombia)";
            }
            case "CO-MET": {
                return "Meta (Colombia)";
            }
            case "CO-NAR": {
                return "Nari\u00f1o (Colombia)";
            }
            case "CO-NSA": {
                return "Norte de Santander (Colombia)";
            }
            case "CO-PUT": {
                return "Putumayo (Colombia)";
            }
            case "CO-QUI": {
                return "Quind\u00edo (Colombia)";
            }
            case "CO-RIS": {
                return "Risaralda (Colombia)";
            }
            case "CO-SAN": {
                return "Santander (Colombia)";
            }
            case "CO-SAP": {
                return "San Andr\u00e9s, Providencia y Santa Catalina (Colombia)";
            }
            case "CO-SUC": {
                return "Sucre (Colombia)";
            }
            case "CO-TOL": {
                return "Tolima (Colombia)";
            }
            case "CO-VAC": {
                return "Valle del Cauca (Colombia)";
            }
            case "CO-VAU": {
                return "Vaup\u00e9s (Colombia)";
            }
            case "CO-VID": {
                return "Vichada (Colombia)";
            }
            case "CR-A": {
                return "Alajuela (Costa Rica)";
            }
            case "CR-C": {
                return "Cartago (Costa Rica)";
            }
            case "CR-G": {
                return "Guanacaste (Costa Rica)";
            }
            case "CR-H": {
                return "Heredia (Costa Rica)";
            }
            case "CR-L": {
                return "Lim\u00f3n (Costa Rica)";
            }
            case "CR-P": {
                return "Puntarenas (Costa Rica)";
            }
            case "CR-SJ": {
                return "San Jos\u00e9 (Costa Rica)";
            }
            case "CU-01": {
                return "Pinar del R\u00edo (Cuba)";
            }
            case "CU-03": {
                return "La Habana (Cuba)";
            }
            case "CU-04": {
                return "Matanzas (Cuba)";
            }
            case "CU-05": {
                return "Villa Clara (Cuba)";
            }
            case "CU-06": {
                return "Cienfuegos (Cuba)";
            }
            case "CU-07": {
                return "Sancti Sp\u00edritus (Cuba)";
            }
            case "CU-08": {
                return "Ciego de \u00c1vila (Cuba)";
            }
            case "CU-09": {
                return "Camag\u00fcey (Cuba)";
            }
            case "CU-10": {
                return "Las Tunas (Cuba)";
            }
            case "CU-11": {
                return "Holgu\u00edn (Cuba)";
            }
            case "CU-12": {
                return "Granma (Cuba)";
            }
            case "CU-13": {
                return "Santiago de Cuba (Cuba)";
            }
            case "CU-14": {
                return "Guant\u00e1namo (Cuba)";
            }
            case "CU-15": {
                return "Artemisa (Cuba)";
            }
            case "CU-16": {
                return "Mayabeque (Cuba)";
            }
            case "CU-99": {
                return "Isla de la Juventud (Cuba)";
            }
            case "CV-B": {
                return "Ilhas de Barlavento (Cape Verde)";
            }
            case "CV-BR": {
                return "Brava (Cape Verde)";
            }
            case "CV-BV": {
                return "Boa Vista (Cape Verde)";
            }
            case "CV-CA": {
                return "Santa Catarina (Cape Verde)";
            }
            case "CV-CF": {
                return "Santa Catarina do Fogo (Cape Verde)";
            }
            case "CV-CR": {
                return "Santa Cruz (Cape Verde)";
            }
            case "CV-MA": {
                return "Maio (Cape Verde)";
            }
            case "CV-MO": {
                return "Mosteiros (Cape Verde)";
            }
            case "CV-PA": {
                return "Paul (Cape Verde)";
            }
            case "CV-PN": {
                return "Porto Novo (Cape Verde)";
            }
            case "CV-PR": {
                return "Praia (Cape Verde)";
            }
            case "CV-RB": {
                return "Ribeira Brava (Cape Verde)";
            }
            case "CV-RG": {
                return "Ribeira Grande (Cape Verde)";
            }
            case "CV-RS": {
                return "Ribeira Grande de Santiago (Cape Verde)";
            }
            case "CV-S": {
                return "Ilhas de Sotavento (Cape Verde)";
            }
            case "CV-SD": {
                return "S\u00e3o Domingos (Cape Verde)";
            }
            case "CV-SF": {
                return "S\u00e3o Filipe (Cape Verde)";
            }
            case "CV-SL": {
                return "Sal (Cape Verde)";
            }
            case "CV-SM": {
                return "S\u00e3o Miguel (Cape Verde)";
            }
            case "CV-SO": {
                return "S\u00e3o Louren\u00e7o dos \u00d3rg\u00e3os (Cape Verde)";
            }
            case "CV-SS": {
                return "S\u00e3o Salvador do Mundo (Cape Verde)";
            }
            case "CV-SV": {
                return "S\u00e3o Vicente (Cape Verde)";
            }
            case "CV-TA": {
                return "Tarrafal (Cape Verde)";
            }
            case "CV-TS": {
                return "Tarrafal de S\u00e3o Nicolau (Cape Verde)";
            }
            case "CW-CW": {
                return "Cura\u00e7ao (Cura\u00e7ao)";
            }
            case "CX-CX": {
                return "Christmas Island (Christmas Island)";
            }
            case "CY-01": {
                return "Lefko\u015fa (Cyprus)";
            }
            case "CY-02": {
                return "Lemesos (Cyprus)";
            }
            case "CY-03": {
                return "Larnaka (Cyprus)";
            }
            case "CY-04": {
                return "Ammochostos (Cyprus)";
            }
            case "CY-05": {
                return "Baf (Cyprus)";
            }
            case "CY-06": {
                return "Girne (Cyprus)";
            }
            case "CZ-101": {
                return "Praha 1 (Czech Republic)";
            }
            case "CZ-102": {
                return "Praha 2 (Czech Republic)";
            }
            case "CZ-103": {
                return "Praha 3 (Czech Republic)";
            }
            case "CZ-104": {
                return "Praha 4 (Czech Republic)";
            }
            case "CZ-105": {
                return "Praha 5 (Czech Republic)";
            }
            case "CZ-106": {
                return "Praha 6 (Czech Republic)";
            }
            case "CZ-107": {
                return "Praha 7 (Czech Republic)";
            }
            case "CZ-108": {
                return "Praha 8 (Czech Republic)";
            }
            case "CZ-109": {
                return "Praha 9 (Czech Republic)";
            }
            case "CZ-10A": {
                return "Praha 10 (Czech Republic)";
            }
            case "CZ-10B": {
                return "Praha 11 (Czech Republic)";
            }
            case "CZ-10C": {
                return "Praha 12 (Czech Republic)";
            }
            case "CZ-10D": {
                return "Praha 13 (Czech Republic)";
            }
            case "CZ-10E": {
                return "Praha 14 (Czech Republic)";
            }
            case "CZ-10F": {
                return "Praha 15 (Czech Republic)";
            }
            case "CZ-201": {
                return "Bene\u0161ov (Czech Republic)";
            }
            case "CZ-202": {
                return "Beroun (Czech Republic)";
            }
            case "CZ-203": {
                return "Kladno (Czech Republic)";
            }
            case "CZ-204": {
                return "Kol\u00edn (Czech Republic)";
            }
            case "CZ-205": {
                return "Kutn\u00e1 Hora (Czech Republic)";
            }
            case "CZ-206": {
                return "M\u011bln\u00edk (Czech Republic)";
            }
            case "CZ-207": {
                return "Mlad\u00e1 Boleslav (Czech Republic)";
            }
            case "CZ-208": {
                return "Nymburk (Czech Republic)";
            }
            case "CZ-209": {
                return "Praha-v\u00fdchod (Czech Republic)";
            }
            case "CZ-20A": {
                return "Praha-z\u00e1pad (Czech Republic)";
            }
            case "CZ-20B": {
                return "P\u0159\u00edbram (Czech Republic)";
            }
            case "CZ-20C": {
                return "Rakovn\u00edk (Czech Republic)";
            }
            case "CZ-311": {
                return "\u010cesk\u00e9 Bud\u011bjovice (Czech Republic)";
            }
            case "CZ-312": {
                return "\u010cesk\u00fd Krumlov (Czech Republic)";
            }
            case "CZ-313": {
                return "Jind\u0159ich\u016fv Hradec (Czech Republic)";
            }
            case "CZ-314": {
                return "P\u00edsek (Czech Republic)";
            }
            case "CZ-315": {
                return "Prachatice (Czech Republic)";
            }
            case "CZ-316": {
                return "Strakonice (Czech Republic)";
            }
            case "CZ-317": {
                return "T\u00e1bor (Czech Republic)";
            }
            case "CZ-321": {
                return "Doma\u017elice (Czech Republic)";
            }
            case "CZ-322": {
                return "Klatovy (Czech Republic)";
            }
            case "CZ-323": {
                return "Plze\u0148-m\u011bsto (Czech Republic)";
            }
            case "CZ-324": {
                return "Plze\u0148-jih (Czech Republic)";
            }
            case "CZ-325": {
                return "Plze\u0148-sever (Czech Republic)";
            }
            case "CZ-326": {
                return "Rokycany (Czech Republic)";
            }
            case "CZ-327": {
                return "Tachov (Czech Republic)";
            }
            case "CZ-411": {
                return "Cheb (Czech Republic)";
            }
            case "CZ-412": {
                return "Karlovy Vary (Czech Republic)";
            }
            case "CZ-413": {
                return "Sokolov (Czech Republic)";
            }
            case "CZ-421": {
                return "D\u011b\u010d\u00edn (Czech Republic)";
            }
            case "CZ-422": {
                return "Chomutov (Czech Republic)";
            }
            case "CZ-423": {
                return "Litom\u011b\u0159ice (Czech Republic)";
            }
            case "CZ-424": {
                return "Louny (Czech Republic)";
            }
            case "CZ-425": {
                return "Most (Czech Republic)";
            }
            case "CZ-426": {
                return "Teplice (Czech Republic)";
            }
            case "CZ-427": {
                return "\u00dast\u00ed nad Labem (Czech Republic)";
            }
            case "CZ-511": {
                return "\u010cesk\u00e1 L\u00edpa (Czech Republic)";
            }
            case "CZ-512": {
                return "Jablonec nad Nisou (Czech Republic)";
            }
            case "CZ-513": {
                return "Liberec (Czech Republic)";
            }
            case "CZ-514": {
                return "Semily (Czech Republic)";
            }
            case "CZ-521": {
                return "Hradec Kr\u00e1lov\u00e9 (Czech Republic)";
            }
            case "CZ-522": {
                return "Ji\u010d\u00edn (Czech Republic)";
            }
            case "CZ-523": {
                return "N\u00e1chod (Czech Republic)";
            }
            case "CZ-524": {
                return "Rychnov nad Kn\u011b\u017enou (Czech Republic)";
            }
            case "CZ-525": {
                return "Trutnov (Czech Republic)";
            }
            case "CZ-531": {
                return "Chrudim (Czech Republic)";
            }
            case "CZ-532": {
                return "Pardubice (Czech Republic)";
            }
            case "CZ-533": {
                return "Svitavy (Czech Republic)";
            }
            case "CZ-534": {
                return "\u00dast\u00ed nad Orlic\u00ed (Czech Republic)";
            }
            case "CZ-611": {
                return "Havl\u00ed\u010dk\u016fv Brod (Czech Republic)";
            }
            case "CZ-612": {
                return "Jihlava (Czech Republic)";
            }
            case "CZ-613": {
                return "Pelh\u0159imov (Czech Republic)";
            }
            case "CZ-614": {
                return "T\u0159eb\u00ed\u010d (Czech Republic)";
            }
            case "CZ-615": {
                return "\u017dd'\u00e1r nad S\u00e1zavou (Czech Republic)";
            }
            case "CZ-621": {
                return "Blansko (Czech Republic)";
            }
            case "CZ-622": {
                return "Brno-m\u011bsto (Czech Republic)";
            }
            case "CZ-623": {
                return "Brno-venkov (Czech Republic)";
            }
            case "CZ-624": {
                return "B\u0159eclav (Czech Republic)";
            }
            case "CZ-625": {
                return "Hodon\u00edn (Czech Republic)";
            }
            case "CZ-626": {
                return "Vy\u0161kov (Czech Republic)";
            }
            case "CZ-627": {
                return "Znojmo (Czech Republic)";
            }
            case "CZ-711": {
                return "Jesen\u00edk (Czech Republic)";
            }
            case "CZ-712": {
                return "Olomouc (Czech Republic)";
            }
            case "CZ-713": {
                return "Prost\u0115jov (Czech Republic)";
            }
            case "CZ-714": {
                return "P\u0159erov (Czech Republic)";
            }
            case "CZ-715": {
                return "\u0160umperk (Czech Republic)";
            }
            case "CZ-721": {
                return "Krom\u0115\u0159\u00ed\u017e (Czech Republic)";
            }
            case "CZ-722": {
                return "Uhersk\u00e9 Hradi\u0161t\u0115 (Czech Republic)";
            }
            case "CZ-723": {
                return "Vset\u00edn (Czech Republic)";
            }
            case "CZ-724": {
                return "Zl\u00edn (Czech Republic)";
            }
            case "CZ-801": {
                return "Brunt\u00e1l (Czech Republic)";
            }
            case "CZ-802": {
                return "Fr\u00fddek M\u00edstek (Czech Republic)";
            }
            case "CZ-803": {
                return "Karvin\u00e1 (Czech Republic)";
            }
            case "CZ-804": {
                return "Nov\u00fd Ji\u010d\u00edn (Czech Republic)";
            }
            case "CZ-805": {
                return "Opava (Czech Republic)";
            }
            case "CZ-806": {
                return "Ostrava m\u011bsto (Czech Republic)";
            }
            case "CZ-JC": {
                return "Jiho\u010desk\u00fd kraj (Czech Republic)";
            }
            case "CZ-JM": {
                return "Jihomoravsk\u00fd kraj (Czech Republic)";
            }
            case "CZ-KA": {
                return "Karlovarsk\u00fd kraj (Czech Republic)";
            }
            case "CZ-KR": {
                return "Kr\u00e1lov\u00e9hradeck\u00fd kraj (Czech Republic)";
            }
            case "CZ-LI": {
                return "Libereck\u00fd kraj (Czech Republic)";
            }
            case "CZ-MO": {
                return "Moravskoslezsk\u00fd kraj (Czech Republic)";
            }
            case "CZ-OL": {
                return "Olomouck\u00fd kraj (Czech Republic)";
            }
            case "CZ-PA": {
                return "Pardubick\u00fd kraj (Czech Republic)";
            }
            case "CZ-PL": {
                return "Plze\u0148sk\u00fd kraj (Czech Republic)";
            }
            case "CZ-PR": {
                return "Praha, hlavn\u00ed me\u0161to (Czech Republic)";
            }
            case "CZ-ST": {
                return "St\u0159edo\u010desk\u00fd kraj (Czech Republic)";
            }
            case "CZ-US": {
                return "\u00dasteck\u00fd kraj (Czech Republic)";
            }
            case "CZ-VY": {
                return "Vyso\u010dina (Czech Republic)";
            }
            case "CZ-ZL": {
                return "Zl\u00ednsk\u00fd kraj (Czech Republic)";
            }
            case "DE-BB": {
                return "Brandenburg (Germany)";
            }
            case "DE-BE": {
                return "Berlin (Germany)";
            }
            case "DE-BW": {
                return "Baden-W\u00fcrttemberg (Germany)";
            }
            case "DE-BY": {
                return "Bayern (Germany)";
            }
            case "DE-HB": {
                return "Bremen (Germany)";
            }
            case "DE-HE": {
                return "Hessen (Germany)";
            }
            case "DE-HH": {
                return "Hamburg (Germany)";
            }
            case "DE-MV": {
                return "Mecklenburg-Vorpommern (Germany)";
            }
            case "DE-NI": {
                return "Niedersachsen (Germany)";
            }
            case "DE-NW": {
                return "Nordrhein-Westfalen (Germany)";
            }
            case "DE-RP": {
                return "Rheinland-Pfalz (Germany)";
            }
            case "DE-SH": {
                return "Schleswig-Holstein (Germany)";
            }
            case "DE-SL": {
                return "Saarland (Germany)";
            }
            case "DE-SN": {
                return "Sachsen (Germany)";
            }
            case "DE-ST": {
                return "Sachsen-Anhalt (Germany)";
            }
            case "DE-TH": {
                return "Th\u00fcringen (Germany)";
            }
            case "DJ-AR": {
                return "Arta (Djibouti)";
            }
            case "DJ-AS": {
                return "Ali Sabieh (Djibouti)";
            }
            case "DJ-DI": {
                return "Dikh\u012bl (Djibouti)";
            }
            case "DJ-DJ": {
                return "Djibouti (Djibouti)";
            }
            case "DJ-OB": {
                return "Obock (Djibouti)";
            }
            case "DJ-TA": {
                return "Tadjourah (Djibouti)";
            }
            case "DK-81": {
                return "Nordjylland (Denmark)";
            }
            case "DK-82": {
                return "Midtjylland (Denmark)";
            }
            case "DK-83": {
                return "Syddanmark (Denmark)";
            }
            case "DK-84": {
                return "Hovedstaden (Denmark)";
            }
            case "DK-85": {
                return "Sj\u00e6lland (Denmark)";
            }
            case "DM-02": {
                return "Saint Andrew (Dominica)";
            }
            case "DM-03": {
                return "Saint David (Dominica)";
            }
            case "DM-04": {
                return "Saint George (Dominica)";
            }
            case "DM-05": {
                return "Saint John (Dominica)";
            }
            case "DM-06": {
                return "Saint Joseph (Dominica)";
            }
            case "DM-07": {
                return "Saint Luke (Dominica)";
            }
            case "DM-08": {
                return "Saint Mark (Dominica)";
            }
            case "DM-09": {
                return "Saint Patrick (Dominica)";
            }
            case "DM-10": {
                return "Saint Paul (Dominica)";
            }
            case "DM-11": {
                return "Saint Peter (Dominica)";
            }
            case "DO-01": {
                return "Distrito Nacional (Dominican Republic)";
            }
            case "DO-02": {
                return "Azua (Dominican Republic)";
            }
            case "DO-03": {
                return "Baoruco (Dominican Republic)";
            }
            case "DO-04": {
                return "Barahona (Dominican Republic)";
            }
            case "DO-05": {
                return "Dajab\u00f3n (Dominican Republic)";
            }
            case "DO-06": {
                return "Duarte (Dominican Republic)";
            }
            case "DO-07": {
                return "La Estrelleta (Dominican Republic)";
            }
            case "DO-08": {
                return "El Seibo (Dominican Republic)";
            }
            case "DO-09": {
                return "Espaillat (Dominican Republic)";
            }
            case "DO-10": {
                return "Independencia (Dominican Republic)";
            }
            case "DO-11": {
                return "La Altagracia (Dominican Republic)";
            }
            case "DO-12": {
                return "La Romana (Dominican Republic)";
            }
            case "DO-13": {
                return "La Vega (Dominican Republic)";
            }
            case "DO-14": {
                return "Mar\u00eda Trinidad S\u00e1nchez (Dominican Republic)";
            }
            case "DO-15": {
                return "Monte Cristi (Dominican Republic)";
            }
            case "DO-16": {
                return "Pedernales (Dominican Republic)";
            }
            case "DO-17": {
                return "Peravia (Dominican Republic)";
            }
            case "DO-18": {
                return "Puerto Plata (Dominican Republic)";
            }
            case "DO-19": {
                return "Hermanas Mirabal (Dominican Republic)";
            }
            case "DO-20": {
                return "Saman\u00e1 (Dominican Republic)";
            }
            case "DO-21": {
                return "San Crist\u00f3bal (Dominican Republic)";
            }
            case "DO-22": {
                return "San Juan (Dominican Republic)";
            }
            case "DO-23": {
                return "San Pedro de Macor\u00eds (Dominican Republic)";
            }
            case "DO-24": {
                return "S\u00e1nchez Ram\u00edrez (Dominican Republic)";
            }
            case "DO-25": {
                return "Santiago (Dominican Republic)";
            }
            case "DO-26": {
                return "Santiago Rodr\u00edguez (Dominican Republic)";
            }
            case "DO-27": {
                return "Valverde (Dominican Republic)";
            }
            case "DO-28": {
                return "Monse\u00f1or Nouel (Dominican Republic)";
            }
            case "DO-29": {
                return "Monte Plata (Dominican Republic)";
            }
            case "DO-30": {
                return "Hato Mayor (Dominican Republic)";
            }
            case "DO-31": {
                return "San Jos\u00e9 de Ocoa (Dominican Republic)";
            }
            case "DO-32": {
                return "Santo Domingo (Dominican Republic)";
            }
            case "DO-33": {
                return "Cibao Nordeste (Dominican Republic)";
            }
            case "DO-34": {
                return "Cibao Noroeste (Dominican Republic)";
            }
            case "DO-35": {
                return "Cibao Norte (Dominican Republic)";
            }
            case "DO-36": {
                return "Cibao Sur (Dominican Republic)";
            }
            case "DO-37": {
                return "El Valle (Dominican Republic)";
            }
            case "DO-38": {
                return "Enriquillo (Dominican Republic)";
            }
            case "DO-39": {
                return "Higuamo (Dominican Republic)";
            }
            case "DO-40": {
                return "Ozama (Dominican Republic)";
            }
            case "DO-41": {
                return "Valdesia (Dominican Republic)";
            }
            case "DO-42": {
                return "Yuma (Dominican Republic)";
            }
            case "DZ-01": {
                return "Adrar (Algeria)";
            }
            case "DZ-02": {
                return "Chlef (Algeria)";
            }
            case "DZ-03": {
                return "Laghouat (Algeria)";
            }
            case "DZ-04": {
                return "Oum el Bouaghi (Algeria)";
            }
            case "DZ-05": {
                return "Batna (Algeria)";
            }
            case "DZ-06": {
                return "B\u00e9ja\u00efa (Algeria)";
            }
            case "DZ-07": {
                return "Biskra (Algeria)";
            }
            case "DZ-08": {
                return "B\u00e9char (Algeria)";
            }
            case "DZ-09": {
                return "Blida (Algeria)";
            }
            case "DZ-10": {
                return "Bouira (Algeria)";
            }
            case "DZ-11": {
                return "Tamanrasset (Algeria)";
            }
            case "DZ-12": {
                return "T\u00e9bessa (Algeria)";
            }
            case "DZ-13": {
                return "Tlemcen (Algeria)";
            }
            case "DZ-14": {
                return "Tiaret (Algeria)";
            }
            case "DZ-15": {
                return "Tizi Ouzou (Algeria)";
            }
            case "DZ-16": {
                return "Alger (Algeria)";
            }
            case "DZ-17": {
                return "Djelfa (Algeria)";
            }
            case "DZ-18": {
                return "Jijel (Algeria)";
            }
            case "DZ-19": {
                return "S\u00e9tif (Algeria)";
            }
            case "DZ-20": {
                return "Sa\u00efda (Algeria)";
            }
            case "DZ-21": {
                return "Skikda (Algeria)";
            }
            case "DZ-22": {
                return "Sidi Bel Abb\u00e8s (Algeria)";
            }
            case "DZ-23": {
                return "Annaba (Algeria)";
            }
            case "DZ-24": {
                return "Guelma (Algeria)";
            }
            case "DZ-25": {
                return "Constantine (Algeria)";
            }
            case "DZ-26": {
                return "M\u00e9d\u00e9a (Algeria)";
            }
            case "DZ-27": {
                return "Mostaganem (Algeria)";
            }
            case "DZ-28": {
                return "Msila (Algeria)";
            }
            case "DZ-29": {
                return "Mascara (Algeria)";
            }
            case "DZ-30": {
                return "Ouargla (Algeria)";
            }
            case "DZ-31": {
                return "Oran (Algeria)";
            }
            case "DZ-32": {
                return "El Bayadh (Algeria)";
            }
            case "DZ-33": {
                return "Illizi (Algeria)";
            }
            case "DZ-34": {
                return "Bordj Bou Arr\u00e9ridj (Algeria)";
            }
            case "DZ-35": {
                return "Boumerd\u00e8s (Algeria)";
            }
            case "DZ-36": {
                return "El Tarf (Algeria)";
            }
            case "DZ-37": {
                return "Tindouf (Algeria)";
            }
            case "DZ-38": {
                return "Tissemsilt (Algeria)";
            }
            case "DZ-39": {
                return "El Oued (Algeria)";
            }
            case "DZ-40": {
                return "Khenchela (Algeria)";
            }
            case "DZ-41": {
                return "Souk Ahras (Algeria)";
            }
            case "DZ-42": {
                return "Tipaza (Algeria)";
            }
            case "DZ-43": {
                return "Mila (Algeria)";
            }
            case "DZ-44": {
                return "A\u00efn Defla (Algeria)";
            }
            case "DZ-45": {
                return "Naama (Algeria)";
            }
            case "DZ-46": {
                return "A\u00efn T\u00e9mouchent (Algeria)";
            }
            case "DZ-47": {
                return "Gharda\u00efa (Algeria)";
            }
            case "DZ-48": {
                return "Relizane (Algeria)";
            }
            case "EC-A": {
                return "Azuay (Ecuador)";
            }
            case "EC-B": {
                return "Bol\u00edvar (Ecuador)";
            }
            case "EC-C": {
                return "Carchi (Ecuador)";
            }
            case "EC-D": {
                return "Orellana (Ecuador)";
            }
            case "EC-E": {
                return "Esmeraldas (Ecuador)";
            }
            case "EC-F": {
                return "Ca\u00f1ar (Ecuador)";
            }
            case "EC-G": {
                return "Guayas (Ecuador)";
            }
            case "EC-H": {
                return "Chimborazo (Ecuador)";
            }
            case "EC-I": {
                return "Imbabura (Ecuador)";
            }
            case "EC-L": {
                return "Loja (Ecuador)";
            }
            case "EC-M": {
                return "Manab\u00ed (Ecuador)";
            }
            case "EC-N": {
                return "Napo (Ecuador)";
            }
            case "EC-O": {
                return "El Oro (Ecuador)";
            }
            case "EC-P": {
                return "Pichincha (Ecuador)";
            }
            case "EC-R": {
                return "Los R\u00edos (Ecuador)";
            }
            case "EC-S": {
                return "Morona-Santiago (Ecuador)";
            }
            case "EC-SD": {
                return "Santo Domingo de los Ts\u00e1chilas (Ecuador)";
            }
            case "EC-SE": {
                return "Santa Elena (Ecuador)";
            }
            case "EC-T": {
                return "Tungurahua (Ecuador)";
            }
            case "EC-U": {
                return "Sucumb\u00edos (Ecuador)";
            }
            case "EC-W": {
                return "Gal\u00e1pagos (Ecuador)";
            }
            case "EC-X": {
                return "Cotopaxi (Ecuador)";
            }
            case "EC-Y": {
                return "Pastaza (Ecuador)";
            }
            case "EC-Z": {
                return "Zamora-Chinchipe (Ecuador)";
            }
            case "EE-37": {
                return "Harjumaa (Estonia)";
            }
            case "EE-39": {
                return "Hiiumaa (Estonia)";
            }
            case "EE-44": {
                return "Ida-Virumaa (Estonia)";
            }
            case "EE-49": {
                return "J\u00f5gevamaa (Estonia)";
            }
            case "EE-51": {
                return "J\u00e4rvamaa (Estonia)";
            }
            case "EE-57": {
                return "L\u00e4\u00e4nemaa (Estonia)";
            }
            case "EE-59": {
                return "L\u00e4\u00e4ne-Virumaa (Estonia)";
            }
            case "EE-65": {
                return "P\u00f5lvamaa (Estonia)";
            }
            case "EE-67": {
                return "P\u00e4rnumaa (Estonia)";
            }
            case "EE-70": {
                return "Raplamaa (Estonia)";
            }
            case "EE-74": {
                return "Saaremaa (Estonia)";
            }
            case "EE-78": {
                return "Tartumaa (Estonia)";
            }
            case "EE-82": {
                return "Valgamaa (Estonia)";
            }
            case "EE-84": {
                return "Viljandimaa (Estonia)";
            }
            case "EE-86": {
                return "V\u00f5rumaa (Estonia)";
            }
            case "EG-ALX": {
                return "Al Iskandar\u012byah (Egypt)";
            }
            case "EG-ASN": {
                return "Asw\u0101n (Egypt)";
            }
            case "EG-AST": {
                return "Asy\u016b\u0163 (Egypt)";
            }
            case "EG-BA": {
                return "Al Ba\u1e29r al A\u1e29mar (Egypt)";
            }
            case "EG-BH": {
                return "Al Bu\u1e29ayrah (Egypt)";
            }
            case "EG-BNS": {
                return "Ban\u012b Suwayf (Egypt)";
            }
            case "EG-C": {
                return "Al Q\u0101hirah (Egypt)";
            }
            case "EG-DK": {
                return "Ad Daqahl\u012byah (Egypt)";
            }
            case "EG-DT": {
                return "Dumy\u0101\u0163 (Egypt)";
            }
            case "EG-FYM": {
                return "Al Fayy\u016bm (Egypt)";
            }
            case "EG-GH": {
                return "Al Gharb\u012byah (Egypt)";
            }
            case "EG-GZ": {
                return "Al J\u012bzah (Egypt)";
            }
            case "EG-IS": {
                return "Al Ism\u0101'\u012bl\u012byah (Egypt)";
            }
            case "EG-JS": {
                return "Jan\u016bb S\u012bn\u0101' (Egypt)";
            }
            case "EG-KB": {
                return "Al Qaly\u016bb\u012byah (Egypt)";
            }
            case "EG-KFS": {
                return "Kafr ash Shaykh (Egypt)";
            }
            case "EG-KN": {
                return "Qin\u0101 (Egypt)";
            }
            case "EG-LX": {
                return "Al Uq\u015fur (Egypt)";
            }
            case "EG-MN": {
                return "Al Miny\u0101 (Egypt)";
            }
            case "EG-MNF": {
                return "Al Min\u016bf\u012byah (Egypt)";
            }
            case "EG-MT": {
                return "Ma\u0163r\u016b\u1e29 (Egypt)";
            }
            case "EG-PTS": {
                return "B\u016br Sa\u2018\u012bd (Egypt)";
            }
            case "EG-SHG": {
                return "S\u016bh\u0101j (Egypt)";
            }
            case "EG-SHR": {
                return "Ash Sharq\u012byah (Egypt)";
            }
            case "EG-SIN": {
                return "Sham\u0101l S\u012bn\u0101' (Egypt)";
            }
            case "EG-SUZ": {
                return "As Suways (Egypt)";
            }
            case "EG-WAD": {
                return "Al W\u0101d\u012b al Jad\u012bd (Egypt)";
            }
            case "EH-EH": {
                return "Western Sahara (Western Sahara)";
            }
            case "ER-AN": {
                return "Ansab\u0101 (Eritrea)";
            }
            case "ER-DK": {
                return "Debubawi K\u2019eyy\u012d\u1e25 Ba\u1e25ri (Eritrea)";
            }
            case "ER-DU": {
                return "Al Jan\u016bb\u012b (Eritrea)";
            }
            case "ER-GB": {
                return "Gash-Barka (Eritrea)";
            }
            case "ER-MA": {
                return "Al Awsa\u0163 (Eritrea)";
            }
            case "ER-SK": {
                return "Semienawi K\u2019eyy\u012d\u1e25 Ba\u1e25ri (Eritrea)";
            }
            case "ES-A": {
                return "Alacant* (Spain)";
            }
            case "ES-AB": {
                return "Albacete (Spain)";
            }
            case "ES-AL": {
                return "Almer\u00eda (Spain)";
            }
            case "ES-AN": {
                return "Andaluc\u00eda (Spain)";
            }
            case "ES-AR": {
                return "Arag\u00f3n (Spain)";
            }
            case "ES-AS": {
                return "Asturias, Principado de (Spain)";
            }
            case "ES-AV": {
                return "\u00c1vila (Spain)";
            }
            case "ES-B": {
                return "Barcelona (Spain)";
            }
            case "ES-BA": {
                return "Badajoz (Spain)";
            }
            case "ES-BI": {
                return "Bizkaia* (Spain)";
            }
            case "ES-BU": {
                return "Burgos (Spain)";
            }
            case "ES-C": {
                return "A Coru\u00f1a (Spain)";
            }
            case "ES-CA": {
                return "C\u00e1diz (Spain)";
            }
            case "ES-CB": {
                return "Cantabria (Spain)";
            }
            case "ES-CC": {
                return "C\u00e1ceres (Spain)";
            }
            case "ES-CE": {
                return "Ceuta (Spain)";
            }
            case "ES-CL": {
                return "Castilla y Le\u00f3n (Spain)";
            }
            case "ES-CM": {
                return "Castilla-La Mancha (Spain)";
            }
            case "ES-CN": {
                return "Canarias (Spain)";
            }
            case "ES-CO": {
                return "C\u00f3rdoba (Spain)";
            }
            case "ES-CR": {
                return "Ciudad Real (Spain)";
            }
            case "ES-CS": {
                return "Castell\u00f3* (Spain)";
            }
            case "ES-CT": {
                return "Catalunya (Spain)";
            }
            case "ES-CU": {
                return "Cuenca (Spain)";
            }
            case "ES-EX": {
                return "Extremadura (Spain)";
            }
            case "ES-GA": {
                return "Galicia (Spain)";
            }
            case "ES-GC": {
                return "Las Palmas (Spain)";
            }
            case "ES-GI": {
                return "Girona (Spain)";
            }
            case "ES-GR": {
                return "Granada (Spain)";
            }
            case "ES-GU": {
                return "Guadalajara (Spain)";
            }
            case "ES-H": {
                return "Huelva (Spain)";
            }
            case "ES-HU": {
                return "Huesca (Spain)";
            }
            case "ES-IB": {
                return "Illes Balears (Spain)";
            }
            case "ES-J": {
                return "Ja\u00e9n (Spain)";
            }
            case "ES-L": {
                return "Lleida (Spain)";
            }
            case "ES-LE": {
                return "Le\u00f3n (Spain)";
            }
            case "ES-LO": {
                return "La Rioja (Spain)";
            }
            case "ES-LU": {
                return "Lugo (Spain)";
            }
            case "ES-M": {
                return "Madrid (Spain)";
            }
            case "ES-MA": {
                return "M\u00e1laga (Spain)";
            }
            case "ES-MC": {
                return "Murcia, Regi\u00f3n de (Spain)";
            }
            case "ES-MD": {
                return "Madrid, Comunidad de (Spain)";
            }
            case "ES-ML": {
                return "Melilla (Spain)";
            }
            case "ES-MU": {
                return "Murcia (Spain)";
            }
            case "ES-NA": {
                return "Nafarroa* (Spain)";
            }
            case "ES-NC": {
                return "Nafarroako Foru Komunitatea* (Spain)";
            }
            case "ES-O": {
                return "Asturias (Spain)";
            }
            case "ES-OR": {
                return "Ourense (Spain)";
            }
            case "ES-P": {
                return "Palencia (Spain)";
            }
            case "ES-PM": {
                return "Balears (Spain)";
            }
            case "ES-PO": {
                return "Pontevedra (Spain)";
            }
            case "ES-PV": {
                return "Euskal Herria (Spain)";
            }
            case "ES-RI": {
                return "La Rioja (Spain)";
            }
            case "ES-S": {
                return "Cantabria (Spain)";
            }
            case "ES-SA": {
                return "Salamanca (Spain)";
            }
            case "ES-SE": {
                return "Sevilla (Spain)";
            }
            case "ES-SG": {
                return "Segovia (Spain)";
            }
            case "ES-SO": {
                return "Soria (Spain)";
            }
            case "ES-SS": {
                return "Gipuzkoa* (Spain)";
            }
            case "ES-T": {
                return "Tarragona (Spain)";
            }
            case "ES-TE": {
                return "Teruel (Spain)";
            }
            case "ES-TF": {
                return "Santa Cruz de Tenerife (Spain)";
            }
            case "ES-TO": {
                return "Toledo (Spain)";
            }
            case "ES-V": {
                return "Valencia (Spain)";
            }
            case "ES-VA": {
                return "Valladolid (Spain)";
            }
            case "ES-VC": {
                return "Valenciana, Comunidad (Spain)";
            }
            case "ES-VI": {
                return "\u00c1lava (Spain)";
            }
            case "ES-Z": {
                return "Zaragoza (Spain)";
            }
            case "ES-ZA": {
                return "Zamora (Spain)";
            }
            case "ET-AA": {
                return "Addis Ababa (Ethiopia)";
            }
            case "ET-AF": {
                return "Afar (Ethiopia)";
            }
            case "ET-AM": {
                return "Amara (Ethiopia)";
            }
            case "ET-BE": {
                return "Benshangul-Gumaz (Ethiopia)";
            }
            case "ET-DD": {
                return "Dire Dawa (Ethiopia)";
            }
            case "ET-GA": {
                return "Gamb\u0113la Hizboch (Ethiopia)";
            }
            case "ET-HA": {
                return "Harari People (Ethiopia)";
            }
            case "ET-OR": {
                return "Oromia (Ethiopia)";
            }
            case "ET-SN": {
                return "Southern Nations, Nationalities and Peoples (Ethiopia)";
            }
            case "ET-SO": {
                return "Somali (Ethiopia)";
            }
            case "ET-TI": {
                return "Tigrai (Ethiopia)";
            }
        }
        return "Unknown state code '" + c.getCode() + "'";
    }

    /*
     * Opcode count of 14153 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static String stateFL(Coding c) {
        switch (c.getCode()) {
            case "FI-01": {
                return "Ahvenanmaan maakunta (Finland)";
            }
            case "FI-02": {
                return "Etel\u00e4-Karjala (Finland)";
            }
            case "FI-03": {
                return "Etel\u00e4-Pohjanmaa (Finland)";
            }
            case "FI-04": {
                return "Etel\u00e4-Savo (Finland)";
            }
            case "FI-05": {
                return "Kainuu (Finland)";
            }
            case "FI-06": {
                return "Egentliga Tavastland (Finland)";
            }
            case "FI-07": {
                return "Keski-Pohjanmaa (Finland)";
            }
            case "FI-08": {
                return "Keski-Suomi (Finland)";
            }
            case "FI-09": {
                return "Kymenlaakso (Finland)";
            }
            case "FI-10": {
                return "Lappi (Finland)";
            }
            case "FI-11": {
                return "Birkaland (Finland)";
            }
            case "FI-12": {
                return "\u00d6sterbotten (Finland)";
            }
            case "FI-13": {
                return "Norra Karelen (Finland)";
            }
            case "FI-14": {
                return "Norra \u00d6sterbotten (Finland)";
            }
            case "FI-15": {
                return "Norra Savolax (Finland)";
            }
            case "FI-16": {
                return "P\u00e4ij\u00e4nne-Tavastland (Finland)";
            }
            case "FI-17": {
                return "Satakunda (Finland)";
            }
            case "FI-18": {
                return "Nyland (Finland)";
            }
            case "FI-19": {
                return "Egentliga Finland (Finland)";
            }
            case "FJ-01": {
                return "Ba (Fiji)";
            }
            case "FJ-02": {
                return "Bua (Fiji)";
            }
            case "FJ-03": {
                return "Cakaudrove (Fiji)";
            }
            case "FJ-04": {
                return "Kadavu (Fiji)";
            }
            case "FJ-05": {
                return "Lau (Fiji)";
            }
            case "FJ-06": {
                return "Lomaiviti (Fiji)";
            }
            case "FJ-07": {
                return "Macuata (Fiji)";
            }
            case "FJ-08": {
                return "Nadroga and Navosa (Fiji)";
            }
            case "FJ-09": {
                return "Naitasiri (Fiji)";
            }
            case "FJ-10": {
                return "Namosi (Fiji)";
            }
            case "FJ-11": {
                return "Ra (Fiji)";
            }
            case "FJ-12": {
                return "Rewa (Fiji)";
            }
            case "FJ-13": {
                return "Serua (Fiji)";
            }
            case "FJ-14": {
                return "Tailevu (Fiji)";
            }
            case "FJ-C": {
                return "Central (Fiji)";
            }
            case "FJ-E": {
                return "Eastern (Fiji)";
            }
            case "FJ-N": {
                return "Northern (Fiji)";
            }
            case "FJ-R": {
                return "Rotuma (Fiji)";
            }
            case "FJ-W": {
                return "Western (Fiji)";
            }
            case "FK-FK": {
                return "Falkland Islands (Falkland Islands)";
            }
            case "FM-KSA": {
                return "Kosrae (Micronesia, Federated States Of)";
            }
            case "FM-PNI": {
                return "Pohnpei (Micronesia, Federated States Of)";
            }
            case "FM-TRK": {
                return "Chuuk (Micronesia, Federated States Of)";
            }
            case "FM-YAP": {
                return "Yap (Micronesia, Federated States Of)";
            }
            case "FO-FO": {
                return "Faroe Islands (Faroe Islands)";
            }
            case "FR-01": {
                return "Ain (France)";
            }
            case "FR-02": {
                return "Aisne (France)";
            }
            case "FR-03": {
                return "Allier (France)";
            }
            case "FR-04": {
                return "Alpes-de-Haute-Provence (France)";
            }
            case "FR-05": {
                return "Hautes-Alpes (France)";
            }
            case "FR-06": {
                return "Alpes-Maritimes (France)";
            }
            case "FR-07": {
                return "Ard\u00e8che (France)";
            }
            case "FR-08": {
                return "Ardennes (France)";
            }
            case "FR-09": {
                return "Ari\u00e8ge (France)";
            }
            case "FR-10": {
                return "Aube (France)";
            }
            case "FR-11": {
                return "Aude (France)";
            }
            case "FR-12": {
                return "Aveyron (France)";
            }
            case "FR-13": {
                return "Bouches-du-Rh\u00f4ne (France)";
            }
            case "FR-14": {
                return "Calvados (France)";
            }
            case "FR-15": {
                return "Cantal (France)";
            }
            case "FR-16": {
                return "Charente (France)";
            }
            case "FR-17": {
                return "Charente-Maritime (France)";
            }
            case "FR-18": {
                return "Cher (France)";
            }
            case "FR-19": {
                return "Corr\u00e8ze (France)";
            }
            case "FR-21": {
                return "C\u00f4te-d'Or (France)";
            }
            case "FR-22": {
                return "C\u00f4tes-d'Armor (France)";
            }
            case "FR-23": {
                return "Creuse (France)";
            }
            case "FR-24": {
                return "Dordogne (France)";
            }
            case "FR-25": {
                return "Doubs (France)";
            }
            case "FR-26": {
                return "Dr\u00f4me (France)";
            }
            case "FR-27": {
                return "Eure (France)";
            }
            case "FR-28": {
                return "Eure-et-Loir (France)";
            }
            case "FR-29": {
                return "Finist\u00e8re (France)";
            }
            case "FR-2A": {
                return "Corse-du-Sud (France)";
            }
            case "FR-2B": {
                return "Haute-Corse (France)";
            }
            case "FR-30": {
                return "Gard (France)";
            }
            case "FR-31": {
                return "Haute-Garonne (France)";
            }
            case "FR-32": {
                return "Gers (France)";
            }
            case "FR-33": {
                return "Gironde (France)";
            }
            case "FR-34": {
                return "H\u00e9rault (France)";
            }
            case "FR-35": {
                return "Ille-et-Vilaine (France)";
            }
            case "FR-36": {
                return "Indre (France)";
            }
            case "FR-37": {
                return "Indre-et-Loire (France)";
            }
            case "FR-38": {
                return "Is\u00e8re (France)";
            }
            case "FR-39": {
                return "Jura (France)";
            }
            case "FR-40": {
                return "Landes (France)";
            }
            case "FR-41": {
                return "Loir-et-Cher (France)";
            }
            case "FR-42": {
                return "Loire (France)";
            }
            case "FR-43": {
                return "Haute-Loire (France)";
            }
            case "FR-44": {
                return "Loire-Atlantique (France)";
            }
            case "FR-45": {
                return "Loiret (France)";
            }
            case "FR-46": {
                return "Lot (France)";
            }
            case "FR-47": {
                return "Lot-et-Garonne (France)";
            }
            case "FR-48": {
                return "Loz\u00e8re (France)";
            }
            case "FR-49": {
                return "Maine-et-Loire (France)";
            }
            case "FR-50": {
                return "Manche (France)";
            }
            case "FR-51": {
                return "Marne (France)";
            }
            case "FR-52": {
                return "Haute-Marne (France)";
            }
            case "FR-53": {
                return "Mayenne (France)";
            }
            case "FR-54": {
                return "Meurthe-et-Moselle (France)";
            }
            case "FR-55": {
                return "Meuse (France)";
            }
            case "FR-56": {
                return "Morbihan (France)";
            }
            case "FR-57": {
                return "Moselle (France)";
            }
            case "FR-58": {
                return "Ni\u00e8vre (France)";
            }
            case "FR-59": {
                return "Nord (France)";
            }
            case "FR-60": {
                return "Oise (France)";
            }
            case "FR-61": {
                return "Orne (France)";
            }
            case "FR-62": {
                return "Pas-de-Calais (France)";
            }
            case "FR-63": {
                return "Puy-de-D\u00f4me (France)";
            }
            case "FR-64": {
                return "Pyr\u00e9n\u00e9es-Atlantiques (France)";
            }
            case "FR-65": {
                return "Hautes-Pyr\u00e9n\u00e9es (France)";
            }
            case "FR-66": {
                return "Pyr\u00e9n\u00e9es-Orientales (France)";
            }
            case "FR-67": {
                return "Bas-Rhin (France)";
            }
            case "FR-68": {
                return "Haut-Rhin (France)";
            }
            case "FR-69": {
                return "Rh\u00f4ne (France)";
            }
            case "FR-70": {
                return "Haute-Sa\u00f4ne (France)";
            }
            case "FR-71": {
                return "Sa\u00f4ne-et-Loire (France)";
            }
            case "FR-72": {
                return "Sarthe (France)";
            }
            case "FR-73": {
                return "Savoie (France)";
            }
            case "FR-74": {
                return "Haute-Savoie (France)";
            }
            case "FR-75": {
                return "Paris (France)";
            }
            case "FR-76": {
                return "Seine-Maritime (France)";
            }
            case "FR-77": {
                return "Seine-et-Marne (France)";
            }
            case "FR-78": {
                return "Yvelines (France)";
            }
            case "FR-79": {
                return "Deux-S\u00e8vres (France)";
            }
            case "FR-80": {
                return "Somme (France)";
            }
            case "FR-81": {
                return "Tarn (France)";
            }
            case "FR-82": {
                return "Tarn-et-Garonne (France)";
            }
            case "FR-83": {
                return "Var (France)";
            }
            case "FR-84": {
                return "Vaucluse (France)";
            }
            case "FR-85": {
                return "Vend\u00e9e (France)";
            }
            case "FR-86": {
                return "Vienne (France)";
            }
            case "FR-87": {
                return "Haute-Vienne (France)";
            }
            case "FR-88": {
                return "Vosges (France)";
            }
            case "FR-89": {
                return "Yonne (France)";
            }
            case "FR-90": {
                return "Territoire de Belfort (France)";
            }
            case "FR-91": {
                return "Essonne (France)";
            }
            case "FR-92": {
                return "Hauts-de-Seine (France)";
            }
            case "FR-93": {
                return "Seine-Saint-Denis (France)";
            }
            case "FR-94": {
                return "Val-de-Marne (France)";
            }
            case "FR-95": {
                return "Val-d'Oise (France)";
            }
            case "FR-A": {
                return "Alsace (France)";
            }
            case "FR-B": {
                return "Aquitaine (France)";
            }
            case "FR-BL": {
                return "Saint-Barth\u00e9lemy (France)";
            }
            case "FR-C": {
                return "Auvergne (France)";
            }
            case "FR-CP": {
                return "Clipperton (France)";
            }
            case "FR-D": {
                return "Bourgogne (France)";
            }
            case "FR-E": {
                return "Bretagne (France)";
            }
            case "FR-F": {
                return "Centre (France)";
            }
            case "FR-G": {
                return "Champagne-Ardenne (France)";
            }
            case "FR-GF": {
                return "Guyane (France)";
            }
            case "FR-GP": {
                return "Guadeloupe (France)";
            }
            case "FR-H": {
                return "Corse (France)";
            }
            case "FR-I": {
                return "Franche-Comt\u00e9 (France)";
            }
            case "FR-J": {
                return "\u00cele-de-France (France)";
            }
            case "FR-K": {
                return "Languedoc-Roussillon (France)";
            }
            case "FR-L": {
                return "Limousin (France)";
            }
            case "FR-M": {
                return "Lorraine (France)";
            }
            case "FR-MF": {
                return "Saint-Martin (France)";
            }
            case "FR-MQ": {
                return "Martinique (France)";
            }
            case "FR-N": {
                return "Midi-Pyr\u00e9n\u00e9es (France)";
            }
            case "FR-NC": {
                return "Nouvelle-Cal\u00e9donie (France)";
            }
            case "FR-O": {
                return "Nord-Pas-de-Calais (France)";
            }
            case "FR-P": {
                return "Basse-Normandie (France)";
            }
            case "FR-PF": {
                return "Polyn\u00e9sie fran\u00e7aise (France)";
            }
            case "FR-PM": {
                return "Saint-Pierre-et-Miquelon (France)";
            }
            case "FR-Q": {
                return "Haute-Normandie (France)";
            }
            case "FR-R": {
                return "Pays-de-la-Loire (France)";
            }
            case "FR-RE": {
                return "La R\u00e9union (France)";
            }
            case "FR-S": {
                return "Picardie (France)";
            }
            case "FR-T": {
                return "Poitou-Charentes (France)";
            }
            case "FR-TF": {
                return "Terres australes fran\u00e7aises (France)";
            }
            case "FR-U": {
                return "Provence-Alpes-C\u00f4te-d'Azur (France)";
            }
            case "FR-V": {
                return "Rh\u00f4ne-Alpes (France)";
            }
            case "FR-WF": {
                return "Wallis-et-Futuna (France)";
            }
            case "FR-YT": {
                return "Mayotte (France)";
            }
            case "GA-1": {
                return "Estuaire (Gabon)";
            }
            case "GA-2": {
                return "Haut-Ogoou\u00e9 (Gabon)";
            }
            case "GA-3": {
                return "Moyen-Ogoou\u00e9 (Gabon)";
            }
            case "GA-4": {
                return "Ngouni\u00e9 (Gabon)";
            }
            case "GA-5": {
                return "Nyanga (Gabon)";
            }
            case "GA-6": {
                return "Ogoou\u00e9-Ivindo (Gabon)";
            }
            case "GA-7": {
                return "Ogoou\u00e9-Lolo (Gabon)";
            }
            case "GA-8": {
                return "Ogoou\u00e9-Maritime (Gabon)";
            }
            case "GA-9": {
                return "Woleu-Ntem (Gabon)";
            }
            case "GB-ABD": {
                return "Aberdeenshire (United Kingdom)";
            }
            case "GB-ABE": {
                return "Aberdeen City (United Kingdom)";
            }
            case "GB-AGB": {
                return "Argyll and Bute (United Kingdom)";
            }
            case "GB-AGY": {
                return "Isle of Anglesey (United Kingdom)";
            }
            case "GB-ANS": {
                return "Angus (United Kingdom)";
            }
            case "GB-ANT": {
                return "Antrim (United Kingdom)";
            }
            case "GB-ARD": {
                return "Ards (United Kingdom)";
            }
            case "GB-ARM": {
                return "Armagh (United Kingdom)";
            }
            case "GB-BAS": {
                return "Bath and North East Somerset (United Kingdom)";
            }
            case "GB-BBD": {
                return "Blackburn with Darwen (United Kingdom)";
            }
            case "GB-BDF": {
                return "Bedford (United Kingdom)";
            }
            case "GB-BDG": {
                return "Barking and Dagenham (United Kingdom)";
            }
            case "GB-BEN": {
                return "Brent (United Kingdom)";
            }
            case "GB-BEX": {
                return "Bexley (United Kingdom)";
            }
            case "GB-BFS": {
                return "Belfast (United Kingdom)";
            }
            case "GB-BGE": {
                return "Bridgend (United Kingdom)";
            }
            case "GB-BGW": {
                return "Blaenau Gwent (United Kingdom)";
            }
            case "GB-BIR": {
                return "Birmingham (United Kingdom)";
            }
            case "GB-BKM": {
                return "Buckinghamshire (United Kingdom)";
            }
            case "GB-BLA": {
                return "Ballymena (United Kingdom)";
            }
            case "GB-BLY": {
                return "Ballymoney (United Kingdom)";
            }
            case "GB-BMH": {
                return "Bournemouth (United Kingdom)";
            }
            case "GB-BNB": {
                return "Banbridge (United Kingdom)";
            }
            case "GB-BNE": {
                return "Barnet (United Kingdom)";
            }
            case "GB-BNH": {
                return "Brighton and Hove (United Kingdom)";
            }
            case "GB-BNS": {
                return "Barnsley (United Kingdom)";
            }
            case "GB-BOL": {
                return "Bolton (United Kingdom)";
            }
            case "GB-BPL": {
                return "Blackpool (United Kingdom)";
            }
            case "GB-BRC": {
                return "Bracknell Forest (United Kingdom)";
            }
            case "GB-BRD": {
                return "Bradford (United Kingdom)";
            }
            case "GB-BRY": {
                return "Bromley (United Kingdom)";
            }
            case "GB-BST": {
                return "Bristol, City of (United Kingdom)";
            }
            case "GB-BUR": {
                return "Bury (United Kingdom)";
            }
            case "GB-CAM": {
                return "Cambridgeshire (United Kingdom)";
            }
            case "GB-CAY": {
                return "Caerphilly (United Kingdom)";
            }
            case "GB-CBF": {
                return "Central Bedfordshire (United Kingdom)";
            }
            case "GB-CGN": {
                return "Ceredigion (United Kingdom)";
            }
            case "GB-CGV": {
                return "Craigavon (United Kingdom)";
            }
            case "GB-CHE": {
                return "Cheshire East (United Kingdom)";
            }
            case "GB-CHW": {
                return "Cheshire West and Chester (United Kingdom)";
            }
            case "GB-CKF": {
                return "Carrickfergus (United Kingdom)";
            }
            case "GB-CKT": {
                return "Cookstown (United Kingdom)";
            }
            case "GB-CLD": {
                return "Calderdale (United Kingdom)";
            }
            case "GB-CLK": {
                return "Clackmannanshire (United Kingdom)";
            }
            case "GB-CLR": {
                return "Coleraine (United Kingdom)";
            }
            case "GB-CMA": {
                return "Cumbria (United Kingdom)";
            }
            case "GB-CMD": {
                return "Camden (United Kingdom)";
            }
            case "GB-CMN": {
                return "Carmarthenshire (United Kingdom)";
            }
            case "GB-CON": {
                return "Cornwall (United Kingdom)";
            }
            case "GB-COV": {
                return "Coventry (United Kingdom)";
            }
            case "GB-CRF": {
                return "Cardiff (United Kingdom)";
            }
            case "GB-CRY": {
                return "Croydon (United Kingdom)";
            }
            case "GB-CSR": {
                return "Castlereagh (United Kingdom)";
            }
            case "GB-CWY": {
                return "Conwy (United Kingdom)";
            }
            case "GB-DAL": {
                return "Darlington (United Kingdom)";
            }
            case "GB-DBY": {
                return "Derbyshire (United Kingdom)";
            }
            case "GB-DEN": {
                return "Denbighshire (United Kingdom)";
            }
            case "GB-DER": {
                return "Derby (United Kingdom)";
            }
            case "GB-DEV": {
                return "Devon (United Kingdom)";
            }
            case "GB-DGN": {
                return "Dungannon and South Tyrone (United Kingdom)";
            }
            case "GB-DGY": {
                return "Dumfries and Galloway (United Kingdom)";
            }
            case "GB-DNC": {
                return "Doncaster (United Kingdom)";
            }
            case "GB-DND": {
                return "Dundee City (United Kingdom)";
            }
            case "GB-DOR": {
                return "Dorset (United Kingdom)";
            }
            case "GB-DOW": {
                return "Down (United Kingdom)";
            }
            case "GB-DRY": {
                return "Derry (United Kingdom)";
            }
            case "GB-DUD": {
                return "Dudley (United Kingdom)";
            }
            case "GB-DUR": {
                return "Durham County (United Kingdom)";
            }
            case "GB-EAL": {
                return "Ealing (United Kingdom)";
            }
            case "GB-EAW": {
                return "England and Wales (United Kingdom)";
            }
            case "GB-EAY": {
                return "East Ayrshire (United Kingdom)";
            }
            case "GB-EDH": {
                return "Edinburgh, City of (United Kingdom)";
            }
            case "GB-EDU": {
                return "East Dunbartonshire (United Kingdom)";
            }
            case "GB-ELN": {
                return "East Lothian (United Kingdom)";
            }
            case "GB-ELS": {
                return "Eilean Siar (United Kingdom)";
            }
            case "GB-ENF": {
                return "Enfield (United Kingdom)";
            }
            case "GB-ENG": {
                return "England (United Kingdom)";
            }
            case "GB-ERW": {
                return "East Renfrewshire (United Kingdom)";
            }
            case "GB-ERY": {
                return "East Riding of Yorkshire (United Kingdom)";
            }
            case "GB-ESS": {
                return "Essex (United Kingdom)";
            }
            case "GB-ESX": {
                return "East Sussex (United Kingdom)";
            }
            case "GB-FAL": {
                return "Falkirk (United Kingdom)";
            }
            case "GB-FER": {
                return "Fermanagh (United Kingdom)";
            }
            case "GB-FIF": {
                return "Fife (United Kingdom)";
            }
            case "GB-FLN": {
                return "Flintshire (United Kingdom)";
            }
            case "GB-GAT": {
                return "Gateshead (United Kingdom)";
            }
            case "GB-GBN": {
                return "Great Britain (United Kingdom)";
            }
            case "GB-GLG": {
                return "Glasgow City (United Kingdom)";
            }
            case "GB-GLS": {
                return "Gloucestershire (United Kingdom)";
            }
            case "GB-GRE": {
                return "Greenwich (United Kingdom)";
            }
            case "GB-GWN": {
                return "Gwynedd (United Kingdom)";
            }
            case "GB-HAL": {
                return "Halton (United Kingdom)";
            }
            case "GB-HAM": {
                return "Hampshire (United Kingdom)";
            }
            case "GB-HAV": {
                return "Havering (United Kingdom)";
            }
            case "GB-HCK": {
                return "Hackney (United Kingdom)";
            }
            case "GB-HEF": {
                return "Herefordshire (United Kingdom)";
            }
            case "GB-HIL": {
                return "Hillingdon (United Kingdom)";
            }
            case "GB-HLD": {
                return "Highland (United Kingdom)";
            }
            case "GB-HMF": {
                return "Hammersmith and Fulham (United Kingdom)";
            }
            case "GB-HNS": {
                return "Hounslow (United Kingdom)";
            }
            case "GB-HPL": {
                return "Hartlepool (United Kingdom)";
            }
            case "GB-HRT": {
                return "Hertfordshire (United Kingdom)";
            }
            case "GB-HRW": {
                return "Harrow (United Kingdom)";
            }
            case "GB-HRY": {
                return "Haringey (United Kingdom)";
            }
            case "GB-IOS": {
                return "Isles of Scilly (United Kingdom)";
            }
            case "GB-IOW": {
                return "Isle of Wight (United Kingdom)";
            }
            case "GB-ISL": {
                return "Islington (United Kingdom)";
            }
            case "GB-IVC": {
                return "Inverclyde (United Kingdom)";
            }
            case "GB-KEC": {
                return "Kensington and Chelsea (United Kingdom)";
            }
            case "GB-KEN": {
                return "Kent (United Kingdom)";
            }
            case "GB-KHL": {
                return "Kingston upon Hull (United Kingdom)";
            }
            case "GB-KIR": {
                return "Kirklees (United Kingdom)";
            }
            case "GB-KTT": {
                return "Kingston upon Thames (United Kingdom)";
            }
            case "GB-KWL": {
                return "Knowsley (United Kingdom)";
            }
            case "GB-LAN": {
                return "Lancashire (United Kingdom)";
            }
            case "GB-LBH": {
                return "Lambeth (United Kingdom)";
            }
            case "GB-LCE": {
                return "Leicester (United Kingdom)";
            }
            case "GB-LDS": {
                return "Leeds (United Kingdom)";
            }
            case "GB-LEC": {
                return "Leicestershire (United Kingdom)";
            }
            case "GB-LEW": {
                return "Lewisham (United Kingdom)";
            }
            case "GB-LIN": {
                return "Lincolnshire (United Kingdom)";
            }
            case "GB-LIV": {
                return "Liverpool (United Kingdom)";
            }
            case "GB-LMV": {
                return "Limavady (United Kingdom)";
            }
            case "GB-LND": {
                return "London, City of (United Kingdom)";
            }
            case "GB-LRN": {
                return "Larne (United Kingdom)";
            }
            case "GB-LSB": {
                return "Lisburn (United Kingdom)";
            }
            case "GB-LUT": {
                return "Luton (United Kingdom)";
            }
            case "GB-MAN": {
                return "Manchester (United Kingdom)";
            }
            case "GB-MDB": {
                return "Middlesbrough (United Kingdom)";
            }
            case "GB-MDW": {
                return "Medway (United Kingdom)";
            }
            case "GB-MFT": {
                return "Magherafelt (United Kingdom)";
            }
            case "GB-MIK": {
                return "Milton Keynes (United Kingdom)";
            }
            case "GB-MLN": {
                return "Midlothian (United Kingdom)";
            }
            case "GB-MON": {
                return "Monmouthshire (United Kingdom)";
            }
            case "GB-MRT": {
                return "Merton (United Kingdom)";
            }
            case "GB-MRY": {
                return "Moray (United Kingdom)";
            }
            case "GB-MTY": {
                return "Merthyr Tydfil (United Kingdom)";
            }
            case "GB-MYL": {
                return "Moyle (United Kingdom)";
            }
            case "GB-NAY": {
                return "North Ayrshire (United Kingdom)";
            }
            case "GB-NBL": {
                return "Northumberland (United Kingdom)";
            }
            case "GB-NDN": {
                return "North Down (United Kingdom)";
            }
            case "GB-NEL": {
                return "North East Lincolnshire (United Kingdom)";
            }
            case "GB-NET": {
                return "Newcastle upon Tyne (United Kingdom)";
            }
            case "GB-NFK": {
                return "Norfolk (United Kingdom)";
            }
            case "GB-NGM": {
                return "Nottingham (United Kingdom)";
            }
            case "GB-NIR": {
                return "Northern Ireland (United Kingdom)";
            }
            case "GB-NLK": {
                return "North Lanarkshire (United Kingdom)";
            }
            case "GB-NLN": {
                return "North Lincolnshire (United Kingdom)";
            }
            case "GB-NSM": {
                return "North Somerset (United Kingdom)";
            }
            case "GB-NTA": {
                return "Newtownabbey (United Kingdom)";
            }
            case "GB-NTH": {
                return "Northamptonshire (United Kingdom)";
            }
            case "GB-NTL": {
                return "Neath Port Talbot (United Kingdom)";
            }
            case "GB-NTT": {
                return "Nottinghamshire (United Kingdom)";
            }
            case "GB-NTY": {
                return "North Tyneside (United Kingdom)";
            }
            case "GB-NWM": {
                return "Newham (United Kingdom)";
            }
            case "GB-NWP": {
                return "Newport (United Kingdom)";
            }
            case "GB-NYK": {
                return "North Yorkshire (United Kingdom)";
            }
            case "GB-NYM": {
                return "Newry and Mourne (United Kingdom)";
            }
            case "GB-OLD": {
                return "Oldham (United Kingdom)";
            }
            case "GB-OMH": {
                return "Omagh (United Kingdom)";
            }
            case "GB-ORK": {
                return "Orkney Islands (United Kingdom)";
            }
            case "GB-OXF": {
                return "Oxfordshire (United Kingdom)";
            }
            case "GB-PEM": {
                return "Pembrokeshire (United Kingdom)";
            }
            case "GB-PKN": {
                return "Perth and Kinross (United Kingdom)";
            }
            case "GB-PLY": {
                return "Plymouth (United Kingdom)";
            }
            case "GB-POL": {
                return "Poole (United Kingdom)";
            }
            case "GB-POR": {
                return "Portsmouth (United Kingdom)";
            }
            case "GB-POW": {
                return "Powys (United Kingdom)";
            }
            case "GB-PTE": {
                return "Peterborough (United Kingdom)";
            }
            case "GB-RCC": {
                return "Redcar and Cleveland (United Kingdom)";
            }
            case "GB-RCH": {
                return "Rochdale (United Kingdom)";
            }
            case "GB-RCT": {
                return "Rhondda, Cynon, Taff (United Kingdom)";
            }
            case "GB-RDB": {
                return "Redbridge (United Kingdom)";
            }
            case "GB-RDG": {
                return "Reading (United Kingdom)";
            }
            case "GB-RFW": {
                return "Renfrewshire (United Kingdom)";
            }
            case "GB-RIC": {
                return "Richmond upon Thames (United Kingdom)";
            }
            case "GB-ROT": {
                return "Rotherham (United Kingdom)";
            }
            case "GB-RUT": {
                return "Rutland (United Kingdom)";
            }
            case "GB-SAW": {
                return "Sandwell (United Kingdom)";
            }
            case "GB-SAY": {
                return "South Ayrshire (United Kingdom)";
            }
            case "GB-SCB": {
                return "Scottish Borders, The (United Kingdom)";
            }
            case "GB-SCT": {
                return "Scotland (United Kingdom)";
            }
            case "GB-SFK": {
                return "Suffolk (United Kingdom)";
            }
            case "GB-SFT": {
                return "Sefton (United Kingdom)";
            }
            case "GB-SGC": {
                return "South Gloucestershire (United Kingdom)";
            }
            case "GB-SHF": {
                return "Sheffield (United Kingdom)";
            }
            case "GB-SHN": {
                return "St. Helens (United Kingdom)";
            }
            case "GB-SHR": {
                return "Shropshire (United Kingdom)";
            }
            case "GB-SKP": {
                return "Stockport (United Kingdom)";
            }
            case "GB-SLF": {
                return "Salford (United Kingdom)";
            }
            case "GB-SLG": {
                return "Slough (United Kingdom)";
            }
            case "GB-SLK": {
                return "South Lanarkshire (United Kingdom)";
            }
            case "GB-SND": {
                return "Sunderland (United Kingdom)";
            }
            case "GB-SOL": {
                return "Solihull (United Kingdom)";
            }
            case "GB-SOM": {
                return "Somerset (United Kingdom)";
            }
            case "GB-SOS": {
                return "Southend-on-Sea (United Kingdom)";
            }
            case "GB-SRY": {
                return "Surrey (United Kingdom)";
            }
            case "GB-STB": {
                return "Strabane (United Kingdom)";
            }
            case "GB-STE": {
                return "Stoke-on-Trent (United Kingdom)";
            }
            case "GB-STG": {
                return "Stirling (United Kingdom)";
            }
            case "GB-STH": {
                return "Southampton (United Kingdom)";
            }
            case "GB-STN": {
                return "Sutton (United Kingdom)";
            }
            case "GB-STS": {
                return "Staffordshire (United Kingdom)";
            }
            case "GB-STT": {
                return "Stockton-on-Tees (United Kingdom)";
            }
            case "GB-STY": {
                return "South Tyneside (United Kingdom)";
            }
            case "GB-SWA": {
                return "Swansea (United Kingdom)";
            }
            case "GB-SWD": {
                return "Swindon (United Kingdom)";
            }
            case "GB-SWK": {
                return "Southwark (United Kingdom)";
            }
            case "GB-TAM": {
                return "Tameside (United Kingdom)";
            }
            case "GB-TFW": {
                return "Telford and Wrekin (United Kingdom)";
            }
            case "GB-THR": {
                return "Thurrock (United Kingdom)";
            }
            case "GB-TOB": {
                return "Torbay (United Kingdom)";
            }
            case "GB-TOF": {
                return "Torfaen (United Kingdom)";
            }
            case "GB-TRF": {
                return "Trafford (United Kingdom)";
            }
            case "GB-TWH": {
                return "Tower Hamlets (United Kingdom)";
            }
            case "GB-UKM": {
                return "United Kingdom (United Kingdom)";
            }
            case "GB-VGL": {
                return "Vale of Glamorgan, The (United Kingdom)";
            }
            case "GB-WAR": {
                return "Warwickshire (United Kingdom)";
            }
            case "GB-WBK": {
                return "West Berkshire (United Kingdom)";
            }
            case "GB-WDU": {
                return "West Dunbartonshire (United Kingdom)";
            }
            case "GB-WFT": {
                return "Waltham Forest (United Kingdom)";
            }
            case "GB-WGN": {
                return "Wigan (United Kingdom)";
            }
            case "GB-WIL": {
                return "Wiltshire (United Kingdom)";
            }
            case "GB-WKF": {
                return "Wakefield (United Kingdom)";
            }
            case "GB-WLL": {
                return "Walsall (United Kingdom)";
            }
            case "GB-WLN": {
                return "West Lothian (United Kingdom)";
            }
            case "GB-WLS": {
                return "Wales (United Kingdom)";
            }
            case "GB-WLV": {
                return "Wolverhampton (United Kingdom)";
            }
            case "GB-WND": {
                return "Wandsworth (United Kingdom)";
            }
            case "GB-WNM": {
                return "Windsor and Maidenhead (United Kingdom)";
            }
            case "GB-WOK": {
                return "Wokingham (United Kingdom)";
            }
            case "GB-WOR": {
                return "Worcestershire (United Kingdom)";
            }
            case "GB-WRL": {
                return "Wirral (United Kingdom)";
            }
            case "GB-WRT": {
                return "Warrington (United Kingdom)";
            }
            case "GB-WRX": {
                return "Wrexham (United Kingdom)";
            }
            case "GB-WSM": {
                return "Westminster (United Kingdom)";
            }
            case "GB-WSX": {
                return "West Sussex (United Kingdom)";
            }
            case "GB-YOR": {
                return "York (United Kingdom)";
            }
            case "GB-ZET": {
                return "Shetland Islands (United Kingdom)";
            }
            case "GD-01": {
                return "Saint Andrew (Grenada)";
            }
            case "GD-02": {
                return "Saint David (Grenada)";
            }
            case "GD-03": {
                return "Saint George (Grenada)";
            }
            case "GD-04": {
                return "Saint John (Grenada)";
            }
            case "GD-05": {
                return "Saint Mark (Grenada)";
            }
            case "GD-06": {
                return "Saint Patrick (Grenada)";
            }
            case "GD-10": {
                return "Southern Grenadine Islands (Grenada)";
            }
            case "GE-AB": {
                return "Abkhazia (Georgia)";
            }
            case "GE-AJ": {
                return "Ajaria (Georgia)";
            }
            case "GE-GU": {
                return "Guria (Georgia)";
            }
            case "GE-IM": {
                return "Imereti (Georgia)";
            }
            case "GE-KA": {
                return "K'akheti (Georgia)";
            }
            case "GE-KK": {
                return "Kvemo Kartli (Georgia)";
            }
            case "GE-MM": {
                return "Mtskheta-Mtianeti (Georgia)";
            }
            case "GE-RL": {
                return "Rach'a-Lechkhumi-Kvemo Svaneti (Georgia)";
            }
            case "GE-SJ": {
                return "Samtskhe-Javakheti (Georgia)";
            }
            case "GE-SK": {
                return "Shida Kartli (Georgia)";
            }
            case "GE-SZ": {
                return "Samegrelo-Zemo Svaneti (Georgia)";
            }
            case "GE-TB": {
                return "Tbilisi (Georgia)";
            }
            case "GF-GF": {
                return "French Guiana (French Guiana)";
            }
            case "GG-GG": {
                return "Guernsey (Guernsey)";
            }
            case "GH-AA": {
                return "Greater Accra (Ghana)";
            }
            case "GH-AH": {
                return "Ashanti (Ghana)";
            }
            case "GH-BA": {
                return "Brong-Ahafo (Ghana)";
            }
            case "GH-CP": {
                return "Central (Ghana)";
            }
            case "GH-EP": {
                return "Eastern (Ghana)";
            }
            case "GH-NP": {
                return "Northern (Ghana)";
            }
            case "GH-TV": {
                return "Volta (Ghana)";
            }
            case "GH-UE": {
                return "Upper East (Ghana)";
            }
            case "GH-UW": {
                return "Upper West (Ghana)";
            }
            case "GH-WP": {
                return "Western (Ghana)";
            }
            case "GI-GI": {
                return "Gibraltar (Gibraltar)";
            }
            case "GL-KU": {
                return "Kommune Kujalleq (Greenland)";
            }
            case "GL-QA": {
                return "Qaasuitsup Kommunia (Greenland)";
            }
            case "GL-QE": {
                return "Qeqqata Kommunia (Greenland)";
            }
            case "GL-SM": {
                return "Kommuneqarfik Sermersooq (Greenland)";
            }
            case "GM-B": {
                return "Banjul (Gambia)";
            }
            case "GM-L": {
                return "Lower River (Gambia)";
            }
            case "GM-M": {
                return "Central River (Gambia)";
            }
            case "GM-N": {
                return "North Bank (Gambia)";
            }
            case "GM-U": {
                return "Upper River (Gambia)";
            }
            case "GM-W": {
                return "Western (Gambia)";
            }
            case "GN-B": {
                return "Bok\u00e9 (Guinea)";
            }
            case "GN-BE": {
                return "Beyla (Guinea)";
            }
            case "GN-BF": {
                return "Boffa (Guinea)";
            }
            case "GN-BK": {
                return "Bok\u00e9 (Guinea)";
            }
            case "GN-C": {
                return "Conakry (Guinea)";
            }
            case "GN-CO": {
                return "Coyah (Guinea)";
            }
            case "GN-D": {
                return "Kindia (Guinea)";
            }
            case "GN-DB": {
                return "Dabola (Guinea)";
            }
            case "GN-DI": {
                return "Dinguiraye (Guinea)";
            }
            case "GN-DL": {
                return "Dalaba (Guinea)";
            }
            case "GN-DU": {
                return "Dubr\u00e9ka (Guinea)";
            }
            case "GN-F": {
                return "Faranah (Guinea)";
            }
            case "GN-FA": {
                return "Faranah (Guinea)";
            }
            case "GN-FO": {
                return "For\u00e9cariah (Guinea)";
            }
            case "GN-FR": {
                return "Fria (Guinea)";
            }
            case "GN-GA": {
                return "Gaoual (Guinea)";
            }
            case "GN-GU": {
                return "Gu\u00e9k\u00e9dou (Guinea)";
            }
            case "GN-K": {
                return "Kankan (Guinea)";
            }
            case "GN-KA": {
                return "Kankan (Guinea)";
            }
            case "GN-KB": {
                return "Koubia (Guinea)";
            }
            case "GN-KD": {
                return "Kindia (Guinea)";
            }
            case "GN-KE": {
                return "K\u00e9rouan\u00e9 (Guinea)";
            }
            case "GN-KN": {
                return "Koundara (Guinea)";
            }
            case "GN-KO": {
                return "Kouroussa (Guinea)";
            }
            case "GN-KS": {
                return "Kissidougou (Guinea)";
            }
            case "GN-L": {
                return "Lab\u00e9 (Guinea)";
            }
            case "GN-LA": {
                return "Lab\u00e9 (Guinea)";
            }
            case "GN-LE": {
                return "L\u00e9louma (Guinea)";
            }
            case "GN-LO": {
                return "Lola (Guinea)";
            }
            case "GN-M": {
                return "Mamou (Guinea)";
            }
            case "GN-MC": {
                return "Macenta (Guinea)";
            }
            case "GN-MD": {
                return "Mandiana (Guinea)";
            }
            case "GN-ML": {
                return "Mali (Guinea)";
            }
            case "GN-MM": {
                return "Mamou (Guinea)";
            }
            case "GN-N": {
                return "Nz\u00e9r\u00e9kor\u00e9 (Guinea)";
            }
            case "GN-NZ": {
                return "Nz\u00e9r\u00e9kor\u00e9 (Guinea)";
            }
            case "GN-PI": {
                return "Pita (Guinea)";
            }
            case "GN-SI": {
                return "Siguiri (Guinea)";
            }
            case "GN-TE": {
                return "T\u00e9lim\u00e9l\u00e9 (Guinea)";
            }
            case "GN-TO": {
                return "Tougu\u00e9 (Guinea)";
            }
            case "GN-YO": {
                return "Yomou (Guinea)";
            }
            case "GP-GP": {
                return "Guadeloupe (Guadeloupe)";
            }
            case "GQ-AN": {
                return "Annob\u00f3n (Equatorial Guinea)";
            }
            case "GQ-BN": {
                return "Bioko Nord (Equatorial Guinea)";
            }
            case "GQ-BS": {
                return "Bioko Sud (Equatorial Guinea)";
            }
            case "GQ-C": {
                return "Regi\u00e3o Continental (Equatorial Guinea)";
            }
            case "GQ-CS": {
                return "Centro Sud (Equatorial Guinea)";
            }
            case "GQ-I": {
                return "Regi\u00e3o Insular (Equatorial Guinea)";
            }
            case "GQ-KN": {
                return "Ki\u00e9-Ntem (Equatorial Guinea)";
            }
            case "GQ-LI": {
                return "Litoral (Equatorial Guinea)";
            }
            case "GQ-WN": {
                return "Wele-Nzas (Equatorial Guinea)";
            }
            case "GR-01": {
                return "Aitoloakarnan\u00eda (Greece)";
            }
            case "GR-03": {
                return "Voiot\u00eda (Greece)";
            }
            case "GR-04": {
                return "\u00c9vvoia (Greece)";
            }
            case "GR-05": {
                return "Evrytan\u00eda (Greece)";
            }
            case "GR-06": {
                return "Fthi\u00f3tida (Greece)";
            }
            case "GR-07": {
                return "Fok\u00edda (Greece)";
            }
            case "GR-11": {
                return "Argol\u00edda (Greece)";
            }
            case "GR-12": {
                return "Arkad\u00eda (Greece)";
            }
            case "GR-13": {
                return "Acha\u1e2fa (Greece)";
            }
            case "GR-14": {
                return "Ile\u00eda (Greece)";
            }
            case "GR-15": {
                return "Korinth\u00eda (Greece)";
            }
            case "GR-16": {
                return "Lakon\u00eda (Greece)";
            }
            case "GR-17": {
                return "Messin\u00eda (Greece)";
            }
            case "GR-21": {
                return "Z\u00e1kynthos (Greece)";
            }
            case "GR-22": {
                return "K\u00e9rkyra (Greece)";
            }
            case "GR-23": {
                return "Kefallin\u00eda (Greece)";
            }
            case "GR-24": {
                return "Lefk\u00e1da (Greece)";
            }
            case "GR-31": {
                return "\u00c1rta (Greece)";
            }
            case "GR-32": {
                return "Thesprot\u00eda (Greece)";
            }
            case "GR-33": {
                return "Io\u00e1nnina (Greece)";
            }
            case "GR-34": {
                return "Pr\u00e9veza (Greece)";
            }
            case "GR-41": {
                return "Kard\u00edtsa (Greece)";
            }
            case "GR-42": {
                return "L\u00e1risa (Greece)";
            }
            case "GR-43": {
                return "Magnis\u00eda (Greece)";
            }
            case "GR-44": {
                return "Tr\u00edkala (Greece)";
            }
            case "GR-51": {
                return "Greven\u00e1 (Greece)";
            }
            case "GR-52": {
                return "Dr\u00e1ma (Greece)";
            }
            case "GR-53": {
                return "Imath\u00eda (Greece)";
            }
            case "GR-54": {
                return "Thessalon\u00edki (Greece)";
            }
            case "GR-55": {
                return "Kav\u00e1la (Greece)";
            }
            case "GR-56": {
                return "Kastori\u00e1 (Greece)";
            }
            case "GR-57": {
                return "Kilk\u00eds (Greece)";
            }
            case "GR-58": {
                return "Koz\u00e1ni (Greece)";
            }
            case "GR-59": {
                return "P\u00e9lla (Greece)";
            }
            case "GR-61": {
                return "Pier\u00eda (Greece)";
            }
            case "GR-62": {
                return "S\u00e9rres (Greece)";
            }
            case "GR-63": {
                return "Fl\u00f3rina (Greece)";
            }
            case "GR-64": {
                return "Chalkidik\u00ed (Greece)";
            }
            case "GR-69": {
                return "\u00c1gion \u00d3ros (Greece)";
            }
            case "GR-71": {
                return "\u00c9vros (Greece)";
            }
            case "GR-72": {
                return "X\u00e1nthi (Greece)";
            }
            case "GR-73": {
                return "Rod\u00f3pi (Greece)";
            }
            case "GR-81": {
                return "Dodek\u00e1nisa (Greece)";
            }
            case "GR-82": {
                return "Kykl\u00e1des (Greece)";
            }
            case "GR-83": {
                return "L\u00e9svos (Greece)";
            }
            case "GR-84": {
                return "S\u00e1mos (Greece)";
            }
            case "GR-85": {
                return "Ch\u00edos (Greece)";
            }
            case "GR-91": {
                return "Irakle\u00edo (Greece)";
            }
            case "GR-92": {
                return "Las\u00edthi (Greece)";
            }
            case "GR-93": {
                return "Reth\u00fdmnis (Greece)";
            }
            case "GR-94": {
                return "Chani\u00e1 (Greece)";
            }
            case "GR-A": {
                return "Anatolik\u00ed Makedon\u00eda kai Thr\u00e1ki (Greece)";
            }
            case "GR-A1": {
                return "Attik\u00ed (Greece)";
            }
            case "GR-B": {
                return "Kentrik\u00ed Makedon\u00eda (Greece)";
            }
            case "GR-C": {
                return "Dytik\u00ed Makedon\u00eda (Greece)";
            }
            case "GR-D": {
                return "\u00cdpeiros (Greece)";
            }
            case "GR-E": {
                return "Thessal\u00eda (Greece)";
            }
            case "GR-F": {
                return "Ion\u00eda N\u00edsia (Greece)";
            }
            case "GR-G": {
                return "Dytik\u00ed Ell\u00e1da (Greece)";
            }
            case "GR-H": {
                return "Stere\u00e1 Ell\u00e1da (Greece)";
            }
            case "GR-I": {
                return "Attik\u00ed (Greece)";
            }
            case "GR-J": {
                return "Peloponn\u00edsos (Greece)";
            }
            case "GR-K": {
                return "Vore\u00edo Aiga\u00edo (Greece)";
            }
            case "GR-L": {
                return "Not\u00edo Aiga\u00edo (Greece)";
            }
            case "GR-M": {
                return "Kr\u00edt\u00ed (Greece)";
            }
            case "GS-GS": {
                return "S.Georgia & S.Sandwich Islands (S.Georgia & S.Sandwich Islands)";
            }
            case "GT-AV": {
                return "Alta Verapaz (Guatemala)";
            }
            case "GT-BV": {
                return "Baja Verapaz (Guatemala)";
            }
            case "GT-CM": {
                return "Chimaltenango (Guatemala)";
            }
            case "GT-CQ": {
                return "Chiquimula (Guatemala)";
            }
            case "GT-ES": {
                return "Escuintla (Guatemala)";
            }
            case "GT-GU": {
                return "Guatemala (Guatemala)";
            }
            case "GT-HU": {
                return "Huehuetenango (Guatemala)";
            }
            case "GT-IZ": {
                return "Izabal (Guatemala)";
            }
            case "GT-JA": {
                return "Jalapa (Guatemala)";
            }
            case "GT-JU": {
                return "Jutiapa (Guatemala)";
            }
            case "GT-PE": {
                return "Pet\u00e9n (Guatemala)";
            }
            case "GT-PR": {
                return "El Progreso (Guatemala)";
            }
            case "GT-QC": {
                return "Quich\u00e9 (Guatemala)";
            }
            case "GT-QZ": {
                return "Quetzaltenango (Guatemala)";
            }
            case "GT-RE": {
                return "Retalhuleu (Guatemala)";
            }
            case "GT-SA": {
                return "Sacatep\u00e9quez (Guatemala)";
            }
            case "GT-SM": {
                return "San Marcos (Guatemala)";
            }
            case "GT-SO": {
                return "Solol\u00e1 (Guatemala)";
            }
            case "GT-SR": {
                return "Santa Rosa (Guatemala)";
            }
            case "GT-SU": {
                return "Suchitep\u00e9quez (Guatemala)";
            }
            case "GT-TO": {
                return "Totonicap\u00e1n (Guatemala)";
            }
            case "GT-ZA": {
                return "Zacapa (Guatemala)";
            }
            case "GU-GU": {
                return "Guam (Guam)";
            }
            case "GW-BA": {
                return "Bafat\u00e1 (Guinea-Bissau)";
            }
            case "GW-BL": {
                return "Bolama (Guinea-Bissau)";
            }
            case "GW-BM": {
                return "Biombo (Guinea-Bissau)";
            }
            case "GW-BS": {
                return "Bissau (Guinea-Bissau)";
            }
            case "GW-CA": {
                return "Cacheu (Guinea-Bissau)";
            }
            case "GW-GA": {
                return "Gab\u00fa (Guinea-Bissau)";
            }
            case "GW-L": {
                return "Leste (Guinea-Bissau)";
            }
            case "GW-N": {
                return "Norte (Guinea-Bissau)";
            }
            case "GW-OI": {
                return "Oio (Guinea-Bissau)";
            }
            case "GW-QU": {
                return "Quinara (Guinea-Bissau)";
            }
            case "GW-S": {
                return "Sul (Guinea-Bissau)";
            }
            case "GW-TO": {
                return "Tombali (Guinea-Bissau)";
            }
            case "GY-BA": {
                return "Barima-Waini (Guyana)";
            }
            case "GY-CU": {
                return "Cuyuni-Mazaruni (Guyana)";
            }
            case "GY-DE": {
                return "Demerara-Mahaica (Guyana)";
            }
            case "GY-EB": {
                return "East Berbice-Corentyne (Guyana)";
            }
            case "GY-ES": {
                return "Essequibo Islands-West Demerara (Guyana)";
            }
            case "GY-MA": {
                return "Mahaica-Berbice (Guyana)";
            }
            case "GY-PM": {
                return "Pomeroon-Supenaam (Guyana)";
            }
            case "GY-PT": {
                return "Potaro-Siparuni (Guyana)";
            }
            case "GY-UD": {
                return "Upper Demerara-Berbice (Guyana)";
            }
            case "GY-UT": {
                return "Upper Takutu-Upper Essequibo (Guyana)";
            }
            case "HK-HK": {
                return "Hong Kong (Hong Kong)";
            }
            case "HM-HM": {
                return "Heard & McDonald Islands (Heard & McDonald Islands)";
            }
            case "HN-AT": {
                return "Atl\u00e1ntida (Honduras)";
            }
            case "HN-CH": {
                return "Choluteca (Honduras)";
            }
            case "HN-CL": {
                return "Col\u00f3n (Honduras)";
            }
            case "HN-CM": {
                return "Comayagua (Honduras)";
            }
            case "HN-CP": {
                return "Cop\u00e1n (Honduras)";
            }
            case "HN-CR": {
                return "Cort\u00e9s (Honduras)";
            }
            case "HN-EP": {
                return "El Para\u00edso (Honduras)";
            }
            case "HN-FM": {
                return "Francisco Moraz\u00e1n (Honduras)";
            }
            case "HN-GD": {
                return "Gracias a Dios (Honduras)";
            }
            case "HN-IB": {
                return "Islas de la Bah\u00eda (Honduras)";
            }
            case "HN-IN": {
                return "Intibuc\u00e1 (Honduras)";
            }
            case "HN-LE": {
                return "Lempira (Honduras)";
            }
            case "HN-LP": {
                return "La Paz (Honduras)";
            }
            case "HN-OC": {
                return "Ocotepeque (Honduras)";
            }
            case "HN-OL": {
                return "Olancho (Honduras)";
            }
            case "HN-SB": {
                return "Santa B\u00e1rbara (Honduras)";
            }
            case "HN-VA": {
                return "Valle (Honduras)";
            }
            case "HN-YO": {
                return "Yoro (Honduras)";
            }
            case "HR-01": {
                return "Zagreba\u010dka \u017eupanija (Croatia)";
            }
            case "HR-02": {
                return "Krapinsko-zagorska \u017eupanija (Croatia)";
            }
            case "HR-03": {
                return "Sisa\u010dko-moslava\u010dka \u017eupanija (Croatia)";
            }
            case "HR-04": {
                return "Karlova\u010dka \u017eupanija (Croatia)";
            }
            case "HR-05": {
                return "Vara\u017edinska \u017eupanija (Croatia)";
            }
            case "HR-06": {
                return "Koprivni\u010dko-kri\u017eeva\u010dka \u017eupanija (Croatia)";
            }
            case "HR-07": {
                return "Bjelovarsko-bilogorska \u017eupanija (Croatia)";
            }
            case "HR-08": {
                return "Primorsko-goranska \u017eupanija (Croatia)";
            }
            case "HR-09": {
                return "Li\u010dko-senjska \u017eupanija (Croatia)";
            }
            case "HR-10": {
                return "Viroviti\u010dko-podravska \u017eupanija (Croatia)";
            }
            case "HR-11": {
                return "Po\u017ee\u0161ko-slavonska \u017eupanija (Croatia)";
            }
            case "HR-12": {
                return "Brodsko-posavska \u017eupanija (Croatia)";
            }
            case "HR-13": {
                return "Zadarska \u017eupanija (Croatia)";
            }
            case "HR-14": {
                return "Osje\u010dko-baranjska \u017eupanija (Croatia)";
            }
            case "HR-15": {
                return "\u0160ibensko-kninska \u017eupanija (Croatia)";
            }
            case "HR-16": {
                return "Vukovarsko-srijemska \u017eupanija (Croatia)";
            }
            case "HR-17": {
                return "Splitsko-dalmatinska \u017eupanija (Croatia)";
            }
            case "HR-18": {
                return "Istarska \u017eupanija (Croatia)";
            }
            case "HR-19": {
                return "Dubrova\u010dko-neretvanska \u017eupanija (Croatia)";
            }
            case "HR-20": {
                return "Me\u0111imurska \u017eupanija (Croatia)";
            }
            case "HR-21": {
                return "Grad Zagreb (Croatia)";
            }
            case "HT-AR": {
                return "Artibonite (Haiti)";
            }
            case "HT-CE": {
                return "Centre (Haiti)";
            }
            case "HT-GA": {
                return "Grandans (Haiti)";
            }
            case "HT-ND": {
                return "N\u00f2 (Haiti)";
            }
            case "HT-NE": {
                return "N\u00f2d\u00e8s (Haiti)";
            }
            case "HT-NI": {
                return "Nip (Haiti)";
            }
            case "HT-NO": {
                return "N\u00f2dw\u00e8s (Haiti)";
            }
            case "HT-OU": {
                return "Lw\u00e8s (Haiti)";
            }
            case "HT-SD": {
                return "Sid (Haiti)";
            }
            case "HT-SE": {
                return "Sid\u00e8s (Haiti)";
            }
            case "HU-BA": {
                return "Baranya (Hungary)";
            }
            case "HU-BC": {
                return "B\u00e9k\u00e9scsaba (Hungary)";
            }
            case "HU-BE": {
                return "B\u00e9k\u00e9s (Hungary)";
            }
            case "HU-BK": {
                return "B\u00e1cs-Kiskun (Hungary)";
            }
            case "HU-BU": {
                return "Budapest (Hungary)";
            }
            case "HU-BZ": {
                return "Borsod-Aba\u00faj-Zempl\u00e9n (Hungary)";
            }
            case "HU-CS": {
                return "Csongr\u00e1d (Hungary)";
            }
            case "HU-DE": {
                return "Debrecen (Hungary)";
            }
            case "HU-DU": {
                return "Duna\u00fajv\u00e1ros (Hungary)";
            }
            case "HU-EG": {
                return "Eger (Hungary)";
            }
            case "HU-ER": {
                return "\u00c9rd (Hungary)";
            }
            case "HU-FE": {
                return "Fej\u00e9r (Hungary)";
            }
            case "HU-GS": {
                return "Gy\u0151r-Moson-Sopron (Hungary)";
            }
            case "HU-GY": {
                return "Gy\u0151r (Hungary)";
            }
            case "HU-HB": {
                return "Hajd\u00fa-Bihar (Hungary)";
            }
            case "HU-HE": {
                return "Heves (Hungary)";
            }
            case "HU-HV": {
                return "H\u00f3dmez\u0151v\u00e1s\u00e1rhely (Hungary)";
            }
            case "HU-JN": {
                return "J\u00e1sz-Nagykun-Szolnok (Hungary)";
            }
            case "HU-KE": {
                return "Kom\u00e1rom-Esztergom (Hungary)";
            }
            case "HU-KM": {
                return "Kecskem\u00e9t (Hungary)";
            }
            case "HU-KV": {
                return "Kaposv\u00e1r (Hungary)";
            }
            case "HU-MI": {
                return "Miskolc (Hungary)";
            }
            case "HU-NK": {
                return "Nagykanizsa (Hungary)";
            }
            case "HU-NO": {
                return "N\u00f3gr\u00e1d (Hungary)";
            }
            case "HU-NY": {
                return "Ny\u00edregyh\u00e1za (Hungary)";
            }
            case "HU-PE": {
                return "Pest (Hungary)";
            }
            case "HU-PS": {
                return "P\u00e9cs (Hungary)";
            }
            case "HU-SD": {
                return "Szeged (Hungary)";
            }
            case "HU-SF": {
                return "Sz\u00e9kesfeh\u00e9rv\u00e1r (Hungary)";
            }
            case "HU-SH": {
                return "Szombathely (Hungary)";
            }
            case "HU-SK": {
                return "Szolnok (Hungary)";
            }
            case "HU-SN": {
                return "Sopron (Hungary)";
            }
            case "HU-SO": {
                return "Somogy (Hungary)";
            }
            case "HU-SS": {
                return "Szeksz\u00e1rd (Hungary)";
            }
            case "HU-ST": {
                return "Salg\u00f3tarj\u00e1n (Hungary)";
            }
            case "HU-SZ": {
                return "Szabolcs-Szatm\u00e1r-Bereg (Hungary)";
            }
            case "HU-TB": {
                return "Tatab\u00e1nya (Hungary)";
            }
            case "HU-TO": {
                return "Tolna (Hungary)";
            }
            case "HU-VA": {
                return "Vas (Hungary)";
            }
            case "HU-VE": {
                return "Veszpr\u00e9m (Hungary)";
            }
            case "HU-VM": {
                return "Veszpr\u00e9m (Hungary)";
            }
            case "HU-ZA": {
                return "Zala (Hungary)";
            }
            case "HU-ZE": {
                return "Zalaegerszeg (Hungary)";
            }
            case "ID-AC": {
                return "Aceh (Indonesia)";
            }
            case "ID-BA": {
                return "Bali (Indonesia)";
            }
            case "ID-BB": {
                return "Bangka Belitung (Indonesia)";
            }
            case "ID-BE": {
                return "Bengkulu (Indonesia)";
            }
            case "ID-BT": {
                return "Banten (Indonesia)";
            }
            case "ID-GO": {
                return "Gorontalo (Indonesia)";
            }
            case "ID-JA": {
                return "Jambi (Indonesia)";
            }
            case "ID-JB": {
                return "Jawa Barat (Indonesia)";
            }
            case "ID-JI": {
                return "Jawa Timur (Indonesia)";
            }
            case "ID-JK": {
                return "Jakarta Raya (Indonesia)";
            }
            case "ID-JT": {
                return "Jawa Tengah (Indonesia)";
            }
            case "ID-JW": {
                return "Jawa (Indonesia)";
            }
            case "ID-KA": {
                return "Kalimantan (Indonesia)";
            }
            case "ID-KB": {
                return "Kalimantan Barat (Indonesia)";
            }
            case "ID-KI": {
                return "Kalimantan Timur (Indonesia)";
            }
            case "ID-KR": {
                return "Kepulauan Riau (Indonesia)";
            }
            case "ID-KS": {
                return "Kalimantan Selatan (Indonesia)";
            }
            case "ID-KT": {
                return "Kalimantan Tengah (Indonesia)";
            }
            case "ID-KU": {
                return "Kalimantan Utara (Indonesia)";
            }
            case "ID-LA": {
                return "Lampung (Indonesia)";
            }
            case "ID-MA": {
                return "Maluku (Indonesia)";
            }
            case "ID-ML": {
                return "Maluku (Indonesia)";
            }
            case "ID-MU": {
                return "Maluku Utara (Indonesia)";
            }
            case "ID-NB": {
                return "Nusa Tenggara Barat (Indonesia)";
            }
            case "ID-NT": {
                return "Nusa Tenggara Timur (Indonesia)";
            }
            case "ID-NU": {
                return "Nusa Tenggara (Indonesia)";
            }
            case "ID-PA": {
                return "Papua (Indonesia)";
            }
            case "ID-PB": {
                return "Papua Barat (Indonesia)";
            }
            case "ID-PP": {
                return "Papua (Indonesia)";
            }
            case "ID-RI": {
                return "Riau (Indonesia)";
            }
            case "ID-SA": {
                return "Sulawesi Utara (Indonesia)";
            }
            case "ID-SB": {
                return "Sumatera Barat (Indonesia)";
            }
            case "ID-SG": {
                return "Sulawesi Tenggara (Indonesia)";
            }
            case "ID-SL": {
                return "Sulawesi (Indonesia)";
            }
            case "ID-SM": {
                return "Sumatera (Indonesia)";
            }
            case "ID-SN": {
                return "Sulawesi Selatan (Indonesia)";
            }
            case "ID-SR": {
                return "Sulawesi Barat (Indonesia)";
            }
            case "ID-SS": {
                return "Sumatera Selatan (Indonesia)";
            }
            case "ID-ST": {
                return "Sulawesi Tengah (Indonesia)";
            }
            case "ID-SU": {
                return "Sumatera Utara (Indonesia)";
            }
            case "ID-YO": {
                return "Yogyakarta (Indonesia)";
            }
            case "IE-C": {
                return "Connacht (Ireland)";
            }
            case "IE-CE": {
                return "An Cl\u00e1r (Ireland)";
            }
            case "IE-CN": {
                return "An Cabh\u00e1n (Ireland)";
            }
            case "IE-CO": {
                return "Corcaigh (Ireland)";
            }
            case "IE-CW": {
                return "Carlow (Ireland)";
            }
            case "IE-D": {
                return "Baile \u00c1tha Cliath (Ireland)";
            }
            case "IE-DL": {
                return "Donegal (Ireland)";
            }
            case "IE-G": {
                return "Gaillimh (Ireland)";
            }
            case "IE-KE": {
                return "Cill Dara (Ireland)";
            }
            case "IE-KK": {
                return "Cill Chainnigh (Ireland)";
            }
            case "IE-KY": {
                return "Ciarra\u00ed (Ireland)";
            }
            case "IE-L": {
                return "Laighin (Ireland)";
            }
            case "IE-LD": {
                return "An Longfort (Ireland)";
            }
            case "IE-LH": {
                return "Louth (Ireland)";
            }
            case "IE-LK": {
                return "Limerick (Ireland)";
            }
            case "IE-LM": {
                return "Leitrim (Ireland)";
            }
            case "IE-LS": {
                return "Laois (Ireland)";
            }
            case "IE-M": {
                return "An Mhumhain (Ireland)";
            }
            case "IE-MH": {
                return "An Mh\u00ed (Ireland)";
            }
            case "IE-MN": {
                return "Monaghan (Ireland)";
            }
            case "IE-MO": {
                return "Maigh Eo (Ireland)";
            }
            case "IE-OY": {
                return "Offaly (Ireland)";
            }
            case "IE-RN": {
                return "Ros Com\u00e1in (Ireland)";
            }
            case "IE-SO": {
                return "Sligeach (Ireland)";
            }
            case "IE-TA": {
                return "Tiobraid \u00c1rann (Ireland)";
            }
            case "IE-U": {
                return "Ulaidh (Ireland)";
            }
            case "IE-WD": {
                return "Port L\u00e1irge (Ireland)";
            }
            case "IE-WH": {
                return "An Iarmh\u00ed (Ireland)";
            }
            case "IE-WW": {
                return "Cill Mhant\u00e1in (Ireland)";
            }
            case "IE-WX": {
                return "Loch Garman (Ireland)";
            }
            case "IL-D": {
                return "Southern District (Israel)";
            }
            case "IL-HA": {
                return "Haifa (Israel)";
            }
            case "IL-JM": {
                return "Jerusalem (Israel)";
            }
            case "IL-M": {
                return "Central District (Israel)";
            }
            case "IL-TA": {
                return "Tel Aviv (Israel)";
            }
            case "IL-Z": {
                return "Northern District (Israel)";
            }
            case "IM-IM": {
                return "Isle of Main (Isle of Man)";
            }
            case "IN-AN": {
                return "Andaman and Nicobar Islands (India)";
            }
            case "IN-AP": {
                return "Andhra Pradesh (India)";
            }
            case "IN-AR": {
                return "Arunachal Pradesh (India)";
            }
            case "IN-AS": {
                return "Assam (India)";
            }
            case "IN-BR": {
                return "Bihar (India)";
            }
            case "IN-CH": {
                return "Chandigarh (India)";
            }
            case "IN-CT": {
                return "Chhattisgarh (India)";
            }
            case "IN-DD": {
                return "Daman and Diu (India)";
            }
            case "IN-DL": {
                return "Delhi (India)";
            }
            case "IN-DN": {
                return "Dadra and Nagar Haveli (India)";
            }
            case "IN-GA": {
                return "Goa (India)";
            }
            case "IN-GJ": {
                return "Gujarat (India)";
            }
            case "IN-HP": {
                return "Himachal Pradesh (India)";
            }
            case "IN-HR": {
                return "Haryana (India)";
            }
            case "IN-JH": {
                return "Jharkhand (India)";
            }
            case "IN-JK": {
                return "Jammu and Kashmir (India)";
            }
            case "IN-KA": {
                return "Karnataka (India)";
            }
            case "IN-KL": {
                return "Kerala (India)";
            }
            case "IN-LD": {
                return "Lakshadweep (India)";
            }
            case "IN-MH": {
                return "Maharashtra (India)";
            }
            case "IN-ML": {
                return "Meghalaya (India)";
            }
            case "IN-MN": {
                return "Manipur (India)";
            }
            case "IN-MP": {
                return "Madhya Pradesh (India)";
            }
            case "IN-MZ": {
                return "Mizoram (India)";
            }
            case "IN-NL": {
                return "Nagaland (India)";
            }
            case "IN-OR": {
                return "Odisha (India)";
            }
            case "IN-PB": {
                return "Punjab (India)";
            }
            case "IN-PY": {
                return "Puducherry (India)";
            }
            case "IN-RJ": {
                return "Rajasthan (India)";
            }
            case "IN-SK": {
                return "Sikkim (India)";
            }
            case "IN-TG": {
                return "Telangana (India)";
            }
            case "IN-TN": {
                return "Tamil Nadu (India)";
            }
            case "IN-TR": {
                return "Tripura (India)";
            }
            case "IN-UP": {
                return "Uttar Pradesh (India)";
            }
            case "IN-UT": {
                return "Uttarakhand (India)";
            }
            case "IN-WB": {
                return "West Bengal (India)";
            }
            case "IO-IO": {
                return "British Indian Ocean Territory (British Indian Ocean Territory)";
            }
            case "IQ-AN": {
                return "Al Anb\u0101r (Iraq)";
            }
            case "IQ-AR": {
                return "Arb\u012bl (Iraq)";
            }
            case "IQ-BA": {
                return "Al Ba\u015frah (Iraq)";
            }
            case "IQ-BB": {
                return "B\u0101bil (Iraq)";
            }
            case "IQ-BG": {
                return "Baghd\u0101d (Iraq)";
            }
            case "IQ-DA": {
                return "Dah\u016bk (Iraq)";
            }
            case "IQ-DI": {
                return "Diy\u0101l\u00e1 (Iraq)";
            }
            case "IQ-DQ": {
                return "Dh\u012b Q\u0101r (Iraq)";
            }
            case "IQ-KA": {
                return "Karbal\u0101' (Iraq)";
            }
            case "IQ-KI": {
                return "Kirk\u016bk (Iraq)";
            }
            case "IQ-MA": {
                return "Mays\u0101n (Iraq)";
            }
            case "IQ-MU": {
                return "Al Muthann\u00e1 (Iraq)";
            }
            case "IQ-NA": {
                return "An Najaf (Iraq)";
            }
            case "IQ-NI": {
                return "N\u012bnaw\u00e1 (Iraq)";
            }
            case "IQ-QA": {
                return "Al Q\u0101dis\u012byah (Iraq)";
            }
            case "IQ-SD": {
                return "\u015eal\u0101\u1e29 ad D\u012bn (Iraq)";
            }
            case "IQ-SU": {
                return "As Sulaym\u0101n\u012byah (Iraq)";
            }
            case "IQ-WA": {
                return "W\u0101si\u0163 (Iraq)";
            }
            case "IR-01": {
                return "\u0100z\u0304arb\u0101yj\u0101n-e Sharq\u012b (Iran)";
            }
            case "IR-02": {
                return "\u0100z\u0304arb\u0101yj\u0101n-e Gharb\u012b (Iran)";
            }
            case "IR-03": {
                return "Ardab\u012bl (Iran)";
            }
            case "IR-04": {
                return "E\u015ffah\u0101n (Iran)";
            }
            case "IR-05": {
                return "\u012al\u0101m (Iran)";
            }
            case "IR-06": {
                return "B\u016bshehr (Iran)";
            }
            case "IR-07": {
                return "Tehr\u0101n (Iran)";
            }
            case "IR-08": {
                return "Chah\u0101r Ma\u1e29\u0101ll va Bakht\u012b\u0101r\u012b (Iran)";
            }
            case "IR-10": {
                return "Kh\u016bzest\u0101n (Iran)";
            }
            case "IR-11": {
                return "Zanj\u0101n (Iran)";
            }
            case "IR-12": {
                return "Semn\u0101n (Iran)";
            }
            case "IR-13": {
                return "S\u012bst\u0101n va Bal\u016bchest\u0101n (Iran)";
            }
            case "IR-14": {
                return "F\u0101rs (Iran)";
            }
            case "IR-15": {
                return "Kerm\u0101n (Iran)";
            }
            case "IR-16": {
                return "Kordest\u0101n (Iran)";
            }
            case "IR-17": {
                return "Kerm\u0101nsh\u0101h (Iran)";
            }
            case "IR-18": {
                return "Kohg\u012bl\u016byeh va B\u016byer A\u1e29mad (Iran)";
            }
            case "IR-19": {
                return "G\u012bl\u0101n (Iran)";
            }
            case "IR-20": {
                return "Lorest\u0101n (Iran)";
            }
            case "IR-21": {
                return "M\u0101zandar\u0101n (Iran)";
            }
            case "IR-22": {
                return "Markaz\u012b (Iran)";
            }
            case "IR-23": {
                return "Hormozg\u0101n (Iran)";
            }
            case "IR-24": {
                return "Hamad\u0101n (Iran)";
            }
            case "IR-25": {
                return "Yazd (Iran)";
            }
            case "IR-26": {
                return "Qom (Iran)";
            }
            case "IR-27": {
                return "Golest\u0101n (Iran)";
            }
            case "IR-28": {
                return "Qazv\u012bn (Iran)";
            }
            case "IR-29": {
                return "Khor\u0101s\u0101n-e Jan\u016bb\u012b (Iran)";
            }
            case "IR-30": {
                return "Khor\u0101s\u0101n-e Razav\u012b (Iran)";
            }
            case "IR-31": {
                return "Khor\u0101s\u0101n-e Shem\u0101l\u012b (Iran)";
            }
            case "IR-32": {
                return "Alborz (Iran)";
            }
            case "IS-0": {
                return "Reykjav\u00edk (Iceland)";
            }
            case "IS-1": {
                return "H\u00f6fu\u00f0borgarsv\u00e6\u00f0i utan Reykjav\u00edkur (Iceland)";
            }
            case "IS-2": {
                return "Su\u00f0urnes (Iceland)";
            }
            case "IS-3": {
                return "Vesturland (Iceland)";
            }
            case "IS-4": {
                return "Vestfir\u00f0ir (Iceland)";
            }
            case "IS-5": {
                return "Nor\u00f0urland vestra (Iceland)";
            }
            case "IS-6": {
                return "Nor\u00f0urland eystra (Iceland)";
            }
            case "IS-7": {
                return "Austurland (Iceland)";
            }
            case "IS-8": {
                return "Su\u00f0urland (Iceland)";
            }
            case "IT-21": {
                return "Piemonte (Italy)";
            }
            case "IT-23": {
                return "Val d'Aoste (Italy)";
            }
            case "IT-25": {
                return "Lombardia (Italy)";
            }
            case "IT-32": {
                return "Trentino-Alto Adige (Italy)";
            }
            case "IT-34": {
                return "Veneto (Italy)";
            }
            case "IT-36": {
                return "Friuli-Venezia Giulia (Italy)";
            }
            case "IT-42": {
                return "Liguria (Italy)";
            }
            case "IT-45": {
                return "Emilia-Romagna (Italy)";
            }
            case "IT-52": {
                return "Toscana (Italy)";
            }
            case "IT-55": {
                return "Umbria (Italy)";
            }
            case "IT-57": {
                return "Marche (Italy)";
            }
            case "IT-62": {
                return "Lazio (Italy)";
            }
            case "IT-65": {
                return "Abruzzo (Italy)";
            }
            case "IT-67": {
                return "Molise (Italy)";
            }
            case "IT-72": {
                return "Campania (Italy)";
            }
            case "IT-75": {
                return "Puglia (Italy)";
            }
            case "IT-77": {
                return "Basilicata (Italy)";
            }
            case "IT-78": {
                return "Calabria (Italy)";
            }
            case "IT-82": {
                return "Sicilia (Italy)";
            }
            case "IT-88": {
                return "Sardegna (Italy)";
            }
            case "IT-AG": {
                return "Agrigento (Italy)";
            }
            case "IT-AL": {
                return "Alessandria (Italy)";
            }
            case "IT-AN": {
                return "Ancona (Italy)";
            }
            case "IT-AO": {
                return "Aosta (Italy)";
            }
            case "IT-AP": {
                return "Ascoli Piceno (Italy)";
            }
            case "IT-AQ": {
                return "L'Aquila (Italy)";
            }
            case "IT-AR": {
                return "Arezzo (Italy)";
            }
            case "IT-AT": {
                return "Asti (Italy)";
            }
            case "IT-AV": {
                return "Avellino (Italy)";
            }
            case "IT-BA": {
                return "Bari (Italy)";
            }
            case "IT-BG": {
                return "Bergamo (Italy)";
            }
            case "IT-BI": {
                return "Biella (Italy)";
            }
            case "IT-BL": {
                return "Belluno (Italy)";
            }
            case "IT-BN": {
                return "Benevento (Italy)";
            }
            case "IT-BO": {
                return "Bologna (Italy)";
            }
            case "IT-BR": {
                return "Brindisi (Italy)";
            }
            case "IT-BS": {
                return "Brescia (Italy)";
            }
            case "IT-BT": {
                return "Barletta-Andria-Trani (Italy)";
            }
            case "IT-BZ": {
                return "Bolzano (Italy)";
            }
            case "IT-CA": {
                return "Cagliari (Italy)";
            }
            case "IT-CB": {
                return "Campobasso (Italy)";
            }
            case "IT-CE": {
                return "Caserta (Italy)";
            }
            case "IT-CH": {
                return "Chieti (Italy)";
            }
            case "IT-CI": {
                return "Carbonia-Iglesias (Italy)";
            }
            case "IT-CL": {
                return "Caltanissetta (Italy)";
            }
            case "IT-CN": {
                return "Cuneo (Italy)";
            }
            case "IT-CO": {
                return "Como (Italy)";
            }
            case "IT-CR": {
                return "Cremona (Italy)";
            }
            case "IT-CS": {
                return "Cosenza (Italy)";
            }
            case "IT-CT": {
                return "Catania (Italy)";
            }
            case "IT-CZ": {
                return "Catanzaro (Italy)";
            }
            case "IT-EN": {
                return "Enna (Italy)";
            }
            case "IT-FC": {
                return "Forl\u00ec-Cesena (Italy)";
            }
            case "IT-FE": {
                return "Ferrara (Italy)";
            }
            case "IT-FG": {
                return "Foggia (Italy)";
            }
            case "IT-FI": {
                return "Firenze (Italy)";
            }
            case "IT-FM": {
                return "Fermo (Italy)";
            }
            case "IT-FR": {
                return "Frosinone (Italy)";
            }
            case "IT-GE": {
                return "Genova (Italy)";
            }
            case "IT-GO": {
                return "Gorizia (Italy)";
            }
            case "IT-GR": {
                return "Grosseto (Italy)";
            }
            case "IT-IM": {
                return "Imperia (Italy)";
            }
            case "IT-IS": {
                return "Isernia (Italy)";
            }
            case "IT-KR": {
                return "Crotone (Italy)";
            }
            case "IT-LC": {
                return "Lecco (Italy)";
            }
            case "IT-LE": {
                return "Lecce (Italy)";
            }
            case "IT-LI": {
                return "Livorno (Italy)";
            }
            case "IT-LO": {
                return "Lodi (Italy)";
            }
            case "IT-LT": {
                return "Latina (Italy)";
            }
            case "IT-LU": {
                return "Lucca (Italy)";
            }
            case "IT-MB": {
                return "Monza e Brianza (Italy)";
            }
            case "IT-MC": {
                return "Macerata (Italy)";
            }
            case "IT-ME": {
                return "Messina (Italy)";
            }
            case "IT-MI": {
                return "Milano (Italy)";
            }
            case "IT-MN": {
                return "Mantova (Italy)";
            }
            case "IT-MO": {
                return "Modena (Italy)";
            }
            case "IT-MS": {
                return "Massa-Carrara (Italy)";
            }
            case "IT-MT": {
                return "Matera (Italy)";
            }
            case "IT-NA": {
                return "Napoli (Italy)";
            }
            case "IT-NO": {
                return "Novara (Italy)";
            }
            case "IT-NU": {
                return "Nuoro (Italy)";
            }
            case "IT-OG": {
                return "Ogliastra (Italy)";
            }
            case "IT-OR": {
                return "Oristano (Italy)";
            }
            case "IT-OT": {
                return "Olbia-Tempio (Italy)";
            }
            case "IT-PA": {
                return "Palermo (Italy)";
            }
            case "IT-PC": {
                return "Piacenza (Italy)";
            }
            case "IT-PD": {
                return "Padova (Italy)";
            }
            case "IT-PE": {
                return "Pescara (Italy)";
            }
            case "IT-PG": {
                return "Perugia (Italy)";
            }
            case "IT-PI": {
                return "Pisa (Italy)";
            }
            case "IT-PN": {
                return "Pordenone (Italy)";
            }
            case "IT-PO": {
                return "Prato (Italy)";
            }
            case "IT-PR": {
                return "Parma (Italy)";
            }
            case "IT-PT": {
                return "Pistoia (Italy)";
            }
            case "IT-PU": {
                return "Pesaro e Urbino (Italy)";
            }
            case "IT-PV": {
                return "Pavia (Italy)";
            }
            case "IT-PZ": {
                return "Potenza (Italy)";
            }
            case "IT-RA": {
                return "Ravenna (Italy)";
            }
            case "IT-RC": {
                return "Reggio Calabria (Italy)";
            }
            case "IT-RE": {
                return "Reggio Emilia (Italy)";
            }
            case "IT-RG": {
                return "Ragusa (Italy)";
            }
            case "IT-RI": {
                return "Rieti (Italy)";
            }
            case "IT-RM": {
                return "Roma (Italy)";
            }
            case "IT-RN": {
                return "Rimini (Italy)";
            }
            case "IT-RO": {
                return "Rovigo (Italy)";
            }
            case "IT-SA": {
                return "Salerno (Italy)";
            }
            case "IT-SI": {
                return "Siena (Italy)";
            }
            case "IT-SO": {
                return "Sondrio (Italy)";
            }
            case "IT-SP": {
                return "La Spezia (Italy)";
            }
            case "IT-SR": {
                return "Siracusa (Italy)";
            }
            case "IT-SS": {
                return "Sassari (Italy)";
            }
            case "IT-SV": {
                return "Savona (Italy)";
            }
            case "IT-TA": {
                return "Taranto (Italy)";
            }
            case "IT-TE": {
                return "Teramo (Italy)";
            }
            case "IT-TN": {
                return "Trento (Italy)";
            }
            case "IT-TO": {
                return "Torino (Italy)";
            }
            case "IT-TP": {
                return "Trapani (Italy)";
            }
            case "IT-TR": {
                return "Terni (Italy)";
            }
            case "IT-TS": {
                return "Trieste (Italy)";
            }
            case "IT-TV": {
                return "Treviso (Italy)";
            }
            case "IT-UD": {
                return "Udine (Italy)";
            }
            case "IT-VA": {
                return "Varese (Italy)";
            }
            case "IT-VB": {
                return "Verbano-Cusio-Ossola (Italy)";
            }
            case "IT-VC": {
                return "Vercelli (Italy)";
            }
            case "IT-VE": {
                return "Venezia (Italy)";
            }
            case "IT-VI": {
                return "Vicenza (Italy)";
            }
            case "IT-VR": {
                return "Verona (Italy)";
            }
            case "IT-VS": {
                return "Medio Campidano (Italy)";
            }
            case "IT-VT": {
                return "Viterbo (Italy)";
            }
            case "IT-VV": {
                return "Vibo Valentia (Italy)";
            }
            case "JE-JE": {
                return "Jersey (Jersey)";
            }
            case "JM-01": {
                return "Kingston (Jamaica)";
            }
            case "JM-02": {
                return "Saint Andrew (Jamaica)";
            }
            case "JM-03": {
                return "Saint Thomas (Jamaica)";
            }
            case "JM-04": {
                return "Portland (Jamaica)";
            }
            case "JM-05": {
                return "Saint Mary (Jamaica)";
            }
            case "JM-06": {
                return "Saint Ann (Jamaica)";
            }
            case "JM-07": {
                return "Trelawny (Jamaica)";
            }
            case "JM-08": {
                return "Saint James (Jamaica)";
            }
            case "JM-09": {
                return "Hanover (Jamaica)";
            }
            case "JM-10": {
                return "Westmoreland (Jamaica)";
            }
            case "JM-11": {
                return "Saint Elizabeth (Jamaica)";
            }
            case "JM-12": {
                return "Manchester (Jamaica)";
            }
            case "JM-13": {
                return "Clarendon (Jamaica)";
            }
            case "JM-14": {
                return "Saint Catherine (Jamaica)";
            }
            case "JO-AJ": {
                return "\u02bdAjl\u016bn (Jordan)";
            }
            case "JO-AM": {
                return "\u2018Amm\u0101n (Jordan)";
            }
            case "JO-AQ": {
                return "Al \u02bdAqabah (Jordan)";
            }
            case "JO-AT": {
                return "A\u0163 \u0162af\u012blah (Jordan)";
            }
            case "JO-AZ": {
                return "Az Zarq\u0101' (Jordan)";
            }
            case "JO-BA": {
                return "Al Balq\u0101' (Jordan)";
            }
            case "JO-IR": {
                return "Irbid (Jordan)";
            }
            case "JO-JA": {
                return "Jarash (Jordan)";
            }
            case "JO-KA": {
                return "Al Karak (Jordan)";
            }
            case "JO-MA": {
                return "Al Mafraq (Jordan)";
            }
            case "JO-MD": {
                return "M\u0101dab\u0101 (Jordan)";
            }
            case "JO-MN": {
                return "Ma'\u0101n (Jordan)";
            }
            case "JP-01": {
                return "Hokkaido (Japan)";
            }
            case "JP-02": {
                return "Aomori (Japan)";
            }
            case "JP-03": {
                return "Iwate (Japan)";
            }
            case "JP-04": {
                return "Miyagi (Japan)";
            }
            case "JP-05": {
                return "Akita (Japan)";
            }
            case "JP-06": {
                return "Yamagata (Japan)";
            }
            case "JP-07": {
                return "Fukushima (Japan)";
            }
            case "JP-08": {
                return "Ibaraki (Japan)";
            }
            case "JP-09": {
                return "Tochigi (Japan)";
            }
            case "JP-10": {
                return "Gunma (Japan)";
            }
            case "JP-11": {
                return "Saitama (Japan)";
            }
            case "JP-12": {
                return "Chiba (Japan)";
            }
            case "JP-13": {
                return "T\u00f4ky\u00f4 (Japan)";
            }
            case "JP-14": {
                return "Kanagawa (Japan)";
            }
            case "JP-15": {
                return "Niigata (Japan)";
            }
            case "JP-16": {
                return "Toyama (Japan)";
            }
            case "JP-17": {
                return "Ishikawa (Japan)";
            }
            case "JP-18": {
                return "Fukui (Japan)";
            }
            case "JP-19": {
                return "Yamanashi (Japan)";
            }
            case "JP-20": {
                return "Nagano (Japan)";
            }
            case "JP-21": {
                return "Gifu (Japan)";
            }
            case "JP-22": {
                return "Shizuoka (Japan)";
            }
            case "JP-23": {
                return "Aichi (Japan)";
            }
            case "JP-24": {
                return "Mie (Japan)";
            }
            case "JP-25": {
                return "Shiga (Japan)";
            }
            case "JP-26": {
                return "Kyoto (Japan)";
            }
            case "JP-27": {
                return "Osaka (Japan)";
            }
            case "JP-28": {
                return "Hyogo (Japan)";
            }
            case "JP-29": {
                return "Nara (Japan)";
            }
            case "JP-30": {
                return "Wakayama (Japan)";
            }
            case "JP-31": {
                return "Tottori (Japan)";
            }
            case "JP-32": {
                return "Shimane (Japan)";
            }
            case "JP-33": {
                return "Okayama (Japan)";
            }
            case "JP-34": {
                return "Hiroshima (Japan)";
            }
            case "JP-35": {
                return "Yamaguchi (Japan)";
            }
            case "JP-36": {
                return "Tokushima (Japan)";
            }
            case "JP-37": {
                return "Kagawa (Japan)";
            }
            case "JP-38": {
                return "Ehime (Japan)";
            }
            case "JP-39": {
                return "Kochi (Japan)";
            }
            case "JP-40": {
                return "Fukuoka (Japan)";
            }
            case "JP-41": {
                return "Saga (Japan)";
            }
            case "JP-42": {
                return "Nagasaki (Japan)";
            }
            case "JP-43": {
                return "Kumamoto (Japan)";
            }
            case "JP-44": {
                return "Oita (Japan)";
            }
            case "JP-45": {
                return "Miyazaki (Japan)";
            }
            case "JP-46": {
                return "Kagoshima (Japan)";
            }
            case "JP-47": {
                return "Okinawa (Japan)";
            }
            case "KE-01": {
                return "Baringo (Kenya)";
            }
            case "KE-02": {
                return "Bomet (Kenya)";
            }
            case "KE-03": {
                return "Bungoma (Kenya)";
            }
            case "KE-04": {
                return "Busia (Kenya)";
            }
            case "KE-05": {
                return "Elgeyo/Marakwet (Kenya)";
            }
            case "KE-06": {
                return "Embu (Kenya)";
            }
            case "KE-07": {
                return "Garissa (Kenya)";
            }
            case "KE-08": {
                return "Homa Bay (Kenya)";
            }
            case "KE-09": {
                return "Isiolo (Kenya)";
            }
            case "KE-10": {
                return "Kajiado (Kenya)";
            }
            case "KE-11": {
                return "Kakamega (Kenya)";
            }
            case "KE-12": {
                return "Kericho (Kenya)";
            }
            case "KE-13": {
                return "Kiambu (Kenya)";
            }
            case "KE-14": {
                return "Kilifi (Kenya)";
            }
            case "KE-15": {
                return "Kirinyaga (Kenya)";
            }
            case "KE-16": {
                return "Kisii (Kenya)";
            }
            case "KE-17": {
                return "Kisumu (Kenya)";
            }
            case "KE-18": {
                return "Kitui (Kenya)";
            }
            case "KE-19": {
                return "Kwale (Kenya)";
            }
            case "KE-20": {
                return "Laikipia (Kenya)";
            }
            case "KE-21": {
                return "Lamu (Kenya)";
            }
            case "KE-22": {
                return "Machakos (Kenya)";
            }
            case "KE-23": {
                return "Makueni (Kenya)";
            }
            case "KE-24": {
                return "Mandera (Kenya)";
            }
            case "KE-25": {
                return "Marsabit (Kenya)";
            }
            case "KE-26": {
                return "Meru (Kenya)";
            }
            case "KE-27": {
                return "Migori (Kenya)";
            }
            case "KE-28": {
                return "Mombasa (Kenya)";
            }
            case "KE-29": {
                return "Murang'a (Kenya)";
            }
            case "KE-30": {
                return "Nairobi City (Kenya)";
            }
            case "KE-31": {
                return "Nakuru (Kenya)";
            }
            case "KE-32": {
                return "Nandi (Kenya)";
            }
            case "KE-33": {
                return "Narok (Kenya)";
            }
            case "KE-34": {
                return "Nyamira (Kenya)";
            }
            case "KE-35": {
                return "Nyandarua (Kenya)";
            }
            case "KE-36": {
                return "Nyeri (Kenya)";
            }
            case "KE-37": {
                return "Samburu (Kenya)";
            }
            case "KE-38": {
                return "Siaya (Kenya)";
            }
            case "KE-39": {
                return "Taita/Taveta (Kenya)";
            }
            case "KE-40": {
                return "Tana River (Kenya)";
            }
            case "KE-41": {
                return "Tharaka-Nithi (Kenya)";
            }
            case "KE-42": {
                return "Trans Nzoia (Kenya)";
            }
            case "KE-43": {
                return "Turkana (Kenya)";
            }
            case "KE-44": {
                return "Uasin Gishu (Kenya)";
            }
            case "KE-45": {
                return "Vihiga (Kenya)";
            }
            case "KE-46": {
                return "Wajir (Kenya)";
            }
            case "KE-47": {
                return "West Pokot (Kenya)";
            }
            case "KG-B": {
                return "Batken (Kyrgyzstan)";
            }
            case "KG-C": {
                return "Ch\u00fc (Kyrgyzstan)";
            }
            case "KG-GB": {
                return "Bishkek (Kyrgyzstan)";
            }
            case "KG-GO": {
                return "Gorod O\u0161 (Kyrgyzstan)";
            }
            case "KG-J": {
                return "D\u017ealal-Abadskaja oblast' (Kyrgyzstan)";
            }
            case "KG-N": {
                return "Naryn (Kyrgyzstan)";
            }
            case "KG-O": {
                return "Osh (Kyrgyzstan)";
            }
            case "KG-T": {
                return "Talas (Kyrgyzstan)";
            }
            case "KG-Y": {
                return "Issyk-Kul'skaja oblast' (Kyrgyzstan)";
            }
            case "KH-1": {
                return "B\u00e2nt\u00e9ay M\u00e9anchey (Cambodia)";
            }
            case "KH-10": {
                return "Kr\u00e2ch\u00e9h (Cambodia)";
            }
            case "KH-11": {
                return "M\u00f4nd\u00f3l Kiri (Cambodia)";
            }
            case "KH-12": {
                return "Phnom Penh (Cambodia)";
            }
            case "KH-13": {
                return "Pre\u0103h Vih\u00e9ar (Cambodia)";
            }
            case "KH-14": {
                return "Prey Veaeng (Cambodia)";
            }
            case "KH-15": {
                return "Pousaat (Cambodia)";
            }
            case "KH-16": {
                return "Rotanak Kiri (Cambodia)";
            }
            case "KH-17": {
                return "Siem Reab (Cambodia)";
            }
            case "KH-18": {
                return "Kr\u014fng Pre\u0103h Sihanouk (Cambodia)";
            }
            case "KH-19": {
                return "Sto\u0115ng Tr\u00eang (Cambodia)";
            }
            case "KH-2": {
                return "Baat Dambang (Cambodia)";
            }
            case "KH-20": {
                return "Svaay Rieng (Cambodia)";
            }
            case "KH-21": {
                return "Taakaev (Cambodia)";
            }
            case "KH-22": {
                return "\u014etd\u00e2r M\u00e9anchey (Cambodia)";
            }
            case "KH-23": {
                return "Krong Kaeb (Cambodia)";
            }
            case "KH-24": {
                return "Kr\u014fng Pail\u012dn (Cambodia)";
            }
            case "KH-3": {
                return "Kampong Chaam (Cambodia)";
            }
            case "KH-4": {
                return "Kampong Chhnang (Cambodia)";
            }
            case "KH-5": {
                return "K\u00e2mp\u00f3ng Sp\u0153 (Cambodia)";
            }
            case "KH-6": {
                return "K\u00e2mp\u00f3ng Thum (Cambodia)";
            }
            case "KH-7": {
                return "Kampot (Cambodia)";
            }
            case "KH-8": {
                return "Kandaal (Cambodia)";
            }
            case "KH-9": {
                return "Kaoh Kong (Cambodia)";
            }
            case "KI-G": {
                return "Gilbert Islands (Kiribati)";
            }
            case "KI-L": {
                return "Line Islands (Kiribati)";
            }
            case "KI-P": {
                return "Phoenix Islands (Kiribati)";
            }
            case "KM-A": {
                return "Andjou\u00e2n (Comoros)";
            }
            case "KM-G": {
                return "Andjaz\u00eedja (Comoros)";
            }
            case "KM-M": {
                return "Moh\u00e9li (Comoros)";
            }
            case "KN-01": {
                return "Christ Church Nichola Town (Saint Kitts And Nevis)";
            }
            case "KN-02": {
                return "Saint Anne Sandy Point (Saint Kitts And Nevis)";
            }
            case "KN-03": {
                return "Saint George Basseterre (Saint Kitts And Nevis)";
            }
            case "KN-04": {
                return "Saint George Gingerland (Saint Kitts And Nevis)";
            }
            case "KN-05": {
                return "Saint James Windward (Saint Kitts And Nevis)";
            }
            case "KN-06": {
                return "Saint John Capisterre (Saint Kitts And Nevis)";
            }
            case "KN-07": {
                return "Saint John Figtree (Saint Kitts And Nevis)";
            }
            case "KN-08": {
                return "Saint Mary Cayon (Saint Kitts And Nevis)";
            }
            case "KN-09": {
                return "Saint Paul Capisterre (Saint Kitts And Nevis)";
            }
            case "KN-10": {
                return "Saint Paul Charlestown (Saint Kitts And Nevis)";
            }
            case "KN-11": {
                return "Saint Peter Basseterre (Saint Kitts And Nevis)";
            }
            case "KN-12": {
                return "Saint Thomas Lowland (Saint Kitts And Nevis)";
            }
            case "KN-13": {
                return "Saint Thomas Middle Island (Saint Kitts And Nevis)";
            }
            case "KN-15": {
                return "Trinity Palmetto Point (Saint Kitts And Nevis)";
            }
            case "KN-K": {
                return "Saint Kitts (Saint Kitts And Nevis)";
            }
            case "KN-N": {
                return "Nevis (Saint Kitts And Nevis)";
            }
            case "KP-01": {
                return "P'y\u01d2ngyang (Korea, Democratic People's Republic Of)";
            }
            case "KP-02": {
                return "P'y\u01d2ngan-namdo (Korea, Democratic People's Republic Of)";
            }
            case "KP-03": {
                return "P'y\u01d2ngan-bukto (Korea, Democratic People's Republic Of)";
            }
            case "KP-04": {
                return "Chagang-do (Korea, Democratic People's Republic Of)";
            }
            case "KP-05": {
                return "Hwanghae-namdo (Korea, Democratic People's Republic Of)";
            }
            case "KP-06": {
                return "Hwanghae-bukto (Korea, Democratic People's Republic Of)";
            }
            case "KP-07": {
                return "Kangweonto (Korea, Democratic People's Republic Of)";
            }
            case "KP-08": {
                return "Hamgy\u01d2ng-namdo (Korea, Democratic People's Republic Of)";
            }
            case "KP-09": {
                return "Hamgy\u01d2ng-bukto (Korea, Democratic People's Republic Of)";
            }
            case "KP-10": {
                return "Ryangkangto (Korea, Democratic People's Republic Of)";
            }
            case "KP-13": {
                return "Nas\u01d2n (Korea, Democratic People's Republic Of)";
            }
            case "KR-11": {
                return "Seoul-T'\u01d4kpy\u01d2lshi (Korea, Republic of)";
            }
            case "KR-26": {
                return "Busan Gwang'yeogsi (Korea, Republic of)";
            }
            case "KR-27": {
                return "Daegu Gwang'yeogsi (Korea, Republic of)";
            }
            case "KR-28": {
                return "Inch'\u01d2n-Kwangy\u01d2kshi (Korea, Republic of)";
            }
            case "KR-29": {
                return "Gwangju Gwang'yeogsi (Korea, Republic of)";
            }
            case "KR-30": {
                return "Daejeon Gwang'yeogsi (Korea, Republic of)";
            }
            case "KR-31": {
                return "Ulsan Gwang'yeogsi (Korea, Republic of)";
            }
            case "KR-41": {
                return "Gyeonggido (Korea, Republic of)";
            }
            case "KR-42": {
                return "Gang'weondo (Korea, Republic of)";
            }
            case "KR-43": {
                return "Ch'ungch'\u01d2ngbuk-do (Korea, Republic of)";
            }
            case "KR-44": {
                return "Ch'ungch'\u01d2ngnam-do (Korea, Republic of)";
            }
            case "KR-45": {
                return "Ch\u01d2llabuk-do (Korea, Republic of)";
            }
            case "KR-46": {
                return "Ch\u01d2llanam-do (Korea, Republic of)";
            }
            case "KR-47": {
                return "Gyeongsangbugdo (Korea, Republic of)";
            }
            case "KR-48": {
                return "Gyeongsangnamdo (Korea, Republic of)";
            }
            case "KR-49": {
                return "Cheju-do (Korea, Republic of)";
            }
            case "KR-50": {
                return "Sejong (Korea, Republic of)";
            }
            case "KW-AH": {
                return "Al A\u1e29mad\u012b (Kuwait)";
            }
            case "KW-FA": {
                return "Al Farw\u0101n\u012byah (Kuwait)";
            }
            case "KW-HA": {
                return "\u1e28awall\u012b (Kuwait)";
            }
            case "KW-JA": {
                return "Al Jahr\u0101\u2019 (Kuwait)";
            }
            case "KW-KU": {
                return "Al Kuwayt (Kuwait)";
            }
            case "KW-MU": {
                return "Mub\u0101rak al Kab\u012br (Kuwait)";
            }
            case "KY-KY": {
                return "Cayman Islands (Cayman Islands)";
            }
            case "KZ-AKM": {
                return "Akmolinskaja oblast' (Kazakhstan)";
            }
            case "KZ-AKT": {
                return "Aktjubinskaja oblast' (Kazakhstan)";
            }
            case "KZ-ALA": {
                return "Almaty (Kazakhstan)";
            }
            case "KZ-ALM": {
                return "Almatinskaja oblast' (Kazakhstan)";
            }
            case "KZ-AST": {
                return "Astana (Kazakhstan)";
            }
            case "KZ-ATY": {
                return "Atyra\u016b oblysy (Kazakhstan)";
            }
            case "KZ-KAR": {
                return "Karagandinskaja oblast' (Kazakhstan)";
            }
            case "KZ-KUS": {
                return "Kostanajskaja oblast' (Kazakhstan)";
            }
            case "KZ-KZY": {
                return "Kyzylordinskaja oblast' (Kazakhstan)";
            }
            case "KZ-MAN": {
                return "Mangghysta\u016b oblysy (Kazakhstan)";
            }
            case "KZ-PAV": {
                return "Pavlodar oblysy (Kazakhstan)";
            }
            case "KZ-SEV": {
                return "Severo-Kazahstanskaja oblast' (Kazakhstan)";
            }
            case "KZ-VOS": {
                return "Shyghys Qazaqstan oblysy (Kazakhstan)";
            }
            case "KZ-YUZ": {
                return "Ju\u017eno-Kazahstanskaja oblast' (Kazakhstan)";
            }
            case "KZ-ZAP": {
                return "Batys Qazaqstan oblysy (Kazakhstan)";
            }
            case "KZ-ZHA": {
                return "\u017dambylskaja oblast' (Kazakhstan)";
            }
            case "LA-AT": {
                return "Attapu (Laos)";
            }
            case "LA-BK": {
                return "Bok\u00e8o (Laos)";
            }
            case "LA-BL": {
                return "Bolikhamxai (Laos)";
            }
            case "LA-CH": {
                return "Champasak (Laos)";
            }
            case "LA-HO": {
                return "Houaphan (Laos)";
            }
            case "LA-KH": {
                return "Khammouan (Laos)";
            }
            case "LA-LM": {
                return "Louang Namtha (Laos)";
            }
            case "LA-LP": {
                return "Louangphabang (Laos)";
            }
            case "LA-OU": {
                return "Oudomsai (Laos)";
            }
            case "LA-PH": {
                return "Ph\u00f4ngsali (Laos)";
            }
            case "LA-SL": {
                return "Salavan (Laos)";
            }
            case "LA-SV": {
                return "Savannakh\u00e9t (Laos)";
            }
            case "LA-VI": {
                return "Vientiane (Laos)";
            }
            case "LA-VT": {
                return "Vientiane (Laos)";
            }
            case "LA-XA": {
                return "Sayaboury (Laos)";
            }
            case "LA-XE": {
                return "S\u00e9kong (Laos)";
            }
            case "LA-XI": {
                return "Xiangkhouang (Laos)";
            }
            case "LA-XN": {
                return "Xais\u00f4mboun (Laos)";
            }
            case "LB-AK": {
                return "Aakk\u00e2r (Lebanon)";
            }
            case "LB-AS": {
                return "Ash Shim\u0101l (Lebanon)";
            }
            case "LB-BA": {
                return "Bayr\u016bt (Lebanon)";
            }
            case "LB-BH": {
                return "Baalbek-Hermel (Lebanon)";
            }
            case "LB-BI": {
                return "Al Biq\u0101\u2018 (Lebanon)";
            }
            case "LB-JA": {
                return "Al Jan\u016bb (Lebanon)";
            }
            case "LB-JL": {
                return "Jabal Lubn\u0101n (Lebanon)";
            }
            case "LB-NA": {
                return "An Naba\u0163\u012byah (Lebanon)";
            }
            case "LC-01": {
                return "Anse la Raye (Saint Lucia)";
            }
            case "LC-02": {
                return "Castries (Saint Lucia)";
            }
            case "LC-03": {
                return "Choiseul (Saint Lucia)";
            }
            case "LC-05": {
                return "Dennery (Saint Lucia)";
            }
            case "LC-06": {
                return "Gros Islet (Saint Lucia)";
            }
            case "LC-07": {
                return "Laborie (Saint Lucia)";
            }
            case "LC-08": {
                return "Micoud (Saint Lucia)";
            }
            case "LC-10": {
                return "Soufri\u00e8re (Saint Lucia)";
            }
            case "LC-11": {
                return "Vieux Fort (Saint Lucia)";
            }
            case "LC-12": {
                return "Canaries (Saint Lucia)";
            }
            case "LI-01": {
                return "Balzers (Liechtenstein)";
            }
            case "LI-02": {
                return "Eschen (Liechtenstein)";
            }
            case "LI-03": {
                return "Gamprin (Liechtenstein)";
            }
            case "LI-04": {
                return "Mauren (Liechtenstein)";
            }
            case "LI-05": {
                return "Planken (Liechtenstein)";
            }
            case "LI-06": {
                return "Ruggell (Liechtenstein)";
            }
            case "LI-07": {
                return "Schaan (Liechtenstein)";
            }
            case "LI-08": {
                return "Schellenberg (Liechtenstein)";
            }
            case "LI-09": {
                return "Triesen (Liechtenstein)";
            }
            case "LI-10": {
                return "Triesenberg (Liechtenstein)";
            }
            case "LI-11": {
                return "Vaduz (Liechtenstein)";
            }
            case "LK-1": {
                return "Basn\u0101hira pa\u1e37\u0101ta (Sri Lanka)";
            }
            case "LK-11": {
                return "Colombo (Sri Lanka)";
            }
            case "LK-12": {
                return "Gampaha (Sri Lanka)";
            }
            case "LK-13": {
                return "Kalutara (Sri Lanka)";
            }
            case "LK-2": {
                return "Central Province (Sri Lanka)";
            }
            case "LK-21": {
                return "Kandy (Sri Lanka)";
            }
            case "LK-22": {
                return "Matale (Sri Lanka)";
            }
            case "LK-23": {
                return "Nuvara \u0114liya (Sri Lanka)";
            }
            case "LK-3": {
                return "Daku\u1e47u pa\u1e37\u0101ta (Sri Lanka)";
            }
            case "LK-31": {
                return "G\u0101lla (Sri Lanka)";
            }
            case "LK-32": {
                return "Matara (Sri Lanka)";
            }
            case "LK-33": {
                return "Amp\u0101nt\u014d\u1e6d\u1e6dai (Sri Lanka)";
            }
            case "LK-4": {
                return "Northern Province (Sri Lanka)";
            }
            case "LK-41": {
                return "Jaffna (Sri Lanka)";
            }
            case "LK-42": {
                return "Kilinochchi (Sri Lanka)";
            }
            case "LK-43": {
                return "Mannar (Sri Lanka)";
            }
            case "LK-44": {
                return "Vavuniya (Sri Lanka)";
            }
            case "LK-45": {
                return "Mulativ (Sri Lanka)";
            }
            case "LK-5": {
                return "Eastern Province (Sri Lanka)";
            }
            case "LK-51": {
                return "Batticaloa (Sri Lanka)";
            }
            case "LK-52": {
                return "Ampara (Sri Lanka)";
            }
            case "LK-53": {
                return "Tiruk\u014f\u1e47amalai (Sri Lanka)";
            }
            case "LK-6": {
                return "North Western Province (Sri Lanka)";
            }
            case "LK-61": {
                return "Kuru\u1e47\u00e6gala (Sri Lanka)";
            }
            case "LK-62": {
                return "Puttalam (Sri Lanka)";
            }
            case "LK-7": {
                return "North Central Province (Sri Lanka)";
            }
            case "LK-71": {
                return "Anuradhapura (Sri Lanka)";
            }
            case "LK-72": {
                return "P\u014fla\u1e49\u1e49a\u1e5buvai (Sri Lanka)";
            }
            case "LK-8": {
                return "\u016av\u0101 m\u0101k\u0101\u1e47am (Sri Lanka)";
            }
            case "LK-81": {
                return "Badulla (Sri Lanka)";
            }
            case "LK-82": {
                return "Monaragala (Sri Lanka)";
            }
            case "LK-9": {
                return "Chappirakamuva m\u0101k\u0101\u1e47am (Sri Lanka)";
            }
            case "LK-91": {
                return "Iratti\u1e49apuri (Sri Lanka)";
            }
            case "LK-92": {
                return "K\u00e6galla (Sri Lanka)";
            }
            case "LR-BG": {
                return "Bong (Liberia)";
            }
            case "LR-BM": {
                return "Bomi (Liberia)";
            }
            case "LR-CM": {
                return "Grand Cape Mount (Liberia)";
            }
            case "LR-GB": {
                return "Grand Bassa (Liberia)";
            }
            case "LR-GG": {
                return "Grand Gedeh (Liberia)";
            }
            case "LR-GK": {
                return "Grand Kru (Liberia)";
            }
            case "LR-GP": {
                return "Gbarpolu (Liberia)";
            }
            case "LR-LO": {
                return "Lofa (Liberia)";
            }
            case "LR-MG": {
                return "Margibi (Liberia)";
            }
            case "LR-MO": {
                return "Montserrado (Liberia)";
            }
            case "LR-MY": {
                return "Maryland (Liberia)";
            }
            case "LR-NI": {
                return "Nimba (Liberia)";
            }
            case "LR-RG": {
                return "River Gee (Liberia)";
            }
            case "LR-RI": {
                return "Rivercess (Liberia)";
            }
            case "LR-SI": {
                return "Sinoe (Liberia)";
            }
            case "LS-A": {
                return "Maseru (Lesotho)";
            }
            case "LS-B": {
                return "Butha-Buthe (Lesotho)";
            }
            case "LS-C": {
                return "Leribe (Lesotho)";
            }
            case "LS-D": {
                return "Berea (Lesotho)";
            }
            case "LS-E": {
                return "Mafeteng (Lesotho)";
            }
            case "LS-F": {
                return "Mohale's Hoek (Lesotho)";
            }
            case "LS-G": {
                return "Quthing (Lesotho)";
            }
            case "LS-H": {
                return "Qacha's Nek (Lesotho)";
            }
            case "LS-J": {
                return "Mokhotlong (Lesotho)";
            }
            case "LS-K": {
                return "Thaba-Tseka (Lesotho)";
            }
            case "LT-01": {
                return "Akmen\u0117 (Lithuania)";
            }
            case "LT-02": {
                return "Alytaus miestas (Lithuania)";
            }
            case "LT-03": {
                return "Alytus (Lithuania)";
            }
            case "LT-04": {
                return "Anyk\u0161\u010diai (Lithuania)";
            }
            case "LT-05": {
                return "Bir\u0161tono (Lithuania)";
            }
            case "LT-06": {
                return "Bir\u017eai (Lithuania)";
            }
            case "LT-07": {
                return "Druskininkai (Lithuania)";
            }
            case "LT-08": {
                return "Elektr\u00e9nai (Lithuania)";
            }
            case "LT-09": {
                return "Ignalina (Lithuania)";
            }
            case "LT-10": {
                return "Jonava (Lithuania)";
            }
            case "LT-11": {
                return "Joni\u0161kis (Lithuania)";
            }
            case "LT-12": {
                return "Jurbarkas (Lithuania)";
            }
            case "LT-13": {
                return "Kai\u0161iadorys (Lithuania)";
            }
            case "LT-14": {
                return "Kalvarijos (Lithuania)";
            }
            case "LT-15": {
                return "Kauno miestas (Lithuania)";
            }
            case "LT-16": {
                return "Kaunas (Lithuania)";
            }
            case "LT-17": {
                return "Kazl\u0173 R\u016bdos (Lithuania)";
            }
            case "LT-18": {
                return "K\u0117dainiai (Lithuania)";
            }
            case "LT-19": {
                return "Kelm\u0117 (Lithuania)";
            }
            case "LT-20": {
                return "Klaip\u0117dos miestas (Lithuania)";
            }
            case "LT-21": {
                return "Klaip\u0117da (Lithuania)";
            }
            case "LT-22": {
                return "Kretinga (Lithuania)";
            }
            case "LT-23": {
                return "Kupi\u0161kis (Lithuania)";
            }
            case "LT-24": {
                return "Lazdijai (Lithuania)";
            }
            case "LT-25": {
                return "Marijampol\u0117 (Lithuania)";
            }
            case "LT-26": {
                return "Ma\u017eeikiai (Lithuania)";
            }
            case "LT-27": {
                return "Mol\u0117tai (Lithuania)";
            }
            case "LT-28": {
                return "Neringa (Lithuania)";
            }
            case "LT-29": {
                return "Pag\u00e9giai (Lithuania)";
            }
            case "LT-30": {
                return "Pakruojis (Lithuania)";
            }
            case "LT-31": {
                return "Palangos miestas (Lithuania)";
            }
            case "LT-32": {
                return "Panev\u0117\u017eio miestas (Lithuania)";
            }
            case "LT-33": {
                return "Panev\u0117\u017eys (Lithuania)";
            }
            case "LT-34": {
                return "Pasvalys (Lithuania)";
            }
            case "LT-35": {
                return "Plung\u0117 (Lithuania)";
            }
            case "LT-36": {
                return "Prienai (Lithuania)";
            }
            case "LT-37": {
                return "Radvili\u0161kis (Lithuania)";
            }
            case "LT-38": {
                return "Raseiniai (Lithuania)";
            }
            case "LT-39": {
                return "Rietavo (Lithuania)";
            }
            case "LT-40": {
                return "Roki\u0161kis (Lithuania)";
            }
            case "LT-41": {
                return "\u0160akiai (Lithuania)";
            }
            case "LT-42": {
                return "\u0160al\u010dininkai (Lithuania)";
            }
            case "LT-43": {
                return "\u0160iauli\u0173 miestas (Lithuania)";
            }
            case "LT-44": {
                return "\u0160iauliai (Lithuania)";
            }
            case "LT-45": {
                return "\u0160ilal\u0117 (Lithuania)";
            }
            case "LT-46": {
                return "\u0160ilut\u0117 (Lithuania)";
            }
            case "LT-47": {
                return "\u0160irvintos (Lithuania)";
            }
            case "LT-48": {
                return "Skuodas (Lithuania)";
            }
            case "LT-49": {
                return "\u0160ven\u010dionys (Lithuania)";
            }
            case "LT-50": {
                return "Taurag\u0117 (Lithuania)";
            }
            case "LT-51": {
                return "Tel\u0161iai (Lithuania)";
            }
            case "LT-52": {
                return "Trakai (Lithuania)";
            }
            case "LT-53": {
                return "Ukmerg\u0117 (Lithuania)";
            }
            case "LT-54": {
                return "Utena (Lithuania)";
            }
            case "LT-55": {
                return "Var\u0117na (Lithuania)";
            }
            case "LT-56": {
                return "Vilkavi\u0161kis (Lithuania)";
            }
            case "LT-57": {
                return "Vilniaus miestas (Lithuania)";
            }
            case "LT-58": {
                return "Vilnius (Lithuania)";
            }
            case "LT-59": {
                return "Visaginas (Lithuania)";
            }
            case "LT-60": {
                return "Zarasai (Lithuania)";
            }
            case "LT-AL": {
                return "Alytaus apskritis (Lithuania)";
            }
            case "LT-KL": {
                return "Klaip\u0117dos apskritis (Lithuania)";
            }
            case "LT-KU": {
                return "Kauno apskritis (Lithuania)";
            }
            case "LT-MR": {
                return "Marijampol\u0117s apskritis (Lithuania)";
            }
            case "LT-PN": {
                return "Panev\u0117\u017eio apskritis (Lithuania)";
            }
            case "LT-SA": {
                return "\u0160iauli\u0173 apskritis (Lithuania)";
            }
            case "LT-TA": {
                return "Taurag\u0117s apskritis (Lithuania)";
            }
            case "LT-TE": {
                return "Tel\u0161i\u0173 apskritis (Lithuania)";
            }
            case "LT-UT": {
                return "Utenos apskritis (Lithuania)";
            }
            case "LT-VL": {
                return "Vilniaus apskritis (Lithuania)";
            }
            case "LU-D": {
                return "Diekirch (Luxembourg)";
            }
            case "LU-G": {
                return "Grevenmacher (Luxembourg)";
            }
            case "LU-L": {
                return "L\u00ebtzebuerg (Luxembourg)";
            }
            case "LV-001": {
                return "Aglonas novads (Latvia)";
            }
            case "LV-002": {
                return "Aizkraukles novads (Latvia)";
            }
            case "LV-003": {
                return "Aizputes novads (Latvia)";
            }
            case "LV-004": {
                return "Akn\u012bstes novads (Latvia)";
            }
            case "LV-005": {
                return "Alojas novads (Latvia)";
            }
            case "LV-006": {
                return "Alsungas novads (Latvia)";
            }
            case "LV-007": {
                return "Al\u016bksnes novads (Latvia)";
            }
            case "LV-008": {
                return "Amatas novads (Latvia)";
            }
            case "LV-009": {
                return "Apes novads (Latvia)";
            }
            case "LV-010": {
                return "Auces novads (Latvia)";
            }
            case "LV-011": {
                return "\u0100da\u017eu novads (Latvia)";
            }
            case "LV-012": {
                return "Bab\u012btes novads (Latvia)";
            }
            case "LV-013": {
                return "Baldones novads (Latvia)";
            }
            case "LV-014": {
                return "Baltinavas novads (Latvia)";
            }
            case "LV-015": {
                return "Balvu novads (Latvia)";
            }
            case "LV-016": {
                return "Bauskas novads (Latvia)";
            }
            case "LV-017": {
                return "Bever\u012bnas novads (Latvia)";
            }
            case "LV-018": {
                return "Broc\u0113nu novads (Latvia)";
            }
            case "LV-019": {
                return "Burtnieku novads (Latvia)";
            }
            case "LV-020": {
                return "Carnikavas novads (Latvia)";
            }
            case "LV-021": {
                return "Cesvaines novads (Latvia)";
            }
            case "LV-022": {
                return "C\u0113su novads (Latvia)";
            }
            case "LV-023": {
                return "Ciblas novads (Latvia)";
            }
            case "LV-024": {
                return "Dagdas novads (Latvia)";
            }
            case "LV-025": {
                return "Daugavpils novads (Latvia)";
            }
            case "LV-026": {
                return "Dobeles novads (Latvia)";
            }
            case "LV-027": {
                return "Dundagas novads (Latvia)";
            }
            case "LV-028": {
                return "Durbes novads (Latvia)";
            }
            case "LV-029": {
                return "Engures novads (Latvia)";
            }
            case "LV-030": {
                return "\u0112rg\u013cu novads (Latvia)";
            }
            case "LV-031": {
                return "Garkalnes novads (Latvia)";
            }
            case "LV-032": {
                return "Grobi\u0146as novads (Latvia)";
            }
            case "LV-033": {
                return "Gulbenes novads (Latvia)";
            }
            case "LV-034": {
                return "Iecavas novads (Latvia)";
            }
            case "LV-035": {
                return "Ik\u0161\u0137iles novads (Latvia)";
            }
            case "LV-036": {
                return "Il\u016bkstes novads (Latvia)";
            }
            case "LV-037": {
                return "In\u010dukalna novads (Latvia)";
            }
            case "LV-038": {
                return "Jaunjelgavas novads (Latvia)";
            }
            case "LV-039": {
                return "Jaunpiebalgas novads (Latvia)";
            }
            case "LV-040": {
                return "Jaunpils novads (Latvia)";
            }
            case "LV-041": {
                return "Jelgavas novads (Latvia)";
            }
            case "LV-042": {
                return "J\u0113kabpils novads (Latvia)";
            }
            case "LV-043": {
                return "Kandavas novads (Latvia)";
            }
            case "LV-044": {
                return "K\u0101rsavas novads (Latvia)";
            }
            case "LV-045": {
                return "Koc\u0113nu novads (Latvia)";
            }
            case "LV-046": {
                return "Kokneses novads (Latvia)";
            }
            case "LV-047": {
                return "Kr\u0101slavas novads (Latvia)";
            }
            case "LV-048": {
                return "Krimuldas novads (Latvia)";
            }
            case "LV-049": {
                return "Krustpils novads (Latvia)";
            }
            case "LV-050": {
                return "Kuld\u012bgas novads (Latvia)";
            }
            case "LV-051": {
                return "\u0136eguma novads (Latvia)";
            }
            case "LV-052": {
                return "\u0136ekavas novads (Latvia)";
            }
            case "LV-053": {
                return "Lielv\u0101rdes novads (Latvia)";
            }
            case "LV-054": {
                return "Limba\u017eu novads (Latvia)";
            }
            case "LV-055": {
                return "L\u012bgatnes novads (Latvia)";
            }
            case "LV-056": {
                return "L\u012bv\u0101nu novads (Latvia)";
            }
            case "LV-057": {
                return "Lub\u0101nas novads (Latvia)";
            }
            case "LV-058": {
                return "Ludzas novads (Latvia)";
            }
            case "LV-059": {
                return "Madonas novads (Latvia)";
            }
            case "LV-060": {
                return "Mazsalacas novads (Latvia)";
            }
            case "LV-061": {
                return "M\u0101lpils novads (Latvia)";
            }
            case "LV-062": {
                return "M\u0101rupes novads (Latvia)";
            }
            case "LV-063": {
                return "M\u0113rsraga novads (Latvia)";
            }
            case "LV-064": {
                return "Nauk\u0161\u0113nu novads (Latvia)";
            }
            case "LV-065": {
                return "Neretas novads (Latvia)";
            }
            case "LV-066": {
                return "N\u012bcas novads (Latvia)";
            }
            case "LV-067": {
                return "Ogres novads (Latvia)";
            }
            case "LV-068": {
                return "Olaines novads (Latvia)";
            }
            case "LV-069": {
                return "Ozolnieku novads (Latvia)";
            }
            case "LV-070": {
                return "P\u0101rgaujas novads (Latvia)";
            }
            case "LV-071": {
                return "P\u0101vilostas novads (Latvia)";
            }
            case "LV-072": {
                return "P\u013cavi\u0146u novads (Latvia)";
            }
            case "LV-073": {
                return "Prei\u013cu novads (Latvia)";
            }
            case "LV-074": {
                return "Priekules novads (Latvia)";
            }
            case "LV-075": {
                return "Prieku\u013cu novads (Latvia)";
            }
            case "LV-076": {
                return "Raunas novads (Latvia)";
            }
            case "LV-077": {
                return "R\u0113zeknes novads (Latvia)";
            }
            case "LV-078": {
                return "Riebi\u0146u novads (Latvia)";
            }
            case "LV-079": {
                return "Rojas novads (Latvia)";
            }
            case "LV-080": {
                return "Ropa\u017eu novads (Latvia)";
            }
            case "LV-081": {
                return "Rucavas novads (Latvia)";
            }
            case "LV-082": {
                return "Rug\u0101ju novads (Latvia)";
            }
            case "LV-083": {
                return "Rund\u0101les novads (Latvia)";
            }
            case "LV-084": {
                return "R\u016bjienas novads (Latvia)";
            }
            case "LV-085": {
                return "Salas novads (Latvia)";
            }
            case "LV-086": {
                return "Salacgr\u012bvas novads (Latvia)";
            }
            case "LV-087": {
                return "Salaspils novads (Latvia)";
            }
            case "LV-088": {
                return "Saldus novads (Latvia)";
            }
            case "LV-089": {
                return "Saulkrastu novads (Latvia)";
            }
            case "LV-090": {
                return "S\u0113jas novads (Latvia)";
            }
            case "LV-091": {
                return "Siguldas novads (Latvia)";
            }
            case "LV-092": {
                return "Skr\u012bveru novads (Latvia)";
            }
            case "LV-093": {
                return "Skrundas novads (Latvia)";
            }
            case "LV-094": {
                return "Smiltenes novads (Latvia)";
            }
            case "LV-095": {
                return "Stopi\u0146u novads (Latvia)";
            }
            case "LV-096": {
                return "Stren\u010du novads (Latvia)";
            }
            case "LV-097": {
                return "Talsu novads (Latvia)";
            }
            case "LV-098": {
                return "T\u0113rvetes novads (Latvia)";
            }
            case "LV-099": {
                return "Tukuma novads (Latvia)";
            }
            case "LV-100": {
                return "Vai\u0146odes novads (Latvia)";
            }
            case "LV-101": {
                return "Valkas novads (Latvia)";
            }
            case "LV-102": {
                return "Varak\u013c\u0101nu novads (Latvia)";
            }
            case "LV-103": {
                return "V\u0101rkavas novads (Latvia)";
            }
            case "LV-104": {
                return "Vecpiebalgas novads (Latvia)";
            }
            case "LV-105": {
                return "Vecumnieku novads (Latvia)";
            }
            case "LV-106": {
                return "Ventspils novads (Latvia)";
            }
            case "LV-107": {
                return "Vies\u012btes novads (Latvia)";
            }
            case "LV-108": {
                return "Vi\u013cakas novads (Latvia)";
            }
            case "LV-109": {
                return "Vi\u013c\u0101nu novads (Latvia)";
            }
            case "LV-110": {
                return "Zilupes novads (Latvia)";
            }
            case "LV-DGV": {
                return "Daugavpils (Latvia)";
            }
            case "LV-JEL": {
                return "Jelgava (Latvia)";
            }
            case "LV-JKB": {
                return "J\u0113kabpils (Latvia)";
            }
            case "LV-JUR": {
                return "J\u016brmala (Latvia)";
            }
            case "LV-LPX": {
                return "Liep\u0101ja (Latvia)";
            }
            case "LV-REZ": {
                return "R\u0113zekne (Latvia)";
            }
            case "LV-RIX": {
                return "R\u012bga (Latvia)";
            }
            case "LV-VEN": {
                return "Ventspils (Latvia)";
            }
            case "LV-VMR": {
                return "Valmiera (Latvia)";
            }
            case "LY-BA": {
                return "Bangh\u0101z\u012b (Libya)";
            }
            case "LY-BU": {
                return "Al Bu\u0163n\u0101n (Libya)";
            }
            case "LY-DR": {
                return "Darnah (Libya)";
            }
            case "LY-GT": {
                return "Gh\u0101t (Libya)";
            }
            case "LY-JA": {
                return "Al Jabal al Akh\u1e11ar (Libya)";
            }
            case "LY-JG": {
                return "Al Jabal al Gharb\u012b (Libya)";
            }
            case "LY-JI": {
                return "Al Jif\u0101rah (Libya)";
            }
            case "LY-JU": {
                return "Al Jufrah (Libya)";
            }
            case "LY-KF": {
                return "Al Kufrah (Libya)";
            }
            case "LY-MB": {
                return "Al Marqab (Libya)";
            }
            case "LY-MI": {
                return "Mi\u015fr\u0101tah (Libya)";
            }
            case "LY-MJ": {
                return "Al Marj (Libya)";
            }
            case "LY-MQ": {
                return "Murzuq (Libya)";
            }
            case "LY-NL": {
                return "N\u0101l\u016bt (Libya)";
            }
            case "LY-NQ": {
                return "An Nuq\u0101\u0163 al Khams (Libya)";
            }
            case "LY-SB": {
                return "Sabh\u0101 (Libya)";
            }
            case "LY-SR": {
                return "Surt (Libya)";
            }
            case "LY-TB": {
                return "\u0162ar\u0101bulus (Libya)";
            }
            case "LY-WA": {
                return "Al W\u0101\u1e29\u0101t (Libya)";
            }
            case "LY-WD": {
                return "W\u0101d\u012b al \u1e28ay\u0101t (Libya)";
            }
            case "LY-WS": {
                return "W\u0101d\u012b ash Sh\u0101\u0163i\u2019 (Libya)";
            }
            case "LY-ZA": {
                return "Az Z\u0101wiyah (Libya)";
            }
        }
        return "Unknown state code '" + c.getCode() + "'";
    }

    private static String stateMR(Coding c) {
        switch (c.getCode()) {
            case "MA-01": {
                return "Tanger-T\u00e9touan (Morocco)";
            }
            case "MA-02": {
                return "Gharb-Chrarda-Beni Hssen (Morocco)";
            }
            case "MA-03": {
                return "Taza-Al Hoceima-Taounate (Morocco)";
            }
            case "MA-04": {
                return "L'Oriental (Morocco)";
            }
            case "MA-05": {
                return "F\u00e8s-Boulemane (Morocco)";
            }
            case "MA-06": {
                return "Mekn\u00e8s-Tafilalet (Morocco)";
            }
            case "MA-07": {
                return "Rabat-Sal\u00e9-Zemmour-Zaer (Morocco)";
            }
            case "MA-08": {
                return "Grand Casablanca (Morocco)";
            }
            case "MA-09": {
                return "Chaouia-Ouardigha (Morocco)";
            }
            case "MA-10": {
                return "Doukkala-Abda (Morocco)";
            }
            case "MA-11": {
                return "Marrakech-Tensift-Al Haouz (Morocco)";
            }
            case "MA-12": {
                return "Tadla-Azilal (Morocco)";
            }
            case "MA-13": {
                return "Sous-Massa-Draa (Morocco)";
            }
            case "MA-14": {
                return "Guelmim-Es Semara (Morocco)";
            }
            case "MA-15": {
                return "La\u00e2youne-Boujdour-Sakia el Hamra (Morocco)";
            }
            case "MA-16": {
                return "Oued ed Dahab-Lagouira (Morocco)";
            }
            case "MA-AGD": {
                return "Agadir-Ida-Outanane (Morocco)";
            }
            case "MA-AOU": {
                return "Aousserd (Morocco)";
            }
            case "MA-ASZ": {
                return "Assa-Zag (Morocco)";
            }
            case "MA-AZI": {
                return "Azilal (Morocco)";
            }
            case "MA-BEM": {
                return "Beni Mellal (Morocco)";
            }
            case "MA-BER": {
                return "Berkane (Morocco)";
            }
            case "MA-BES": {
                return "Ben Slimane (Morocco)";
            }
            case "MA-BOD": {
                return "Boujdour (Morocco)";
            }
            case "MA-BOM": {
                return "Boulemane (Morocco)";
            }
            case "MA-CAS": {
                return "Casablanca (Morocco)";
            }
            case "MA-CHE": {
                return "Chefchaouen (Morocco)";
            }
            case "MA-CHI": {
                return "Chichaoua (Morocco)";
            }
            case "MA-CHT": {
                return "Chtouka-Ait Baha (Morocco)";
            }
            case "MA-ERR": {
                return "Errachidia (Morocco)";
            }
            case "MA-ESI": {
                return "Essaouira (Morocco)";
            }
            case "MA-ESM": {
                return "Es Smara (Morocco)";
            }
            case "MA-FAH": {
                return "Fahs-Beni Makada (Morocco)";
            }
            case "MA-FES": {
                return "F\u00e8s-Dar-Dbibegh (Morocco)";
            }
            case "MA-FIG": {
                return "Figuig (Morocco)";
            }
            case "MA-GUE": {
                return "Guelmim (Morocco)";
            }
            case "MA-HAJ": {
                return "El Hajeb (Morocco)";
            }
            case "MA-HAO": {
                return "Al Haouz (Morocco)";
            }
            case "MA-HOC": {
                return "Al Hoce\u00efma (Morocco)";
            }
            case "MA-IFR": {
                return "Ifrane (Morocco)";
            }
            case "MA-INE": {
                return "Inezgane-Ait Melloul (Morocco)";
            }
            case "MA-JDI": {
                return "El Jadida (Morocco)";
            }
            case "MA-JRA": {
                return "Jrada (Morocco)";
            }
            case "MA-KEN": {
                return "K\u00e9nitra (Morocco)";
            }
            case "MA-KES": {
                return "Kelaat es Sraghna (Morocco)";
            }
            case "MA-KHE": {
                return "Khemisset (Morocco)";
            }
            case "MA-KHN": {
                return "Khenifra (Morocco)";
            }
            case "MA-KHO": {
                return "Khouribga (Morocco)";
            }
            case "MA-LAA": {
                return "La\u00e2youne (Morocco)";
            }
            case "MA-LAR": {
                return "Larache (Morocco)";
            }
            case "MA-MED": {
                return "M\u00e9diouna (Morocco)";
            }
            case "MA-MEK": {
                return "Mekn\u00e8s (Morocco)";
            }
            case "MA-MMD": {
                return "Marrakech-Medina (Morocco)";
            }
            case "MA-MMN": {
                return "Marrakech-Menara (Morocco)";
            }
            case "MA-MOH": {
                return "Mohammadia (Morocco)";
            }
            case "MA-MOU": {
                return "Moulay Yacoub (Morocco)";
            }
            case "MA-NAD": {
                return "Nador (Morocco)";
            }
            case "MA-NOU": {
                return "Nouaceur (Morocco)";
            }
            case "MA-OUA": {
                return "Ouarzazate (Morocco)";
            }
            case "MA-OUD": {
                return "Oued ed Dahab (Morocco)";
            }
            case "MA-OUJ": {
                return "Oujda-Angad (Morocco)";
            }
            case "MA-RAB": {
                return "Rabat (Morocco)";
            }
            case "MA-SAF": {
                return "Safi (Morocco)";
            }
            case "MA-SAL": {
                return "Sal\u00e9 (Morocco)";
            }
            case "MA-SEF": {
                return "Sefrou (Morocco)";
            }
            case "MA-SET": {
                return "Settat (Morocco)";
            }
            case "MA-SIK": {
                return "Sidi Kacem (Morocco)";
            }
            case "MA-SKH": {
                return "Skhirate-T\u00e9mara (Morocco)";
            }
            case "MA-SYB": {
                return "Sidi Youssef Ben Ali (Morocco)";
            }
            case "MA-TAI": {
                return "Taourirt (Morocco)";
            }
            case "MA-TAO": {
                return "Taounate (Morocco)";
            }
            case "MA-TAR": {
                return "Taroudant (Morocco)";
            }
            case "MA-TAT": {
                return "Tata (Morocco)";
            }
            case "MA-TAZ": {
                return "Taza (Morocco)";
            }
            case "MA-TET": {
                return "T\u00e9touan (Morocco)";
            }
            case "MA-TIZ": {
                return "Tiznit (Morocco)";
            }
            case "MA-TNG": {
                return "Tanger-Assilah (Morocco)";
            }
            case "MA-TNT": {
                return "Tan-Tan (Morocco)";
            }
            case "MA-ZAG": {
                return "Zagora (Morocco)";
            }
            case "MC-CL": {
                return "La Colle (Monaco)";
            }
            case "MC-CO": {
                return "La Condamine (Monaco)";
            }
            case "MC-FO": {
                return "Fontvieille (Monaco)";
            }
            case "MC-GA": {
                return "La Gare (Monaco)";
            }
            case "MC-JE": {
                return "Jardin Exotique (Monaco)";
            }
            case "MC-LA": {
                return "Larvotto (Monaco)";
            }
            case "MC-MA": {
                return "Malbousquet (Monaco)";
            }
            case "MC-MC": {
                return "Monte-Carlo (Monaco)";
            }
            case "MC-MG": {
                return "Moneghetti (Monaco)";
            }
            case "MC-MO": {
                return "Monaco-Ville (Monaco)";
            }
            case "MC-MU": {
                return "Moulins (Monaco)";
            }
            case "MC-PH": {
                return "Port-Hercule (Monaco)";
            }
            case "MC-SD": {
                return "Sainte-D\u00e9vote (Monaco)";
            }
            case "MC-SO": {
                return "La Source (Monaco)";
            }
            case "MC-SP": {
                return "Sp\u00e9lugues (Monaco)";
            }
            case "MC-SR": {
                return "Saint-Roman (Monaco)";
            }
            case "MC-VR": {
                return "Vallon de la Rousse (Monaco)";
            }
            case "MD-AN": {
                return "Anenii Noi (Moldova)";
            }
            case "MD-BA": {
                return "B\u0103l\u0163i (Moldova)";
            }
            case "MD-BD": {
                return "Bender (Moldova)";
            }
            case "MD-BR": {
                return "Briceni (Moldova)";
            }
            case "MD-BS": {
                return "Basarabeasca (Moldova)";
            }
            case "MD-CA": {
                return "Cahul (Moldova)";
            }
            case "MD-CL": {
                return "C\u0103l\u0103ra\u015fi (Moldova)";
            }
            case "MD-CM": {
                return "Cimi\u015flia (Moldova)";
            }
            case "MD-CR": {
                return "Criuleni (Moldova)";
            }
            case "MD-CS": {
                return "C\u0103u\u015feni (Moldova)";
            }
            case "MD-CT": {
                return "Cantemir (Moldova)";
            }
            case "MD-CU": {
                return "Chi\u015fin\u0103u (Moldova)";
            }
            case "MD-DO": {
                return "Dondu\u015feni (Moldova)";
            }
            case "MD-DR": {
                return "Drochia (Moldova)";
            }
            case "MD-DU": {
                return "Dub\u0103sari (Moldova)";
            }
            case "MD-ED": {
                return "Edine\u0163 (Moldova)";
            }
            case "MD-FA": {
                return "F\u0103le\u015fti (Moldova)";
            }
            case "MD-FL": {
                return "Flore\u015fti (Moldova)";
            }
            case "MD-GA": {
                return "G\u0103g\u0103uzia, Unitatea teritorial\u0103 autonom\u0103 (Moldova)";
            }
            case "MD-GL": {
                return "Glodeni (Moldova)";
            }
            case "MD-HI": {
                return "H\u00eence\u015fti (Moldova)";
            }
            case "MD-IA": {
                return "Ialoveni (Moldova)";
            }
            case "MD-LE": {
                return "Leova (Moldova)";
            }
            case "MD-NI": {
                return "Nisporeni (Moldova)";
            }
            case "MD-OC": {
                return "Ocni\u0163a (Moldova)";
            }
            case "MD-OR": {
                return "Orhei (Moldova)";
            }
            case "MD-RE": {
                return "Rezina (Moldova)";
            }
            case "MD-RI": {
                return "R\u00ee\u015fcani (Moldova)";
            }
            case "MD-SD": {
                return "\u015eold\u0103ne\u015fti (Moldova)";
            }
            case "MD-SI": {
                return "S\u00eengerei (Moldova)";
            }
            case "MD-SN": {
                return "St\u00eenga Nistrului, unitatea teritorial\u0103 din (Moldova)";
            }
            case "MD-SO": {
                return "Soroca (Moldova)";
            }
            case "MD-ST": {
                return "Str\u0103\u015feni (Moldova)";
            }
            case "MD-SV": {
                return "\u015etefan Vod\u0103 (Moldova)";
            }
            case "MD-TA": {
                return "Taraclia (Moldova)";
            }
            case "MD-TE": {
                return "Telene\u015fti (Moldova)";
            }
            case "MD-UN": {
                return "Ungheni (Moldova)";
            }
            case "ME-01": {
                return "Andrijevica (Montenegro)";
            }
            case "ME-02": {
                return "Bar (Montenegro)";
            }
            case "ME-03": {
                return "Berane (Montenegro)";
            }
            case "ME-04": {
                return "Bijelo Polje (Montenegro)";
            }
            case "ME-05": {
                return "Budva (Montenegro)";
            }
            case "ME-06": {
                return "Cetinje (Montenegro)";
            }
            case "ME-07": {
                return "Danilovgrad (Montenegro)";
            }
            case "ME-08": {
                return "Herceg-Novi (Montenegro)";
            }
            case "ME-09": {
                return "Kola\u0161in (Montenegro)";
            }
            case "ME-10": {
                return "Kotor (Montenegro)";
            }
            case "ME-11": {
                return "Mojkovac (Montenegro)";
            }
            case "ME-12": {
                return "Nik\u0161i\u0107 (Montenegro)";
            }
            case "ME-13": {
                return "Plav (Montenegro)";
            }
            case "ME-14": {
                return "Pljevlja (Montenegro)";
            }
            case "ME-15": {
                return "Plu\u017eine (Montenegro)";
            }
            case "ME-16": {
                return "Podgorica (Montenegro)";
            }
            case "ME-17": {
                return "Ro\u017eaje (Montenegro)";
            }
            case "ME-18": {
                return "\u0160avnik (Montenegro)";
            }
            case "ME-19": {
                return "Tivat (Montenegro)";
            }
            case "ME-20": {
                return "Ulcinj (Montenegro)";
            }
            case "ME-21": {
                return "\u017dabljak (Montenegro)";
            }
            case "ME-22": {
                return "Gusinje (Montenegro)";
            }
            case "ME-23": {
                return "Petnjica (Montenegro)";
            }
            case "MF-MF": {
                return "St. Martin (St. Martin)";
            }
            case "MG-A": {
                return "Toamasina (Madagascar)";
            }
            case "MG-D": {
                return "Antsiranana (Madagascar)";
            }
            case "MG-F": {
                return "Fianarantsoa (Madagascar)";
            }
            case "MG-M": {
                return "Mahajanga (Madagascar)";
            }
            case "MG-T": {
                return "Antananarivo (Madagascar)";
            }
            case "MG-U": {
                return "Toliara (Madagascar)";
            }
            case "MH-ALK": {
                return "Ailuk (Marshall Islands)";
            }
            case "MH-ALL": {
                return "Ailinglaplap (Marshall Islands)";
            }
            case "MH-ARN": {
                return "Arno (Marshall Islands)";
            }
            case "MH-AUR": {
                return "Aur (Marshall Islands)";
            }
            case "MH-EBO": {
                return "Ebon (Marshall Islands)";
            }
            case "MH-ENI": {
                return "Enewetak and Ujelang (Marshall Islands)";
            }
            case "MH-JAB": {
                return "Jabat (Marshall Islands)";
            }
            case "MH-JAL": {
                return "Jaluit (Marshall Islands)";
            }
            case "MH-KIL": {
                return "Bikini and Kili (Marshall Islands)";
            }
            case "MH-KWA": {
                return "Kwajalein (Marshall Islands)";
            }
            case "MH-L": {
                return "Ralik chain (Marshall Islands)";
            }
            case "MH-LAE": {
                return "Lae (Marshall Islands)";
            }
            case "MH-LIB": {
                return "Lib (Marshall Islands)";
            }
            case "MH-LIK": {
                return "Likiep (Marshall Islands)";
            }
            case "MH-MAJ": {
                return "Majuro (Marshall Islands)";
            }
            case "MH-MAL": {
                return "Maloelap (Marshall Islands)";
            }
            case "MH-MEJ": {
                return "Mejit (Marshall Islands)";
            }
            case "MH-MIL": {
                return "Mili (Marshall Islands)";
            }
            case "MH-NMK": {
                return "Namdrik (Marshall Islands)";
            }
            case "MH-NMU": {
                return "Namu (Marshall Islands)";
            }
            case "MH-RON": {
                return "Rongelap (Marshall Islands)";
            }
            case "MH-T": {
                return "Ratak chain (Marshall Islands)";
            }
            case "MH-UJA": {
                return "Ujae (Marshall Islands)";
            }
            case "MH-UTI": {
                return "Utrik (Marshall Islands)";
            }
            case "MH-WTH": {
                return "Wotho (Marshall Islands)";
            }
            case "MH-WTJ": {
                return "Wotje (Marshall Islands)";
            }
            case "MK-01": {
                return "Aerodrom \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-02": {
                return "Ara\u010dinovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-03": {
                return "Berovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-04": {
                return "Bitola (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-05": {
                return "Bogdanci (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-06": {
                return "Bogovinje (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-07": {
                return "Bosilovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-08": {
                return "Brvenica (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-09": {
                return "Butel \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-10": {
                return "Valandovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-11": {
                return "Vasilevo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-12": {
                return "Vev\u010dani (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-13": {
                return "Veles (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-14": {
                return "Vinica (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-15": {
                return "Vrane\u0161tica (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-16": {
                return "Vrap\u010di\u0161te (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-17": {
                return "Gazi Baba \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-18": {
                return "Gevgelija (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-19": {
                return "Gostivar (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-20": {
                return "Gradsko (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-21": {
                return "Debar (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-22": {
                return "Debarca (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-23": {
                return "Del\u010devo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-24": {
                return "Demir Kapija (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-25": {
                return "Demir Hisar (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-26": {
                return "Dojran (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-27": {
                return "Dolneni (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-28": {
                return "Drugovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-29": {
                return "Gjor\u010de Petrov \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-30": {
                return "\u017delino (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-31": {
                return "Zajas (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-32": {
                return "Zelenikovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-33": {
                return "Zrnovci (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-34": {
                return "Ilinden (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-35": {
                return "Jegunovce (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-36": {
                return "Kavadarci (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-37": {
                return "Karbinci (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-38": {
                return "Karpo\u0161 \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-39": {
                return "Kisela Voda \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-40": {
                return "Ki\u010devo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-41": {
                return "Kon\u010de (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-42": {
                return "Ko\u010dani (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-43": {
                return "Kratovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-44": {
                return "Kriva Palanka (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-45": {
                return "Krivoga\u0161tani (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-46": {
                return "Kru\u0161evo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-47": {
                return "Kumanovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-48": {
                return "Lipkovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-49": {
                return "Lozovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-50": {
                return "Mavrovo i Rostu\u0161a (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-51": {
                return "Makedonska Kamenica (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-52": {
                return "Makedonski Brod (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-53": {
                return "Mogila (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-54": {
                return "Negotino (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-55": {
                return "Novaci (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-56": {
                return "Novo Selo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-57": {
                return "Oslomej (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-58": {
                return "Ohrid (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-59": {
                return "Petrovec (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-60": {
                return "Peh\u010devo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-61": {
                return "Plasnica (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-62": {
                return "Prilep (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-63": {
                return "Probi\u0161tip (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-64": {
                return "Radovi\u0161 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-65": {
                return "Rankovce (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-66": {
                return "Resen (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-67": {
                return "Rosoman (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-68": {
                return "Saraj \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-69": {
                return "Sveti Nikole (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-70": {
                return "Sopi\u0161te (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-71": {
                return "Staro Nagori\u010dane (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-72": {
                return "Struga (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-73": {
                return "Strumica (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-74": {
                return "Studeni\u010dani (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-75": {
                return "Tearce (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-76": {
                return "Tetovo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-77": {
                return "Centar \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-78": {
                return "Centar \u017dupa (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-79": {
                return "\u010cair \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-80": {
                return "\u010ca\u0161ka (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-81": {
                return "\u010ce\u0161inovo-Oble\u0161evo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-82": {
                return "\u010cu\u010der Sandevo (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-83": {
                return "\u0160tip (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "MK-84": {
                return "\u0160uto Orizari \u2020 (Macedonia, the Former Yugoslav Republic Of)";
            }
            case "ML-1": {
                return "Kayes (Mali)";
            }
            case "ML-2": {
                return "Koulikoro (Mali)";
            }
            case "ML-3": {
                return "Sikasso (Mali)";
            }
            case "ML-4": {
                return "S\u00e9gou (Mali)";
            }
            case "ML-5": {
                return "Mopti (Mali)";
            }
            case "ML-6": {
                return "Tombouctou (Mali)";
            }
            case "ML-7": {
                return "Gao (Mali)";
            }
            case "ML-8": {
                return "Kidal (Mali)";
            }
            case "ML-BKO": {
                return "Bamako (Mali)";
            }
            case "MM-01": {
                return "Sagaing (Myanmar)";
            }
            case "MM-02": {
                return "Bago (Myanmar)";
            }
            case "MM-03": {
                return "Magway (Myanmar)";
            }
            case "MM-04": {
                return "Mandalay (Myanmar)";
            }
            case "MM-05": {
                return "Taninthayi (Myanmar)";
            }
            case "MM-06": {
                return "Yangon (Myanmar)";
            }
            case "MM-07": {
                return "Ayeyawady (Myanmar)";
            }
            case "MM-11": {
                return "Kachin (Myanmar)";
            }
            case "MM-12": {
                return "Kayah (Myanmar)";
            }
            case "MM-13": {
                return "Kayin (Myanmar)";
            }
            case "MM-14": {
                return "Chin (Myanmar)";
            }
            case "MM-15": {
                return "Mon (Myanmar)";
            }
            case "MM-16": {
                return "Rakhine (Myanmar)";
            }
            case "MM-17": {
                return "Shan (Myanmar)";
            }
            case "MM-18": {
                return "Nay Pyi Taw (Myanmar)";
            }
            case "MN-035": {
                return "Orhon (Mongolia)";
            }
            case "MN-037": {
                return "Darhan uul (Mongolia)";
            }
            case "MN-039": {
                return "Hentiy (Mongolia)";
            }
            case "MN-041": {
                return "H\u00f6vsg\u00f6l (Mongolia)";
            }
            case "MN-043": {
                return "Hovd (Mongolia)";
            }
            case "MN-046": {
                return "Uvs (Mongolia)";
            }
            case "MN-047": {
                return "T\u00f6v (Mongolia)";
            }
            case "MN-049": {
                return "Selenge (Mongolia)";
            }
            case "MN-051": {
                return "S\u00fchbaatar (Mongolia)";
            }
            case "MN-053": {
                return "\u00d6mn\u00f6gov\u012d (Mongolia)";
            }
            case "MN-055": {
                return "\u00d6v\u00f6rhangay (Mongolia)";
            }
            case "MN-057": {
                return "Dzavhan (Mongolia)";
            }
            case "MN-059": {
                return "Dundgov\u012d (Mongolia)";
            }
            case "MN-061": {
                return "Dornod (Mongolia)";
            }
            case "MN-063": {
                return "Dornogov\u012d (Mongolia)";
            }
            case "MN-064": {
                return "Gov\u012d-S\u00fcmber (Mongolia)";
            }
            case "MN-065": {
                return "Gov\u012d-Altay (Mongolia)";
            }
            case "MN-067": {
                return "Bulgan (Mongolia)";
            }
            case "MN-069": {
                return "Bayanhongor (Mongolia)";
            }
            case "MN-071": {
                return "Bayan-\u00d6lgiy (Mongolia)";
            }
            case "MN-073": {
                return "Arhangay (Mongolia)";
            }
            case "MN-1": {
                return "Ulaanbaatar (Mongolia)";
            }
            case "MO-MO": {
                return "Macau (Macau)";
            }
            case "MP-MP": {
                return "Northern Mariana Islands (Northern Mariana Islands)";
            }
            case "MQ-MQ": {
                return "Martinique (Martinique)";
            }
            case "MR-01": {
                return "Hodh ech Chargui (Mauritania)";
            }
            case "MR-02": {
                return "Hodh el Gharbi (Mauritania)";
            }
            case "MR-03": {
                return "Assaba (Mauritania)";
            }
            case "MR-04": {
                return "Gorgol (Mauritania)";
            }
            case "MR-05": {
                return "Brakna (Mauritania)";
            }
            case "MR-06": {
                return "Trarza (Mauritania)";
            }
            case "MR-07": {
                return "Adrar (Mauritania)";
            }
            case "MR-08": {
                return "Dakhlet Nou\u00e2dhibou (Mauritania)";
            }
            case "MR-09": {
                return "Tagant (Mauritania)";
            }
            case "MR-10": {
                return "Guidimaka (Mauritania)";
            }
            case "MR-11": {
                return "Tiris Zemmour (Mauritania)";
            }
            case "MR-12": {
                return "Inchiri (Mauritania)";
            }
            case "MR-NKC": {
                return "Nouakchott (Mauritania)";
            }
            case "MS-MS": {
                return "Montserrat (Montserrat)";
            }
            case "MT-01": {
                return "Attard (Malta)";
            }
            case "MT-02": {
                return "Balzan (Malta)";
            }
            case "MT-03": {
                return "Birgu (Malta)";
            }
            case "MT-04": {
                return "Birkirkara (Malta)";
            }
            case "MT-05": {
                return "Bir\u017cebbu\u0121a (Malta)";
            }
            case "MT-06": {
                return "Bormla (Malta)";
            }
            case "MT-07": {
                return "Dingli (Malta)";
            }
            case "MT-08": {
                return "Fgura (Malta)";
            }
            case "MT-09": {
                return "Floriana (Malta)";
            }
            case "MT-10": {
                return "Fontana (Malta)";
            }
            case "MT-11": {
                return "Gudja (Malta)";
            }
            case "MT-12": {
                return "G\u017cira (Malta)";
            }
            case "MT-13": {
                return "G\u0127ajnsielem (Malta)";
            }
            case "MT-14": {
                return "G\u0127arb (Malta)";
            }
            case "MT-15": {
                return "G\u0127arg\u0127ur (Malta)";
            }
            case "MT-16": {
                return "G\u0127asri (Malta)";
            }
            case "MT-17": {
                return "G\u0127axaq (Malta)";
            }
            case "MT-18": {
                return "\u0126amrun (Malta)";
            }
            case "MT-19": {
                return "Iklin (Malta)";
            }
            case "MT-20": {
                return "Isla (Malta)";
            }
            case "MT-21": {
                return "Kalkara (Malta)";
            }
            case "MT-22": {
                return "Ker\u010bem (Malta)";
            }
            case "MT-23": {
                return "Kirkop (Malta)";
            }
            case "MT-24": {
                return "Lija (Malta)";
            }
            case "MT-25": {
                return "Luqa (Malta)";
            }
            case "MT-26": {
                return "Marsa (Malta)";
            }
            case "MT-27": {
                return "Marsaskala (Malta)";
            }
            case "MT-28": {
                return "Marsaxlokk (Malta)";
            }
            case "MT-29": {
                return "Mdina (Malta)";
            }
            case "MT-30": {
                return "Mellie\u0127a (Malta)";
            }
            case "MT-31": {
                return "M\u0121arr (Malta)";
            }
            case "MT-32": {
                return "Mosta (Malta)";
            }
            case "MT-33": {
                return "Mqabba (Malta)";
            }
            case "MT-34": {
                return "Msida (Malta)";
            }
            case "MT-35": {
                return "Mtarfa (Malta)";
            }
            case "MT-36": {
                return "Munxar (Malta)";
            }
            case "MT-37": {
                return "Nadur (Malta)";
            }
            case "MT-38": {
                return "Naxxar (Malta)";
            }
            case "MT-39": {
                return "Paola (Malta)";
            }
            case "MT-40": {
                return "Pembroke (Malta)";
            }
            case "MT-41": {
                return "Piet\u00e0 (Malta)";
            }
            case "MT-42": {
                return "Qala (Malta)";
            }
            case "MT-43": {
                return "Qormi (Malta)";
            }
            case "MT-44": {
                return "Qrendi (Malta)";
            }
            case "MT-45": {
                return "Rabat Gozo (Malta)";
            }
            case "MT-46": {
                return "Rabat Malta (Malta)";
            }
            case "MT-47": {
                return "Safi (Malta)";
            }
            case "MT-48": {
                return "Saint Julian\u2019s (Malta)";
            }
            case "MT-49": {
                return "Saint John (Malta)";
            }
            case "MT-50": {
                return "Saint Lawrence (Malta)";
            }
            case "MT-51": {
                return "Saint Paul\u2019s Bay (Malta)";
            }
            case "MT-52": {
                return "Sannat (Malta)";
            }
            case "MT-53": {
                return "Saint Lucia\u2019s (Malta)";
            }
            case "MT-54": {
                return "Santa Venera (Malta)";
            }
            case "MT-55": {
                return "Si\u0121\u0121iewi (Malta)";
            }
            case "MT-56": {
                return "Sliema (Malta)";
            }
            case "MT-57": {
                return "Swieqi (Malta)";
            }
            case "MT-58": {
                return "Ta\u2019 Xbiex (Malta)";
            }
            case "MT-59": {
                return "Tarxien (Malta)";
            }
            case "MT-60": {
                return "Valletta (Malta)";
            }
            case "MT-61": {
                return "Xag\u0127ra (Malta)";
            }
            case "MT-62": {
                return "Xewkija (Malta)";
            }
            case "MT-63": {
                return "Xg\u0127ajra (Malta)";
            }
            case "MT-64": {
                return "\u017babbar (Malta)";
            }
            case "MT-65": {
                return "\u017bebbu\u0121 Gozo (Malta)";
            }
            case "MT-66": {
                return "\u017bebbu\u0121 Malta (Malta)";
            }
            case "MT-67": {
                return "\u017bejtun (Malta)";
            }
            case "MT-68": {
                return "\u017burrieq (Malta)";
            }
            case "MU-AG": {
                return "Agalega Islands (Mauritius)";
            }
            case "MU-BL": {
                return "Black River (Mauritius)";
            }
            case "MU-BR": {
                return "Beau Bassin-Rose Hill (Mauritius)";
            }
            case "MU-CC": {
                return "Cargados Carajos Shoals (Mauritius)";
            }
            case "MU-CU": {
                return "Curepipe (Mauritius)";
            }
            case "MU-FL": {
                return "Flacq (Mauritius)";
            }
            case "MU-GP": {
                return "Grand Port (Mauritius)";
            }
            case "MU-MO": {
                return "Moka (Mauritius)";
            }
            case "MU-PA": {
                return "Pamplemousses (Mauritius)";
            }
            case "MU-PL": {
                return "Port Louis (Mauritius)";
            }
            case "MU-PU": {
                return "Port Louis (Mauritius)";
            }
            case "MU-PW": {
                return "Plaines Wilhems (Mauritius)";
            }
            case "MU-QB": {
                return "Quatre Bornes (Mauritius)";
            }
            case "MU-RO": {
                return "Rodrigues Island (Mauritius)";
            }
            case "MU-RR": {
                return "Rivi\u00e8re du Rempart (Mauritius)";
            }
            case "MU-SA": {
                return "Savanne (Mauritius)";
            }
            case "MU-VP": {
                return "Vacoas-Phoenix (Mauritius)";
            }
            case "MV-00": {
                return "Alifu Dhaalu (Maldives)";
            }
            case "MV-01": {
                return "Addu Atholhu (Maldives)";
            }
            case "MV-02": {
                return "Alifu Alifu (Maldives)";
            }
            case "MV-03": {
                return "Faadhippolhu (Maldives)";
            }
            case "MV-04": {
                return "Felidhu Atholhu (Maldives)";
            }
            case "MV-05": {
                return "Hadhdhunmathi (Maldives)";
            }
            case "MV-07": {
                return "Haa Alifu (Maldives)";
            }
            case "MV-08": {
                return "Kolhumadulu (Maldives)";
            }
            case "MV-12": {
                return "Meemu (Maldives)";
            }
            case "MV-13": {
                return "Maalhosmadulu Uthuruburi (Maldives)";
            }
            case "MV-14": {
                return "Faafu (Maldives)";
            }
            case "MV-17": {
                return "Dhaalu (Maldives)";
            }
            case "MV-20": {
                return "Baa (Maldives)";
            }
            case "MV-23": {
                return "Haa Dhaalu (Maldives)";
            }
            case "MV-24": {
                return "Miladhunmadulu Uthuruburi (Maldives)";
            }
            case "MV-25": {
                return "Miladhunmadulu Dhekunuburi (Maldives)";
            }
            case "MV-26": {
                return "Kaafu (Maldives)";
            }
            case "MV-27": {
                return "Gaafu Alifu (Maldives)";
            }
            case "MV-28": {
                return "Gaafu Dhaalu (Maldives)";
            }
            case "MV-29": {
                return "Fuvammulah (Maldives)";
            }
            case "MV-CE": {
                return "Central (Maldives)";
            }
            case "MV-MLE": {
                return "Maale (Maldives)";
            }
            case "MV-NC": {
                return "Medhu-Uthuru (Maldives)";
            }
            case "MV-NO": {
                return "North (Maldives)";
            }
            case "MV-SC": {
                return "Medhu-Dhekunu (Maldives)";
            }
            case "MV-SU": {
                return "Dhekunu (Maldives)";
            }
            case "MV-UN": {
                return "Mathi-Uthuru (Maldives)";
            }
            case "MV-US": {
                return "Mathi-Dhekunu (Maldives)";
            }
            case "MW-BA": {
                return "Balaka (Malawi)";
            }
            case "MW-BL": {
                return "Blantyre (Malawi)";
            }
            case "MW-C": {
                return "Central Region (Malawi)";
            }
            case "MW-CK": {
                return "Chikwawa (Malawi)";
            }
            case "MW-CR": {
                return "Chiradzulu (Malawi)";
            }
            case "MW-CT": {
                return "Chitipa (Malawi)";
            }
            case "MW-DE": {
                return "Dedza (Malawi)";
            }
            case "MW-DO": {
                return "Dowa (Malawi)";
            }
            case "MW-KR": {
                return "Karonga (Malawi)";
            }
            case "MW-KS": {
                return "Kasungu (Malawi)";
            }
            case "MW-LI": {
                return "Lilongwe (Malawi)";
            }
            case "MW-LK": {
                return "Likoma (Malawi)";
            }
            case "MW-MC": {
                return "Mchinji (Malawi)";
            }
            case "MW-MG": {
                return "Mangochi (Malawi)";
            }
            case "MW-MH": {
                return "Machinga (Malawi)";
            }
            case "MW-MU": {
                return "Mulanje (Malawi)";
            }
            case "MW-MW": {
                return "Mwanza (Malawi)";
            }
            case "MW-MZ": {
                return "Mzimba (Malawi)";
            }
            case "MW-N": {
                return "Chakumpoto (Malawi)";
            }
            case "MW-NB": {
                return "Nkhata Bay (Malawi)";
            }
            case "MW-NE": {
                return "Neno (Malawi)";
            }
            case "MW-NI": {
                return "Ntchisi (Malawi)";
            }
            case "MW-NK": {
                return "Nkhotakota (Malawi)";
            }
            case "MW-NS": {
                return "Nsanje (Malawi)";
            }
            case "MW-NU": {
                return "Ntcheu (Malawi)";
            }
            case "MW-PH": {
                return "Phalombe (Malawi)";
            }
            case "MW-RU": {
                return "Rumphi (Malawi)";
            }
            case "MW-S": {
                return "Chakumwera (Malawi)";
            }
            case "MW-SA": {
                return "Salima (Malawi)";
            }
            case "MW-TH": {
                return "Thyolo (Malawi)";
            }
            case "MW-ZO": {
                return "Zomba (Malawi)";
            }
            case "MX-AGU": {
                return "Aguascalientes (Mexico)";
            }
            case "MX-BCN": {
                return "Baja California (Mexico)";
            }
            case "MX-BCS": {
                return "Baja California Sur (Mexico)";
            }
            case "MX-CAM": {
                return "Campeche (Mexico)";
            }
            case "MX-CHH": {
                return "Chihuahua (Mexico)";
            }
            case "MX-CHP": {
                return "Chiapas (Mexico)";
            }
            case "MX-CMX": {
                return "Ciudad de M\u00e9xico (Mexico)";
            }
            case "MX-COA": {
                return "Coahuila de Zaragoza (Mexico)";
            }
            case "MX-COL": {
                return "Colima (Mexico)";
            }
            case "MX-DUR": {
                return "Durango (Mexico)";
            }
            case "MX-GRO": {
                return "Guerrero (Mexico)";
            }
            case "MX-GUA": {
                return "Guanajuato (Mexico)";
            }
            case "MX-HID": {
                return "Hidalgo (Mexico)";
            }
            case "MX-JAL": {
                return "Jalisco (Mexico)";
            }
            case "MX-MEX": {
                return "M\u00e9xico (Mexico)";
            }
            case "MX-MIC": {
                return "Michoac\u00e1n de Ocampo (Mexico)";
            }
            case "MX-MOR": {
                return "Morelos (Mexico)";
            }
            case "MX-NAY": {
                return "Nayarit (Mexico)";
            }
            case "MX-NLE": {
                return "Nuevo Le\u00f3n (Mexico)";
            }
            case "MX-OAX": {
                return "Oaxaca (Mexico)";
            }
            case "MX-PUE": {
                return "Puebla (Mexico)";
            }
            case "MX-QUE": {
                return "Quer\u00e9taro (Mexico)";
            }
            case "MX-ROO": {
                return "Quintana Roo (Mexico)";
            }
            case "MX-SIN": {
                return "Sinaloa (Mexico)";
            }
            case "MX-SLP": {
                return "San Luis Potos\u00ed (Mexico)";
            }
            case "MX-SON": {
                return "Sonora (Mexico)";
            }
            case "MX-TAB": {
                return "Tabasco (Mexico)";
            }
            case "MX-TAM": {
                return "Tamaulipas (Mexico)";
            }
            case "MX-TLA": {
                return "Tlaxcala (Mexico)";
            }
            case "MX-VER": {
                return "Veracruz de Ignacio de la Llave (Mexico)";
            }
            case "MX-YUC": {
                return "Yucat\u00e1n (Mexico)";
            }
            case "MX-ZAC": {
                return "Zacatecas (Mexico)";
            }
            case "MY-01": {
                return "Johor (Malaysia)";
            }
            case "MY-02": {
                return "Kedah (Malaysia)";
            }
            case "MY-03": {
                return "Kelantan (Malaysia)";
            }
            case "MY-04": {
                return "Melaka (Malaysia)";
            }
            case "MY-05": {
                return "Negeri Sembilan (Malaysia)";
            }
            case "MY-06": {
                return "Pahang (Malaysia)";
            }
            case "MY-07": {
                return "Pulau Pinang (Malaysia)";
            }
            case "MY-08": {
                return "Perak (Malaysia)";
            }
            case "MY-09": {
                return "Perlis (Malaysia)";
            }
            case "MY-10": {
                return "Selangor (Malaysia)";
            }
            case "MY-11": {
                return "Terengganu (Malaysia)";
            }
            case "MY-12": {
                return "Sabah (Malaysia)";
            }
            case "MY-13": {
                return "Sarawak (Malaysia)";
            }
            case "MY-14": {
                return "Wilayah Persekutuan Kuala Lumpur (Malaysia)";
            }
            case "MY-15": {
                return "Wilayah Persekutuan Labuan (Malaysia)";
            }
            case "MY-16": {
                return "Wilayah Persekutuan Putrajaya (Malaysia)";
            }
            case "MZ-A": {
                return "Niassa (Mozambique)";
            }
            case "MZ-B": {
                return "Manica (Mozambique)";
            }
            case "MZ-G": {
                return "Gaza (Mozambique)";
            }
            case "MZ-I": {
                return "Inhambane (Mozambique)";
            }
            case "MZ-L": {
                return "Maputo (Mozambique)";
            }
            case "MZ-MPM": {
                return "Maputo (Mozambique)";
            }
            case "MZ-N": {
                return "Nampula (Mozambique)";
            }
            case "MZ-P": {
                return "Cabo Delgado (Mozambique)";
            }
            case "MZ-Q": {
                return "Zamb\u00e9zia (Mozambique)";
            }
            case "MZ-S": {
                return "Sofala (Mozambique)";
            }
            case "MZ-T": {
                return "Tete (Mozambique)";
            }
            case "NA-CA": {
                return "Zambezi (Namibia)";
            }
            case "NA-ER": {
                return "Erongo (Namibia)";
            }
            case "NA-HA": {
                return "Hardap (Namibia)";
            }
            case "NA-KA": {
                return "Karas (Namibia)";
            }
            case "NA-KE": {
                return "Kavango East (Namibia)";
            }
            case "NA-KH": {
                return "Khomas (Namibia)";
            }
            case "NA-KU": {
                return "Kunene (Namibia)";
            }
            case "NA-KW": {
                return "Kavango West (Namibia)";
            }
            case "NA-OD": {
                return "Otjozondjupa (Namibia)";
            }
            case "NA-OH": {
                return "Omaheke (Namibia)";
            }
            case "NA-ON": {
                return "Oshana (Namibia)";
            }
            case "NA-OS": {
                return "Omusati (Namibia)";
            }
            case "NA-OT": {
                return "Oshikoto (Namibia)";
            }
            case "NA-OW": {
                return "Ohangwena (Namibia)";
            }
            case "NC-NC": {
                return "New Caledonia (New Caledonia)";
            }
            case "NE-1": {
                return "Agadez (Niger)";
            }
            case "NE-2": {
                return "Diffa (Niger)";
            }
            case "NE-3": {
                return "Dosso (Niger)";
            }
            case "NE-4": {
                return "Maradi (Niger)";
            }
            case "NE-5": {
                return "Tahoua (Niger)";
            }
            case "NE-6": {
                return "Tillab\u00e9ri (Niger)";
            }
            case "NE-7": {
                return "Zinder (Niger)";
            }
            case "NE-8": {
                return "Niamey (Niger)";
            }
            case "NF-NF": {
                return "Norfolk Island (Norfolk Island)";
            }
            case "NG-AB": {
                return "Abia (Nigeria)";
            }
            case "NG-AD": {
                return "Adamawa (Nigeria)";
            }
            case "NG-AK": {
                return "Akwa Ibom (Nigeria)";
            }
            case "NG-AN": {
                return "Anambra (Nigeria)";
            }
            case "NG-BA": {
                return "Bauchi (Nigeria)";
            }
            case "NG-BE": {
                return "Benue (Nigeria)";
            }
            case "NG-BO": {
                return "Borno (Nigeria)";
            }
            case "NG-BY": {
                return "Bayelsa (Nigeria)";
            }
            case "NG-CR": {
                return "Cross River (Nigeria)";
            }
            case "NG-DE": {
                return "Delta (Nigeria)";
            }
            case "NG-EB": {
                return "Ebonyi (Nigeria)";
            }
            case "NG-ED": {
                return "Edo (Nigeria)";
            }
            case "NG-EK": {
                return "Ekiti (Nigeria)";
            }
            case "NG-EN": {
                return "Enugu (Nigeria)";
            }
            case "NG-FC": {
                return "Abuja Federal Capital Territory (Nigeria)";
            }
            case "NG-GO": {
                return "Gombe (Nigeria)";
            }
            case "NG-IM": {
                return "Imo (Nigeria)";
            }
            case "NG-JI": {
                return "Jigawa (Nigeria)";
            }
            case "NG-KD": {
                return "Kaduna (Nigeria)";
            }
            case "NG-KE": {
                return "Kebbi (Nigeria)";
            }
            case "NG-KN": {
                return "Kano (Nigeria)";
            }
            case "NG-KO": {
                return "Kogi (Nigeria)";
            }
            case "NG-KT": {
                return "Katsina (Nigeria)";
            }
            case "NG-KW": {
                return "Kwara (Nigeria)";
            }
            case "NG-LA": {
                return "Lagos (Nigeria)";
            }
            case "NG-NA": {
                return "Nasarawa (Nigeria)";
            }
            case "NG-NI": {
                return "Niger (Nigeria)";
            }
            case "NG-OG": {
                return "Ogun (Nigeria)";
            }
            case "NG-ON": {
                return "Ondo (Nigeria)";
            }
            case "NG-OS": {
                return "Osun (Nigeria)";
            }
            case "NG-OY": {
                return "Oyo (Nigeria)";
            }
            case "NG-PL": {
                return "Plateau (Nigeria)";
            }
            case "NG-RI": {
                return "Rivers (Nigeria)";
            }
            case "NG-SO": {
                return "Sokoto (Nigeria)";
            }
            case "NG-TA": {
                return "Taraba (Nigeria)";
            }
            case "NG-YO": {
                return "Yobe (Nigeria)";
            }
            case "NG-ZA": {
                return "Zamfara (Nigeria)";
            }
            case "NI-AN": {
                return "Atl\u00e1ntico Norte (Nicaragua)";
            }
            case "NI-AS": {
                return "Atl\u00e1ntico Sur (Nicaragua)";
            }
            case "NI-BO": {
                return "Boaco (Nicaragua)";
            }
            case "NI-CA": {
                return "Carazo (Nicaragua)";
            }
            case "NI-CI": {
                return "Chinandega (Nicaragua)";
            }
            case "NI-CO": {
                return "Chontales (Nicaragua)";
            }
            case "NI-ES": {
                return "Estel\u00ed (Nicaragua)";
            }
            case "NI-GR": {
                return "Granada (Nicaragua)";
            }
            case "NI-JI": {
                return "Jinotega (Nicaragua)";
            }
            case "NI-LE": {
                return "Le\u00f3n (Nicaragua)";
            }
            case "NI-MD": {
                return "Madriz (Nicaragua)";
            }
            case "NI-MN": {
                return "Managua (Nicaragua)";
            }
            case "NI-MS": {
                return "Masaya (Nicaragua)";
            }
            case "NI-MT": {
                return "Matagalpa (Nicaragua)";
            }
            case "NI-NS": {
                return "Nueva Segovia (Nicaragua)";
            }
            case "NI-RI": {
                return "Rivas (Nicaragua)";
            }
            case "NI-SJ": {
                return "R\u00edo San Juan (Nicaragua)";
            }
            case "NL-AW": {
                return "Aruba (Netherlands)";
            }
            case "NL-BQ1": {
                return "Bonaire (Netherlands)";
            }
            case "NL-BQ2": {
                return "Saba (Netherlands)";
            }
            case "NL-BQ3": {
                return "Sint Eustatius (Netherlands)";
            }
            case "NL-CW": {
                return "Cura\u00e7ao (Netherlands)";
            }
            case "NL-DR": {
                return "Drenthe (Netherlands)";
            }
            case "NL-FL": {
                return "Flevoland (Netherlands)";
            }
            case "NL-FR": {
                return "Frysl\u00e2n (Netherlands)";
            }
            case "NL-GE": {
                return "Gelderland (Netherlands)";
            }
            case "NL-GR": {
                return "Groningen (Netherlands)";
            }
            case "NL-LI": {
                return "Limburg (Netherlands)";
            }
            case "NL-NB": {
                return "Noord-Brabant (Netherlands)";
            }
            case "NL-NH": {
                return "Noord-Holland (Netherlands)";
            }
            case "NL-OV": {
                return "Overijssel (Netherlands)";
            }
            case "NL-SX": {
                return "Sint Maarten (Netherlands)";
            }
            case "NL-UT": {
                return "Utrecht (Netherlands)";
            }
            case "NL-ZE": {
                return "Zeeland (Netherlands)";
            }
            case "NL-ZH": {
                return "Zuid-Holland (Netherlands)";
            }
            case "NO-01": {
                return "\u00d8stfold (Norway)";
            }
            case "NO-02": {
                return "Akershus (Norway)";
            }
            case "NO-03": {
                return "Oslo (Norway)";
            }
            case "NO-04": {
                return "Hedmark (Norway)";
            }
            case "NO-05": {
                return "Oppland (Norway)";
            }
            case "NO-06": {
                return "Buskerud (Norway)";
            }
            case "NO-07": {
                return "Vestfold (Norway)";
            }
            case "NO-08": {
                return "Telemark (Norway)";
            }
            case "NO-09": {
                return "Aust-Agder (Norway)";
            }
            case "NO-10": {
                return "Vest-Agder (Norway)";
            }
            case "NO-11": {
                return "Rogaland (Norway)";
            }
            case "NO-12": {
                return "Hordaland (Norway)";
            }
            case "NO-14": {
                return "Sogn og Fjordane (Norway)";
            }
            case "NO-15": {
                return "M\u00f8re og Romsdal (Norway)";
            }
            case "NO-16": {
                return "S\u00f8r-Tr\u00f8ndelag (Norway)";
            }
            case "NO-17": {
                return "Nord-Tr\u00f8ndelag (Norway)";
            }
            case "NO-18": {
                return "Nordland (Norway)";
            }
            case "NO-19": {
                return "Romsa (Norway)";
            }
            case "NO-20": {
                return "Finnmark (Norway)";
            }
            case "NO-21": {
                return "Svalbard (Norway)";
            }
            case "NO-22": {
                return "Jan Mayen (Norway)";
            }
            case "NP-1": {
                return "Central (Nepal)";
            }
            case "NP-2": {
                return "Madhya Pashchimanchal (Nepal)";
            }
            case "NP-3": {
                return "Pashchimanchal (Nepal)";
            }
            case "NP-4": {
                return "Eastern (Nepal)";
            }
            case "NP-5": {
                return "Far Western (Nepal)";
            }
            case "NP-BA": {
                return "Bagmati (Nepal)";
            }
            case "NP-BH": {
                return "Bheri (Nepal)";
            }
            case "NP-DH": {
                return "Dhawalagiri (Nepal)";
            }
            case "NP-GA": {
                return "Gandaki (Nepal)";
            }
            case "NP-JA": {
                return "Janakpur (Nepal)";
            }
            case "NP-KA": {
                return "Karnali (Nepal)";
            }
            case "NP-KO": {
                return "Kosi (Nepal)";
            }
            case "NP-LU": {
                return "Lumbini (Nepal)";
            }
            case "NP-MA": {
                return "Mahakali (Nepal)";
            }
            case "NP-ME": {
                return "Mechi (Nepal)";
            }
            case "NP-NA": {
                return "Narayani (Nepal)";
            }
            case "NP-RA": {
                return "Rapti (Nepal)";
            }
            case "NP-SA": {
                return "Sagarmatha (Nepal)";
            }
            case "NP-SE": {
                return "Seti (Nepal)";
            }
            case "NR-01": {
                return "Aiwo (Nauru)";
            }
            case "NR-02": {
                return "Anabar (Nauru)";
            }
            case "NR-03": {
                return "Anetan (Nauru)";
            }
            case "NR-04": {
                return "Anibare (Nauru)";
            }
            case "NR-05": {
                return "Baiti (Nauru)";
            }
            case "NR-06": {
                return "Boe (Nauru)";
            }
            case "NR-07": {
                return "Buada (Nauru)";
            }
            case "NR-08": {
                return "Denigomodu (Nauru)";
            }
            case "NR-09": {
                return "Ewa (Nauru)";
            }
            case "NR-10": {
                return "Ijuw (Nauru)";
            }
            case "NR-11": {
                return "Meneng (Nauru)";
            }
            case "NR-12": {
                return "Nibok (Nauru)";
            }
            case "NR-13": {
                return "Uaboe (Nauru)";
            }
            case "NR-14": {
                return "Yaren (Nauru)";
            }
            case "NU-NU": {
                return "Niue (Niue)";
            }
            case "NZ-AUK": {
                return "Auckland (New Zealand)";
            }
            case "NZ-BOP": {
                return "Bay of Plenty (New Zealand)";
            }
            case "NZ-CAN": {
                return "Canterbury (New Zealand)";
            }
            case "NZ-CIT": {
                return "Chatham Islands Territory (New Zealand)";
            }
            case "NZ-GIS": {
                return "Gisborne District (New Zealand)";
            }
            case "NZ-HKB": {
                return "Hawke's Bay (New Zealand)";
            }
            case "NZ-MBH": {
                return "Marlborough District (New Zealand)";
            }
            case "NZ-MWT": {
                return "Manawatu-Wanganui (New Zealand)";
            }
            case "NZ-N": {
                return "North Island (New Zealand)";
            }
            case "NZ-NSN": {
                return "Nelson City (New Zealand)";
            }
            case "NZ-NTL": {
                return "Northland (New Zealand)";
            }
            case "NZ-OTA": {
                return "Otago (New Zealand)";
            }
            case "NZ-S": {
                return "South Island (New Zealand)";
            }
            case "NZ-STL": {
                return "Southland (New Zealand)";
            }
            case "NZ-TAS": {
                return "Tasman District (New Zealand)";
            }
            case "NZ-TKI": {
                return "Taranaki (New Zealand)";
            }
            case "NZ-WGN": {
                return "Wellington (New Zealand)";
            }
            case "NZ-WKO": {
                return "Waikato (New Zealand)";
            }
            case "NZ-WTC": {
                return "West Coast (New Zealand)";
            }
            case "OM-BA": {
                return "Al B\u0101\u0163inah (Oman)";
            }
            case "OM-BU": {
                return "Al Buraym\u012b (Oman)";
            }
            case "OM-DA": {
                return "Ad D\u0101khil\u012byah (Oman)";
            }
            case "OM-MA": {
                return "Masqa\u0163 (Oman)";
            }
            case "OM-MU": {
                return "Musandam (Oman)";
            }
            case "OM-SH": {
                return "Ash Sharq\u012byah (Oman)";
            }
            case "OM-WU": {
                return "Al Wus\u0163\u00e1 (Oman)";
            }
            case "OM-ZA": {
                return "Az\u0327 Z\u0327\u0101hirah (Oman)";
            }
            case "OM-ZU": {
                return "Z\u0327uf\u0101r (Oman)";
            }
            case "PA-1": {
                return "Bocas del Toro (Panama)";
            }
            case "PA-10": {
                return "Panam\u00e1 Oeste (Panama)";
            }
            case "PA-2": {
                return "Cocl\u00e9 (Panama)";
            }
            case "PA-3": {
                return "Col\u00f3n (Panama)";
            }
            case "PA-4": {
                return "Chiriqu\u00ed (Panama)";
            }
            case "PA-5": {
                return "Dari\u00e9n (Panama)";
            }
            case "PA-6": {
                return "Herrera (Panama)";
            }
            case "PA-7": {
                return "Los Santos (Panama)";
            }
            case "PA-8": {
                return "Panam\u00e1 (Panama)";
            }
            case "PA-9": {
                return "Veraguas (Panama)";
            }
            case "PA-EM": {
                return "Ember\u00e1 (Panama)";
            }
            case "PA-KY": {
                return "Kuna Yala (Panama)";
            }
            case "PA-NB": {
                return "Ng\u00f6be-Bugl\u00e9 (Panama)";
            }
            case "PE-AMA": {
                return "Amarumayu (Peru)";
            }
            case "PE-ANC": {
                return "Ancash (Peru)";
            }
            case "PE-APU": {
                return "Apur\u00edmac (Peru)";
            }
            case "PE-ARE": {
                return "Arequipa (Peru)";
            }
            case "PE-AYA": {
                return "Ayacucho (Peru)";
            }
            case "PE-CAJ": {
                return "Cajamarca (Peru)";
            }
            case "PE-CAL": {
                return "El Callao (Peru)";
            }
            case "PE-CUS": {
                return "Cusco (Peru)";
            }
            case "PE-HUC": {
                return "Hu\u00e1nuco (Peru)";
            }
            case "PE-HUV": {
                return "Huancavelica (Peru)";
            }
            case "PE-ICA": {
                return "Ica (Peru)";
            }
            case "PE-JUN": {
                return "Hunin (Peru)";
            }
            case "PE-LAL": {
                return "La Libertad (Peru)";
            }
            case "PE-LAM": {
                return "Lambayeque (Peru)";
            }
            case "PE-LIM": {
                return "Lima (Peru)";
            }
            case "PE-LMA": {
                return "Lima hatun llaqta (Peru)";
            }
            case "PE-LOR": {
                return "Loreto (Peru)";
            }
            case "PE-MDD": {
                return "Madre de Dios (Peru)";
            }
            case "PE-MOQ": {
                return "Moquegua (Peru)";
            }
            case "PE-PAS": {
                return "Pasco (Peru)";
            }
            case "PE-PIU": {
                return "Piura (Peru)";
            }
            case "PE-PUN": {
                return "Puno (Peru)";
            }
            case "PE-SAM": {
                return "San Martin (Peru)";
            }
            case "PE-TAC": {
                return "Tacna (Peru)";
            }
            case "PE-TUM": {
                return "Tumbes (Peru)";
            }
            case "PE-UCA": {
                return "Ucayali (Peru)";
            }
            case "PF-PF": {
                return "French Polynesia (French Polynesia)";
            }
            case "PG-CPK": {
                return "Chimbu (Papua New Guinea)";
            }
            case "PG-CPM": {
                return "Central (Papua New Guinea)";
            }
            case "PG-EBR": {
                return "East New Britain (Papua New Guinea)";
            }
            case "PG-EHG": {
                return "Eastern Highlands (Papua New Guinea)";
            }
            case "PG-EPW": {
                return "Enga (Papua New Guinea)";
            }
            case "PG-ESW": {
                return "East Sepik (Papua New Guinea)";
            }
            case "PG-GPK": {
                return "Gulf (Papua New Guinea)";
            }
            case "PG-HLA": {
                return "Hela (Papua New Guinea)";
            }
            case "PG-JWK": {
                return "Jiwaka (Papua New Guinea)";
            }
            case "PG-MBA": {
                return "Milne Bay (Papua New Guinea)";
            }
            case "PG-MPL": {
                return "Morobe (Papua New Guinea)";
            }
            case "PG-MPM": {
                return "Madang (Papua New Guinea)";
            }
            case "PG-MRL": {
                return "Manus (Papua New Guinea)";
            }
            case "PG-NCD": {
                return "National Capital District (Papua New Guinea)";
            }
            case "PG-NIK": {
                return "New Ireland (Papua New Guinea)";
            }
            case "PG-NPP": {
                return "Northern (Papua New Guinea)";
            }
            case "PG-NSB": {
                return "Bougainville (Papua New Guinea)";
            }
            case "PG-SAN": {
                return "West Sepik (Papua New Guinea)";
            }
            case "PG-SHM": {
                return "Southern Highlands (Papua New Guinea)";
            }
            case "PG-WBK": {
                return "West New Britain (Papua New Guinea)";
            }
            case "PG-WHM": {
                return "Western Highlands (Papua New Guinea)";
            }
            case "PG-WPD": {
                return "Western (Papua New Guinea)";
            }
            case "PH-00": {
                return "National Capital Region (Philippines)";
            }
            case "PH-01": {
                return "Ilocos (Philippines)";
            }
            case "PH-02": {
                return "Cagayan Valley (Philippines)";
            }
            case "PH-03": {
                return "Central Luzon (Philippines)";
            }
            case "PH-05": {
                return "Bicol (Philippines)";
            }
            case "PH-06": {
                return "Rehiyon ng Kanlurang Bisaya (Philippines)";
            }
            case "PH-07": {
                return "Central Visayas (Philippines)";
            }
            case "PH-08": {
                return "Eastern Visayas (Philippines)";
            }
            case "PH-09": {
                return "Rehiyon ng Tangway ng Sambuwangga (Philippines)";
            }
            case "PH-10": {
                return "Northern Mindanao (Philippines)";
            }
            case "PH-11": {
                return "Davao (Philippines)";
            }
            case "PH-12": {
                return "Rehiyon ng Soccsksargen (Philippines)";
            }
            case "PH-13": {
                return "Caraga (Philippines)";
            }
            case "PH-14": {
                return "Autonomous Region in Muslim Mindanao (Philippines)";
            }
            case "PH-15": {
                return "Cordillera Administrative Region (Philippines)";
            }
            case "PH-40": {
                return "Calabarzon (Philippines)";
            }
            case "PH-41": {
                return "Mimaropa (Philippines)";
            }
            case "PH-ABR": {
                return "Abra (Philippines)";
            }
            case "PH-AGN": {
                return "Agusan del Norte (Philippines)";
            }
            case "PH-AGS": {
                return "Agusan del Sur (Philippines)";
            }
            case "PH-AKL": {
                return "Aklan (Philippines)";
            }
            case "PH-ALB": {
                return "Albay (Philippines)";
            }
            case "PH-ANT": {
                return "Antike (Philippines)";
            }
            case "PH-APA": {
                return "Apayao (Philippines)";
            }
            case "PH-AUR": {
                return "Aurora (Philippines)";
            }
            case "PH-BAN": {
                return "Bataan (Philippines)";
            }
            case "PH-BAS": {
                return "Basilan (Philippines)";
            }
            case "PH-BEN": {
                return "Benget (Philippines)";
            }
            case "PH-BIL": {
                return "Biliran (Philippines)";
            }
            case "PH-BOH": {
                return "Bohol (Philippines)";
            }
            case "PH-BTG": {
                return "Batangas (Philippines)";
            }
            case "PH-BTN": {
                return "Batanes (Philippines)";
            }
            case "PH-BUK": {
                return "Bukidnon (Philippines)";
            }
            case "PH-BUL": {
                return "Bulacan (Philippines)";
            }
            case "PH-CAG": {
                return "Cagayan (Philippines)";
            }
            case "PH-CAM": {
                return "Camiguin (Philippines)";
            }
            case "PH-CAN": {
                return "Camarines Norte (Philippines)";
            }
            case "PH-CAP": {
                return "Capiz (Philippines)";
            }
            case "PH-CAS": {
                return "Camarines Sur (Philippines)";
            }
            case "PH-CAT": {
                return "Catanduanes (Philippines)";
            }
            case "PH-CAV": {
                return "Cavite (Philippines)";
            }
            case "PH-CEB": {
                return "Cebu (Philippines)";
            }
            case "PH-COM": {
                return "Compostela Valley (Philippines)";
            }
            case "PH-DAO": {
                return "Davao Oriental (Philippines)";
            }
            case "PH-DAS": {
                return "Davao del Sur (Philippines)";
            }
            case "PH-DAV": {
                return "Davao del Norte (Philippines)";
            }
            case "PH-DIN": {
                return "Dinagat Islands (Philippines)";
            }
            case "PH-EAS": {
                return "Eastern Samar (Philippines)";
            }
            case "PH-GUI": {
                return "Gimaras (Philippines)";
            }
            case "PH-IFU": {
                return "Ifugao (Philippines)";
            }
            case "PH-ILI": {
                return "Iloilo (Philippines)";
            }
            case "PH-ILN": {
                return "Hilagang Iloko (Philippines)";
            }
            case "PH-ILS": {
                return "Ilocos Sur (Philippines)";
            }
            case "PH-ISA": {
                return "Isabela (Philippines)";
            }
            case "PH-KAL": {
                return "Kalinga (Philippines)";
            }
            case "PH-LAG": {
                return "Laguna (Philippines)";
            }
            case "PH-LAN": {
                return "Hilagang Lanaw (Philippines)";
            }
            case "PH-LAS": {
                return "Lanao del Sur (Philippines)";
            }
            case "PH-LEY": {
                return "Leyte (Philippines)";
            }
            case "PH-LUN": {
                return "La Union (Philippines)";
            }
            case "PH-MAD": {
                return "Marinduke (Philippines)";
            }
            case "PH-MAG": {
                return "Magindanaw (Philippines)";
            }
            case "PH-MAS": {
                return "Masbate (Philippines)";
            }
            case "PH-MDC": {
                return "Kanlurang Mindoro (Philippines)";
            }
            case "PH-MDR": {
                return "Mindoro Oriental (Philippines)";
            }
            case "PH-MOU": {
                return "Lalawigang Bulubundukin (Philippines)";
            }
            case "PH-MSC": {
                return "Kanlurang Misamis (Philippines)";
            }
            case "PH-MSR": {
                return "Misamis Oriental (Philippines)";
            }
            case "PH-NCO": {
                return "Cotabato (Philippines)";
            }
            case "PH-NEC": {
                return "Kanlurang Negros (Philippines)";
            }
            case "PH-NER": {
                return "Negros Oriental (Philippines)";
            }
            case "PH-NSA": {
                return "Hilagang Samar (Philippines)";
            }
            case "PH-NUE": {
                return "Nueva Ecija (Philippines)";
            }
            case "PH-NUV": {
                return "Nueva Vizcaya (Philippines)";
            }
            case "PH-PAM": {
                return "Pampanga (Philippines)";
            }
            case "PH-PAN": {
                return "Pangasinan (Philippines)";
            }
            case "PH-PLW": {
                return "Palawan (Philippines)";
            }
            case "PH-QUE": {
                return "Keson (Philippines)";
            }
            case "PH-QUI": {
                return "Kirino (Philippines)";
            }
            case "PH-RIZ": {
                return "Risal (Philippines)";
            }
            case "PH-ROM": {
                return "Romblon (Philippines)";
            }
            case "PH-SAR": {
                return "Sarangani (Philippines)";
            }
            case "PH-SCO": {
                return "South Cotabato (Philippines)";
            }
            case "PH-SIG": {
                return "Sikihor (Philippines)";
            }
            case "PH-SLE": {
                return "Katimogang Leyte (Philippines)";
            }
            case "PH-SLU": {
                return "Sulu (Philippines)";
            }
            case "PH-SOR": {
                return "Sorsogon (Philippines)";
            }
            case "PH-SUK": {
                return "Sultan Kudarat (Philippines)";
            }
            case "PH-SUN": {
                return "Hilagang Surigaw (Philippines)";
            }
            case "PH-SUR": {
                return "Surigao del Sur (Philippines)";
            }
            case "PH-TAR": {
                return "Tarlac (Philippines)";
            }
            case "PH-TAW": {
                return "Tawi-Tawi (Philippines)";
            }
            case "PH-WSA": {
                return "Samar (Philippines)";
            }
            case "PH-ZAN": {
                return "Hilagang Sambuwangga (Philippines)";
            }
            case "PH-ZAS": {
                return "Timog Sambuwangga (Philippines)";
            }
            case "PH-ZMB": {
                return "Sambales (Philippines)";
            }
            case "PH-ZSI": {
                return "Sambuwangga Sibugay (Philippines)";
            }
            case "PK-BA": {
                return "Balochistan (Pakistan)";
            }
            case "PK-GB": {
                return "Gilgit-Baltist\u0101n (Pakistan)";
            }
            case "PK-IS": {
                return "Isl\u0101m\u0101b\u0101d (Pakistan)";
            }
            case "PK-JK": {
                return "Azad Kashmir (Pakistan)";
            }
            case "PK-KP": {
                return "Kha\u012bbar Pakht\u016bnkhw\u0101 (Pakistan)";
            }
            case "PK-PB": {
                return "Panj\u0101b (Pakistan)";
            }
            case "PK-SD": {
                return "Sindh (Pakistan)";
            }
            case "PK-TA": {
                return "Federally Administered Tribal Areas (Pakistan)";
            }
            case "PL-DS": {
                return "Dolno\u015bl\u0105skie (Poland)";
            }
            case "PL-KP": {
                return "Kujawsko-pomorskie (Poland)";
            }
            case "PL-LB": {
                return "Lubuskie (Poland)";
            }
            case "PL-LD": {
                return "\u0141\u00f3dzkie (Poland)";
            }
            case "PL-LU": {
                return "Lubelskie (Poland)";
            }
            case "PL-MA": {
                return "Ma\u0142opolskie (Poland)";
            }
            case "PL-MZ": {
                return "Mazowieckie (Poland)";
            }
            case "PL-OP": {
                return "Opolskie (Poland)";
            }
            case "PL-PD": {
                return "Podlaskie (Poland)";
            }
            case "PL-PK": {
                return "Podkarpackie (Poland)";
            }
            case "PL-PM": {
                return "Pomorskie (Poland)";
            }
            case "PL-SK": {
                return "\u015awi\u0119tokrzyskie (Poland)";
            }
            case "PL-SL": {
                return "\u015al\u0105skie (Poland)";
            }
            case "PL-WN": {
                return "Warmi\u0144sko-mazurskie (Poland)";
            }
            case "PL-WP": {
                return "Wielkopolskie (Poland)";
            }
            case "PL-ZP": {
                return "Zachodniopomorskie (Poland)";
            }
            case "PM-PM": {
                return "St. Pierre & Miquelon (St. Pierre & Miquelon)";
            }
            case "PN-PN": {
                return "Pitcairn (Pitcairn)";
            }
            case "PR-PR": {
                return "Puerto Rico (Puerto Rico)";
            }
            case "PS-BTH": {
                return "Bayt La\u1e29m (Palestine)";
            }
            case "PS-DEB": {
                return "Dayr al Bala\u1e29 (Palestine)";
            }
            case "PS-GZA": {
                return "Gaza (Palestine)";
            }
            case "PS-HBN": {
                return "Al Khal\u012bl (Palestine)";
            }
            case "PS-JEM": {
                return "Al Quds (Palestine)";
            }
            case "PS-JEN": {
                return "Jan\u012bn (Palestine)";
            }
            case "PS-JRH": {
                return "Ar\u012b\u1e29\u0101 wa al Aghw\u0101r (Palestine)";
            }
            case "PS-KYS": {
                return "Khan Yunis (Palestine)";
            }
            case "PS-NBS": {
                return "Nablus (Palestine)";
            }
            case "PS-NGZ": {
                return "North Gaza (Palestine)";
            }
            case "PS-QQA": {
                return "Qalqilya (Palestine)";
            }
            case "PS-RBH": {
                return "Ramallah (Palestine)";
            }
            case "PS-RFH": {
                return "Rafah (Palestine)";
            }
            case "PS-SLT": {
                return "Salfit (Palestine)";
            }
            case "PS-TBS": {
                return "Tubas (Palestine)";
            }
            case "PS-TKM": {
                return "Tulkarm (Palestine)";
            }
            case "PT-01": {
                return "Aveiro (Portugal)";
            }
            case "PT-02": {
                return "Beja (Portugal)";
            }
            case "PT-03": {
                return "Braga (Portugal)";
            }
            case "PT-04": {
                return "Bragan\u00e7a (Portugal)";
            }
            case "PT-05": {
                return "Castelo Branco (Portugal)";
            }
            case "PT-06": {
                return "Coimbra (Portugal)";
            }
            case "PT-07": {
                return "\u00c9vora (Portugal)";
            }
            case "PT-08": {
                return "Faro (Portugal)";
            }
            case "PT-09": {
                return "Guarda (Portugal)";
            }
            case "PT-10": {
                return "Leiria (Portugal)";
            }
            case "PT-11": {
                return "Lisboa (Portugal)";
            }
            case "PT-12": {
                return "Portalegre (Portugal)";
            }
            case "PT-13": {
                return "Porto (Portugal)";
            }
            case "PT-14": {
                return "Santar\u00e9m (Portugal)";
            }
            case "PT-15": {
                return "Set\u00fabal (Portugal)";
            }
            case "PT-16": {
                return "Viana do Castelo (Portugal)";
            }
            case "PT-17": {
                return "Vila Real (Portugal)";
            }
            case "PT-18": {
                return "Viseu (Portugal)";
            }
            case "PT-20": {
                return "Regi\u00e3o Aut\u00f3noma dos A\u00e7ores (Portugal)";
            }
            case "PT-30": {
                return "Regi\u00e3o Aut\u00f3noma da Madeira (Portugal)";
            }
            case "PW-002": {
                return "Aimeliik (Palau)";
            }
            case "PW-004": {
                return "Airai (Palau)";
            }
            case "PW-010": {
                return "Angaur (Palau)";
            }
            case "PW-050": {
                return "Hatobohei (Palau)";
            }
            case "PW-100": {
                return "Kayangel (Palau)";
            }
            case "PW-150": {
                return "Koror (Palau)";
            }
            case "PW-212": {
                return "Melekeok (Palau)";
            }
            case "PW-214": {
                return "Ngaraard (Palau)";
            }
            case "PW-218": {
                return "Ngarchelong (Palau)";
            }
            case "PW-222": {
                return "Ngardmau (Palau)";
            }
            case "PW-224": {
                return "Ngatpang (Palau)";
            }
            case "PW-226": {
                return "Ngchesar (Palau)";
            }
            case "PW-227": {
                return "Ngeremlengui (Palau)";
            }
            case "PW-228": {
                return "Ngiwal (Palau)";
            }
            case "PW-350": {
                return "Peleliu (Palau)";
            }
            case "PW-370": {
                return "Sonsorol (Palau)";
            }
            case "PY-1": {
                return "Concepci\u00f3n (Paraguay)";
            }
            case "PY-10": {
                return "Alto Paran\u00e1 (Paraguay)";
            }
            case "PY-11": {
                return "Central (Paraguay)";
            }
            case "PY-12": {
                return "\u00d1eembuc\u00fa (Paraguay)";
            }
            case "PY-13": {
                return "Amambay (Paraguay)";
            }
            case "PY-14": {
                return "Canindey\u00fa (Paraguay)";
            }
            case "PY-15": {
                return "Presidente Hayes (Paraguay)";
            }
            case "PY-16": {
                return "Alto Paraguay (Paraguay)";
            }
            case "PY-19": {
                return "Boquer\u00f3n (Paraguay)";
            }
            case "PY-2": {
                return "San Pedro (Paraguay)";
            }
            case "PY-3": {
                return "Cordillera (Paraguay)";
            }
            case "PY-4": {
                return "Guair\u00e1 (Paraguay)";
            }
            case "PY-5": {
                return "Caaguaz\u00fa (Paraguay)";
            }
            case "PY-6": {
                return "Caazap\u00e1 (Paraguay)";
            }
            case "PY-7": {
                return "Itap\u00faa (Paraguay)";
            }
            case "PY-8": {
                return "Misiones (Paraguay)";
            }
            case "PY-9": {
                return "Paraguar\u00ed (Paraguay)";
            }
            case "PY-ASU": {
                return "Asunci\u00f3n (Paraguay)";
            }
            case "QA-DA": {
                return "Ad Daw\u1e29ah (Qatar)";
            }
            case "QA-KH": {
                return "Al Khawr wa adh Dhakh\u012brah (Qatar)";
            }
            case "QA-MS": {
                return "Ash Sham\u0101l (Qatar)";
            }
            case "QA-RA": {
                return "Ar Rayy\u0101n (Qatar)";
            }
            case "QA-US": {
                return "Umm \u015eal\u0101l (Qatar)";
            }
            case "QA-WA": {
                return "Al Wakrah (Qatar)";
            }
            case "QA-ZA": {
                return "Az\u0327 Z\u0327a\u2018\u0101yin (Qatar)";
            }
            case "RE-RE": {
                return "Reunion (Reunion)";
            }
            case "RO-AB": {
                return "Alba (Romania)";
            }
            case "RO-AG": {
                return "Arge\u015f (Romania)";
            }
            case "RO-AR": {
                return "Arad (Romania)";
            }
            case "RO-B": {
                return "Bucure\u015fti (Romania)";
            }
            case "RO-BC": {
                return "Bac\u0103u (Romania)";
            }
            case "RO-BH": {
                return "Bihor (Romania)";
            }
            case "RO-BN": {
                return "Bistri\u0163a-N\u0103s\u0103ud (Romania)";
            }
            case "RO-BR": {
                return "Br\u0103ila (Romania)";
            }
            case "RO-BT": {
                return "Boto\u015fani (Romania)";
            }
            case "RO-BV": {
                return "Bra\u015fov (Romania)";
            }
            case "RO-BZ": {
                return "Buz\u0103u (Romania)";
            }
            case "RO-CJ": {
                return "Cluj (Romania)";
            }
            case "RO-CL": {
                return "C\u0103l\u0103ra\u015fi (Romania)";
            }
            case "RO-CS": {
                return "Cara\u015f-Severin (Romania)";
            }
            case "RO-CT": {
                return "Constan\u0163a (Romania)";
            }
            case "RO-CV": {
                return "Covasna (Romania)";
            }
            case "RO-DB": {
                return "D\u00e2mbovi\u0163a (Romania)";
            }
            case "RO-DJ": {
                return "Dolj (Romania)";
            }
            case "RO-GJ": {
                return "Gorj (Romania)";
            }
            case "RO-GL": {
                return "Gala\u0163i (Romania)";
            }
            case "RO-GR": {
                return "Giurgiu (Romania)";
            }
            case "RO-HD": {
                return "Hunedoara (Romania)";
            }
            case "RO-HR": {
                return "Harghita (Romania)";
            }
            case "RO-IF": {
                return "Ilfov (Romania)";
            }
            case "RO-IL": {
                return "Ialomi\u0163a (Romania)";
            }
            case "RO-IS": {
                return "Ia\u015fi (Romania)";
            }
            case "RO-MH": {
                return "Mehedin\u0163i (Romania)";
            }
            case "RO-MM": {
                return "Maramure\u015f (Romania)";
            }
            case "RO-MS": {
                return "Mure\u015f (Romania)";
            }
            case "RO-NT": {
                return "Neam\u0163 (Romania)";
            }
            case "RO-OT": {
                return "Olt (Romania)";
            }
            case "RO-PH": {
                return "Prahova (Romania)";
            }
            case "RO-SB": {
                return "Sibiu (Romania)";
            }
            case "RO-SJ": {
                return "S\u0103laj (Romania)";
            }
            case "RO-SM": {
                return "Satu Mare (Romania)";
            }
            case "RO-SV": {
                return "Suceava (Romania)";
            }
            case "RO-TL": {
                return "Tulcea (Romania)";
            }
            case "RO-TM": {
                return "Timi\u015f (Romania)";
            }
            case "RO-TR": {
                return "Teleorman (Romania)";
            }
            case "RO-VL": {
                return "V\u00e2lcea (Romania)";
            }
            case "RO-VN": {
                return "Vrancea (Romania)";
            }
            case "RO-VS": {
                return "Vaslui (Romania)";
            }
            case "RS-00": {
                return "Beograd (Serbia)";
            }
            case "RS-01": {
                return "Severnoba\u010dki okrug (Serbia)";
            }
            case "RS-02": {
                return "Srednjebanatski okrug (Serbia)";
            }
            case "RS-03": {
                return "Severnobanatski okrug (Serbia)";
            }
            case "RS-04": {
                return "Ju\u017enobanatski okrug (Serbia)";
            }
            case "RS-05": {
                return "Zapadnoba\u010dki okrug (Serbia)";
            }
            case "RS-06": {
                return "Ju\u017enoba\u010dki okrug (Serbia)";
            }
            case "RS-07": {
                return "Sremski okrug (Serbia)";
            }
            case "RS-08": {
                return "Ma\u010dvanski okrug (Serbia)";
            }
            case "RS-09": {
                return "Kolubarski okrug (Serbia)";
            }
            case "RS-10": {
                return "Podunavski okrug (Serbia)";
            }
            case "RS-11": {
                return "Brani\u010devski okrug (Serbia)";
            }
            case "RS-12": {
                return "\u0160umadijski okrug (Serbia)";
            }
            case "RS-13": {
                return "Pomoravski okrug (Serbia)";
            }
            case "RS-14": {
                return "Borski okrug (Serbia)";
            }
            case "RS-15": {
                return "Zaje\u010darski okrug (Serbia)";
            }
            case "RS-16": {
                return "Zlatiborski okrug (Serbia)";
            }
            case "RS-17": {
                return "Moravi\u010dki okrug (Serbia)";
            }
            case "RS-18": {
                return "Ra\u0161ki okrug (Serbia)";
            }
            case "RS-19": {
                return "Rasinski okrug (Serbia)";
            }
            case "RS-20": {
                return "Ni\u0161avski okrug (Serbia)";
            }
            case "RS-21": {
                return "Topli\u010dki okrug (Serbia)";
            }
            case "RS-22": {
                return "Pirotski okrug (Serbia)";
            }
            case "RS-23": {
                return "Jablani\u010dki okrug (Serbia)";
            }
            case "RS-24": {
                return "P\u010dinjski okrug (Serbia)";
            }
            case "RS-25": {
                return "Kosovski okrug (Serbia)";
            }
            case "RS-26": {
                return "Pe\u0107ki okrug (Serbia)";
            }
            case "RS-27": {
                return "Prizrenski okrug (Serbia)";
            }
            case "RS-28": {
                return "Kosovsko-Mitrova\u010dki okrug (Serbia)";
            }
            case "RS-29": {
                return "Kosovsko-Pomoravski okrug (Serbia)";
            }
            case "RS-KM": {
                return "Kosovo-Metohija (Serbia)";
            }
            case "RS-VO": {
                return "Vojvodina (Serbia)";
            }
            case "RU-AD": {
                return "Adygeja, Respublika (Russia)";
            }
            case "RU-AL": {
                return "Altaj, Respublika (Russia)";
            }
            case "RU-ALT": {
                return "Altajskij kraj (Russia)";
            }
            case "RU-AMU": {
                return "Amurskaja oblast' (Russia)";
            }
            case "RU-ARK": {
                return "Arhangel'skaja oblast' (Russia)";
            }
            case "RU-AST": {
                return "Astrahanskaja oblast' (Russia)";
            }
            case "RU-BA": {
                return "Bashkortostan, Respublika (Russia)";
            }
            case "RU-BEL": {
                return "Belgorodskaja oblast' (Russia)";
            }
            case "RU-BRY": {
                return "Brjanskaja oblast' (Russia)";
            }
            case "RU-BU": {
                return "Burjatija, Respublika (Russia)";
            }
            case "RU-CE": {
                return "\u010ce\u010denskaja Respublika (Russia)";
            }
            case "RU-CHE": {
                return "\u010celjabinskaja oblast' (Russia)";
            }
            case "RU-CHU": {
                return "Chukotskiy avtonomnyy okrug (Russia)";
            }
            case "RU-CU": {
                return "Chuvashskaya Respublika (Russia)";
            }
            case "RU-DA": {
                return "Dagestan, Respublika (Russia)";
            }
            case "RU-IN": {
                return "Ingu\u0161etija, Respublika (Russia)";
            }
            case "RU-IRK": {
                return "Irkutskaja oblast' (Russia)";
            }
            case "RU-IVA": {
                return "Ivanovskaja oblast' (Russia)";
            }
            case "RU-KAM": {
                return "Kam\u010datskij kraj (Russia)";
            }
            case "RU-KB": {
                return "Kabardino-Balkarskaja Respublika (Russia)";
            }
            case "RU-KC": {
                return "Kara\u010daevo-\u010cerkesskaja Respublika (Russia)";
            }
            case "RU-KDA": {
                return "Krasnodarskij kraj (Russia)";
            }
            case "RU-KEM": {
                return "Kemerovskaja oblast' (Russia)";
            }
            case "RU-KGD": {
                return "Kaliningradskaja oblast' (Russia)";
            }
            case "RU-KGN": {
                return "Kurganskaja oblast' (Russia)";
            }
            case "RU-KHA": {
                return "Habarovskij kraj (Russia)";
            }
            case "RU-KHM": {
                return "Hanty-Mansijskij avtonomnyj okrug (Russia)";
            }
            case "RU-KIR": {
                return "Kirovskaja oblast' (Russia)";
            }
            case "RU-KK": {
                return "Hakasija, Respublika (Russia)";
            }
            case "RU-KL": {
                return "Kalmykija, Respublika (Russia)";
            }
            case "RU-KLU": {
                return "Kaluzhskaya oblast' (Russia)";
            }
            case "RU-KO": {
                return "Komi, Respublika (Russia)";
            }
            case "RU-KOS": {
                return "Kostromskaja oblast' (Russia)";
            }
            case "RU-KR": {
                return "Karelija, Respublika (Russia)";
            }
            case "RU-KRS": {
                return "Kurskaja oblast' (Russia)";
            }
            case "RU-KYA": {
                return "Krasnojarskij kraj (Russia)";
            }
            case "RU-LEN": {
                return "Leningradskaja oblast' (Russia)";
            }
            case "RU-LIP": {
                return "Lipeckaja oblast' (Russia)";
            }
            case "RU-MAG": {
                return "Magadanskaja oblast' (Russia)";
            }
            case "RU-ME": {
                return "Marij \u00c8l, Respublika (Russia)";
            }
            case "RU-MO": {
                return "Mordovija, Respublika (Russia)";
            }
            case "RU-MOS": {
                return "Moskovskaja oblast' (Russia)";
            }
            case "RU-MOW": {
                return "Moskva (Russia)";
            }
            case "RU-MUR": {
                return "Murmanskaja oblast' (Russia)";
            }
            case "RU-NEN": {
                return "Neneckij avtonomnyj okrug (Russia)";
            }
            case "RU-NGR": {
                return "Novgorodskaja oblast' (Russia)";
            }
            case "RU-NIZ": {
                return "Ni\u017eegorodskaja oblast' (Russia)";
            }
            case "RU-NVS": {
                return "Novosibirskaja oblast' (Russia)";
            }
            case "RU-OMS": {
                return "Omskaja oblast' (Russia)";
            }
            case "RU-ORE": {
                return "Orenburgskaja oblast' (Russia)";
            }
            case "RU-ORL": {
                return "Orlovskaja oblast' (Russia)";
            }
            case "RU-PER": {
                return "Permskij kraj (Russia)";
            }
            case "RU-PNZ": {
                return "Penzenskaja oblast' (Russia)";
            }
            case "RU-PRI": {
                return "Primorskij kraj (Russia)";
            }
            case "RU-PSK": {
                return "Pskovskaja oblast' (Russia)";
            }
            case "RU-ROS": {
                return "Rostovskaja oblast' (Russia)";
            }
            case "RU-RYA": {
                return "Rjazanskaja oblast' (Russia)";
            }
            case "RU-SA": {
                return "Saha, Respublika (Russia)";
            }
            case "RU-SAK": {
                return "Sahalinskaja oblast' (Russia)";
            }
            case "RU-SAM": {
                return "Samarskaja oblast' (Russia)";
            }
            case "RU-SAR": {
                return "Saratovskaja oblast' (Russia)";
            }
            case "RU-SE": {
                return "Severnaja Osetija, Respublika (Russia)";
            }
            case "RU-SMO": {
                return "Smolenskaja oblast' (Russia)";
            }
            case "RU-SPE": {
                return "Sankt-Peterburg (Russia)";
            }
            case "RU-STA": {
                return "Stavropol'skij kraj (Russia)";
            }
            case "RU-SVE": {
                return "Sverdlovskaja oblast' (Russia)";
            }
            case "RU-TA": {
                return "Tatarstan, Respublika (Russia)";
            }
            case "RU-TAM": {
                return "Tambovskaja oblast' (Russia)";
            }
            case "RU-TOM": {
                return "Tomskaja oblast' (Russia)";
            }
            case "RU-TUL": {
                return "Tul'skaja oblast' (Russia)";
            }
            case "RU-TVE": {
                return "Tverskaja oblast' (Russia)";
            }
            case "RU-TY": {
                return "Tyva, Respublika (Russia)";
            }
            case "RU-TYU": {
                return "Tjumenskaja oblast' (Russia)";
            }
            case "RU-UD": {
                return "Udmurtskaja Respublika (Russia)";
            }
            case "RU-ULY": {
                return "Ul'janovskaja oblast' (Russia)";
            }
            case "RU-VGG": {
                return "Volgogradskaja oblast' (Russia)";
            }
            case "RU-VLA": {
                return "Vladimirskaja oblast' (Russia)";
            }
            case "RU-VLG": {
                return "Vologodskaja oblast' (Russia)";
            }
            case "RU-VOR": {
                return "Voronezhskaya oblast' (Russia)";
            }
            case "RU-YAN": {
                return "Jamalo-Neneckij avtonomnyj okrug (Russia)";
            }
            case "RU-YAR": {
                return "Jaroslavskaja oblast' (Russia)";
            }
            case "RU-YEV": {
                return "Evrejskaja avtonomnaja oblast' (Russia)";
            }
            case "RU-ZAB": {
                return "Zabajkal'skij kraj (Russia)";
            }
            case "RW-01": {
                return "Ville de Kigal (Rwanda)";
            }
            case "RW-02": {
                return "Est (Rwanda)";
            }
            case "RW-03": {
                return "Nord (Rwanda)";
            }
            case "RW-04": {
                return "Ouest (Rwanda)";
            }
            case "RW-05": {
                return "Sud (Rwanda)";
            }
        }
        return "Unknown state code '" + c.getCode() + "'";
    }

    private static String stateSZ(Coding c) {
        switch (c.getCode()) {
            case "SA-01": {
                return "Ar Riy\u0101\u1e11 (Saudi Arabia)";
            }
            case "SA-02": {
                return "Makkah al Mukarramah (Saudi Arabia)";
            }
            case "SA-03": {
                return "Al Mad\u012bnah al Munawwarah (Saudi Arabia)";
            }
            case "SA-04": {
                return "Ash Sharq\u012byah (Saudi Arabia)";
            }
            case "SA-05": {
                return "Al Qa\u015f\u012bm (Saudi Arabia)";
            }
            case "SA-06": {
                return "\u1e28\u0101'il (Saudi Arabia)";
            }
            case "SA-07": {
                return "Tab\u016bk (Saudi Arabia)";
            }
            case "SA-08": {
                return "Al \u1e28ud\u016bd ash Sham\u0101l\u012byah (Saudi Arabia)";
            }
            case "SA-09": {
                return "J\u0101z\u0101n (Saudi Arabia)";
            }
            case "SA-10": {
                return "Najr\u0101n (Saudi Arabia)";
            }
            case "SA-11": {
                return "Al B\u0101\u1e29ah (Saudi Arabia)";
            }
            case "SA-12": {
                return "Al Jawf (Saudi Arabia)";
            }
            case "SA-14": {
                return "'As\u012br (Saudi Arabia)";
            }
            case "SB-CE": {
                return "Central (Solomon Islands)";
            }
            case "SB-CH": {
                return "Choiseul (Solomon Islands)";
            }
            case "SB-CT": {
                return "Capital Territory (Solomon Islands)";
            }
            case "SB-GU": {
                return "Guadalcanal (Solomon Islands)";
            }
            case "SB-IS": {
                return "Isabel (Solomon Islands)";
            }
            case "SB-MK": {
                return "Makira-Ulawa (Solomon Islands)";
            }
            case "SB-ML": {
                return "Malaita (Solomon Islands)";
            }
            case "SB-RB": {
                return "Rennell and Bellona (Solomon Islands)";
            }
            case "SB-TE": {
                return "Temotu (Solomon Islands)";
            }
            case "SB-WE": {
                return "Western (Solomon Islands)";
            }
            case "SC-01": {
                return "Anse aux Pins (Seychelles)";
            }
            case "SC-02": {
                return "Ans Bwalo (Seychelles)";
            }
            case "SC-03": {
                return "Anse Etoile (Seychelles)";
            }
            case "SC-04": {
                return "Au Cap (Seychelles)";
            }
            case "SC-05": {
                return "Anse Royale (Seychelles)";
            }
            case "SC-06": {
                return "Baie Lazare (Seychelles)";
            }
            case "SC-07": {
                return "Baie Sainte-Anne (Seychelles)";
            }
            case "SC-08": {
                return "Beau Vallon (Seychelles)";
            }
            case "SC-09": {
                return "Bel Air (Seychelles)";
            }
            case "SC-10": {
                return "Bel Ombre (Seychelles)";
            }
            case "SC-11": {
                return "Cascade (Seychelles)";
            }
            case "SC-12": {
                return "Glacis (Seychelles)";
            }
            case "SC-13": {
                return "Grand'Anse Mah\u00e9 (Seychelles)";
            }
            case "SC-14": {
                return "Grand'Anse Praslin (Seychelles)";
            }
            case "SC-15": {
                return "Ladig (Seychelles)";
            }
            case "SC-16": {
                return "English River (Seychelles)";
            }
            case "SC-17": {
                return "Mon Bikston (Seychelles)";
            }
            case "SC-18": {
                return "Mon Fleri (Seychelles)";
            }
            case "SC-19": {
                return "Plaisance (Seychelles)";
            }
            case "SC-20": {
                return "Pointe La Rue (Seychelles)";
            }
            case "SC-21": {
                return "Porglo (Seychelles)";
            }
            case "SC-22": {
                return "Saint Louis (Seychelles)";
            }
            case "SC-23": {
                return "Takamaka (Seychelles)";
            }
            case "SC-24": {
                return "Lemamel (Seychelles)";
            }
            case "SC-25": {
                return "Roche Ca\u00efman (Seychelles)";
            }
            case "SD-DC": {
                return "Central Darfur (Sudan)";
            }
            case "SD-DE": {
                return "East Darfur (Sudan)";
            }
            case "SD-DN": {
                return "North Darfur (Sudan)";
            }
            case "SD-DS": {
                return "Jan\u016bb D\u0101rf\u016br (Sudan)";
            }
            case "SD-DW": {
                return "Gharb D\u0101rf\u016br (Sudan)";
            }
            case "SD-GD": {
                return "Al Qa\u1e11\u0101rif (Sudan)";
            }
            case "SD-GZ": {
                return "Al Jaz\u012brah (Sudan)";
            }
            case "SD-KA": {
                return "Kassala (Sudan)";
            }
            case "SD-KH": {
                return "Al Khar\u0163\u016bm (Sudan)";
            }
            case "SD-KN": {
                return "North Kordofan (Sudan)";
            }
            case "SD-KS": {
                return "Jan\u016bb Kurduf\u0101n (Sudan)";
            }
            case "SD-NB": {
                return "An N\u012bl al Azraq (Sudan)";
            }
            case "SD-NO": {
                return "Ash Sham\u0101l\u012byah (Sudan)";
            }
            case "SD-NR": {
                return "An N\u012bl (Sudan)";
            }
            case "SD-NW": {
                return "An N\u012bl al Abya\u1e11 (Sudan)";
            }
            case "SD-RS": {
                return "Al Ba\u1e29r al A\u1e29mar (Sudan)";
            }
            case "SD-SI": {
                return "Sennar (Sudan)";
            }
            case "SE-AB": {
                return "Stockholms l\u00e4n (Sweden)";
            }
            case "SE-AC": {
                return "V\u00e4sterbottens l\u00e4n (Sweden)";
            }
            case "SE-BD": {
                return "Norrbottens l\u00e4n (Sweden)";
            }
            case "SE-C": {
                return "Uppsala l\u00e4n (Sweden)";
            }
            case "SE-D": {
                return "S\u00f6dermanlands l\u00e4n (Sweden)";
            }
            case "SE-E": {
                return "\u00d6sterg\u00f6tlands l\u00e4n (Sweden)";
            }
            case "SE-F": {
                return "J\u00f6nk\u00f6pings l\u00e4n (Sweden)";
            }
            case "SE-G": {
                return "Kronobergs l\u00e4n (Sweden)";
            }
            case "SE-H": {
                return "Kalmar l\u00e4n (Sweden)";
            }
            case "SE-I": {
                return "Gotlands l\u00e4n (Sweden)";
            }
            case "SE-K": {
                return "Blekinge l\u00e4n (Sweden)";
            }
            case "SE-M": {
                return "Sk\u00e5ne l\u00e4n (Sweden)";
            }
            case "SE-N": {
                return "Hallands l\u00e4n (Sweden)";
            }
            case "SE-O": {
                return "V\u00e4stra G\u00f6talands l\u00e4n (Sweden)";
            }
            case "SE-S": {
                return "V\u00e4rmlands l\u00e4n (Sweden)";
            }
            case "SE-T": {
                return "\u00d6rebro l\u00e4n (Sweden)";
            }
            case "SE-U": {
                return "V\u00e4stmanlands l\u00e4n (Sweden)";
            }
            case "SE-W": {
                return "Dalarnas l\u00e4n (Sweden)";
            }
            case "SE-X": {
                return "G\u00e4vleborgs l\u00e4n (Sweden)";
            }
            case "SE-Y": {
                return "V\u00e4sternorrlands l\u00e4n (Sweden)";
            }
            case "SE-Z": {
                return "J\u00e4mtlands l\u00e4n (Sweden)";
            }
            case "SG-01": {
                return "Central Singapore (Singapore)";
            }
            case "SG-02": {
                return "North East (Singapore)";
            }
            case "SG-03": {
                return "North West (Singapore)";
            }
            case "SG-04": {
                return "South East (Singapore)";
            }
            case "SG-05": {
                return "South West (Singapore)";
            }
            case "SH-AC": {
                return "Ascension (Saint Helena, Ascension and Tristan Da Cunha)";
            }
            case "SH-HL": {
                return "Saint Helena (Saint Helena, Ascension and Tristan Da Cunha)";
            }
            case "SH-TA": {
                return "Tristan da Cunha (Saint Helena, Ascension and Tristan Da Cunha)";
            }
            case "SI-001": {
                return "Ajdov\u0161\u010dina (Slovenia)";
            }
            case "SI-002": {
                return "Beltinci (Slovenia)";
            }
            case "SI-003": {
                return "Bled (Slovenia)";
            }
            case "SI-004": {
                return "Bohinj (Slovenia)";
            }
            case "SI-005": {
                return "Borovnica (Slovenia)";
            }
            case "SI-006": {
                return "Bovec (Slovenia)";
            }
            case "SI-007": {
                return "Brda (Slovenia)";
            }
            case "SI-008": {
                return "Brezovica (Slovenia)";
            }
            case "SI-009": {
                return "Bre\u017eice (Slovenia)";
            }
            case "SI-010": {
                return "Ti\u0161ina (Slovenia)";
            }
            case "SI-011": {
                return "Celje (Slovenia)";
            }
            case "SI-012": {
                return "Cerklje na Gorenjskem (Slovenia)";
            }
            case "SI-013": {
                return "Cerknica (Slovenia)";
            }
            case "SI-014": {
                return "Cerkno (Slovenia)";
            }
            case "SI-015": {
                return "\u010cren\u0161ovci (Slovenia)";
            }
            case "SI-016": {
                return "\u010crna na Koro\u0161kem (Slovenia)";
            }
            case "SI-017": {
                return "\u010crnomelj (Slovenia)";
            }
            case "SI-018": {
                return "Destrnik (Slovenia)";
            }
            case "SI-019": {
                return "Diva\u010da (Slovenia)";
            }
            case "SI-020": {
                return "Dobrepolje (Slovenia)";
            }
            case "SI-021": {
                return "Dobrova-Polhov Gradec (Slovenia)";
            }
            case "SI-022": {
                return "Dol pri Ljubljani (Slovenia)";
            }
            case "SI-023": {
                return "Dom\u017eale (Slovenia)";
            }
            case "SI-024": {
                return "Dornava (Slovenia)";
            }
            case "SI-025": {
                return "Dravograd (Slovenia)";
            }
            case "SI-026": {
                return "Duplek (Slovenia)";
            }
            case "SI-027": {
                return "Gorenja vas-Poljane (Slovenia)";
            }
            case "SI-028": {
                return "Gori\u0161nica (Slovenia)";
            }
            case "SI-029": {
                return "Gornja Radgona (Slovenia)";
            }
            case "SI-030": {
                return "Gornji Grad (Slovenia)";
            }
            case "SI-031": {
                return "Gornji Petrovci (Slovenia)";
            }
            case "SI-032": {
                return "Grosuplje (Slovenia)";
            }
            case "SI-033": {
                return "\u0160alovci (Slovenia)";
            }
            case "SI-034": {
                return "Hrastnik (Slovenia)";
            }
            case "SI-035": {
                return "Hrpelje-Kozina (Slovenia)";
            }
            case "SI-036": {
                return "Idrija (Slovenia)";
            }
            case "SI-037": {
                return "Ig (Slovenia)";
            }
            case "SI-038": {
                return "Ilirska Bistrica (Slovenia)";
            }
            case "SI-039": {
                return "Ivan\u010dna Gorica (Slovenia)";
            }
            case "SI-040": {
                return "Izola (Slovenia)";
            }
            case "SI-041": {
                return "Jesenice (Slovenia)";
            }
            case "SI-042": {
                return "Jur\u0161inci (Slovenia)";
            }
            case "SI-043": {
                return "Kamnik (Slovenia)";
            }
            case "SI-044": {
                return "Kanal (Slovenia)";
            }
            case "SI-045": {
                return "Kidri\u010devo (Slovenia)";
            }
            case "SI-046": {
                return "Kobarid (Slovenia)";
            }
            case "SI-047": {
                return "Kobilje (Slovenia)";
            }
            case "SI-048": {
                return "Ko\u010devje (Slovenia)";
            }
            case "SI-049": {
                return "Komen (Slovenia)";
            }
            case "SI-050": {
                return "Koper (Slovenia)";
            }
            case "SI-051": {
                return "Kozje (Slovenia)";
            }
            case "SI-052": {
                return "Kranj (Slovenia)";
            }
            case "SI-053": {
                return "Kranjska Gora (Slovenia)";
            }
            case "SI-054": {
                return "Kr\u0161ko (Slovenia)";
            }
            case "SI-055": {
                return "Kungota (Slovenia)";
            }
            case "SI-056": {
                return "Kuzma (Slovenia)";
            }
            case "SI-057": {
                return "La\u0161ko (Slovenia)";
            }
            case "SI-058": {
                return "Lenart (Slovenia)";
            }
            case "SI-059": {
                return "Lendava (Slovenia)";
            }
            case "SI-060": {
                return "Litija (Slovenia)";
            }
            case "SI-061": {
                return "Ljubljana (Slovenia)";
            }
            case "SI-062": {
                return "Ljubno (Slovenia)";
            }
            case "SI-063": {
                return "Ljutomer (Slovenia)";
            }
            case "SI-064": {
                return "Logatec (Slovenia)";
            }
            case "SI-065": {
                return "Lo\u0161ka Dolina (Slovenia)";
            }
            case "SI-066": {
                return "Lo\u0161ki Potok (Slovenia)";
            }
            case "SI-067": {
                return "Lu\u010de (Slovenia)";
            }
            case "SI-068": {
                return "Lukovica (Slovenia)";
            }
            case "SI-069": {
                return "Maj\u0161perk (Slovenia)";
            }
            case "SI-070": {
                return "Maribor (Slovenia)";
            }
            case "SI-071": {
                return "Medvode (Slovenia)";
            }
            case "SI-072": {
                return "Menge\u0161 (Slovenia)";
            }
            case "SI-073": {
                return "Metlika (Slovenia)";
            }
            case "SI-074": {
                return "Me\u017eica (Slovenia)";
            }
            case "SI-075": {
                return "Miren-Kostanjevica (Slovenia)";
            }
            case "SI-076": {
                return "Mislinja (Slovenia)";
            }
            case "SI-077": {
                return "Morav\u010de (Slovenia)";
            }
            case "SI-078": {
                return "Moravske Toplice (Slovenia)";
            }
            case "SI-079": {
                return "Mozirje (Slovenia)";
            }
            case "SI-080": {
                return "Murska Sobota (Slovenia)";
            }
            case "SI-081": {
                return "Muta (Slovenia)";
            }
            case "SI-082": {
                return "Naklo (Slovenia)";
            }
            case "SI-083": {
                return "Nazarje (Slovenia)";
            }
            case "SI-084": {
                return "Nova Gorica (Slovenia)";
            }
            case "SI-085": {
                return "Novo Mesto (Slovenia)";
            }
            case "SI-086": {
                return "Odranci (Slovenia)";
            }
            case "SI-087": {
                return "Ormo\u017e (Slovenia)";
            }
            case "SI-088": {
                return "Osilnica (Slovenia)";
            }
            case "SI-089": {
                return "Pesnica (Slovenia)";
            }
            case "SI-090": {
                return "Piran (Slovenia)";
            }
            case "SI-091": {
                return "Pivka (Slovenia)";
            }
            case "SI-092": {
                return "Pod\u010detrtek (Slovenia)";
            }
            case "SI-093": {
                return "Podvelka (Slovenia)";
            }
            case "SI-094": {
                return "Postojna (Slovenia)";
            }
            case "SI-095": {
                return "Preddvor (Slovenia)";
            }
            case "SI-096": {
                return "Ptuj (Slovenia)";
            }
            case "SI-097": {
                return "Puconci (Slovenia)";
            }
            case "SI-098": {
                return "Ra\u010de-Fram (Slovenia)";
            }
            case "SI-099": {
                return "Rade\u010de (Slovenia)";
            }
            case "SI-100": {
                return "Radenci (Slovenia)";
            }
            case "SI-101": {
                return "Radlje ob Dravi (Slovenia)";
            }
            case "SI-102": {
                return "Radovljica (Slovenia)";
            }
            case "SI-103": {
                return "Ravne na Koro\u0161kem (Slovenia)";
            }
            case "SI-104": {
                return "Ribnica (Slovenia)";
            }
            case "SI-105": {
                return "Roga\u0161ovci (Slovenia)";
            }
            case "SI-106": {
                return "Roga\u0161ka Slatina (Slovenia)";
            }
            case "SI-107": {
                return "Rogatec (Slovenia)";
            }
            case "SI-108": {
                return "Ru\u0161e (Slovenia)";
            }
            case "SI-109": {
                return "Semi\u010d (Slovenia)";
            }
            case "SI-110": {
                return "Sevnica (Slovenia)";
            }
            case "SI-111": {
                return "Se\u017eana (Slovenia)";
            }
            case "SI-112": {
                return "Slovenj Gradec (Slovenia)";
            }
            case "SI-113": {
                return "Slovenska Bistrica (Slovenia)";
            }
            case "SI-114": {
                return "Slovenske Konjice (Slovenia)";
            }
            case "SI-115": {
                return "Star\u0161e (Slovenia)";
            }
            case "SI-116": {
                return "Sveti Jurij (Slovenia)";
            }
            case "SI-117": {
                return "\u0160en\u010dur (Slovenia)";
            }
            case "SI-118": {
                return "\u0160entilj (Slovenia)";
            }
            case "SI-119": {
                return "\u0160entjernej (Slovenia)";
            }
            case "SI-120": {
                return "\u0160entjur (Slovenia)";
            }
            case "SI-121": {
                return "\u0160kocjan (Slovenia)";
            }
            case "SI-122": {
                return "\u0160kofja Loka (Slovenia)";
            }
            case "SI-123": {
                return "\u0160kofljica (Slovenia)";
            }
            case "SI-124": {
                return "\u0160marje pri Jel\u0161ah (Slovenia)";
            }
            case "SI-125": {
                return "\u0160martno ob Paki (Slovenia)";
            }
            case "SI-126": {
                return "\u0160o\u0161tanj (Slovenia)";
            }
            case "SI-127": {
                return "\u0160tore (Slovenia)";
            }
            case "SI-128": {
                return "Tolmin (Slovenia)";
            }
            case "SI-129": {
                return "Trbovlje (Slovenia)";
            }
            case "SI-130": {
                return "Trebnje (Slovenia)";
            }
            case "SI-131": {
                return "Tr\u017ei\u010d (Slovenia)";
            }
            case "SI-132": {
                return "Turni\u0161\u010de (Slovenia)";
            }
            case "SI-133": {
                return "Velenje (Slovenia)";
            }
            case "SI-134": {
                return "Velike La\u0161\u010de (Slovenia)";
            }
            case "SI-135": {
                return "Videm (Slovenia)";
            }
            case "SI-136": {
                return "Vipava (Slovenia)";
            }
            case "SI-137": {
                return "Vitanje (Slovenia)";
            }
            case "SI-138": {
                return "Vodice (Slovenia)";
            }
            case "SI-139": {
                return "Vojnik (Slovenia)";
            }
            case "SI-140": {
                return "Vrhnika (Slovenia)";
            }
            case "SI-141": {
                return "Vuzenica (Slovenia)";
            }
            case "SI-142": {
                return "Zagorje ob Savi (Slovenia)";
            }
            case "SI-143": {
                return "Zavr\u010d (Slovenia)";
            }
            case "SI-144": {
                return "Zre\u010de (Slovenia)";
            }
            case "SI-146": {
                return "\u017delezniki (Slovenia)";
            }
            case "SI-147": {
                return "\u017diri (Slovenia)";
            }
            case "SI-148": {
                return "Benedikt (Slovenia)";
            }
            case "SI-149": {
                return "Bistrica ob Sotli (Slovenia)";
            }
            case "SI-150": {
                return "Bloke (Slovenia)";
            }
            case "SI-151": {
                return "Braslov\u010de (Slovenia)";
            }
            case "SI-152": {
                return "Cankova (Slovenia)";
            }
            case "SI-153": {
                return "Cerkvenjak (Slovenia)";
            }
            case "SI-154": {
                return "Dobje (Slovenia)";
            }
            case "SI-155": {
                return "Dobrna (Slovenia)";
            }
            case "SI-156": {
                return "Dobrovnik (Slovenia)";
            }
            case "SI-157": {
                return "Dolenjske Toplice (Slovenia)";
            }
            case "SI-158": {
                return "Grad (Slovenia)";
            }
            case "SI-159": {
                return "Hajdina (Slovenia)";
            }
            case "SI-160": {
                return "Ho\u010de-Slivnica (Slovenia)";
            }
            case "SI-161": {
                return "Hodo\u0161 (Slovenia)";
            }
            case "SI-162": {
                return "Horjul (Slovenia)";
            }
            case "SI-163": {
                return "Jezersko (Slovenia)";
            }
            case "SI-164": {
                return "Komenda (Slovenia)";
            }
            case "SI-165": {
                return "Kostel (Slovenia)";
            }
            case "SI-166": {
                return "Kri\u017eevci (Slovenia)";
            }
            case "SI-167": {
                return "Lovrenc na Pohorju (Slovenia)";
            }
            case "SI-168": {
                return "Markovci (Slovenia)";
            }
            case "SI-169": {
                return "Miklav\u017e na Dravskem Polju (Slovenia)";
            }
            case "SI-170": {
                return "Mirna Pe\u010d (Slovenia)";
            }
            case "SI-171": {
                return "Oplotnica (Slovenia)";
            }
            case "SI-172": {
                return "Podlehnik (Slovenia)";
            }
            case "SI-173": {
                return "Polzela (Slovenia)";
            }
            case "SI-174": {
                return "Prebold (Slovenia)";
            }
            case "SI-175": {
                return "Prevalje (Slovenia)";
            }
            case "SI-176": {
                return "Razkri\u017eje (Slovenia)";
            }
            case "SI-177": {
                return "Ribnica na Pohorju (Slovenia)";
            }
            case "SI-178": {
                return "Selnica ob Dravi (Slovenia)";
            }
            case "SI-179": {
                return "Sodra\u017eica (Slovenia)";
            }
            case "SI-180": {
                return "Sol\u010dava (Slovenia)";
            }
            case "SI-181": {
                return "Sveta Ana (Slovenia)";
            }
            case "SI-182": {
                return "Sveti Andra\u017e v Slovenskih Goricah (Slovenia)";
            }
            case "SI-183": {
                return "\u0160empeter-Vrtojba (Slovenia)";
            }
            case "SI-184": {
                return "Tabor (Slovenia)";
            }
            case "SI-185": {
                return "Trnovska Vas (Slovenia)";
            }
            case "SI-186": {
                return "Trzin (Slovenia)";
            }
            case "SI-187": {
                return "Velika Polana (Slovenia)";
            }
            case "SI-188": {
                return "Ver\u017eej (Slovenia)";
            }
            case "SI-189": {
                return "Vransko (Slovenia)";
            }
            case "SI-190": {
                return "\u017dalec (Slovenia)";
            }
            case "SI-191": {
                return "\u017detale (Slovenia)";
            }
            case "SI-192": {
                return "\u017dirovnica (Slovenia)";
            }
            case "SI-193": {
                return "\u017du\u017eemberk (Slovenia)";
            }
            case "SI-194": {
                return "\u0160martno pri Litiji (Slovenia)";
            }
            case "SI-195": {
                return "Apa\u010de (Slovenia)";
            }
            case "SI-196": {
                return "Cirkulane (Slovenia)";
            }
            case "SI-197": {
                return "Kosanjevica na Krki (Slovenia)";
            }
            case "SI-198": {
                return "Makole (Slovenia)";
            }
            case "SI-199": {
                return "Mokronog-Trebelno (Slovenia)";
            }
            case "SI-200": {
                return "Polj\u010dane (Slovenia)";
            }
            case "SI-201": {
                return "Ren\u010de-Vogrsko (Slovenia)";
            }
            case "SI-202": {
                return "Sredi\u0161\u010de ob Dravi (Slovenia)";
            }
            case "SI-203": {
                return "Stra\u017ea (Slovenia)";
            }
            case "SI-204": {
                return "Sveta Trojica v Slovenskih Goricah (Slovenia)";
            }
            case "SI-205": {
                return "Sveti Toma\u017e (Slovenia)";
            }
            case "SI-206": {
                return "\u0160marje\u0161ke Toplice (Slovenia)";
            }
            case "SI-207": {
                return "Gorje (Slovenia)";
            }
            case "SI-208": {
                return "Log-Dragomer (Slovenia)";
            }
            case "SI-209": {
                return "Re\u010dica ob Savinji (Slovenia)";
            }
            case "SI-210": {
                return "Sveti Jurij v Slovenskih Goricah (Slovenia)";
            }
            case "SI-211": {
                return "\u0160entrupert (Slovenia)";
            }
            case "SI-212": {
                return "Mirna (Slovenia)";
            }
            case "SJ-SJ": {
                return "Svalbard & Jan Mayen Islands (Svalbard & Jan Mayen Islands)";
            }
            case "SK-BC": {
                return "Banskobystrick\u00fd kraj (Slovakia)";
            }
            case "SK-BL": {
                return "Bratislavsk\u00fd kraj (Slovakia)";
            }
            case "SK-KI": {
                return "Ko\u0161ick\u00fd kraj (Slovakia)";
            }
            case "SK-NI": {
                return "Nitriansky kraj (Slovakia)";
            }
            case "SK-PV": {
                return "Pre\u0161ovsk\u00fd kraj (Slovakia)";
            }
            case "SK-TA": {
                return "Trnavsk\u00fd kraj (Slovakia)";
            }
            case "SK-TC": {
                return "Tren\u010diansky kraj (Slovakia)";
            }
            case "SK-ZI": {
                return "\u017dilinsk\u00fd kraj (Slovakia)";
            }
            case "SL-E": {
                return "Eastern (Sierra Leone)";
            }
            case "SL-N": {
                return "Northern (Sierra Leone)";
            }
            case "SL-S": {
                return "Southern (Sierra Leone)";
            }
            case "SL-W": {
                return "Western Area (Sierra Leone)";
            }
            case "SM-01": {
                return "Acquaviva (San Marino)";
            }
            case "SM-02": {
                return "Chiesanuova (San Marino)";
            }
            case "SM-03": {
                return "Domagnano (San Marino)";
            }
            case "SM-04": {
                return "Faetano (San Marino)";
            }
            case "SM-05": {
                return "Fiorentino (San Marino)";
            }
            case "SM-06": {
                return "Borgo Maggiore (San Marino)";
            }
            case "SM-07": {
                return "San Marino (San Marino)";
            }
            case "SM-08": {
                return "Montegiardino (San Marino)";
            }
            case "SM-09": {
                return "Serravalle (San Marino)";
            }
            case "SN-DB": {
                return "Diourbel (Senegal)";
            }
            case "SN-DK": {
                return "Dakar (Senegal)";
            }
            case "SN-FK": {
                return "Fatick (Senegal)";
            }
            case "SN-KA": {
                return "Kaffrine (Senegal)";
            }
            case "SN-KD": {
                return "Kolda (Senegal)";
            }
            case "SN-KE": {
                return "K\u00e9dougou (Senegal)";
            }
            case "SN-KL": {
                return "Kaolack (Senegal)";
            }
            case "SN-LG": {
                return "Louga (Senegal)";
            }
            case "SN-MT": {
                return "Matam (Senegal)";
            }
            case "SN-SE": {
                return "S\u00e9dhiou (Senegal)";
            }
            case "SN-SL": {
                return "Saint-Louis (Senegal)";
            }
            case "SN-TC": {
                return "Tambacounda (Senegal)";
            }
            case "SN-TH": {
                return "Thi\u00e8s (Senegal)";
            }
            case "SN-ZG": {
                return "Ziguinchor (Senegal)";
            }
            case "SO-AW": {
                return "Awdal (Somalia)";
            }
            case "SO-BK": {
                return "Bakool (Somalia)";
            }
            case "SO-BN": {
                return "Banaadir (Somalia)";
            }
            case "SO-BR": {
                return "Bari (Somalia)";
            }
            case "SO-BY": {
                return "Bay (Somalia)";
            }
            case "SO-GA": {
                return "Galguduud (Somalia)";
            }
            case "SO-GE": {
                return "Gedo (Somalia)";
            }
            case "SO-HI": {
                return "Hiiraan (Somalia)";
            }
            case "SO-JD": {
                return "Jubbada Dhexe (Somalia)";
            }
            case "SO-JH": {
                return "Jubbada Hoose (Somalia)";
            }
            case "SO-MU": {
                return "Mudug (Somalia)";
            }
            case "SO-NU": {
                return "Nugaal (Somalia)";
            }
            case "SO-SA": {
                return "Sanaag (Somalia)";
            }
            case "SO-SD": {
                return "Shabeellaha Dhexe (Somalia)";
            }
            case "SO-SH": {
                return "Shabeellaha Hoose (Somalia)";
            }
            case "SO-SO": {
                return "Sool (Somalia)";
            }
            case "SO-TO": {
                return "Togdheer (Somalia)";
            }
            case "SO-WO": {
                return "Woqooyi Galbeed (Somalia)";
            }
            case "SR-BR": {
                return "Brokopondo (Suriname)";
            }
            case "SR-CM": {
                return "Commewijne (Suriname)";
            }
            case "SR-CR": {
                return "Coronie (Suriname)";
            }
            case "SR-MA": {
                return "Marowijne (Suriname)";
            }
            case "SR-NI": {
                return "Nickerie (Suriname)";
            }
            case "SR-PM": {
                return "Paramaribo (Suriname)";
            }
            case "SR-PR": {
                return "Para (Suriname)";
            }
            case "SR-SA": {
                return "Saramacca (Suriname)";
            }
            case "SR-SI": {
                return "Sipaliwini (Suriname)";
            }
            case "SR-WA": {
                return "Wanica (Suriname)";
            }
            case "SS-BN": {
                return "Northern Bahr el Ghazal (South Sudan)";
            }
            case "SS-BW": {
                return "Western Bahr el Ghazal (South Sudan)";
            }
            case "SS-EC": {
                return "Central Equatoria (South Sudan)";
            }
            case "SS-EE": {
                return "Eastern Equatoria (South Sudan)";
            }
            case "SS-EW": {
                return "Western Equatoria (South Sudan)";
            }
            case "SS-JG": {
                return "Jonglei (South Sudan)";
            }
            case "SS-LK": {
                return "Lakes (South Sudan)";
            }
            case "SS-NU": {
                return "Upper Nile (South Sudan)";
            }
            case "SS-UY": {
                return "Unity (South Sudan)";
            }
            case "SS-WR": {
                return "Warrap (South Sudan)";
            }
            case "ST-P": {
                return "Pr\u00edncipe (Sao Tome and Principe)";
            }
            case "ST-S": {
                return "S\u00e3o Tom\u00e9 (Sao Tome and Principe)";
            }
            case "SV-AH": {
                return "Ahuachap\u00e1n (El Salvador)";
            }
            case "SV-CA": {
                return "Caba\u00f1as (El Salvador)";
            }
            case "SV-CH": {
                return "Chalatenango (El Salvador)";
            }
            case "SV-CU": {
                return "Cuscatl\u00e1n (El Salvador)";
            }
            case "SV-LI": {
                return "La Libertad (El Salvador)";
            }
            case "SV-MO": {
                return "Moraz\u00e1n (El Salvador)";
            }
            case "SV-PA": {
                return "La Paz (El Salvador)";
            }
            case "SV-SA": {
                return "Santa Ana (El Salvador)";
            }
            case "SV-SM": {
                return "San Miguel (El Salvador)";
            }
            case "SV-SO": {
                return "Sonsonate (El Salvador)";
            }
            case "SV-SS": {
                return "San Salvador (El Salvador)";
            }
            case "SV-SV": {
                return "San Vicente (El Salvador)";
            }
            case "SV-UN": {
                return "La Uni\u00f3n (El Salvador)";
            }
            case "SV-US": {
                return "Usulut\u00e1n (El Salvador)";
            }
            case "SX-SX": {
                return "St. Maarten (St. Maarten)";
            }
            case "SY-DI": {
                return "Dimashq (Syria)";
            }
            case "SY-DR": {
                return "Dar'\u0101 (Syria)";
            }
            case "SY-DY": {
                return "Dayr az Zawr (Syria)";
            }
            case "SY-HA": {
                return "Al \u1e28asakah (Syria)";
            }
            case "SY-HI": {
                return "\u1e28im\u015f (Syria)";
            }
            case "SY-HL": {
                return "\u1e28alab (Syria)";
            }
            case "SY-HM": {
                return "\u1e28am\u0101h (Syria)";
            }
            case "SY-ID": {
                return "Idlib (Syria)";
            }
            case "SY-LA": {
                return "Al L\u0101dhiq\u012byah (Syria)";
            }
            case "SY-QU": {
                return "Al Qunay\u0163irah (Syria)";
            }
            case "SY-RA": {
                return "Ar Raqqah (Syria)";
            }
            case "SY-RD": {
                return "R\u012bf Dimashq (Syria)";
            }
            case "SY-SU": {
                return "As Suwayd\u0101' (Syria)";
            }
            case "SY-TA": {
                return "\u0162ar\u0163\u016bs (Syria)";
            }
            case "SZ-HH": {
                return "Hhohho (Swaziland)";
            }
            case "SZ-LU": {
                return "Lubombo (Swaziland)";
            }
            case "SZ-MA": {
                return "Manzini (Swaziland)";
            }
            case "SZ-SH": {
                return "Shiselweni (Swaziland)";
            }
            case "TC-TC": {
                return "Turks & Caicos Islands (Turks & Caicos Islands)";
            }
            case "TD-BA": {
                return "Al Ba\u0163\u1e29ah (Chad)";
            }
            case "TD-BG": {
                return "Ba\u1e29r al Ghaz\u0101l (Chad)";
            }
            case "TD-BO": {
                return "Borkou (Chad)";
            }
            case "TD-CB": {
                return "Chari-Baguirmi (Chad)";
            }
            case "TD-EE": {
                return "Ennedi-Est (Chad)";
            }
            case "TD-EO": {
                return "Ennedi-Ouest (Chad)";
            }
            case "TD-GR": {
                return "Gu\u00e9ra (Chad)";
            }
            case "TD-HL": {
                return "Hadjer Lamis (Chad)";
            }
            case "TD-KA": {
                return "Kanem (Chad)";
            }
            case "TD-LC": {
                return "Al Bu\u1e29ayrah (Chad)";
            }
            case "TD-LO": {
                return "Logone-Occidental (Chad)";
            }
            case "TD-LR": {
                return "Logone-Oriental (Chad)";
            }
            case "TD-MA": {
                return "Mandoul (Chad)";
            }
            case "TD-MC": {
                return "Moyen-Chari (Chad)";
            }
            case "TD-ME": {
                return "Mayo-Kebbi-Est (Chad)";
            }
            case "TD-MO": {
                return "Mayo-Kebbi-Ouest (Chad)";
            }
            case "TD-ND": {
                return "Mad\u012bnat Injam\u012bn\u0101 (Chad)";
            }
            case "TD-OD": {
                return "Ouadda\u00ef (Chad)";
            }
            case "TD-SA": {
                return "Salamat (Chad)";
            }
            case "TD-SI": {
                return "Sila (Chad)";
            }
            case "TD-TA": {
                return "Tandjil\u00e9 (Chad)";
            }
            case "TD-TI": {
                return "Tibast\u012b (Chad)";
            }
            case "TD-WF": {
                return "Wadi Fira (Chad)";
            }
            case "TF-TF": {
                return "French Southern Territories (French Southern Territories)";
            }
            case "TG-C": {
                return "Centre (Togo)";
            }
            case "TG-K": {
                return "Kara (Togo)";
            }
            case "TG-M": {
                return "Maritime (Togo)";
            }
            case "TG-P": {
                return "Plateaux (Togo)";
            }
            case "TG-S": {
                return "Savannes (Togo)";
            }
            case "TH-10": {
                return "Krung Thep Maha Nakhon (Thailand)";
            }
            case "TH-11": {
                return "Samut Prakan (Thailand)";
            }
            case "TH-12": {
                return "Nonthaburi (Thailand)";
            }
            case "TH-13": {
                return "Pathum Thani (Thailand)";
            }
            case "TH-14": {
                return "Phra Nakhon Si Ayutthaya (Thailand)";
            }
            case "TH-15": {
                return "Ang Thong (Thailand)";
            }
            case "TH-16": {
                return "Lop Buri (Thailand)";
            }
            case "TH-17": {
                return "Sing Buri (Thailand)";
            }
            case "TH-18": {
                return "Chai Nat (Thailand)";
            }
            case "TH-19": {
                return "Saraburi (Thailand)";
            }
            case "TH-20": {
                return "Chon Buri (Thailand)";
            }
            case "TH-21": {
                return "Rayong (Thailand)";
            }
            case "TH-22": {
                return "Chanthaburi (Thailand)";
            }
            case "TH-23": {
                return "Trat (Thailand)";
            }
            case "TH-24": {
                return "Chachoengsao (Thailand)";
            }
            case "TH-25": {
                return "Prachin Buri (Thailand)";
            }
            case "TH-26": {
                return "Nakhon Nayok (Thailand)";
            }
            case "TH-27": {
                return "Sa Kaeo (Thailand)";
            }
            case "TH-30": {
                return "Nakhon Ratchasima (Thailand)";
            }
            case "TH-31": {
                return "Buri Ram (Thailand)";
            }
            case "TH-32": {
                return "Surin (Thailand)";
            }
            case "TH-33": {
                return "Si Sa Ket (Thailand)";
            }
            case "TH-34": {
                return "Ubon Ratchathani (Thailand)";
            }
            case "TH-35": {
                return "Yasothon (Thailand)";
            }
            case "TH-36": {
                return "Chaiyaphum (Thailand)";
            }
            case "TH-37": {
                return "Amnat Charoen (Thailand)";
            }
            case "TH-38": {
                return "Bueng Kan (Thailand)";
            }
            case "TH-39": {
                return "Nong Bua Lam Phu (Thailand)";
            }
            case "TH-40": {
                return "Khon Kaen (Thailand)";
            }
            case "TH-41": {
                return "Udon Thani (Thailand)";
            }
            case "TH-42": {
                return "Loei (Thailand)";
            }
            case "TH-43": {
                return "Nong Khai (Thailand)";
            }
            case "TH-44": {
                return "Maha Sarakham (Thailand)";
            }
            case "TH-45": {
                return "Roi Et (Thailand)";
            }
            case "TH-46": {
                return "Kalasin (Thailand)";
            }
            case "TH-47": {
                return "Sakon Nakhon (Thailand)";
            }
            case "TH-48": {
                return "Nakhon Phanom (Thailand)";
            }
            case "TH-49": {
                return "Mukdahan (Thailand)";
            }
            case "TH-50": {
                return "Chiang Mai (Thailand)";
            }
            case "TH-51": {
                return "Lamphun (Thailand)";
            }
            case "TH-52": {
                return "Lampang (Thailand)";
            }
            case "TH-53": {
                return "Uttaradit (Thailand)";
            }
            case "TH-54": {
                return "Phrae (Thailand)";
            }
            case "TH-55": {
                return "Nan (Thailand)";
            }
            case "TH-56": {
                return "Phayao (Thailand)";
            }
            case "TH-57": {
                return "Chiang Rai (Thailand)";
            }
            case "TH-58": {
                return "Mae Hong Son (Thailand)";
            }
            case "TH-60": {
                return "Nakhon Sawan (Thailand)";
            }
            case "TH-61": {
                return "Uthai Thani (Thailand)";
            }
            case "TH-62": {
                return "Kamphaeng Phet (Thailand)";
            }
            case "TH-63": {
                return "Tak (Thailand)";
            }
            case "TH-64": {
                return "Sukhothai (Thailand)";
            }
            case "TH-65": {
                return "Phitsanulok (Thailand)";
            }
            case "TH-66": {
                return "Phichit (Thailand)";
            }
            case "TH-67": {
                return "Phetchabun (Thailand)";
            }
            case "TH-70": {
                return "Ratchaburi (Thailand)";
            }
            case "TH-71": {
                return "Kanchanaburi (Thailand)";
            }
            case "TH-72": {
                return "Suphan Buri (Thailand)";
            }
            case "TH-73": {
                return "Nakhon Pathom (Thailand)";
            }
            case "TH-74": {
                return "Samut Sakhon (Thailand)";
            }
            case "TH-75": {
                return "Samut Songkhram (Thailand)";
            }
            case "TH-76": {
                return "Phetchaburi (Thailand)";
            }
            case "TH-77": {
                return "Prachuap Khiri Khan (Thailand)";
            }
            case "TH-80": {
                return "Nakhon Si Thammarat (Thailand)";
            }
            case "TH-81": {
                return "Krabi (Thailand)";
            }
            case "TH-82": {
                return "Phangnga (Thailand)";
            }
            case "TH-83": {
                return "Phuket (Thailand)";
            }
            case "TH-84": {
                return "Surat Thani (Thailand)";
            }
            case "TH-85": {
                return "Ranong (Thailand)";
            }
            case "TH-86": {
                return "Chumphon (Thailand)";
            }
            case "TH-90": {
                return "Songkhla (Thailand)";
            }
            case "TH-91": {
                return "Satun (Thailand)";
            }
            case "TH-92": {
                return "Trang (Thailand)";
            }
            case "TH-93": {
                return "Phatthalung (Thailand)";
            }
            case "TH-94": {
                return "Pattani (Thailand)";
            }
            case "TH-95": {
                return "Yala (Thailand)";
            }
            case "TH-96": {
                return "Narathiwat (Thailand)";
            }
            case "TH-S": {
                return "Phatthaya (Thailand)";
            }
            case "TJ-DU": {
                return "Dushanbe (Tajikistan)";
            }
            case "TJ-GB": {
                return "K\u016dhistoni Badakhshon (Tajikistan)";
            }
            case "TJ-KT": {
                return "Khatlon (Tajikistan)";
            }
            case "TJ-SU": {
                return "Sughd (Tajikistan)";
            }
            case "TK-TK": {
                return "Tokelau (Tokelau)";
            }
            case "TL-AL": {
                return "Aileu (East Timor)";
            }
            case "TL-AN": {
                return "Ainaro (East Timor)";
            }
            case "TL-BA": {
                return "Baucau (East Timor)";
            }
            case "TL-BO": {
                return "Bobonaro (East Timor)";
            }
            case "TL-CO": {
                return "Cova Lima (East Timor)";
            }
            case "TL-DI": {
                return "D\u00edli (East Timor)";
            }
            case "TL-ER": {
                return "Ermera (East Timor)";
            }
            case "TL-LA": {
                return "Laut\u00e9m (East Timor)";
            }
            case "TL-LI": {
                return "Likis\u00e1 (East Timor)";
            }
            case "TL-MF": {
                return "Manufahi (East Timor)";
            }
            case "TL-MT": {
                return "Manatuto (East Timor)";
            }
            case "TL-OE": {
                return "Oecussi (East Timor)";
            }
            case "TL-VI": {
                return "Vikeke (East Timor)";
            }
            case "TM-A": {
                return "Ahal (Turkmenistan)";
            }
            case "TM-B": {
                return "Balkan (Turkmenistan)";
            }
            case "TM-D": {
                return "Da\u015foguz (Turkmenistan)";
            }
            case "TM-L": {
                return "Lebap (Turkmenistan)";
            }
            case "TM-M": {
                return "Mary (Turkmenistan)";
            }
            case "TM-S": {
                return "A\u015fgabat (Turkmenistan)";
            }
            case "TN-11": {
                return "Tunis (Tunisia)";
            }
            case "TN-12": {
                return "Ariana (Tunisia)";
            }
            case "TN-13": {
                return "Ben Arous (Tunisia)";
            }
            case "TN-14": {
                return "La Manouba (Tunisia)";
            }
            case "TN-21": {
                return "Nabeul (Tunisia)";
            }
            case "TN-22": {
                return "Zaghouan (Tunisia)";
            }
            case "TN-23": {
                return "Bizerte (Tunisia)";
            }
            case "TN-31": {
                return "B\u00e9ja (Tunisia)";
            }
            case "TN-32": {
                return "Jendouba (Tunisia)";
            }
            case "TN-33": {
                return "Le Kef (Tunisia)";
            }
            case "TN-34": {
                return "Siliana (Tunisia)";
            }
            case "TN-41": {
                return "Kairouan (Tunisia)";
            }
            case "TN-42": {
                return "Kasserine (Tunisia)";
            }
            case "TN-43": {
                return "Sidi Bouzid (Tunisia)";
            }
            case "TN-51": {
                return "Sousse (Tunisia)";
            }
            case "TN-52": {
                return "Monastir (Tunisia)";
            }
            case "TN-53": {
                return "Mahdia (Tunisia)";
            }
            case "TN-61": {
                return "Sfax (Tunisia)";
            }
            case "TN-71": {
                return "Gafsa (Tunisia)";
            }
            case "TN-72": {
                return "Tozeur (Tunisia)";
            }
            case "TN-73": {
                return "Kebili (Tunisia)";
            }
            case "TN-81": {
                return "Gab\u00e8s (Tunisia)";
            }
            case "TN-82": {
                return "Medenine (Tunisia)";
            }
            case "TN-83": {
                return "Tataouine (Tunisia)";
            }
            case "TO-01": {
                return "'Eua (Tonga)";
            }
            case "TO-02": {
                return "Ha'apai (Tonga)";
            }
            case "TO-03": {
                return "Niuas (Tonga)";
            }
            case "TO-04": {
                return "Tongatapu (Tonga)";
            }
            case "TO-05": {
                return "Vava'u (Tonga)";
            }
            case "TR-01": {
                return "Adana (Turkey)";
            }
            case "TR-02": {
                return "Ad\u0131yaman (Turkey)";
            }
            case "TR-03": {
                return "Afyonkarahisar (Turkey)";
            }
            case "TR-04": {
                return "A\u011fr\u0131 (Turkey)";
            }
            case "TR-05": {
                return "Amasya (Turkey)";
            }
            case "TR-06": {
                return "Ankara (Turkey)";
            }
            case "TR-07": {
                return "Antalya (Turkey)";
            }
            case "TR-08": {
                return "Artvin (Turkey)";
            }
            case "TR-09": {
                return "Ayd\u0131n (Turkey)";
            }
            case "TR-10": {
                return "Bal\u0131kesir (Turkey)";
            }
            case "TR-11": {
                return "Bilecik (Turkey)";
            }
            case "TR-12": {
                return "Bing\u00f6l (Turkey)";
            }
            case "TR-13": {
                return "Bitlis (Turkey)";
            }
            case "TR-14": {
                return "Bolu (Turkey)";
            }
            case "TR-15": {
                return "Burdur (Turkey)";
            }
            case "TR-16": {
                return "Bursa (Turkey)";
            }
            case "TR-17": {
                return "\u00c7anakkale (Turkey)";
            }
            case "TR-18": {
                return "\u00c7ank\u0131r\u0131 (Turkey)";
            }
            case "TR-19": {
                return "\u00c7orum (Turkey)";
            }
            case "TR-20": {
                return "Denizli (Turkey)";
            }
            case "TR-21": {
                return "Diyarbak\u0131r (Turkey)";
            }
            case "TR-22": {
                return "Edirne (Turkey)";
            }
            case "TR-23": {
                return "Elaz\u0131\u011f (Turkey)";
            }
            case "TR-24": {
                return "Erzincan (Turkey)";
            }
            case "TR-25": {
                return "Erzurum (Turkey)";
            }
            case "TR-26": {
                return "Eski\u015fehir (Turkey)";
            }
            case "TR-27": {
                return "Gaziantep (Turkey)";
            }
            case "TR-28": {
                return "Giresun (Turkey)";
            }
            case "TR-29": {
                return "G\u00fcm\u00fc\u015fhane (Turkey)";
            }
            case "TR-30": {
                return "Hakk\u00e2ri (Turkey)";
            }
            case "TR-31": {
                return "Hatay (Turkey)";
            }
            case "TR-32": {
                return "Isparta (Turkey)";
            }
            case "TR-33": {
                return "Mersin (Turkey)";
            }
            case "TR-34": {
                return "\u0130stanbul (Turkey)";
            }
            case "TR-35": {
                return "\u0130zmir (Turkey)";
            }
            case "TR-36": {
                return "Kars (Turkey)";
            }
            case "TR-37": {
                return "Kastamonu (Turkey)";
            }
            case "TR-38": {
                return "Kayseri (Turkey)";
            }
            case "TR-39": {
                return "K\u0131rklareli (Turkey)";
            }
            case "TR-40": {
                return "K\u0131r\u015fehir (Turkey)";
            }
            case "TR-41": {
                return "Kocaeli (Turkey)";
            }
            case "TR-42": {
                return "Konya (Turkey)";
            }
            case "TR-43": {
                return "K\u00fctahya (Turkey)";
            }
            case "TR-44": {
                return "Malatya (Turkey)";
            }
            case "TR-45": {
                return "Manisa (Turkey)";
            }
            case "TR-46": {
                return "Kahramanmara\u015f (Turkey)";
            }
            case "TR-47": {
                return "Mardin (Turkey)";
            }
            case "TR-48": {
                return "Mu\u011fla (Turkey)";
            }
            case "TR-49": {
                return "Mu\u015f (Turkey)";
            }
            case "TR-50": {
                return "Nev\u015fehir (Turkey)";
            }
            case "TR-51": {
                return "Ni\u011fde (Turkey)";
            }
            case "TR-52": {
                return "Ordu (Turkey)";
            }
            case "TR-53": {
                return "Rize (Turkey)";
            }
            case "TR-54": {
                return "Sakarya (Turkey)";
            }
            case "TR-55": {
                return "Samsun (Turkey)";
            }
            case "TR-56": {
                return "Siirt (Turkey)";
            }
            case "TR-57": {
                return "Sinop (Turkey)";
            }
            case "TR-58": {
                return "Sivas (Turkey)";
            }
            case "TR-59": {
                return "Tekirda\u011f (Turkey)";
            }
            case "TR-60": {
                return "Tokat (Turkey)";
            }
            case "TR-61": {
                return "Trabzon (Turkey)";
            }
            case "TR-62": {
                return "Tunceli (Turkey)";
            }
            case "TR-63": {
                return "\u015eanl\u0131urfa (Turkey)";
            }
            case "TR-64": {
                return "U\u015fak (Turkey)";
            }
            case "TR-65": {
                return "Van (Turkey)";
            }
            case "TR-66": {
                return "Yozgat (Turkey)";
            }
            case "TR-67": {
                return "Zonguldak (Turkey)";
            }
            case "TR-68": {
                return "Aksaray (Turkey)";
            }
            case "TR-69": {
                return "Bayburt (Turkey)";
            }
            case "TR-70": {
                return "Karaman (Turkey)";
            }
            case "TR-71": {
                return "K\u0131r\u0131kkale (Turkey)";
            }
            case "TR-72": {
                return "Batman (Turkey)";
            }
            case "TR-73": {
                return "\u015e\u0131rnak (Turkey)";
            }
            case "TR-74": {
                return "Bart\u0131n (Turkey)";
            }
            case "TR-75": {
                return "Ardahan (Turkey)";
            }
            case "TR-76": {
                return "I\u011fd\u0131r (Turkey)";
            }
            case "TR-77": {
                return "Yalova (Turkey)";
            }
            case "TR-78": {
                return "Karab\u00fck (Turkey)";
            }
            case "TR-79": {
                return "Kilis (Turkey)";
            }
            case "TR-80": {
                return "Osmaniye (Turkey)";
            }
            case "TR-81": {
                return "D\u00fczce (Turkey)";
            }
            case "TT-ARI": {
                return "Arima (Trinidad and Tobago)";
            }
            case "TT-CHA": {
                return "Chaguanas (Trinidad and Tobago)";
            }
            case "TT-CTT": {
                return "Couva-Tabaquite-Talparo (Trinidad and Tobago)";
            }
            case "TT-DMN": {
                return "Diego Martin (Trinidad and Tobago)";
            }
            case "TT-ETO": {
                return "Eastern Tobago (Trinidad and Tobago)";
            }
            case "TT-PED": {
                return "Penal-Debe (Trinidad and Tobago)";
            }
            case "TT-POS": {
                return "Port of Spain (Trinidad and Tobago)";
            }
            case "TT-PRT": {
                return "Princes Town (Trinidad and Tobago)";
            }
            case "TT-PTF": {
                return "Point Fortin (Trinidad and Tobago)";
            }
            case "TT-RCM": {
                return "Rio Claro-Mayaro (Trinidad and Tobago)";
            }
            case "TT-SFO": {
                return "San Fernando (Trinidad and Tobago)";
            }
            case "TT-SGE": {
                return "Sangre Grande (Trinidad and Tobago)";
            }
            case "TT-SIP": {
                return "Siparia (Trinidad and Tobago)";
            }
            case "TT-SJL": {
                return "San Juan-Laventille (Trinidad and Tobago)";
            }
            case "TT-TUP": {
                return "Tunapuna-Piarco (Trinidad and Tobago)";
            }
            case "TT-WTO": {
                return "Western Tobago (Trinidad and Tobago)";
            }
            case "TV-FUN": {
                return "Funafuti (Tuvalu)";
            }
            case "TV-NIT": {
                return "Niutao (Tuvalu)";
            }
            case "TV-NKF": {
                return "Nukufetau (Tuvalu)";
            }
            case "TV-NKL": {
                return "Nukulaelae (Tuvalu)";
            }
            case "TV-NMA": {
                return "Nanumea (Tuvalu)";
            }
            case "TV-NMG": {
                return "Nanumanga (Tuvalu)";
            }
            case "TV-NUI": {
                return "Nui (Tuvalu)";
            }
            case "TV-VAI": {
                return "Vaitupu (Tuvalu)";
            }
            case "TW-CHA": {
                return "Changhua (Taiwan)";
            }
            case "TW-CYI": {
                return "Chiayi (Taiwan)";
            }
            case "TW-CYQ": {
                return "Chiayi (Taiwan)";
            }
            case "TW-HSQ": {
                return "Hsinchu (Taiwan)";
            }
            case "TW-HSZ": {
                return "Hsinchu (Taiwan)";
            }
            case "TW-HUA": {
                return "Hualien (Taiwan)";
            }
            case "TW-ILA": {
                return "Ilan (Taiwan)";
            }
            case "TW-KEE": {
                return "Keelung (Taiwan)";
            }
            case "TW-KHH": {
                return "Kaohsiung (Taiwan)";
            }
            case "TW-KHQ": {
                return "Kaohsiung (Taiwan)";
            }
            case "TW-MIA": {
                return "Miaoli (Taiwan)";
            }
            case "TW-NAN": {
                return "Nantou (Taiwan)";
            }
            case "TW-PEN": {
                return "Penghu (Taiwan)";
            }
            case "TW-PIF": {
                return "Pingtung (Taiwan)";
            }
            case "TW-TAO": {
                return "Taoyuan (Taiwan)";
            }
            case "TW-TNN": {
                return "Tainan (Taiwan)";
            }
            case "TW-TNQ": {
                return "Tainan (Taiwan)";
            }
            case "TW-TPE": {
                return "Taipei (Taiwan)";
            }
            case "TW-TPQ": {
                return "Taipei (Taiwan)";
            }
            case "TW-TTT": {
                return "Taitung (Taiwan)";
            }
            case "TW-TXG": {
                return "Taichung (Taiwan)";
            }
            case "TW-TXQ": {
                return "Taichung (Taiwan)";
            }
            case "TW-YUN": {
                return "Yunlin (Taiwan)";
            }
            case "TZ-01": {
                return "Arusha (Tanzania)";
            }
            case "TZ-02": {
                return "Dar es Salaam (Tanzania)";
            }
            case "TZ-03": {
                return "Dodoma (Tanzania)";
            }
            case "TZ-04": {
                return "Iringa (Tanzania)";
            }
            case "TZ-05": {
                return "Kagera (Tanzania)";
            }
            case "TZ-06": {
                return "Kaskazini Pemba (Tanzania)";
            }
            case "TZ-07": {
                return "Kaskazini Unguja (Tanzania)";
            }
            case "TZ-08": {
                return "Kigoma (Tanzania)";
            }
            case "TZ-09": {
                return "Kilimanjaro (Tanzania)";
            }
            case "TZ-10": {
                return "Kusini Pemba (Tanzania)";
            }
            case "TZ-11": {
                return "Kusini Unguja (Tanzania)";
            }
            case "TZ-12": {
                return "Lindi (Tanzania)";
            }
            case "TZ-13": {
                return "Mara (Tanzania)";
            }
            case "TZ-14": {
                return "Mbeya (Tanzania)";
            }
            case "TZ-15": {
                return "Mjini Magharibi (Tanzania)";
            }
            case "TZ-16": {
                return "Morogoro (Tanzania)";
            }
            case "TZ-17": {
                return "Mtwara (Tanzania)";
            }
            case "TZ-18": {
                return "Mwanza (Tanzania)";
            }
            case "TZ-19": {
                return "Coast (Tanzania)";
            }
            case "TZ-20": {
                return "Rukwa (Tanzania)";
            }
            case "TZ-21": {
                return "Ruvuma (Tanzania)";
            }
            case "TZ-22": {
                return "Shinyanga (Tanzania)";
            }
            case "TZ-23": {
                return "Singida (Tanzania)";
            }
            case "TZ-24": {
                return "Tabora (Tanzania)";
            }
            case "TZ-25": {
                return "Tanga (Tanzania)";
            }
            case "TZ-26": {
                return "Manyara (Tanzania)";
            }
            case "TZ-27": {
                return "Geita (Tanzania)";
            }
            case "TZ-28": {
                return "Katavi (Tanzania)";
            }
            case "TZ-29": {
                return "Njombe (Tanzania)";
            }
            case "TZ-30": {
                return "Simiyu (Tanzania)";
            }
            case "UA-05": {
                return "Vinnytska oblast (Ukraine)";
            }
            case "UA-07": {
                return "Volynska oblast (Ukraine)";
            }
            case "UA-09": {
                return "Luhanska oblast (Ukraine)";
            }
            case "UA-12": {
                return "Dnipropetrovska oblast (Ukraine)";
            }
            case "UA-14": {
                return "Donetska oblast (Ukraine)";
            }
            case "UA-18": {
                return "Zhytomyrska oblast (Ukraine)";
            }
            case "UA-21": {
                return "Zakarpatska oblast (Ukraine)";
            }
            case "UA-23": {
                return "Zaporizka oblast (Ukraine)";
            }
            case "UA-26": {
                return "Ivano-Frankivska oblast (Ukraine)";
            }
            case "UA-30": {
                return "Kyiv (Ukraine)";
            }
            case "UA-32": {
                return "Kyivska oblast (Ukraine)";
            }
            case "UA-35": {
                return "Kirovohradska oblast (Ukraine)";
            }
            case "UA-40": {
                return "Sevastopol (Ukraine)";
            }
            case "UA-43": {
                return "Avtonomna Respublika Krym (Ukraine)";
            }
            case "UA-46": {
                return "Lvivska oblast (Ukraine)";
            }
            case "UA-48": {
                return "Mykolaivska oblast (Ukraine)";
            }
            case "UA-51": {
                return "Odeska oblast (Ukraine)";
            }
            case "UA-53": {
                return "Poltavska oblast (Ukraine)";
            }
            case "UA-56": {
                return "Rivnenska oblast (Ukraine)";
            }
            case "UA-59": {
                return "Sumska oblast (Ukraine)";
            }
            case "UA-61": {
                return "Ternopilska oblast (Ukraine)";
            }
            case "UA-63": {
                return "Kharkivska oblast (Ukraine)";
            }
            case "UA-65": {
                return "Khersonska oblast (Ukraine)";
            }
            case "UA-68": {
                return "Khmelnytska oblast (Ukraine)";
            }
            case "UA-71": {
                return "Cherkaska oblast (Ukraine)";
            }
            case "UA-74": {
                return "Chernihivska oblast (Ukraine)";
            }
            case "UA-77": {
                return "Chernivetska oblast (Ukraine)";
            }
            case "UG-101": {
                return "Kalangala (Uganda)";
            }
            case "UG-102": {
                return "Kampala (Uganda)";
            }
            case "UG-103": {
                return "Kiboga (Uganda)";
            }
            case "UG-104": {
                return "Luwero (Uganda)";
            }
            case "UG-105": {
                return "Masaka (Uganda)";
            }
            case "UG-106": {
                return "Mpigi (Uganda)";
            }
            case "UG-107": {
                return "Mubende (Uganda)";
            }
            case "UG-108": {
                return "Mukono (Uganda)";
            }
            case "UG-109": {
                return "Nakasongola (Uganda)";
            }
            case "UG-110": {
                return "Rakai (Uganda)";
            }
            case "UG-111": {
                return "Sembabule (Uganda)";
            }
            case "UG-112": {
                return "Kayunga (Uganda)";
            }
            case "UG-113": {
                return "Wakiso (Uganda)";
            }
            case "UG-114": {
                return "Mityana (Uganda)";
            }
            case "UG-115": {
                return "Nakaseke (Uganda)";
            }
            case "UG-116": {
                return "Lyantonde (Uganda)";
            }
            case "UG-117": {
                return "Buikwe (Uganda)";
            }
            case "UG-118": {
                return "Bukomansibi (Uganda)";
            }
            case "UG-119": {
                return "Butambala (Uganda)";
            }
            case "UG-120": {
                return "Buvuma (Uganda)";
            }
            case "UG-121": {
                return "Gomba (Uganda)";
            }
            case "UG-122": {
                return "Kalungu (Uganda)";
            }
            case "UG-123": {
                return "Kyankwanzi (Uganda)";
            }
            case "UG-124": {
                return "Lwengo (Uganda)";
            }
            case "UG-201": {
                return "Bugiri (Uganda)";
            }
            case "UG-202": {
                return "Busia (Uganda)";
            }
            case "UG-203": {
                return "Iganga (Uganda)";
            }
            case "UG-204": {
                return "Jinja (Uganda)";
            }
            case "UG-205": {
                return "Kamuli (Uganda)";
            }
            case "UG-206": {
                return "Kapchorwa (Uganda)";
            }
            case "UG-207": {
                return "Katakwi (Uganda)";
            }
            case "UG-208": {
                return "Kumi (Uganda)";
            }
            case "UG-209": {
                return "Mbale (Uganda)";
            }
            case "UG-210": {
                return "Pallisa (Uganda)";
            }
            case "UG-211": {
                return "Soroti (Uganda)";
            }
            case "UG-212": {
                return "Tororo (Uganda)";
            }
            case "UG-213": {
                return "Kaberamaido (Uganda)";
            }
            case "UG-214": {
                return "Mayuge (Uganda)";
            }
            case "UG-215": {
                return "Sironko (Uganda)";
            }
            case "UG-216": {
                return "Amuria (Uganda)";
            }
            case "UG-217": {
                return "Budaka (Uganda)";
            }
            case "UG-218": {
                return "Bukwa (Uganda)";
            }
            case "UG-219": {
                return "Butaleja (Uganda)";
            }
            case "UG-220": {
                return "Kaliro (Uganda)";
            }
            case "UG-221": {
                return "Manafwa (Uganda)";
            }
            case "UG-222": {
                return "Namutumba (Uganda)";
            }
            case "UG-223": {
                return "Bududa (Uganda)";
            }
            case "UG-224": {
                return "Bukedea (Uganda)";
            }
            case "UG-225": {
                return "Bulambuli (Uganda)";
            }
            case "UG-226": {
                return "Buyende (Uganda)";
            }
            case "UG-227": {
                return "Kibuku (Uganda)";
            }
            case "UG-228": {
                return "Kween (Uganda)";
            }
            case "UG-229": {
                return "Luuka (Uganda)";
            }
            case "UG-230": {
                return "Namayingo (Uganda)";
            }
            case "UG-231": {
                return "Ngora (Uganda)";
            }
            case "UG-232": {
                return "Serere (Uganda)";
            }
            case "UG-301": {
                return "Adjumani (Uganda)";
            }
            case "UG-302": {
                return "Apac (Uganda)";
            }
            case "UG-303": {
                return "Arua (Uganda)";
            }
            case "UG-304": {
                return "Gulu (Uganda)";
            }
            case "UG-305": {
                return "Kitgum (Uganda)";
            }
            case "UG-306": {
                return "Kotido (Uganda)";
            }
            case "UG-307": {
                return "Lira (Uganda)";
            }
            case "UG-308": {
                return "Moroto (Uganda)";
            }
            case "UG-309": {
                return "Moyo (Uganda)";
            }
            case "UG-310": {
                return "Nebbi (Uganda)";
            }
            case "UG-311": {
                return "Nakapiripirit (Uganda)";
            }
            case "UG-312": {
                return "Pader (Uganda)";
            }
            case "UG-313": {
                return "Yumbe (Uganda)";
            }
            case "UG-314": {
                return "Amolatar (Uganda)";
            }
            case "UG-315": {
                return "Kaabong (Uganda)";
            }
            case "UG-316": {
                return "Koboko (Uganda)";
            }
            case "UG-317": {
                return "Abim (Uganda)";
            }
            case "UG-318": {
                return "Dokolo (Uganda)";
            }
            case "UG-319": {
                return "Amuru (Uganda)";
            }
            case "UG-320": {
                return "Maracha (Uganda)";
            }
            case "UG-321": {
                return "Oyam (Uganda)";
            }
            case "UG-322": {
                return "Agago (Uganda)";
            }
            case "UG-323": {
                return "Alebtong (Uganda)";
            }
            case "UG-324": {
                return "Amudat (Uganda)";
            }
            case "UG-325": {
                return "Buhweju (Uganda)";
            }
            case "UG-326": {
                return "Kole (Uganda)";
            }
            case "UG-327": {
                return "Lamwo (Uganda)";
            }
            case "UG-328": {
                return "Napak (Uganda)";
            }
            case "UG-329": {
                return "Nwoya (Uganda)";
            }
            case "UG-330": {
                return "Otuke (Uganda)";
            }
            case "UG-331": {
                return "Zombo (Uganda)";
            }
            case "UG-401": {
                return "Bundibugyo (Uganda)";
            }
            case "UG-402": {
                return "Bushenyi (Uganda)";
            }
            case "UG-403": {
                return "Hoima (Uganda)";
            }
            case "UG-404": {
                return "Kabale (Uganda)";
            }
            case "UG-405": {
                return "Kabarole (Uganda)";
            }
            case "UG-406": {
                return "Kasese (Uganda)";
            }
            case "UG-407": {
                return "Kibaale (Uganda)";
            }
            case "UG-408": {
                return "Kisoro (Uganda)";
            }
            case "UG-409": {
                return "Masindi (Uganda)";
            }
            case "UG-410": {
                return "Mbarara (Uganda)";
            }
            case "UG-411": {
                return "Ntungamo (Uganda)";
            }
            case "UG-412": {
                return "Rukungiri (Uganda)";
            }
            case "UG-413": {
                return "Kamwenge (Uganda)";
            }
            case "UG-414": {
                return "Kanungu (Uganda)";
            }
            case "UG-415": {
                return "Kyenjojo (Uganda)";
            }
            case "UG-416": {
                return "Ibanda (Uganda)";
            }
            case "UG-417": {
                return "Isingiro (Uganda)";
            }
            case "UG-418": {
                return "Kiruhura (Uganda)";
            }
            case "UG-419": {
                return "Buliisa (Uganda)";
            }
            case "UG-420": {
                return "Kiryandongo (Uganda)";
            }
            case "UG-421": {
                return "Kyegegwa (Uganda)";
            }
            case "UG-422": {
                return "Mitooma (Uganda)";
            }
            case "UG-423": {
                return "Ntoroko (Uganda)";
            }
            case "UG-424": {
                return "Rubirizi (Uganda)";
            }
            case "UG-425": {
                return "Sheema (Uganda)";
            }
            case "UG-C": {
                return "Central (Uganda)";
            }
            case "UG-E": {
                return "Eastern (Uganda)";
            }
            case "UG-N": {
                return "Northern (Uganda)";
            }
            case "UG-W": {
                return "Western (Uganda)";
            }
            case "UM-67": {
                return "Johnston Atoll (United States Minor Outlying Islands)";
            }
            case "UM-71": {
                return "Midway Islands (United States Minor Outlying Islands)";
            }
            case "UM-76": {
                return "Navassa Island (United States Minor Outlying Islands)";
            }
            case "UM-79": {
                return "Wake Island (United States Minor Outlying Islands)";
            }
            case "UM-81": {
                return "Baker Island (United States Minor Outlying Islands)";
            }
            case "UM-84": {
                return "Howland Island (United States Minor Outlying Islands)";
            }
            case "UM-86": {
                return "Jarvis Island (United States Minor Outlying Islands)";
            }
            case "UM-89": {
                return "Kingman Reef (United States Minor Outlying Islands)";
            }
            case "UM-95": {
                return "Palmyra Atoll (United States Minor Outlying Islands)";
            }
            case "US-AK": {
                return "Alaska (United States)";
            }
            case "US-AL": {
                return "Alabama (United States)";
            }
            case "US-AR": {
                return "Arkansas (United States)";
            }
            case "US-AS": {
                return "American Samoa (United States)";
            }
            case "US-AZ": {
                return "Arizona (United States)";
            }
            case "US-CA": {
                return "California (United States)";
            }
            case "US-CO": {
                return "Colorado (United States)";
            }
            case "US-CT": {
                return "Connecticut (United States)";
            }
            case "US-DC": {
                return "District of Columbia (United States)";
            }
            case "US-DE": {
                return "Delaware (United States)";
            }
            case "US-FL": {
                return "Florida (United States)";
            }
            case "US-GA": {
                return "Georgia (United States)";
            }
            case "US-GU": {
                return "Guam (United States)";
            }
            case "US-HI": {
                return "Hawaii (United States)";
            }
            case "US-IA": {
                return "Iowa (United States)";
            }
            case "US-ID": {
                return "Idaho (United States)";
            }
            case "US-IL": {
                return "Illinois (United States)";
            }
            case "US-IN": {
                return "Indiana (United States)";
            }
            case "US-KS": {
                return "Kansas (United States)";
            }
            case "US-KY": {
                return "Kentucky (United States)";
            }
            case "US-LA": {
                return "Louisiana (United States)";
            }
            case "US-MA": {
                return "Massachusetts (United States)";
            }
            case "US-MD": {
                return "Maryland (United States)";
            }
            case "US-ME": {
                return "Maine (United States)";
            }
            case "US-MI": {
                return "Michigan (United States)";
            }
            case "US-MN": {
                return "Minnesota (United States)";
            }
            case "US-MO": {
                return "Missouri (United States)";
            }
            case "US-MP": {
                return "Northern Mariana Islands (United States)";
            }
            case "US-MS": {
                return "Mississippi (United States)";
            }
            case "US-MT": {
                return "Montana (United States)";
            }
            case "US-NC": {
                return "North Carolina (United States)";
            }
            case "US-ND": {
                return "North Dakota (United States)";
            }
            case "US-NE": {
                return "Nebraska (United States)";
            }
            case "US-NH": {
                return "New Hampshire (United States)";
            }
            case "US-NJ": {
                return "New Jersey (United States)";
            }
            case "US-NM": {
                return "New Mexico (United States)";
            }
            case "US-NV": {
                return "Nevada (United States)";
            }
            case "US-NY": {
                return "New York (United States)";
            }
            case "US-OH": {
                return "Ohio (United States)";
            }
            case "US-OK": {
                return "Oklahoma (United States)";
            }
            case "US-OR": {
                return "Oregon (United States)";
            }
            case "US-PA": {
                return "Pennsylvania (United States)";
            }
            case "US-PR": {
                return "Puerto Rico (United States)";
            }
            case "US-RI": {
                return "Rhode Island (United States)";
            }
            case "US-SC": {
                return "South Carolina (United States)";
            }
            case "US-SD": {
                return "South Dakota (United States)";
            }
            case "US-TN": {
                return "Tennessee (United States)";
            }
            case "US-TX": {
                return "Texas (United States)";
            }
            case "US-UM": {
                return "United States Minor Outlying Islands (United States)";
            }
            case "US-UT": {
                return "Utah (United States)";
            }
            case "US-VA": {
                return "Virginia (United States)";
            }
            case "US-VI": {
                return "Virgin Islands, U.S. (United States)";
            }
            case "US-VT": {
                return "Vermont (United States)";
            }
            case "US-WA": {
                return "Washington (United States)";
            }
            case "US-WI": {
                return "Wisconsin (United States)";
            }
            case "US-WV": {
                return "West Virginia (United States)";
            }
            case "US-WY": {
                return "Wyoming (United States)";
            }
            case "UY-AR": {
                return "Artigas (Uruguay)";
            }
            case "UY-CA": {
                return "Canelones (Uruguay)";
            }
            case "UY-CL": {
                return "Cerro Largo (Uruguay)";
            }
            case "UY-CO": {
                return "Colonia (Uruguay)";
            }
            case "UY-DU": {
                return "Durazno (Uruguay)";
            }
            case "UY-FD": {
                return "Florida (Uruguay)";
            }
            case "UY-FS": {
                return "Flores (Uruguay)";
            }
            case "UY-LA": {
                return "Lavalleja (Uruguay)";
            }
            case "UY-MA": {
                return "Maldonado (Uruguay)";
            }
            case "UY-MO": {
                return "Montevideo (Uruguay)";
            }
            case "UY-PA": {
                return "Paysand\u00fa (Uruguay)";
            }
            case "UY-RN": {
                return "R\u00edo Negro (Uruguay)";
            }
            case "UY-RO": {
                return "Rocha (Uruguay)";
            }
            case "UY-RV": {
                return "Rivera (Uruguay)";
            }
            case "UY-SA": {
                return "Salto (Uruguay)";
            }
            case "UY-SJ": {
                return "San Jos\u00e9 (Uruguay)";
            }
            case "UY-SO": {
                return "Soriano (Uruguay)";
            }
            case "UY-TA": {
                return "Tacuaremb\u00f3 (Uruguay)";
            }
            case "UY-TT": {
                return "Treinta y Tres (Uruguay)";
            }
            case "UZ-AN": {
                return "Andijon (Uzbekistan)";
            }
            case "UZ-BU": {
                return "Buxoro (Uzbekistan)";
            }
            case "UZ-FA": {
                return "Farg\u2018ona (Uzbekistan)";
            }
            case "UZ-JI": {
                return "Jizzax (Uzbekistan)";
            }
            case "UZ-NG": {
                return "Namangan (Uzbekistan)";
            }
            case "UZ-NW": {
                return "Navoiy (Uzbekistan)";
            }
            case "UZ-QA": {
                return "Qashqadaryo (Uzbekistan)";
            }
            case "UZ-QR": {
                return "Qoraqalpog\u2018iston Respublikasi (Uzbekistan)";
            }
            case "UZ-SA": {
                return "Samarqand (Uzbekistan)";
            }
            case "UZ-SI": {
                return "Sirdaryo (Uzbekistan)";
            }
            case "UZ-SU": {
                return "Surxondaryo (Uzbekistan)";
            }
            case "UZ-TK": {
                return "Toshkent (Uzbekistan)";
            }
            case "UZ-TO": {
                return "Toshkent (Uzbekistan)";
            }
            case "UZ-XO": {
                return "Xorazm (Uzbekistan)";
            }
            case "VA-VA": {
                return "Vatican City (Vatican City)";
            }
            case "VC-01": {
                return "Charlotte (Saint Vincent And The Grenadines)";
            }
            case "VC-02": {
                return "Saint Andrew (Saint Vincent And The Grenadines)";
            }
            case "VC-03": {
                return "Saint David (Saint Vincent And The Grenadines)";
            }
            case "VC-04": {
                return "Saint George (Saint Vincent And The Grenadines)";
            }
            case "VC-05": {
                return "Saint Patrick (Saint Vincent And The Grenadines)";
            }
            case "VC-06": {
                return "Grenadines (Saint Vincent And The Grenadines)";
            }
            case "VE-A": {
                return "Distrito Capital (Venezuela)";
            }
            case "VE-B": {
                return "Anzo\u00e1tegui (Venezuela)";
            }
            case "VE-C": {
                return "Apure (Venezuela)";
            }
            case "VE-D": {
                return "Aragua (Venezuela)";
            }
            case "VE-E": {
                return "Barinas (Venezuela)";
            }
            case "VE-F": {
                return "Bol\u00edvar (Venezuela)";
            }
            case "VE-G": {
                return "Carabobo (Venezuela)";
            }
            case "VE-H": {
                return "Cojedes (Venezuela)";
            }
            case "VE-I": {
                return "Falc\u00f3n (Venezuela)";
            }
            case "VE-J": {
                return "Gu\u00e1rico (Venezuela)";
            }
            case "VE-K": {
                return "Lara (Venezuela)";
            }
            case "VE-L": {
                return "M\u00e9rida (Venezuela)";
            }
            case "VE-M": {
                return "Miranda (Venezuela)";
            }
            case "VE-N": {
                return "Monagas (Venezuela)";
            }
            case "VE-O": {
                return "Nueva Esparta (Venezuela)";
            }
            case "VE-P": {
                return "Portuguesa (Venezuela)";
            }
            case "VE-R": {
                return "Sucre (Venezuela)";
            }
            case "VE-S": {
                return "T\u00e1chira (Venezuela)";
            }
            case "VE-T": {
                return "Trujillo (Venezuela)";
            }
            case "VE-U": {
                return "Yaracuy (Venezuela)";
            }
            case "VE-V": {
                return "Zulia (Venezuela)";
            }
            case "VE-W": {
                return "Dependencias Federales (Venezuela)";
            }
            case "VE-X": {
                return "Vargas (Venezuela)";
            }
            case "VE-Y": {
                return "Delta Amacuro (Venezuela)";
            }
            case "VE-Z": {
                return "Amazonas (Venezuela)";
            }
            case "VG-VG": {
                return "Virgin Islands (Virgin Islands)";
            }
            case "VI-VI": {
                return "Virgin Islands (Virgin Islands)";
            }
            case "VN-01": {
                return "Lai Ch\u00e2u (Viet Nam)";
            }
            case "VN-02": {
                return "L\u00e0o Cai (Viet Nam)";
            }
            case "VN-03": {
                return "H\u00e0 Giang (Viet Nam)";
            }
            case "VN-04": {
                return "Cao B\u1eb1ng (Viet Nam)";
            }
            case "VN-05": {
                return "S\u01a1n La (Viet Nam)";
            }
            case "VN-06": {
                return "Y\u00ean B\u00e1i (Viet Nam)";
            }
            case "VN-07": {
                return "Tuy\u00ean Quang (Viet Nam)";
            }
            case "VN-09": {
                return "L\u1ea1ng S\u01a1n (Viet Nam)";
            }
            case "VN-13": {
                return "Qu\u1ea3ng Ninh (Viet Nam)";
            }
            case "VN-14": {
                return "H\u00f2a B\u00ecnh (Viet Nam)";
            }
            case "VN-18": {
                return "Ninh B\u00ecnh (Viet Nam)";
            }
            case "VN-20": {
                return "Th\u00e1i B\u00ecnh (Viet Nam)";
            }
            case "VN-21": {
                return "Thanh H\u00f3a (Viet Nam)";
            }
            case "VN-22": {
                return "Ngh\u1ec7 An (Viet Nam)";
            }
            case "VN-23": {
                return "H\u00e0 T\u0129nh (Viet Nam)";
            }
            case "VN-24": {
                return "Qu\u1ea3ng B\u00ecnh (Viet Nam)";
            }
            case "VN-25": {
                return "Qu\u1ea3ng Tr\u1ecb (Viet Nam)";
            }
            case "VN-26": {
                return "Th\u1eeba Thi\u00ean-Hu\u1ebf (Viet Nam)";
            }
            case "VN-27": {
                return "Qu\u1ea3ng Nam (Viet Nam)";
            }
            case "VN-28": {
                return "Kon Tum (Viet Nam)";
            }
            case "VN-29": {
                return "Qu\u1ea3ng Ng\u00e3i (Viet Nam)";
            }
            case "VN-30": {
                return "Gia Lai (Viet Nam)";
            }
            case "VN-31": {
                return "B\u00ecnh \u0110\u1ecbnh (Viet Nam)";
            }
            case "VN-32": {
                return "Ph\u00fa Y\u00ean (Viet Nam)";
            }
            case "VN-33": {
                return "\u0110\u1eafk L\u1eafk (Viet Nam)";
            }
            case "VN-34": {
                return "Kh\u00e1nh H\u00f2a (Viet Nam)";
            }
            case "VN-35": {
                return "L\u00e2m \u00d0\u1ed3ng (Viet Nam)";
            }
            case "VN-36": {
                return "Ninh Thu\u1eadn (Viet Nam)";
            }
            case "VN-37": {
                return "T\u00e2y Ninh (Viet Nam)";
            }
            case "VN-39": {
                return "\u00d0\u1ed3ng Nai (Viet Nam)";
            }
            case "VN-40": {
                return "B\u00ecnh Thu\u1eadn (Viet Nam)";
            }
            case "VN-41": {
                return "Long An (Viet Nam)";
            }
            case "VN-43": {
                return "B\u00e0 R\u1ecba - V\u0169ng T\u00e0u (Viet Nam)";
            }
            case "VN-44": {
                return "An Giang (Viet Nam)";
            }
            case "VN-45": {
                return "\u00d0\u1ed3ng Th\u00e1p (Viet Nam)";
            }
            case "VN-46": {
                return "Ti\u1ec1n Giang (Viet Nam)";
            }
            case "VN-47": {
                return "Ki\u1ebfn Giang (Viet Nam)";
            }
            case "VN-49": {
                return "V\u0129nh Long (Viet Nam)";
            }
            case "VN-50": {
                return "B\u1ebfn Tre (Viet Nam)";
            }
            case "VN-51": {
                return "Tr\u00e0 Vinh (Viet Nam)";
            }
            case "VN-52": {
                return "S\u00f3c Tr\u0103ng (Viet Nam)";
            }
            case "VN-53": {
                return "B\u1eafc K\u1ea1n (Viet Nam)";
            }
            case "VN-54": {
                return "B\u1eafc Giang (Viet Nam)";
            }
            case "VN-55": {
                return "B\u1ea1c Li\u00eau (Viet Nam)";
            }
            case "VN-56": {
                return "B\u1eafc Ninh (Viet Nam)";
            }
            case "VN-57": {
                return "B\u00ecnh D\u01b0\u01a1ng (Viet Nam)";
            }
            case "VN-58": {
                return "B\u00ecnh Ph\u01b0\u1edbc (Viet Nam)";
            }
            case "VN-59": {
                return "C\u00e0 Mau (Viet Nam)";
            }
            case "VN-61": {
                return "H\u1ea3i D\u01b0\u01a1ng (Viet Nam)";
            }
            case "VN-63": {
                return "H\u00e0 Nam (Viet Nam)";
            }
            case "VN-66": {
                return "H\u01b0ng Y\u00ean (Viet Nam)";
            }
            case "VN-67": {
                return "Nam \u00d0\u1ecbnh (Viet Nam)";
            }
            case "VN-68": {
                return "Ph\u00fa Th\u1ecd (Viet Nam)";
            }
            case "VN-69": {
                return "Th\u00e1i Nguy\u00ean (Viet Nam)";
            }
            case "VN-70": {
                return "V\u0129nh Ph\u00fac (Viet Nam)";
            }
            case "VN-71": {
                return "\u0110i\u1ec7n Bi\u00ean (Viet Nam)";
            }
            case "VN-72": {
                return "\u0110\u1eafk N\u00f4ng (Viet Nam)";
            }
            case "VN-73": {
                return "H\u1eadu Giang (Viet Nam)";
            }
            case "VN-CT": {
                return "Can Tho (Viet Nam)";
            }
            case "VN-DN": {
                return "Da Nang (Viet Nam)";
            }
            case "VN-HN": {
                return "Ha Noi (Viet Nam)";
            }
            case "VN-HP": {
                return "Hai Phong (Viet Nam)";
            }
            case "VN-SG": {
                return "Ho Chi Minh (Viet Nam)";
            }
            case "VU-MAP": {
                return "Malampa (Vanuatu)";
            }
            case "VU-PAM": {
                return "P\u00e9nama (Vanuatu)";
            }
            case "VU-SAM": {
                return "Sanma (Vanuatu)";
            }
            case "VU-SEE": {
                return "Sh\u00e9fa (Vanuatu)";
            }
            case "VU-TAE": {
                return "Taf\u00e9a (Vanuatu)";
            }
            case "VU-TOB": {
                return "Torba (Vanuatu)";
            }
            case "WF-WF": {
                return "Wallis & Futuna Islands (Wallis & Futuna Islands)";
            }
            case "WS-AA": {
                return "A'ana (Samoa)";
            }
            case "WS-AL": {
                return "Aiga-i-le-Tai (Samoa)";
            }
            case "WS-AT": {
                return "Atua (Samoa)";
            }
            case "WS-FA": {
                return "Fa'asaleleaga (Samoa)";
            }
            case "WS-GE": {
                return "Gaga'emauga (Samoa)";
            }
            case "WS-GI": {
                return "Gagaifomauga (Samoa)";
            }
            case "WS-PA": {
                return "Palauli (Samoa)";
            }
            case "WS-SA": {
                return "Satupa'itea (Samoa)";
            }
            case "WS-TU": {
                return "Tuamasaga (Samoa)";
            }
            case "WS-VF": {
                return "Va'a-o-Fonoti (Samoa)";
            }
            case "WS-VS": {
                return "Vaisigano (Samoa)";
            }
            case "YE-AB": {
                return "Aby\u0101n (Yemen)";
            }
            case "YE-AD": {
                return "'Adan (Yemen)";
            }
            case "YE-AM": {
                return "'Amr\u0101n (Yemen)";
            }
            case "YE-BA": {
                return "Al Bay\u1e11\u0101' (Yemen)";
            }
            case "YE-DA": {
                return "A\u1e11 \u1e10\u0101li' (Yemen)";
            }
            case "YE-DH": {
                return "Dham\u0101r (Yemen)";
            }
            case "YE-HD": {
                return "\u1e28a\u1e11ramawt (Yemen)";
            }
            case "YE-HJ": {
                return "\u1e28ajjah (Yemen)";
            }
            case "YE-HU": {
                return "Al \u1e28udaydah (Yemen)";
            }
            case "YE-IB": {
                return "Ibb (Yemen)";
            }
            case "YE-JA": {
                return "Al Jawf (Yemen)";
            }
            case "YE-LA": {
                return "La\u1e29ij (Yemen)";
            }
            case "YE-MA": {
                return "Ma'rib (Yemen)";
            }
            case "YE-MR": {
                return "Al Mahrah (Yemen)";
            }
            case "YE-MW": {
                return "Al Ma\u1e29w\u012bt (Yemen)";
            }
            case "YE-RA": {
                return "Raymah (Yemen)";
            }
            case "YE-SA": {
                return "Am\u0101nat al \u2018\u0100\u015fimah (Yemen)";
            }
            case "YE-SD": {
                return "\u015e\u0101\u02bbdah (Yemen)";
            }
            case "YE-SH": {
                return "Shabwah (Yemen)";
            }
            case "YE-SN": {
                return "\u015ean\u02bb\u0101' (Yemen)";
            }
            case "YE-TA": {
                return "T\u0101\u02bbizz (Yemen)";
            }
            case "YT-YT": {
                return "Mayotte (Mayotte)";
            }
            case "ZA-EC": {
                return "Eastern Cape (South Africa)";
            }
            case "ZA-FS": {
                return "Foreisetata (South Africa)";
            }
            case "ZA-GT": {
                return "Gauteng (South Africa)";
            }
            case "ZA-LP": {
                return "Limpopo (South Africa)";
            }
            case "ZA-MP": {
                return "iMpumalanga (South Africa)";
            }
            case "ZA-NC": {
                return "iTlhagwini-Kapa (South Africa)";
            }
            case "ZA-NL": {
                return "GaZulu-Natala (South Africa)";
            }
            case "ZA-NW": {
                return "Bokone Bophirima (South Africa)";
            }
            case "ZA-WC": {
                return "iTjhingalanga-Kapa (South Africa)";
            }
            case "ZM-01": {
                return "Western (Zambia)";
            }
            case "ZM-02": {
                return "Central (Zambia)";
            }
            case "ZM-03": {
                return "Eastern (Zambia)";
            }
            case "ZM-04": {
                return "Luapula (Zambia)";
            }
            case "ZM-05": {
                return "Northern (Zambia)";
            }
            case "ZM-06": {
                return "North-Western (Zambia)";
            }
            case "ZM-07": {
                return "Southern (Zambia)";
            }
            case "ZM-08": {
                return "Copperbelt (Zambia)";
            }
            case "ZM-09": {
                return "Lusaka (Zambia)";
            }
            case "ZM-10": {
                return "Muchinga (Zambia)";
            }
            case "ZW-BU": {
                return "Bulawayo (Zimbabwe)";
            }
            case "ZW-HA": {
                return "Harare (Zimbabwe)";
            }
            case "ZW-MA": {
                return "Manicaland (Zimbabwe)";
            }
            case "ZW-MC": {
                return "Mashonaland Central (Zimbabwe)";
            }
            case "ZW-ME": {
                return "Mashonaland East (Zimbabwe)";
            }
            case "ZW-MI": {
                return "Midlands (Zimbabwe)";
            }
            case "ZW-MN": {
                return "Matabeleland North (Zimbabwe)";
            }
            case "ZW-MS": {
                return "Matabeleland South (Zimbabwe)";
            }
            case "ZW-MV": {
                return "Masvingo (Zimbabwe)";
            }
            case "ZW-MW": {
                return "Mashonaland West (Zimbabwe)";
            }
        }
        return "Unknown state code '" + c.getCode() + "'";
    }

    private static String country(Coding c) {
        switch (c.getCode()) {
            case "AD": {
                return "Andorra";
            }
            case "AE": {
                return "United Arab Emirates";
            }
            case "AF": {
                return "Afghanistan";
            }
            case "AG": {
                return "Antigua and Barbuda";
            }
            case "AI": {
                return "Anguilla";
            }
            case "AL": {
                return "Albania";
            }
            case "AM": {
                return "Armenia";
            }
            case "AO": {
                return "Angola";
            }
            case "AQ": {
                return "Antarctica";
            }
            case "AR": {
                return "Argentina";
            }
            case "AS": {
                return "American Samoa";
            }
            case "AT": {
                return "Austria";
            }
            case "AU": {
                return "Australia";
            }
            case "AW": {
                return "Aruba";
            }
            case "AX": {
                return "Eland Islands";
            }
            case "AZ": {
                return "Azerbaijan";
            }
            case "BA": {
                return "Bosnia and Herzegovina";
            }
            case "BB": {
                return "Barbados";
            }
            case "BD": {
                return "Bangladesh";
            }
            case "BE": {
                return "Belgium";
            }
            case "BF": {
                return "Burkina Faso";
            }
            case "BG": {
                return "Bulgaria";
            }
            case "BH": {
                return "Bahrain";
            }
            case "BI": {
                return "Burundi";
            }
            case "BJ": {
                return "Benin";
            }
            case "BL": {
                return "Saint Barthilemy";
            }
            case "BM": {
                return "Bermuda";
            }
            case "BN": {
                return "Brunei Darussalam";
            }
            case "BO": {
                return "Bolivia, Plurinational State of";
            }
            case "BQ": {
                return "Bonaire, Sint Eustatius and Saba";
            }
            case "BR": {
                return "Brazil";
            }
            case "BS": {
                return "Bahamas";
            }
            case "BT": {
                return "Bhutan";
            }
            case "BV": {
                return "Bouvet Island";
            }
            case "BW": {
                return "Botswana";
            }
            case "BY": {
                return "Belarus";
            }
            case "BZ": {
                return "Belize";
            }
            case "CA": {
                return "Canada";
            }
            case "CC": {
                return "Cocos (Keeling) Islands";
            }
            case "CD": {
                return "Congo, the Democratic Republic of the";
            }
            case "CF": {
                return "Central African Republic";
            }
            case "CG": {
                return "Congo";
            }
            case "CH": {
                return "Switzerland";
            }
            case "CI": {
                return "Ctte d'Ivoire";
            }
            case "CK": {
                return "Cook Islands";
            }
            case "CL": {
                return "Chile";
            }
            case "CM": {
                return "Cameroon";
            }
            case "CN": {
                return "China";
            }
            case "CO": {
                return "Colombia";
            }
            case "CR": {
                return "Costa Rica";
            }
            case "CU": {
                return "Cuba";
            }
            case "CV": {
                return "Cabo Verde";
            }
            case "CW": {
                return "Curagao";
            }
            case "CX": {
                return "Christmas Island";
            }
            case "CY": {
                return "Cyprus";
            }
            case "CZ": {
                return "Czechia";
            }
            case "DE": {
                return "Germany";
            }
            case "DJ": {
                return "Djibouti";
            }
            case "DK": {
                return "Denmark";
            }
            case "DM": {
                return "Dominica";
            }
            case "DO": {
                return "Dominican Republic";
            }
            case "DZ": {
                return "Algeria";
            }
            case "EC": {
                return "Ecuador";
            }
            case "EE": {
                return "Estonia";
            }
            case "EG": {
                return "Egypt";
            }
            case "EH": {
                return "Western Sahara";
            }
            case "ER": {
                return "Eritrea";
            }
            case "ES": {
                return "Spain";
            }
            case "ET": {
                return "Ethiopia";
            }
            case "FI": {
                return "Finland";
            }
            case "FJ": {
                return "Fiji";
            }
            case "FK": {
                return "Falkland Islands (Malvinas)";
            }
            case "FM": {
                return "Micronesia, Federated States of";
            }
            case "FO": {
                return "Faroe Islands";
            }
            case "FR": {
                return "France";
            }
            case "GA": {
                return "Gabon";
            }
            case "GB": {
                return "United Kingdom of Great Britain and Northern Ireland";
            }
            case "GD": {
                return "Grenada";
            }
            case "GE": {
                return "Georgia";
            }
            case "GF": {
                return "French Guiana";
            }
            case "GG": {
                return "Guernsey";
            }
            case "GH": {
                return "Ghana";
            }
            case "GI": {
                return "Gibraltar";
            }
            case "GL": {
                return "Greenland";
            }
            case "GM": {
                return "Gambia";
            }
            case "GN": {
                return "Guinea";
            }
            case "GP": {
                return "Guadeloupe";
            }
            case "GQ": {
                return "Equatorial Guinea";
            }
            case "GR": {
                return "Greece";
            }
            case "GS": {
                return "South Georgia and the South Sandwich Islands";
            }
            case "GT": {
                return "Guatemala";
            }
            case "GU": {
                return "Guam";
            }
            case "GW": {
                return "Guinea-Bissau";
            }
            case "GY": {
                return "Guyana";
            }
            case "HK": {
                return "Hong Kong";
            }
            case "HM": {
                return "Heard Island and McDonald Islands";
            }
            case "HN": {
                return "Honduras";
            }
            case "HR": {
                return "Croatia";
            }
            case "HT": {
                return "Haiti";
            }
            case "HU": {
                return "Hungary";
            }
            case "ID": {
                return "Indonesia";
            }
            case "IE": {
                return "Ireland";
            }
            case "IL": {
                return "Israel";
            }
            case "IM": {
                return "Isle of Man";
            }
            case "IN": {
                return "India";
            }
            case "IO": {
                return "British Indian Ocean Territory";
            }
            case "IQ": {
                return "Iraq";
            }
            case "IR": {
                return "Iran, Islamic Republic of";
            }
            case "IS": {
                return "Iceland";
            }
            case "IT": {
                return "Italy";
            }
            case "JE": {
                return "Jersey";
            }
            case "JM": {
                return "Jamaica";
            }
            case "JO": {
                return "Jordan";
            }
            case "JP": {
                return "Japan";
            }
            case "KE": {
                return "Kenya";
            }
            case "KG": {
                return "Kyrgyzstan";
            }
            case "KH": {
                return "Cambodia";
            }
            case "KI": {
                return "Kiribati";
            }
            case "KM": {
                return "Comoros";
            }
            case "KN": {
                return "Saint Kitts and Nevis";
            }
            case "KP": {
                return "Korea, Democratic People's Republic of";
            }
            case "KR": {
                return "Korea, Republic of";
            }
            case "KW": {
                return "Kuwait";
            }
            case "KY": {
                return "Cayman Islands";
            }
            case "KZ": {
                return "Kazakhstan";
            }
            case "LA": {
                return "Lao People's Democratic Republic";
            }
            case "LB": {
                return "Lebanon";
            }
            case "LC": {
                return "Saint Lucia";
            }
            case "LI": {
                return "Liechtenstein";
            }
            case "LK": {
                return "Sri Lanka";
            }
            case "LR": {
                return "Liberia";
            }
            case "LS": {
                return "Lesotho";
            }
            case "LT": {
                return "Lithuania";
            }
            case "LU": {
                return "Luxembourg";
            }
            case "LV": {
                return "Latvia";
            }
            case "LY": {
                return "Libya";
            }
            case "MA": {
                return "Morocco";
            }
            case "MC": {
                return "Monaco";
            }
            case "MD": {
                return "Moldova, Republic of";
            }
            case "ME": {
                return "Montenegro";
            }
            case "MF": {
                return "Saint Martin (French part)";
            }
            case "MG": {
                return "Madagascar";
            }
            case "MH": {
                return "Marshall Islands";
            }
            case "MK": {
                return "Macedonia, the former Yugoslav Republic of";
            }
            case "ML": {
                return "Mali";
            }
            case "MM": {
                return "Myanmar";
            }
            case "MN": {
                return "Mongolia";
            }
            case "MO": {
                return "Macao";
            }
            case "MP": {
                return "Northern Mariana Islands";
            }
            case "MQ": {
                return "Martinique";
            }
            case "MR": {
                return "Mauritania";
            }
            case "MS": {
                return "Montserrat";
            }
            case "MT": {
                return "Malta";
            }
            case "MU": {
                return "Mauritius";
            }
            case "MV": {
                return "Maldives";
            }
            case "MW": {
                return "Malawi";
            }
            case "MX": {
                return "Mexico";
            }
            case "MY": {
                return "Malaysia";
            }
            case "MZ": {
                return "Mozambique";
            }
            case "NA": {
                return "Namibia";
            }
            case "NC": {
                return "New Caledonia";
            }
            case "NE": {
                return "Niger";
            }
            case "NF": {
                return "Norfolk Island";
            }
            case "NG": {
                return "Nigeria";
            }
            case "NI": {
                return "Nicaragua";
            }
            case "NL": {
                return "Netherlands";
            }
            case "NO": {
                return "Norway";
            }
            case "NP": {
                return "Nepal";
            }
            case "NR": {
                return "Nauru";
            }
            case "NU": {
                return "Niue";
            }
            case "NZ": {
                return "New Zealand";
            }
            case "OM": {
                return "Oman";
            }
            case "PA": {
                return "Panama";
            }
            case "PE": {
                return "Peru";
            }
            case "PF": {
                return "French Polynesia";
            }
            case "PG": {
                return "Papua New Guinea";
            }
            case "PH": {
                return "Philippines";
            }
            case "PK": {
                return "Pakistan";
            }
            case "PL": {
                return "Poland";
            }
            case "PM": {
                return "Saint Pierre and Miquelon";
            }
            case "PN": {
                return "Pitcairn";
            }
            case "PR": {
                return "Puerto Rico";
            }
            case "PS": {
                return "Palestine, State of";
            }
            case "PT": {
                return "Portugal";
            }
            case "PW": {
                return "Palau";
            }
            case "PY": {
                return "Paraguay";
            }
            case "QA": {
                return "Qatar";
            }
            case "RE": {
                return "Riunion";
            }
            case "RO": {
                return "Romania";
            }
            case "RS": {
                return "Serbia";
            }
            case "RU": {
                return "Russian Federation";
            }
            case "RW": {
                return "Rwanda";
            }
            case "SA": {
                return "Saudi Arabia";
            }
            case "SB": {
                return "Solomon Islands";
            }
            case "SC": {
                return "Seychelles";
            }
            case "SD": {
                return "Sudan";
            }
            case "SE": {
                return "Sweden";
            }
            case "SG": {
                return "Singapore";
            }
            case "SH": {
                return "Saint Helena, Ascension and Tristan da Cunha";
            }
            case "SI": {
                return "Slovenia";
            }
            case "SJ": {
                return "Svalbard and Jan Mayen";
            }
            case "SK": {
                return "Slovakia";
            }
            case "SL": {
                return "Sierra Leone";
            }
            case "SM": {
                return "San Marino";
            }
            case "SN": {
                return "Senegal";
            }
            case "SO": {
                return "Somalia";
            }
            case "SR": {
                return "Suriname";
            }
            case "SS": {
                return "South Sudan";
            }
            case "ST": {
                return "Sao Tome and Principe";
            }
            case "SV": {
                return "El Salvador";
            }
            case "SX": {
                return "Sint Maarten (Dutch part)";
            }
            case "SY": {
                return "Syrian Arab Republic";
            }
            case "SZ": {
                return "Swaziland";
            }
            case "TC": {
                return "Turks and Caicos Islands";
            }
            case "TD": {
                return "Chad";
            }
            case "TF": {
                return "French Southern Territories";
            }
            case "TG": {
                return "Togo";
            }
            case "TH": {
                return "Thailand";
            }
            case "TJ": {
                return "Tajikistan";
            }
            case "TK": {
                return "Tokelau";
            }
            case "TL": {
                return "Timor-Leste";
            }
            case "TM": {
                return "Turkmenistan";
            }
            case "TN": {
                return "Tunisia";
            }
            case "TO": {
                return "Tonga";
            }
            case "TR": {
                return "Turkey";
            }
            case "TT": {
                return "Trinidad and Tobago";
            }
            case "TV": {
                return "Tuvalu";
            }
            case "TW": {
                return "Taiwan, Province of China";
            }
            case "TZ": {
                return "Tanzania, United Republic of";
            }
            case "UA": {
                return "Ukraine";
            }
            case "UG": {
                return "Uganda";
            }
            case "UM": {
                return "United States Minor Outlying Islands";
            }
            case "US": {
                return "United States of America";
            }
            case "UY": {
                return "Uruguay";
            }
            case "UZ": {
                return "Uzbekistan";
            }
            case "VA": {
                return "Holy See";
            }
            case "VC": {
                return "Saint Vincent and the Grenadines";
            }
            case "VE": {
                return "Venezuela, Bolivarian Republic of";
            }
            case "VG": {
                return "Virgin Islands, British";
            }
            case "VI": {
                return "Virgin Islands,";
            }
            case "VN": {
                return "Viet Nam";
            }
            case "VU": {
                return "Vanuatu";
            }
            case "WF": {
                return "Wallis and Futuna";
            }
            case "WS": {
                return "Samoa";
            }
            case "YE": {
                return "Yemen";
            }
            case "YT": {
                return "Mayotte";
            }
            case "ZA": {
                return "South Africa";
            }
            case "ZM": {
                return "Zambia";
            }
            case "ZW": {
                return "Zimbabwe";
            }
            case "ABW": {
                return "Aruba";
            }
            case "AFG": {
                return "Afghanistan";
            }
            case "AGO": {
                return "Angola";
            }
            case "AIA": {
                return "Anguilla";
            }
            case "ALA": {
                return "Eland Islands";
            }
            case "ALB": {
                return "Albania";
            }
            case "AND": {
                return "Andorra";
            }
            case "ARE": {
                return "United Arab Emirates";
            }
            case "ARG": {
                return "Argentina";
            }
            case "ARM": {
                return "Armenia";
            }
            case "ASM": {
                return "American Samoa";
            }
            case "ATA": {
                return "Antarctica";
            }
            case "ATF": {
                return "French Southern Territories";
            }
            case "ATG": {
                return "Antigua and Barbuda";
            }
            case "AUS": {
                return "Australia";
            }
            case "AUT": {
                return "Austria";
            }
            case "AZE": {
                return "Azerbaijan";
            }
            case "BDI": {
                return "Burundi";
            }
            case "BEL": {
                return "Belgium";
            }
            case "BEN": {
                return "Benin";
            }
            case "BES": {
                return "Bonaire, Sint Eustatius and Saba";
            }
            case "BFA": {
                return "Burkina Faso";
            }
            case "BGD": {
                return "Bangladesh";
            }
            case "BGR": {
                return "Bulgaria";
            }
            case "BHR": {
                return "Bahrain";
            }
            case "BHS": {
                return "Bahamas";
            }
            case "BIH": {
                return "Bosnia and Herzegovina";
            }
            case "BLM": {
                return "Saint Barthilemy";
            }
            case "BLR": {
                return "Belarus";
            }
            case "BLZ": {
                return "Belize";
            }
            case "BMU": {
                return "Bermuda";
            }
            case "BOL": {
                return "Bolivia, Plurinational State of";
            }
            case "BRA": {
                return "Brazil";
            }
            case "BRB": {
                return "Barbados";
            }
            case "BRN": {
                return "Brunei Darussalam";
            }
            case "BTN": {
                return "Bhutan";
            }
            case "BVT": {
                return "Bouvet Island";
            }
            case "BWA": {
                return "Botswana";
            }
            case "CAF": {
                return "Central African Republic";
            }
            case "CAN": {
                return "Canada";
            }
            case "CCK": {
                return "Cocos (Keeling) Islands";
            }
            case "CHE": {
                return "Switzerland";
            }
            case "CHL": {
                return "Chile";
            }
            case "CHN": {
                return "China";
            }
            case "CIV": {
                return "Ctte d'Ivoire";
            }
            case "CMR": {
                return "Cameroon";
            }
            case "COD": {
                return "Congo, the Democratic Republic of the";
            }
            case "COG": {
                return "Congo";
            }
            case "COK": {
                return "Cook Islands";
            }
            case "COL": {
                return "Colombia";
            }
            case "COM": {
                return "Comoros";
            }
            case "CPV": {
                return "Cabo Verde";
            }
            case "CRI": {
                return "Costa Rica";
            }
            case "CUB": {
                return "Cuba";
            }
            case "CUW": {
                return "Curagao";
            }
            case "CXR": {
                return "Christmas Island";
            }
            case "CYM": {
                return "Cayman Islands";
            }
            case "CYP": {
                return "Cyprus";
            }
            case "CZE": {
                return "Czechia";
            }
            case "DEU": {
                return "Germany";
            }
            case "DJI": {
                return "Djibouti";
            }
            case "DMA": {
                return "Dominica";
            }
            case "DNK": {
                return "Denmark";
            }
            case "DOM": {
                return "Dominican Republic";
            }
            case "DZA": {
                return "Algeria";
            }
            case "ECU": {
                return "Ecuador";
            }
            case "EGY": {
                return "Egypt";
            }
            case "ERI": {
                return "Eritrea";
            }
            case "ESH": {
                return "Western Sahara";
            }
            case "ESP": {
                return "Spain";
            }
            case "EST": {
                return "Estonia";
            }
            case "ETH": {
                return "Ethiopia";
            }
            case "FIN": {
                return "Finland";
            }
            case "FJI": {
                return "Fiji";
            }
            case "FLK": {
                return "Falkland Islands (Malvinas)";
            }
            case "FRA": {
                return "France";
            }
            case "FRO": {
                return "Faroe Islands";
            }
            case "FSM": {
                return "Micronesia, Federated States of";
            }
            case "GAB": {
                return "Gabon";
            }
            case "GBR": {
                return "United Kingdom";
            }
            case "GEO": {
                return "Georgia";
            }
            case "GGY": {
                return "Guernsey";
            }
            case "GHA": {
                return "Ghana";
            }
            case "GIB": {
                return "Gibraltar";
            }
            case "GIN": {
                return "Guinea";
            }
            case "GLP": {
                return "Guadeloupe";
            }
            case "GMB": {
                return "Gambia";
            }
            case "GNB": {
                return "Guinea-Bissau";
            }
            case "GNQ": {
                return "Equatorial Guinea";
            }
            case "GRC": {
                return "Greece";
            }
            case "GRD": {
                return "Grenada";
            }
            case "GRL": {
                return "Greenland";
            }
            case "GTM": {
                return "Guatemala";
            }
            case "GUF": {
                return "French Guiana";
            }
            case "GUM": {
                return "Guam";
            }
            case "GUY": {
                return "Guyana";
            }
            case "HKG": {
                return "Hong Kong";
            }
            case "HMD": {
                return "Heard Island and McDonald Islands";
            }
            case "HND": {
                return "Honduras";
            }
            case "HRV": {
                return "Croatia";
            }
            case "HTI": {
                return "Haiti";
            }
            case "HUN": {
                return "Hungary";
            }
            case "IDN": {
                return "Indonesia";
            }
            case "IMN": {
                return "Isle of Man";
            }
            case "IND": {
                return "India";
            }
            case "IOT": {
                return "British Indian Ocean Territory";
            }
            case "IRL": {
                return "Ireland";
            }
            case "IRN": {
                return "Iran, Islamic Republic of";
            }
            case "IRQ": {
                return "Iraq";
            }
            case "ISL": {
                return "Iceland";
            }
            case "ISR": {
                return "Israel";
            }
            case "ITA": {
                return "Italy";
            }
            case "JAM": {
                return "Jamaica";
            }
            case "JEY": {
                return "Jersey";
            }
            case "JOR": {
                return "Jordan";
            }
            case "JPN": {
                return "Japan";
            }
            case "KAZ": {
                return "Kazakhstan";
            }
            case "KEN": {
                return "Kenya";
            }
            case "KGZ": {
                return "Kyrgyzstan";
            }
            case "KHM": {
                return "Cambodia";
            }
            case "KIR": {
                return "Kiribati";
            }
            case "KNA": {
                return "Saint Kitts and Nevis";
            }
            case "KOR": {
                return "Korea, Republic of";
            }
            case "KWT": {
                return "Kuwait";
            }
            case "LAO": {
                return "Lao People's Democratic Republic";
            }
            case "LBN": {
                return "Lebanon";
            }
            case "LBR": {
                return "Liberia";
            }
            case "LBY": {
                return "Libya";
            }
            case "LCA": {
                return "Saint Lucia";
            }
            case "LIE": {
                return "Liechtenstein";
            }
            case "LKA": {
                return "Sri Lanka";
            }
            case "LSO": {
                return "Lesotho";
            }
            case "LTU": {
                return "Lithuania";
            }
            case "LUX": {
                return "Luxembourg";
            }
            case "LVA": {
                return "Latvia";
            }
            case "MAC": {
                return "Macao";
            }
            case "MAF": {
                return "Saint Martin (French part)";
            }
            case "MAR": {
                return "Morocco";
            }
            case "MCO": {
                return "Monaco";
            }
            case "MDA": {
                return "Moldova, Republic of";
            }
            case "MDG": {
                return "Madagascar";
            }
            case "MDV": {
                return "Maldives";
            }
            case "MEX": {
                return "Mexico";
            }
            case "MHL": {
                return "Marshall Islands";
            }
            case "MKD": {
                return "Macedonia, the former Yugoslav Republic of";
            }
            case "MLI": {
                return "Mali";
            }
            case "MLT": {
                return "Malta";
            }
            case "MMR": {
                return "Myanmar";
            }
            case "MNE": {
                return "Montenegro";
            }
            case "MNG": {
                return "Mongolia";
            }
            case "MNP": {
                return "Northern Mariana Islands";
            }
            case "MOZ": {
                return "Mozambique";
            }
            case "MRT": {
                return "Mauritania";
            }
            case "MSR": {
                return "Montserrat";
            }
            case "MTQ": {
                return "Martinique";
            }
            case "MUS": {
                return "Mauritius";
            }
            case "MWI": {
                return "Malawi";
            }
            case "MYS": {
                return "Malaysia";
            }
            case "MYT": {
                return "Mayotte";
            }
            case "NAM": {
                return "Namibia";
            }
            case "NCL": {
                return "New Caledonia";
            }
            case "NER": {
                return "Niger";
            }
            case "NFK": {
                return "Norfolk Island";
            }
            case "NGA": {
                return "Nigeria";
            }
            case "NIC": {
                return "Nicaragua";
            }
            case "NIU": {
                return "Niue";
            }
            case "NLD": {
                return "Netherlands";
            }
            case "NOR": {
                return "Norway";
            }
            case "NPL": {
                return "Nepal";
            }
            case "NRU": {
                return "Nauru";
            }
            case "NZL": {
                return "New Zealand";
            }
            case "OMN": {
                return "Oman";
            }
            case "PAK": {
                return "Pakistan";
            }
            case "PAN": {
                return "Panama";
            }
            case "PCN": {
                return "Pitcairn";
            }
            case "PER": {
                return "Peru";
            }
            case "PHL": {
                return "Philippines";
            }
            case "PLW": {
                return "Palau";
            }
            case "PNG": {
                return "Papua New Guinea";
            }
            case "POL": {
                return "Poland";
            }
            case "PRI": {
                return "Puerto Rico";
            }
            case "PRK": {
                return "Korea, Democratic People's Republic of";
            }
            case "PRT": {
                return "Portugal";
            }
            case "PRY": {
                return "Paraguay";
            }
            case "PSE": {
                return "Palestine, State of";
            }
            case "PYF": {
                return "French Polynesia";
            }
            case "QAT": {
                return "Qatar";
            }
            case "REU": {
                return "Riunion";
            }
            case "ROU": {
                return "Romania";
            }
            case "RUS": {
                return "Russian Federation";
            }
            case "RWA": {
                return "Rwanda";
            }
            case "SAU": {
                return "Saudi Arabia";
            }
            case "SDN": {
                return "Sudan";
            }
            case "SEN": {
                return "Senegal";
            }
            case "SGP": {
                return "Singapore";
            }
            case "SGS": {
                return "South Georgia and the South Sandwich Islands";
            }
            case "SHN": {
                return "Saint Helena, Ascension and Tristan da Cunha";
            }
            case "SJM": {
                return "Svalbard and Jan Mayen";
            }
            case "SLB": {
                return "Solomon Islands";
            }
            case "SLE": {
                return "Sierra Leone";
            }
            case "SLV": {
                return "El Salvador";
            }
            case "SMR": {
                return "San Marino";
            }
            case "SOM": {
                return "Somalia";
            }
            case "SPM": {
                return "Saint Pierre and Miquelon";
            }
            case "SRB": {
                return "Serbia";
            }
            case "SSD": {
                return "South Sudan";
            }
            case "STP": {
                return "Sao Tome and Principe";
            }
            case "SUR": {
                return "Suriname";
            }
            case "SVK": {
                return "Slovakia";
            }
            case "SVN": {
                return "Slovenia";
            }
            case "SWE": {
                return "Sweden";
            }
            case "SWZ": {
                return "Swaziland";
            }
            case "SXM": {
                return "Sint Maarten (Dutch part)";
            }
            case "SYC": {
                return "Seychelles";
            }
            case "SYR": {
                return "Syrian Arab Republic";
            }
            case "TCA": {
                return "Turks and Caicos Islands";
            }
            case "TCD": {
                return "Chad";
            }
            case "TGO": {
                return "Togo";
            }
            case "THA": {
                return "Thailand";
            }
            case "TJK": {
                return "Tajikistan";
            }
            case "TKL": {
                return "Tokelau";
            }
            case "TKM": {
                return "Turkmenistan";
            }
            case "TLS": {
                return "Timor-Leste";
            }
            case "TON": {
                return "Tonga";
            }
            case "TTO": {
                return "Trinidad and Tobago";
            }
            case "TUN": {
                return "Tunisia";
            }
            case "TUR": {
                return "Turkey";
            }
            case "TUV": {
                return "Tuvalu";
            }
            case "TWN": {
                return "Taiwan, Province of China";
            }
            case "TZA": {
                return "Tanzania, United Republic of";
            }
            case "UGA": {
                return "Uganda";
            }
            case "UKR": {
                return "Ukraine";
            }
            case "UMI": {
                return "United States Minor Outlying Islands";
            }
            case "URY": {
                return "Uruguay";
            }
            case "USA": {
                return "United States of America";
            }
            case "UZB": {
                return "Uzbekistan";
            }
            case "VAT": {
                return "Holy See";
            }
            case "VCT": {
                return "Saint Vincent and the Grenadines";
            }
            case "VEN": {
                return "Venezuela, Bolivarian Republic of";
            }
            case "VGB": {
                return "Virgin Islands, British";
            }
            case "VIR": {
                return "Virgin Islands, U.S.";
            }
            case "VNM": {
                return "Viet Nam";
            }
            case "VUT": {
                return "Vanuatu";
            }
            case "WLF": {
                return "Wallis and Futuna";
            }
            case "WSM": {
                return "Samoa";
            }
            case "YEM": {
                return "Yemen";
            }
            case "ZAF": {
                return "South Africa";
            }
            case "ZMB": {
                return "Zambia";
            }
            case "ZWE": {
                return "Zimbabwe";
            }
            case "004": {
                return "Afghanistan";
            }
            case "008": {
                return "Albania";
            }
            case "010": {
                return "Antarctica";
            }
            case "012": {
                return "Algeria";
            }
            case "016": {
                return "American Samoa";
            }
            case "020": {
                return "Andorra";
            }
            case "024": {
                return "Angola";
            }
            case "028": {
                return "Antigua and Barbuda";
            }
            case "031": {
                return "Azerbaijan";
            }
            case "032": {
                return "Argentina";
            }
            case "036": {
                return "Australia";
            }
            case "040": {
                return "Austria";
            }
            case "044": {
                return "Bahamas";
            }
            case "048": {
                return "Bahrain";
            }
            case "050": {
                return "Bangladesh";
            }
            case "051": {
                return "Armenia";
            }
            case "052": {
                return "Barbados";
            }
            case "056": {
                return "Belgium";
            }
            case "060": {
                return "Bermuda";
            }
            case "064": {
                return "Bhutan";
            }
            case "068": {
                return "Bolivia, Plurinational State of";
            }
            case "070": {
                return "Bosnia and Herzegovina";
            }
            case "072": {
                return "Botswana";
            }
            case "074": {
                return "Bouvet Island";
            }
            case "076": {
                return "Brazil";
            }
            case "084": {
                return "Belize";
            }
            case "086": {
                return "British Indian Ocean Territory";
            }
            case "090": {
                return "Solomon Islands";
            }
            case "092": {
                return "Virgin Islands, British";
            }
            case "096": {
                return "Brunei Darussalam";
            }
            case "100": {
                return "Bulgaria";
            }
            case "104": {
                return "Myanmar";
            }
            case "108": {
                return "Burundi";
            }
            case "112": {
                return "Belarus";
            }
            case "116": {
                return "Cambodia";
            }
            case "120": {
                return "Cameroon";
            }
            case "124": {
                return "Canada";
            }
            case "132": {
                return "Cabo Verde";
            }
            case "136": {
                return "Cayman Islands";
            }
            case "140": {
                return "Central African Republic";
            }
            case "144": {
                return "Sri Lanka";
            }
            case "148": {
                return "Chad";
            }
            case "152": {
                return "Chile";
            }
            case "156": {
                return "China";
            }
            case "158": {
                return "Taiwan, Province of China";
            }
            case "162": {
                return "Christmas Island";
            }
            case "166": {
                return "Cocos (Keeling) Islands";
            }
            case "170": {
                return "Colombia";
            }
            case "174": {
                return "Comoros";
            }
            case "175": {
                return "Mayotte";
            }
            case "178": {
                return "Congo";
            }
            case "180": {
                return "Congo, the Democratic Republic of the";
            }
            case "184": {
                return "Cook Islands";
            }
            case "188": {
                return "Costa Rica";
            }
            case "191": {
                return "Croatia";
            }
            case "192": {
                return "Cuba";
            }
            case "196": {
                return "Cyprus";
            }
            case "203": {
                return "Czechia";
            }
            case "204": {
                return "Benin";
            }
            case "208": {
                return "Denmark";
            }
            case "212": {
                return "Dominica";
            }
            case "214": {
                return "Dominican Republic";
            }
            case "218": {
                return "Ecuador";
            }
            case "222": {
                return "El Salvador";
            }
            case "226": {
                return "Equatorial Guinea";
            }
            case "231": {
                return "Ethiopia";
            }
            case "232": {
                return "Eritrea";
            }
            case "233": {
                return "Estonia";
            }
            case "234": {
                return "Faroe Islands";
            }
            case "238": {
                return "Falkland Islands (Malvinas)";
            }
            case "239": {
                return "South Georgia and the South Sandwich Islands";
            }
            case "242": {
                return "Fiji";
            }
            case "246": {
                return "Finland";
            }
            case "248": {
                return "Eland Islands";
            }
            case "250": {
                return "France";
            }
            case "254": {
                return "French Guiana";
            }
            case "258": {
                return "French Polynesia";
            }
            case "260": {
                return "French Southern Territories";
            }
            case "262": {
                return "Djibouti";
            }
            case "266": {
                return "Gabon";
            }
            case "268": {
                return "Georgia";
            }
            case "270": {
                return "Gambia";
            }
            case "275": {
                return "Palestine, State of";
            }
            case "276": {
                return "Germany";
            }
            case "288": {
                return "Ghana";
            }
            case "292": {
                return "Gibraltar";
            }
            case "296": {
                return "Kiribati";
            }
            case "300": {
                return "Greece";
            }
            case "304": {
                return "Greenland";
            }
            case "308": {
                return "Grenada";
            }
            case "312": {
                return "Guadeloupe";
            }
            case "316": {
                return "Guam";
            }
            case "320": {
                return "Guatemala";
            }
            case "324": {
                return "Guinea";
            }
            case "328": {
                return "Guyana";
            }
            case "332": {
                return "Haiti";
            }
            case "334": {
                return "Heard Island and McDonald Islands";
            }
            case "336": {
                return "Holy See";
            }
            case "340": {
                return "Honduras";
            }
            case "344": {
                return "Hong Kong";
            }
            case "348": {
                return "Hungary";
            }
            case "352": {
                return "Iceland";
            }
            case "356": {
                return "India";
            }
            case "360": {
                return "Indonesia";
            }
            case "364": {
                return "Iran, Islamic Republic of";
            }
            case "368": {
                return "Iraq";
            }
            case "372": {
                return "Ireland";
            }
            case "376": {
                return "Israel";
            }
            case "380": {
                return "Italy";
            }
            case "384": {
                return "Ctte d'Ivoire";
            }
            case "388": {
                return "Jamaica";
            }
            case "392": {
                return "Japan";
            }
            case "398": {
                return "Kazakhstan";
            }
            case "400": {
                return "Jordan";
            }
            case "404": {
                return "Kenya";
            }
            case "408": {
                return "Korea, Democratic People's Republic of";
            }
            case "410": {
                return "Korea, Republic of";
            }
            case "414": {
                return "Kuwait";
            }
            case "417": {
                return "Kyrgyzstan";
            }
            case "418": {
                return "Lao People's Democratic Republic";
            }
            case "422": {
                return "Lebanon";
            }
            case "426": {
                return "Lesotho";
            }
            case "428": {
                return "Latvia";
            }
            case "430": {
                return "Liberia";
            }
            case "434": {
                return "Libya";
            }
            case "438": {
                return "Liechtenstein";
            }
            case "440": {
                return "Lithuania";
            }
            case "442": {
                return "Luxembourg";
            }
            case "446": {
                return "Macao";
            }
            case "450": {
                return "Madagascar";
            }
            case "454": {
                return "Malawi";
            }
            case "458": {
                return "Malaysia";
            }
            case "462": {
                return "Maldives";
            }
            case "466": {
                return "Mali";
            }
            case "470": {
                return "Malta";
            }
            case "474": {
                return "Martinique";
            }
            case "478": {
                return "Mauritania";
            }
            case "480": {
                return "Mauritius";
            }
            case "484": {
                return "Mexico";
            }
            case "492": {
                return "Monaco";
            }
            case "496": {
                return "Mongolia";
            }
            case "498": {
                return "Moldova, Republic of";
            }
            case "499": {
                return "Montenegro";
            }
            case "500": {
                return "Montserrat";
            }
            case "504": {
                return "Morocco";
            }
            case "508": {
                return "Mozambique";
            }
            case "512": {
                return "Oman";
            }
            case "516": {
                return "Namibia";
            }
            case "520": {
                return "Nauru";
            }
            case "524": {
                return "Nepal";
            }
            case "528": {
                return "Netherlands";
            }
            case "531": {
                return "Curagao";
            }
            case "533": {
                return "Aruba";
            }
            case "534": {
                return "Sint Maarten (Dutch part)";
            }
            case "535": {
                return "Bonaire, Sint Eustatius and Saba";
            }
            case "540": {
                return "New Caledonia";
            }
            case "548": {
                return "Vanuatu";
            }
            case "554": {
                return "New Zealand";
            }
            case "558": {
                return "Nicaragua";
            }
            case "562": {
                return "Niger";
            }
            case "566": {
                return "Nigeria";
            }
            case "570": {
                return "Niue";
            }
            case "574": {
                return "Norfolk Island";
            }
            case "578": {
                return "Norway";
            }
            case "580": {
                return "Northern Mariana Islands";
            }
            case "581": {
                return "United States Minor Outlying Islands";
            }
            case "583": {
                return "Micronesia, Federated States of";
            }
            case "584": {
                return "Marshall Islands";
            }
            case "585": {
                return "Palau";
            }
            case "586": {
                return "Pakistan";
            }
            case "591": {
                return "Panama";
            }
            case "598": {
                return "Papua New Guinea";
            }
            case "600": {
                return "Paraguay";
            }
            case "604": {
                return "Peru";
            }
            case "608": {
                return "Philippines";
            }
            case "612": {
                return "Pitcairn";
            }
            case "616": {
                return "Poland";
            }
            case "620": {
                return "Portugal";
            }
            case "624": {
                return "Guinea-Bissau";
            }
            case "626": {
                return "Timor-Leste";
            }
            case "630": {
                return "Puerto Rico";
            }
            case "634": {
                return "Qatar";
            }
            case "638": {
                return "Riunion";
            }
            case "642": {
                return "Romania";
            }
            case "643": {
                return "Russian Federation";
            }
            case "646": {
                return "Rwanda";
            }
            case "652": {
                return "Saint Barthilemy";
            }
            case "654": {
                return "Saint Helena, Ascension and Tristan da Cunha";
            }
            case "659": {
                return "Saint Kitts and Nevis";
            }
            case "660": {
                return "Anguilla";
            }
            case "662": {
                return "Saint Lucia";
            }
            case "663": {
                return "Saint Martin (French part)";
            }
            case "666": {
                return "Saint Pierre and Miquelon";
            }
            case "670": {
                return "Saint Vincent and the Grenadines";
            }
            case "674": {
                return "San Marino";
            }
            case "678": {
                return "Sao Tome and Principe";
            }
            case "682": {
                return "Saudi Arabia";
            }
            case "686": {
                return "Senegal";
            }
            case "688": {
                return "Serbia";
            }
            case "690": {
                return "Seychelles";
            }
            case "694": {
                return "Sierra Leone";
            }
            case "702": {
                return "Singapore";
            }
            case "703": {
                return "Slovakia";
            }
            case "704": {
                return "Viet Nam";
            }
            case "705": {
                return "Slovenia";
            }
            case "706": {
                return "Somalia";
            }
            case "710": {
                return "South Africa";
            }
            case "716": {
                return "Zimbabwe";
            }
            case "724": {
                return "Spain";
            }
            case "728": {
                return "South Sudan";
            }
            case "729": {
                return "Sudan";
            }
            case "732": {
                return "Western Sahara";
            }
            case "740": {
                return "Suriname";
            }
            case "744": {
                return "Svalbard and Jan Mayen";
            }
            case "748": {
                return "Swaziland";
            }
            case "752": {
                return "Sweden";
            }
            case "756": {
                return "Switzerland";
            }
            case "760": {
                return "Syrian Arab Republic";
            }
            case "762": {
                return "Tajikistan";
            }
            case "764": {
                return "Thailand";
            }
            case "768": {
                return "Togo";
            }
            case "772": {
                return "Tokelau";
            }
            case "776": {
                return "Tonga";
            }
            case "780": {
                return "Trinidad and Tobago";
            }
            case "784": {
                return "United Arab Emirates";
            }
            case "788": {
                return "Tunisia";
            }
            case "792": {
                return "Turkey";
            }
            case "795": {
                return "Turkmenistan";
            }
            case "796": {
                return "Turks and Caicos Islands";
            }
            case "798": {
                return "Tuvalu";
            }
            case "800": {
                return "Uganda";
            }
            case "804": {
                return "Ukraine";
            }
            case "807": {
                return "Macedonia, the former Yugoslav Republic of";
            }
            case "818": {
                return "Egypt";
            }
            case "826": {
                return "United Kingdom";
            }
            case "831": {
                return "Guernsey";
            }
            case "832": {
                return "Jersey";
            }
            case "833": {
                return "Isle of Man";
            }
            case "834": {
                return "Tanzania, United Republic of";
            }
            case "840": {
                return "United States of America";
            }
            case "850": {
                return "Virgin Islands, U.S.";
            }
            case "854": {
                return "Burkina Faso";
            }
            case "858": {
                return "Uruguay";
            }
            case "860": {
                return "Uzbekistan";
            }
            case "862": {
                return "Venezuela, Bolivarian Republic of";
            }
            case "876": {
                return "Wallis and Futuna";
            }
            case "882": {
                return "Samoa";
            }
            case "887": {
                return "Yemen";
            }
            case "894": {
                return "Zambia";
            }
        }
        return "Unknown country code '" + c.getCode() + "'";
    }

    private static String region(Coding c) {
        switch (c.getCode()) {
            case "001": {
                return "Global (Whole world)";
            }
            case "002": {
                return "Africa";
            }
            case "015": {
                return "Northern Africa";
            }
            case "202": {
                return "Sub-Saharan Africa";
            }
            case "014": {
                return "Eastern Africa";
            }
            case "017": {
                return "Middle Africa";
            }
            case "018": {
                return "Southern Africa";
            }
            case "011": {
                return "Western Africa";
            }
            case "019": {
                return "Americas";
            }
            case "419": {
                return "Latin America and the Caribbean";
            }
            case "029": {
                return "Caribbean";
            }
            case "013": {
                return "Central America";
            }
            case "005": {
                return "South America";
            }
            case "021": {
                return "Northern America";
            }
            case "010": {
                return "Antarctica";
            }
            case "142": {
                return "Asia";
            }
            case "143": {
                return "Central Asia";
            }
            case "030": {
                return "Eastern Asia";
            }
            case "035": {
                return "South-eastern Asia";
            }
            case "034": {
                return "Southern Asia";
            }
            case "145": {
                return "Western Asia";
            }
            case "150": {
                return "Europe";
            }
            case "151": {
                return "Eastern Europe";
            }
            case "154": {
                return "Northern Europe";
            }
            case "830": {
                return "Channel Islands";
            }
            case "039": {
                return "Southern Europe";
            }
            case "155": {
                return "Western Europe";
            }
            case "009": {
                return "Oceania";
            }
            case "053": {
                return "Australia and New Zealand";
            }
            case "054": {
                return "Melanesia";
            }
            case "057": {
                return "Micronesia";
            }
            case "061": {
                return "Polynesia";
            }
        }
        return "Unknown region code '" + c.getCode() + "'";
    }

    public static boolean isJurisdiction(String system) {
        return Utilities.existsInList((String)system, (String[])new String[]{"http://unstats.un.org/unsd/methods/m49/m49.htm", "urn:iso:std:iso:3166", "urn:iso:std:iso:3166:-2"});
    }

    public static void setJurisdictionCountry(List<CodeableConcept> list, String code) {
        CodeableConcept cc = new CodeableConcept();
        cc.addCoding().setCode(code).setSystem("urn:iso:std:iso:3166");
        String disp = JurisdictionUtilities.country(cc.getCodingFirstRep());
        if (disp.contains("Unknown country")) {
            throw new FHIRException(disp);
        }
        list.clear();
        list.add(cc);
    }
}

