/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.TerminologyUtilities;
import org.hl7.fhir.r5.utils.CanonicalResourceUtilities;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSetUtilities
extends TerminologyUtilities {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValueSetUtilities.class);

    public static boolean isServerSide(String url) {
        return Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/sid/cvx"});
    }

    public static ValueSet makeShareable(ValueSet vs) {
        if (!vs.hasExperimental()) {
            vs.setExperimental(false);
        }
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return vs;
        }
        vs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return vs;
    }

    public static boolean makeVSShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            vs.setMeta(new Meta());
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return false;
        }
        vs.getMeta().getProfile().add(new CanonicalType("http://hl7.org/fhir/StructureDefinition/shareablevalueset"));
        return true;
    }

    public static void checkShareable(ValueSet vs) {
        if (!vs.hasMeta()) {
            throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
        }
        for (UriType uriType : vs.getMeta().getProfile()) {
            if (!((String)uriType.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablevalueset")) continue;
            return;
        }
        throw new Error("ValueSet " + vs.getUrl() + " is not shareable");
    }

    public static boolean hasOID(ValueSet vs) {
        return ValueSetUtilities.getOID(vs) != null;
    }

    public static String getOID(ValueSet vs) {
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            return id.getValue().substring(8);
        }
        return null;
    }

    public static void setOID(ValueSet vs, String oid) {
        if (!((String)oid).startsWith("urn:oid:")) {
            oid = "urn:oid:" + (String)oid;
        }
        for (Identifier id : vs.getIdentifier()) {
            if (!"urn:ietf:rfc:3986".equals(id.getSystem()) || !id.hasValue() || !id.getValue().startsWith("urn:oid:")) continue;
            id.setValue((String)oid);
            return;
        }
        vs.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue((String)oid);
    }

    public static void markStatus(ValueSet vs, String wg, StandardsStatus status, String pckage, String fmm, IWorkerContext context, String normativeVersion) throws FHIRException {
        String sfmm;
        if (vs.hasUserData("External.Link")) {
            return;
        }
        if (wg != null && (!ExtensionUtilities.hasExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg") || !Utilities.existsInList((String)ExtensionUtilities.readStringExtension((DomainResource)vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"), (String[])new String[]{"fhir", "vocab"}) && Utilities.existsInList((String)wg, (String[])new String[]{"fhir", "vocab"}))) {
            CanonicalResourceUtilities.setHl7WG(vs, wg);
        }
        if (status != null) {
            StandardsStatus ss = ExtensionUtilities.getStandardsStatus(vs);
            if (ss == null || ss.isLowerThan(status)) {
                ExtensionUtilities.setStandardsStatus(vs, status, normativeVersion);
            }
            if (pckage != null) {
                if (!vs.hasUserData("ballot.package")) {
                    vs.setUserData("ballot.package", pckage);
                } else if (!pckage.equals(vs.getUserString("ballot.package")) && !"infrastructure".equals(vs.getUserString("ballot.package"))) {
                    log.warn("Value Set " + vs.getUrl() + ": ownership clash " + pckage + " vs " + vs.getUserString("ballot.package"));
                }
            }
            if (status == StandardsStatus.NORMATIVE) {
                vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            }
        }
        if (fmm != null && (Utilities.noString((String)(sfmm = ExtensionUtilities.readStringExtension((DomainResource)vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"))) || Integer.parseInt(sfmm) < Integer.parseInt(fmm))) {
            ExtensionUtilities.setIntegerExtension(vs, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", Integer.parseInt(fmm));
        }
        if (vs.hasUserData("cs")) {
            CodeSystemUtilities.markStatus((CodeSystem)vs.getUserData("cs"), wg, status, pckage, fmm, normativeVersion);
        } else if (status == StandardsStatus.NORMATIVE && context != null) {
            for (ValueSet.ConceptSetComponent csc : vs.getCompose().getInclude()) {
                CodeSystem cs;
                if (!csc.hasSystem() || (cs = context.fetchCodeSystem(csc.getSystem())) == null) continue;
                CodeSystemUtilities.markStatus(cs, wg, status, pckage, fmm, normativeVersion);
            }
        }
    }

    private static int ssval(String status) {
        if ("Draft".equals("status")) {
            return 1;
        }
        if ("Informative".equals("status")) {
            return 2;
        }
        if ("External".equals("status")) {
            return 3;
        }
        if ("Trial Use".equals("status")) {
            return 3;
        }
        if ("Normative".equals("status")) {
            return 4;
        }
        return -1;
    }

    public static void sortInclude(ValueSet.ConceptSetComponent inc) {
        Collections.sort(inc.getConcept(), new ConceptReferenceComponentSorter());
    }

    public static String getAllCodesSystem(ValueSet vs) {
        ValueSet.ConceptSetComponent i;
        ValueSet.ValueSetComposeComponent c;
        if (vs.hasCompose() && (c = vs.getCompose()).getExclude().isEmpty() && c.getInclude().size() == 1 && (i = c.getIncludeFirstRep()).hasSystem() && !i.hasValueSet() && !i.hasConcept() && !i.hasFilter()) {
            return i.getSystem();
        }
        return null;
    }

    public static boolean isDeprecated(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent c) {
        try {
            for (ValueSet.ConceptPropertyComponent p : c.getProperty()) {
                if ("status".equals(p.getCode()) && p.hasValue() && p.hasValueCodeType() && "deprecated".equals(p.getValueCodeType().getCode())) {
                    return true;
                }
                if ("deprecationDate".equals(p.getCode()) && p.hasValue() && p.getValue() instanceof DateTimeType) {
                    return ((DateTimeType)p.getValue()).before(new DateTimeType(Calendar.getInstance()));
                }
                if (!"deprecated".equals(p.getCode()) || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
                return (Boolean)((BooleanType)p.getValue()).getValue();
            }
            StandardsStatus ss = ExtensionUtilities.getStandardsStatus(c);
            return ss == StandardsStatus.DEPRECATED;
        }
        catch (FHIRException e) {
            return false;
        }
    }

    public static boolean hasCodeInExpansion(ValueSet vs, Coding code) {
        return ValueSetUtilities.hasCodeInExpansion(vs.getExpansion().getContains(), code);
    }

    private static boolean hasCodeInExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list, Coding code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (c.getSystem().equals(code.getSystem()) && c.getCode().equals(code.getCode())) {
                return true;
            }
            if (!ValueSetUtilities.hasCodeInExpansion(c.getContains(), code)) continue;
            return true;
        }
        return false;
    }

    public static ValueSet.ConceptPropertyComponent addCodeProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, String value) {
        if (value != null) {
            return ValueSetUtilities.addProperty(vs, ctxt, url, code, new CodeType(value));
        }
        return null;
    }

    public static ValueSet.ConceptPropertyComponent addProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, String value) {
        if (value != null) {
            return ValueSetUtilities.addProperty(vs, ctxt, url, code, new StringType(value));
        }
        return null;
    }

    public static ValueSet.ConceptPropertyComponent addProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, Integer value) {
        if (value != null) {
            return ValueSetUtilities.addProperty(vs, ctxt, url, code, new IntegerType(value));
        }
        return null;
    }

    public static ValueSet.ConceptPropertyComponent addProperty(ValueSet vs, ValueSet.ValueSetExpansionContainsComponent ctxt, String url, String code, DataType value) {
        code = ValueSetUtilities.defineProperty(vs, url, code);
        ValueSet.ConceptPropertyComponent p = ValueSetUtilities.getProperty(ctxt.getProperty(), code);
        if (p != null) {
            p.setValue(value);
        } else {
            p = ctxt.addProperty().setCode(code).setValue(value);
        }
        return p;
    }

    private static ValueSet.ConceptPropertyComponent getProperty(List<ValueSet.ConceptPropertyComponent> list, String code) {
        for (ValueSet.ConceptPropertyComponent t : list) {
            if (!code.equals(t.getCode())) continue;
            return t;
        }
        return null;
    }

    private static String defineProperty(ValueSet vs, String url, String code) {
        for (ValueSet.ValueSetExpansionPropertyComponent p : vs.getExpansion().getProperty()) {
            if (!p.hasUri() || !p.getUri().equals(url)) continue;
            return p.getCode();
        }
        for (ValueSet.ValueSetExpansionPropertyComponent p : vs.getExpansion().getProperty()) {
            if (!p.hasCode() || !p.getCode().equals(code)) continue;
            p.setUri(url);
            return code;
        }
        ValueSet.ValueSetExpansionPropertyComponent p = vs.getExpansion().addProperty();
        p.setUri(url);
        p.setCode(code);
        return code;
    }

    public static int countExpansion(ValueSet valueset) {
        int i = valueset.getExpansion().getContains().size();
        for (ValueSet.ValueSetExpansionContainsComponent t : valueset.getExpansion().getContains()) {
            i += ValueSetUtilities.countExpansion(t);
        }
        return i;
    }

    public static int countExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int i = list.size();
        for (ValueSet.ValueSetExpansionContainsComponent t : list) {
            i += ValueSetUtilities.countExpansion(t);
        }
        return i;
    }

    private static int countExpansion(ValueSet.ValueSetExpansionContainsComponent c) {
        int i = c.getContains().size();
        for (ValueSet.ValueSetExpansionContainsComponent t : c.getContains()) {
            i += ValueSetUtilities.countExpansion(t);
        }
        return i;
    }

    public static Set<String> listSystems(IWorkerContext ctxt, ValueSet vs) {
        HashSet<String> systems = new HashSet<String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            for (CanonicalType ct : inc.getValueSet()) {
                ValueSet vsr = ctxt.findTxResource(ValueSet.class, ct.asStringValue(), vs);
                if (vsr == null) continue;
                systems.addAll(ValueSetUtilities.listSystems(ctxt, vsr));
            }
            if (!inc.hasSystem()) continue;
            systems.add(inc.getSystem());
        }
        return systems;
    }

    public static boolean isIncompleteExpansion(ValueSet valueSet) {
        ValueSet.ValueSetExpansionComponent exp;
        return valueSet.hasExpansion() && (exp = valueSet.getExpansion()).hasTotal() && exp.getTotal() != ValueSetUtilities.countExpansion(exp.getContains());
    }

    public static Set<String> codes(ValueSet vs, CodeSystem cs) {
        HashSet<String> res = new HashSet<String>();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            if (!inc.getSystem().equals(cs.getUrl())) continue;
            ValueSetUtilities.addCodes(res, inc, cs.getConcept());
        }
        return res;
    }

    private static void addCodes(Set<String> res, ValueSet.ConceptSetComponent inc, List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent cd : list) {
            if (cd.hasCode() && (!inc.hasConcept() || inc.hasConcept(cd.getCode()))) {
                res.add(cd.getCode());
            }
            if (!cd.hasConcept()) continue;
            ValueSetUtilities.addCodes(res, inc, cd.getConcept());
        }
    }

    public static String versionFromExpansionParams(Parameters expParameters, String system, String defaultVersion) {
        if (expParameters != null) {
            for (Parameters.ParametersParameterComponent p : expParameters.getParameter()) {
                String v;
                if (!"system-version".equals(p.getName()) && !"force-system-version".equals(p.getName()) || !(v = p.getValue().primitiveValue()).startsWith(system + "|")) continue;
                String ver = v.substring(v.indexOf("|") + 1);
                if (defaultVersion != null && !ver.startsWith(defaultVersion) && !"force-system-version".equals(p.getName())) continue;
                return ver;
            }
        }
        return defaultVersion;
    }

    public static Set<String> checkExpansionSubset(ValueSet vs1, ValueSet vs2) {
        HashSet<String> codes = new HashSet<String>();
        ValueSetUtilities.checkCodes(codes, vs2.getExpansion().getContains(), vs1.getExpansion().getContains());
        return codes;
    }

    private static void checkCodes(Set<String> codes, List<ValueSet.ValueSetExpansionContainsComponent> listS, List<ValueSet.ValueSetExpansionContainsComponent> listT) {
        for (ValueSet.ValueSetExpansionContainsComponent c : listS) {
            ValueSet.ValueSetExpansionContainsComponent t = ValueSetUtilities.findContained(c, listT);
            if (t == null) {
                codes.add(c.getCode());
            }
            if (!c.hasContains()) continue;
            ValueSetUtilities.checkCodes(codes, c.getContains(), listT);
        }
    }

    private static ValueSet.ValueSetExpansionContainsComponent findContained(ValueSet.ValueSetExpansionContainsComponent c, List<ValueSet.ValueSetExpansionContainsComponent> listT) {
        for (ValueSet.ValueSetExpansionContainsComponent t : listT) {
            ValueSet.ValueSetExpansionContainsComponent tt;
            if (t.getSystem().equals(c.getSystem()) && t.getCode().equals(c.getCode())) {
                return t;
            }
            if (!t.hasContains() || (tt = ValueSetUtilities.findContained(c, t.getContains())) == null) continue;
            return tt;
        }
        return null;
    }

    public static void setDeprecated(List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, ValueSet.ValueSetExpansionContainsComponent n) {
        if (!"deprecated".equals(ValueSetUtilities.getStatus(vsProp, n))) {
            n.addProperty().setCode("status").setValue(new CodeType("deprecated"));
            for (ValueSet.ValueSetExpansionPropertyComponent o : vsProp) {
                if (!"status".equals(o.getCode())) continue;
                return;
            }
            vsProp.add(new ValueSet.ValueSetExpansionPropertyComponent().setCode("status").setUri("http://hl7.org/fhir/concept-properties#status"));
        }
    }

    private static String getStatus(List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, ValueSet.ValueSetExpansionContainsComponent n) {
        return ValueSetUtilities.getProperty(vsProp, n, "status", "http://hl7.org/fhir/concept-properties#status");
    }

    public static String getProperty(List<ValueSet.ValueSetExpansionPropertyComponent> vsProp, ValueSet.ValueSetExpansionContainsComponent focus, String code, String url) {
        ValueSet.ValueSetExpansionPropertyComponent pc = null;
        for (ValueSet.ValueSetExpansionPropertyComponent valueSetExpansionPropertyComponent : vsProp) {
            if (!valueSetExpansionPropertyComponent.hasUri() || !valueSetExpansionPropertyComponent.getUri().equals(url)) continue;
            pc = valueSetExpansionPropertyComponent;
        }
        if (pc == null) {
            for (ValueSet.ValueSetExpansionPropertyComponent valueSetExpansionPropertyComponent : vsProp) {
                if (!valueSetExpansionPropertyComponent.hasCode() || !valueSetExpansionPropertyComponent.getCode().equals(code)) continue;
                pc = valueSetExpansionPropertyComponent;
            }
        }
        if (pc != null) {
            for (ValueSet.ConceptPropertyComponent conceptPropertyComponent : focus.getProperty()) {
                if (!conceptPropertyComponent.hasCode() || !conceptPropertyComponent.getCode().equals(pc.getCode())) continue;
                return conceptPropertyComponent.getValue().primitiveValue();
            }
        }
        return null;
    }

    public static class ConceptReferenceComponentSorter
    implements Comparator<ValueSet.ConceptReferenceComponent> {
        @Override
        public int compare(ValueSet.ConceptReferenceComponent o1, ValueSet.ConceptReferenceComponent o2) {
            return o1.getCode().compareToIgnoreCase(o2.getCode());
        }
    }

    public static class ValueSetSorter
    implements Comparator<ValueSet> {
        @Override
        public int compare(ValueSet o1, ValueSet o2) {
            String ver2;
            String ver1;
            String url2;
            String url1 = o1.getUrl();
            int c = this.compareString(url1, url2 = o2.getUrl());
            if (c == 0 && (c = VersionUtilities.compareVersions((String)(ver1 = o1.getVersion()), (String)(ver2 = o2.getVersion()))) == 0) {
                String d1 = o1.getDateElement().asStringValue();
                String d2 = o2.getDateElement().asStringValue();
                c = this.compareString(url1, url2);
            }
            return c;
        }

        private int compareString(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            return s1.compareTo(s2);
        }
    }
}

