/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.client;

import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.utils.client.FHIRToolingClient;
import org.hl7.fhir.r5.utils.client.network.ClientHeaders;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPHeader;

public class TerminologyClientR5
implements ITerminologyClient {
    private final FHIRToolingClient client;
    private ClientHeaders clientHeaders;
    private String id;

    public TerminologyClientR5(String id, String address, String userAgent) throws URISyntaxException {
        this.client = new FHIRToolingClient(address, userAgent);
        this.setClientHeaders(new ClientHeaders());
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public TerminologyClientR5(String id, String address, String userAgent, ClientHeaders clientHeaders) throws URISyntaxException {
        this.client = new FHIRToolingClient(address, userAgent);
        this.setClientHeaders(clientHeaders);
        this.id = id;
    }

    @Override
    public EnumSet<FhirPublication> supportableVersions() {
        return EnumSet.range(FhirPublication.STU3, FhirPublication.R5);
    }

    @Override
    public void setAllowedVersions(EnumSet<FhirPublication> versions) {
    }

    @Override
    public EnumSet<FhirPublication> getAllowedVersions() {
        return null;
    }

    @Override
    public FhirPublication getActualVersion() {
        return FhirPublication.R5;
    }

    @Override
    public TerminologyCapabilities getTerminologyCapabilities() {
        return this.client.getTerminologyCapabilities();
    }

    @Override
    public String getAddress() {
        return this.client.getAddress();
    }

    @Override
    public ValueSet expandValueset(ValueSet vs, Parameters p) {
        return this.client.expandValueset(vs, p);
    }

    @Override
    public Parameters validateCS(Parameters pin) {
        return this.client.operateType(CodeSystem.class, "validate-code", pin);
    }

    @Override
    public Parameters batchValidateCS(Parameters pin) {
        return this.client.operateType(CodeSystem.class, "batch-validate-code", pin);
    }

    @Override
    public Parameters subsumes(Parameters pin) {
        return this.client.operateType(CodeSystem.class, "subsumes", pin);
    }

    @Override
    public Parameters validateVS(Parameters pin) {
        return this.client.operateType(ValueSet.class, "validate-code", pin);
    }

    @Override
    public Parameters batchValidateVS(Parameters pin) {
        return this.client.operateType(ValueSet.class, "batch-validate-code", pin);
    }

    @Override
    public ITerminologyClient setTimeoutFactor(int i) {
        this.client.setTimeoutFactor(i);
        return this;
    }

    @Override
    public ToolingClientLogger getLogger() {
        return this.client.getLogger();
    }

    @Override
    public ITerminologyClient setLogger(ToolingClientLogger txLog) {
        this.client.setLogger(txLog);
        return this;
    }

    @Override
    public CapabilityStatement getCapabilitiesStatementQuick() {
        return this.client.getCapabilitiesStatementQuick();
    }

    @Override
    public CapabilityStatement getCapabilitiesStatement() {
        return this.client.getCapabilitiesStatement();
    }

    @Override
    public Parameters lookupCode(Map<String, String> params) {
        return this.client.lookupCode(params);
    }

    @Override
    public Parameters lookupCode(Parameters params) {
        return this.client.lookupCode(params);
    }

    @Override
    public ITerminologyClient setRetryCount(int retryCount) throws FHIRException {
        this.client.setRetryCount(retryCount);
        return this;
    }

    @Override
    public int getRetryCount() throws FHIRException {
        return this.client.getRetryCount();
    }

    @Override
    public Bundle batch(Bundle batch) {
        return this.client.transaction(batch);
    }

    @Override
    public CanonicalResource read(String type, String id) {
        Class<?> t;
        try {
            t = Class.forName("org.hl7.fhir.r5.model." + type);
        }
        catch (ClassNotFoundException e) {
            throw new FHIRException("Unable to fetch resources of type " + type + " in R5");
        }
        Object r5 = this.client.read(t, id);
        if (r5 == null) {
            throw new FHIRException("Unable to convert resource " + Utilities.pathURL((String[])new String[]{this.getAddress(), type, id}) + " to R5 (internal representation)");
        }
        if (!(r5 instanceof CanonicalResource)) {
            throw new FHIRException("Unable to convert resource " + Utilities.pathURL((String[])new String[]{this.getAddress(), type, id}) + " to R5 canonical resource (internal representation)");
        }
        return (CanonicalResource)r5;
    }

    @Override
    public Iterable<HTTPHeader> getClientHeaders() {
        return this.clientHeaders.headers();
    }

    @Override
    public ITerminologyClient setClientHeaders(ClientHeaders clientHeaders) {
        this.clientHeaders = clientHeaders;
        this.client.setClientHeaders(this.clientHeaders.headers());
        this.client.setVersionInMimeTypes(true);
        return this;
    }

    @Override
    public ITerminologyClient setUserAgent(String userAgent) {
        this.client.setUserAgent(userAgent);
        return this;
    }

    @Override
    public String getUserAgent() {
        return this.client.getUserAgent();
    }

    @Override
    public String getServerVersion() {
        return this.client.getServerVersion();
    }

    @Override
    public ITerminologyClient setAcceptLanguage(String lang) {
        this.client.setAcceptLanguage(lang);
        return this;
    }

    @Override
    public ITerminologyClient setContentLanguage(String lang) {
        this.client.setContentLanguage(lang);
        return this;
    }

    @Override
    public int getUseCount() {
        return this.client.getUseCount();
    }

    public static TerminologyClientManager.ITerminologyClientFactory factory() {
        return new TerminologyClientR5Factory();
    }

    @Override
    public Bundle search(String type, String criteria) {
        return this.client.search(type, criteria);
    }

    @Override
    public Parameters translate(Parameters params) throws FHIRException {
        return this.client.translate(params);
    }

    @Override
    public void setConversionLogger(ITerminologyClient.ITerminologyConversionLogger logger) {
    }

    @Override
    public OperationOutcome validateResource(Resource res) {
        return this.client.validate(res, res.getId());
    }

    public static class TerminologyClientR5Factory
    implements TerminologyClientManager.ITerminologyClientFactory {
        @Override
        public ITerminologyClient makeClient(String id, String url, String userAgent, ToolingClientLogger logger) throws URISyntaxException {
            return new TerminologyClientR5(id, this.checkEndsWith("/r5", url), userAgent);
        }

        private String checkEndsWith(String term, String url) {
            if (url.endsWith(term)) {
                return url;
            }
            if (Utilities.isTxFhirOrgServer((String)url)) {
                return Utilities.pathURL((String[])new String[]{url, term});
            }
            return url;
        }

        @Override
        public String getVersion() {
            return "5.0.0";
        }
    }
}

