/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.io.IOException;
import org.hl7.fhir.utilities.filesystem.CSFile;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public interface TerminologyCapabilitiesCache<V> {
    public boolean containsKey(String var1);

    public V get(String var1);

    public V put(String var1, V var2);

    public static boolean cacheFileHasExpired(String fn, long expirationTimeMillis) throws IOException {
        CSFile cacheFile = ManagedFileAccess.csfile((String)fn);
        if (!cacheFile.exists()) {
            return true;
        }
        long lastModified = cacheFile.lastModified();
        long currentTime = System.currentTimeMillis();
        return currentTime - lastModified > expirationTimeMillis;
    }
}

