/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class TerminologyOperationContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TerminologyOperationContext.class);
    public static boolean debugging = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private static final int EXPANSION_DEAD_TIME_SECS = 60;
    private long deadTime;
    private int nestCount = 0;
    private long startTime;
    private List<String> contexts = new ArrayList<String>();
    private IWorkerContext worker;
    private boolean original;
    private ValidationOptions options;
    private String name;
    private List<String> notes = new ArrayList<String>();

    public TerminologyOperationContext(IWorkerContext worker, ValidationOptions options, String name) {
        this.worker = worker;
        this.original = true;
        this.options = options;
        this.name = name;
        this.startTime = System.currentTimeMillis();
        this.deadTime = debugging ? 0L : System.currentTimeMillis() + 60000L;
    }

    private TerminologyOperationContext(ValidationOptions options, String name) {
        this.options = options;
        this.name = name;
        this.startTime = System.currentTimeMillis();
    }

    public TerminologyOperationContext copy() {
        TerminologyOperationContext ret = new TerminologyOperationContext(this.options, this.name);
        ret.worker = this.worker;
        ret.contexts.addAll(this.contexts);
        ret.deadTime = this.deadTime;
        ret.notes = this.notes;
        ret.startTime = this.startTime;
        ret.nestCount = this.nestCount + 1;
        return ret;
    }

    public void deadCheck(String note) {
        this.note(note);
        if (this.deadTime != 0L && System.currentTimeMillis() > this.deadTime) {
            log.error("Operation took too long - longer than " + (this.deadTime - this.startTime) + "ms");
            for (String s : this.notes) {
                log.error(s);
            }
            throw new TerminologyServiceProtectionException(this.worker.formatMessage("VALUESET_TOO_COSTLY_TIME", this.contexts.get(0), 60, this.name + " (local)"), TerminologyServiceErrorClass.TOO_COSTLY, OperationOutcome.IssueType.TOOCOSTLY);
        }
    }

    public void seeContext(String context) {
        if (this.contexts.contains(context)) {
            throw new TerminologyServiceProtectionException(this.worker.formatMessage("VALUESET_CIRCULAR_REFERENCE", context, this.contexts.toString()), TerminologyServiceErrorClass.PROCESSING, OperationOutcome.IssueType.PROCESSING);
        }
        this.contexts.add(context);
    }

    public boolean isOriginal() {
        return this.original;
    }

    public ValidationOptions getOptions() {
        return this.options;
    }

    public void note(String s) {
        s = Utilities.padLeft((String)"", (char)' ', (int)this.nestCount) + " " + (System.currentTimeMillis() - this.startTime) + " " + (String)s;
        this.notes.add((String)s);
    }

    public static class TerminologyServiceProtectionException
    extends FHIRException {
        private TerminologyServiceErrorClass error;
        private OperationOutcome.IssueType type;
        private String diagnostics;

        public TerminologyServiceProtectionException(String message, TerminologyServiceErrorClass error, OperationOutcome.IssueType type) {
            super(message);
            this.error = error;
            this.type = type;
        }

        public TerminologyServiceProtectionException(String message, TerminologyServiceErrorClass error, OperationOutcome.IssueType type, String diagnostics) {
            super(message);
            this.error = error;
            this.type = type;
            this.diagnostics = diagnostics;
        }

        public TerminologyServiceErrorClass getError() {
            return this.error;
        }

        public OperationOutcome.IssueType getType() {
            return this.type;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }
    }
}

