/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies.utilities;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;

public class VCLParser {
    private static String VCL_URI = "http://fhir.org/VCL?v1=";

    public static ValueSet parse(String vclExpression) throws VCLParseException {
        if (vclExpression == null || vclExpression.trim().isEmpty()) {
            throw new VCLParseException("VCL expression cannot be empty");
        }
        Lexer lexer = new Lexer(vclExpression);
        List<Token> tokens = lexer.tokenize();
        Parser parser = new Parser(tokens);
        return parser.parse();
    }

    public static ValueSet parseAndId(String vclExpression) throws VCLParseException, IOException {
        ValueSet vs = VCLParser.parse(vclExpression);
        String json = new JsonParser().composeString(vs);
        vs.setUrl("cid:" + json.hashCode());
        return vs;
    }

    public static class VCLParseException
    extends Exception {
        public VCLParseException(String message) {
            super(message);
        }

        public VCLParseException(String message, int position) {
            super(message + " at position " + position);
        }
    }

    private static class Lexer {
        private String input;
        private int pos = 0;

        public Lexer(String input) {
            this.input = input.trim();
        }

        public List<Token> tokenize() throws VCLParseException {
            ArrayList<Token> tokens = new ArrayList<Token>();
            block20: while (this.pos < this.input.length()) {
                Object value;
                this.skipWhitespace();
                if (this.pos >= this.input.length()) break;
                int startPos = this.pos;
                char ch = this.input.charAt(this.pos);
                switch (ch) {
                    case '-': {
                        tokens.add(new Token(TokenType.DASH, "-", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '(': {
                        tokens.add(new Token(TokenType.OPEN, "(", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case ')': {
                        tokens.add(new Token(TokenType.CLOSE, ")", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '{': {
                        tokens.add(new Token(TokenType.LCRLY, "{", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '}': {
                        tokens.add(new Token(TokenType.RCRLY, "}", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case ';': {
                        tokens.add(new Token(TokenType.SEMI, ";", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case ',': {
                        tokens.add(new Token(TokenType.COMMA, ",", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '.': {
                        tokens.add(new Token(TokenType.DOT, ".", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '*': {
                        tokens.add(new Token(TokenType.STAR, "*", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '=': {
                        tokens.add(new Token(TokenType.EQ, "=", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '/': {
                        tokens.add(new Token(TokenType.REGEX, "/", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '^': {
                        tokens.add(new Token(TokenType.IN, "^", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '>': {
                        if (this.peek() == '>') {
                            tokens.add(new Token(TokenType.GENERALIZES, ">>", startPos));
                            this.pos += 2;
                            continue block20;
                        }
                        throw new VCLParseException("Unexpected character: " + ch, this.pos);
                    }
                    case '<': {
                        if (this.peek() == '<') {
                            tokens.add(new Token(TokenType.IS_A, "<<", startPos));
                            this.pos += 2;
                            continue block20;
                        }
                        if (this.peek() == '!') {
                            tokens.add(new Token(TokenType.CHILD_OF, "<!", startPos));
                            this.pos += 2;
                            continue block20;
                        }
                        tokens.add(new Token(TokenType.DESC_OF, "<", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '~': {
                        if (this.peek() == '<' && this.peek(1) == '<') {
                            tokens.add(new Token(TokenType.IS_NOT_A, "~<<", startPos));
                            this.pos += 3;
                            continue block20;
                        }
                        if (this.peek() == '^') {
                            tokens.add(new Token(TokenType.NOT_IN, "~^", startPos));
                            this.pos += 2;
                            continue block20;
                        }
                        throw new VCLParseException("Unexpected character: " + ch, this.pos);
                    }
                    case '!': {
                        if (this.peek() == '!' && this.peek(1) == '<') {
                            tokens.add(new Token(TokenType.DESC_LEAF, "!!<", startPos));
                            this.pos += 3;
                            continue block20;
                        }
                        throw new VCLParseException("Unexpected character: " + ch, this.pos);
                    }
                    case '?': {
                        tokens.add(new Token(TokenType.EXISTS, "?", startPos));
                        ++this.pos;
                        continue block20;
                    }
                    case '\"': {
                        tokens.add(this.readQuotedValue(startPos));
                        continue block20;
                    }
                }
                if (Character.isLetter(ch)) {
                    value = this.readWhile(c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '_');
                    if (this.pos < this.input.length() && this.input.charAt(this.pos) == ':') {
                        ++this.pos;
                        String restOfUri = this.readWhile(c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '?' || c.charValue() == '&' || c.charValue() == '%' || c.charValue() == '+' || c.charValue() == '-' || c.charValue() == '.' || c.charValue() == '@' || c.charValue() == '#' || c.charValue() == '$' || c.charValue() == '!' || c.charValue() == '{' || c.charValue() == '}' || c.charValue() == '_' || c.charValue() == '/');
                        value = (String)value + ":" + restOfUri;
                        if (this.pos < this.input.length() && this.input.charAt(this.pos) == '|') {
                            ++this.pos;
                            String version = this.readWhile(c -> c.charValue() != '(' && c.charValue() != ')' && !Character.isWhitespace(c.charValue()));
                            value = (String)value + "|" + version;
                        }
                        tokens.add(new Token(TokenType.URI, (String)value, startPos));
                        continue;
                    }
                    tokens.add(new Token(TokenType.SCODE, (String)value, startPos));
                    continue;
                }
                if (Character.isDigit(ch)) {
                    value = this.readWhile(c -> Character.isLetterOrDigit(c.charValue()) || c.charValue() == '-' || c.charValue() == '_');
                    tokens.add(new Token(TokenType.SCODE, (String)value, startPos));
                    continue;
                }
                throw new VCLParseException("Unexpected character: " + ch, this.pos);
            }
            tokens.add(new Token(TokenType.EOF, "", this.pos));
            return tokens;
        }

        private Token readQuotedValue(int startPos) throws VCLParseException {
            StringBuilder sb = new StringBuilder();
            ++this.pos;
            while (this.pos < this.input.length()) {
                char ch = this.input.charAt(this.pos);
                if (ch == '\"') {
                    ++this.pos;
                    return new Token(TokenType.QUOTED_VALUE, sb.toString(), startPos);
                }
                if (ch == '\\' && this.pos + 1 < this.input.length()) {
                    ++this.pos;
                    char escaped = this.input.charAt(this.pos);
                    if (escaped == '\"' || escaped == '\\') {
                        sb.append(escaped);
                    } else {
                        sb.append('\\').append(escaped);
                    }
                    ++this.pos;
                    continue;
                }
                sb.append(ch);
                ++this.pos;
            }
            throw new VCLParseException("Unterminated quoted string", startPos);
        }

        private String readWhile(Predicate<Character> predicate) {
            StringBuilder sb = new StringBuilder();
            while (this.pos < this.input.length() && predicate.test(Character.valueOf(this.input.charAt(this.pos)))) {
                sb.append(this.input.charAt(this.pos));
                ++this.pos;
            }
            return sb.toString();
        }

        private char peek() {
            return this.peek(0);
        }

        private char peek(int offset) {
            int peekPos = this.pos + 1 + offset;
            return peekPos < this.input.length() ? this.input.charAt(peekPos) : (char)'\u0000';
        }

        private void skipWhitespace() {
            while (this.pos < this.input.length() && Character.isWhitespace(this.input.charAt(this.pos))) {
                ++this.pos;
            }
        }
    }

    private static class Parser {
        private List<Token> tokens;
        private int pos = 0;
        private ValueSet valueSet;
        private ValueSet.ValueSetComposeComponent compose;

        private static String getImplicitVcl(String system, String expression) {
            String encodedVcl = ("(" + system + ")(" + expression + ")").replace("%", "%25").replace("&", "%26").replace("(", "%28").replace(")", "%29").replace("=", "%3D").replace("?", "%3F").replace("#", "%23");
            return VCL_URI + encodedVcl;
        }

        public Parser(List<Token> tokens) {
            this.tokens = tokens;
            this.valueSet = new ValueSet();
            this.valueSet.setStatus(Enumerations.PublicationStatus.DRAFT);
            this.compose = new ValueSet.ValueSetComposeComponent();
            this.valueSet.setCompose(this.compose);
        }

        public ValueSet parse() throws VCLParseException {
            this.parseExpr();
            this.expect(TokenType.EOF);
            return this.valueSet;
        }

        private void parseExpr() throws VCLParseException {
            this.parseSubExpr(false);
            if (this.current().type == TokenType.COMMA) {
                this.parseConjunction();
            } else if (this.current().type == TokenType.SEMI) {
                this.parseDisjunction();
            } else if (this.current().type == TokenType.DASH) {
                this.parseExclusion();
            }
        }

        private void parseSubExpr(boolean isExclusion) throws VCLParseException {
            String systemUri = null;
            if (this.current().type == TokenType.OPEN && this.peek().type == TokenType.URI) {
                this.consume(TokenType.OPEN);
                systemUri = this.current().value;
                this.consume(TokenType.URI);
                this.consume(TokenType.CLOSE);
            }
            if (this.current().type == TokenType.OPEN) {
                this.consume(TokenType.OPEN);
                if (this.current().type == TokenType.OPEN && this.peek().type == TokenType.URI) {
                    this.consume(TokenType.OPEN);
                    systemUri = this.current().value;
                    this.consume(TokenType.URI);
                    this.consume(TokenType.CLOSE);
                }
                if (this.isSimpleCodeList()) {
                    this.parseSimpleCodeList(systemUri, isExclusion);
                } else {
                    this.parseExprWithinParentheses(isExclusion);
                }
                this.consume(TokenType.CLOSE);
            } else {
                this.parseSimpleExpr(systemUri, isExclusion);
            }
        }

        private boolean isSimpleCodeList() {
            int lookahead = this.pos;
            while (lookahead < this.tokens.size()) {
                Token token = this.tokens.get(lookahead);
                if (token.type == TokenType.CLOSE) {
                    return true;
                }
                if (token.type == TokenType.OPEN && lookahead + 2 < this.tokens.size()) {
                    Token nextToken = this.tokens.get(lookahead + 1);
                    Token tokenAfterNext = this.tokens.get(lookahead + 2);
                    if (nextToken.type == TokenType.URI && tokenAfterNext.type == TokenType.CLOSE) {
                        lookahead += 3;
                        continue;
                    }
                }
                if (token.type == TokenType.OPEN || token.type == TokenType.DASH || this.isFilterOperator(token.type)) {
                    return false;
                }
                ++lookahead;
            }
            return true;
        }

        private void parseExprWithinParentheses(boolean isExclusion) throws VCLParseException {
            this.parseSubExpr(isExclusion);
            while (this.current().type == TokenType.COMMA || this.current().type == TokenType.SEMI || this.current().type == TokenType.DASH) {
                if (this.current().type == TokenType.COMMA) {
                    this.parseConjunctionWithFlag(isExclusion);
                    continue;
                }
                if (this.current().type == TokenType.SEMI) {
                    this.parseDisjunctionWithFlag(isExclusion);
                    continue;
                }
                if (this.current().type != TokenType.DASH) continue;
                this.parseExclusion();
            }
        }

        private void parseSimpleCodeList(String systemUri, boolean isExclusion) throws VCLParseException {
            ValueSet.ConceptSetComponent conceptSet = this.createConceptSet(systemUri, isExclusion);
            if (this.current().type == TokenType.STAR) {
                this.consume(TokenType.STAR);
                conceptSet.addFilter().setProperty("concept").setOp(Enumerations.FilterOperator.EXISTS).setValue("true");
                return;
            }
            if (this.current().type == TokenType.IN) {
                this.parseIncludeVs(conceptSet);
                return;
            }
            String code = this.parseCode();
            conceptSet.addConcept().setCode(code);
            while (this.current().type == TokenType.SEMI || this.current().type == TokenType.COMMA) {
                this.consume(this.current().type);
                if (this.current().type == TokenType.STAR) {
                    this.consume(TokenType.STAR);
                    conceptSet.addFilter().setProperty("concept").setOp(Enumerations.FilterOperator.EXISTS).setValue("true");
                    continue;
                }
                if (this.current().type == TokenType.IN) {
                    this.parseIncludeVs(conceptSet);
                    continue;
                }
                code = this.parseCode();
                conceptSet.addConcept().setCode(code);
            }
        }

        private void parseSimpleExpr(String systemUri, boolean isExclusion) throws VCLParseException {
            ValueSet.ConceptSetComponent conceptSet = this.createConceptSet(systemUri, isExclusion);
            if (this.peek().type == TokenType.DOT) {
                this.parseOf(systemUri, conceptSet);
            } else if (this.current().type == TokenType.STAR) {
                this.consume(TokenType.STAR);
                conceptSet.addFilter().setProperty("concept").setOp(Enumerations.FilterOperator.EXISTS).setValue("true");
            } else if (this.current().type == TokenType.SCODE || this.current().type == TokenType.QUOTED_VALUE) {
                if (this.current().type == TokenType.SCODE && this.current().value.contains(".")) {
                    this.parseOf(systemUri, conceptSet);
                } else {
                    String code = this.parseCode();
                    if (this.isFilterOperator(this.current().type)) {
                        this.parseFilter(conceptSet, code);
                    } else {
                        conceptSet.addConcept().setCode(code);
                    }
                }
            } else if (this.current().type == TokenType.IN) {
                this.parseIncludeVs(conceptSet);
            } else {
                this.parseOf(systemUri, conceptSet);
            }
        }

        private void parseOf(String systemUri, ValueSet.ConceptSetComponent conceptSet) throws VCLParseException {
            boolean isVcl = false;
            StringBuilder sb = new StringBuilder();
            switch (this.current().type) {
                case LCRLY: {
                    this.consume(TokenType.LCRLY);
                    if (this.peek().type == TokenType.COMMA) {
                        sb.append(this.parseCode());
                        while (this.current().type == TokenType.COMMA) {
                            this.consume(TokenType.COMMA);
                            sb.append(",").append(this.parseCode());
                        }
                    } else {
                        isVcl = true;
                        this.parseFilterList(sb);
                    }
                    this.consume(TokenType.RCRLY);
                    break;
                }
                case STAR: {
                    sb.append(this.current().value);
                    this.consume(TokenType.STAR);
                    break;
                }
                case URI: {
                    sb.append(this.current().value);
                    this.consume(TokenType.URI);
                    break;
                }
                case SCODE: 
                case QUOTED_VALUE: {
                    sb.append(this.current().value);
                    this.parseCode();
                    break;
                }
                default: {
                    throw new VCLParseException("Expected code, codeList, STAR, URI or filterList", this.current().position);
                }
            }
            this.consume(TokenType.DOT);
            String property = this.parseCode();
            String implicitVcl = isVcl ? Parser.getImplicitVcl(systemUri, sb.toString()) : sb.toString();
            this.addOf(conceptSet, property, implicitVcl);
        }

        private void addOf(ValueSet.ConceptSetComponent conceptSet, String property, String value) {
            ValueSet.ConceptSetFilterComponent filter = conceptSet.addFilter().setProperty(property).setOp(Enumerations.FilterOperator.EQUAL).setValue(value);
            filter.addExtension().setUrl("http://hl7.org/fhir/6.0/StructureDefinition/extension-ValueSet.compose.include.filter.op").setValue(new CodeType("of"));
        }

        private void parseFilter(ValueSet.ConceptSetComponent conceptSet, String property) throws VCLParseException {
            ValueSet.ConceptSetFilterComponent filter = conceptSet.addFilter();
            filter.setProperty(property);
            TokenType op = this.current().type;
            this.consume(op);
            switch (op) {
                case EQ: {
                    filter.setOp(Enumerations.FilterOperator.EQUAL);
                    filter.setValue(this.parseCode());
                    break;
                }
                case IS_A: {
                    filter.setOp(Enumerations.FilterOperator.ISA);
                    filter.setValue(this.parseCode());
                    break;
                }
                case IS_NOT_A: {
                    filter.setOp(Enumerations.FilterOperator.ISNOTA);
                    filter.setValue(this.parseCode());
                    break;
                }
                case DESC_OF: {
                    filter.setOp(Enumerations.FilterOperator.DESCENDENTOF);
                    filter.setValue(this.parseCode());
                    break;
                }
                case REGEX: {
                    filter.setOp(Enumerations.FilterOperator.REGEX);
                    filter.setValue(this.parseQuotedString());
                    break;
                }
                case IN: {
                    filter.setOp(Enumerations.FilterOperator.IN);
                    filter.setValue(this.parseFilterValue(conceptSet.getSystem()));
                    break;
                }
                case NOT_IN: {
                    filter.setOp(Enumerations.FilterOperator.NOTIN);
                    filter.setValue(this.parseFilterValue(conceptSet.getSystem()));
                    break;
                }
                case GENERALIZES: {
                    filter.setOp(Enumerations.FilterOperator.GENERALIZES);
                    filter.setValue(this.parseCode());
                    break;
                }
                case CHILD_OF: {
                    filter.setOp(Enumerations.FilterOperator.CHILDOF);
                    filter.setValue(this.parseCode());
                    break;
                }
                case DESC_LEAF: {
                    filter.setOp(Enumerations.FilterOperator.DESCENDENTLEAF);
                    filter.setValue(this.parseCode());
                    break;
                }
                case EXISTS: {
                    filter.setOp(Enumerations.FilterOperator.EXISTS);
                    filter.setValue(this.parseCode());
                    break;
                }
                default: {
                    throw new VCLParseException("Unexpected filter operator: " + String.valueOf((Object)op), this.current().position);
                }
            }
        }

        private void parseIncludeVs(ValueSet.ConceptSetComponent conceptSet) throws VCLParseException {
            this.consume(TokenType.IN);
            if (this.current().type == TokenType.URI) {
                conceptSet.addValueSet(this.current().value);
                this.consume(TokenType.URI);
            } else if (this.current().type == TokenType.OPEN) {
                this.consume(TokenType.OPEN);
                conceptSet.addValueSet(this.current().value);
                this.consume(TokenType.URI);
                this.consume(TokenType.CLOSE);
            } else {
                throw new VCLParseException("Expected URI after ^", this.current().position);
            }
        }

        private void parseConjunction() throws VCLParseException {
            ValueSet.ConceptSetComponent currentConceptSet = this.getCurrentConceptSet(false);
            while (this.current().type == TokenType.COMMA) {
                this.consume(TokenType.COMMA);
                if (this.current().type == TokenType.SCODE || this.current().type == TokenType.QUOTED_VALUE) {
                    String code = this.parseCode();
                    if (this.isFilterOperator(this.current().type)) {
                        this.parseFilter(currentConceptSet, code);
                        continue;
                    }
                    currentConceptSet.addConcept().setCode(code);
                    continue;
                }
                this.parseSubExpr(false);
            }
        }

        private void parseConjunctionWithFlag(boolean isExclusion) throws VCLParseException {
            ValueSet.ConceptSetComponent currentConceptSet = this.getCurrentConceptSet(isExclusion);
            while (this.current().type == TokenType.COMMA) {
                this.consume(TokenType.COMMA);
                if (this.current().type == TokenType.SCODE || this.current().type == TokenType.QUOTED_VALUE) {
                    String code = this.parseCode();
                    if (this.isFilterOperator(this.current().type)) {
                        this.parseFilter(currentConceptSet, code);
                        continue;
                    }
                    currentConceptSet.addConcept().setCode(code);
                    continue;
                }
                this.parseSubExpr(isExclusion);
            }
        }

        private void parseDisjunction() throws VCLParseException {
            while (this.current().type == TokenType.SEMI) {
                this.consume(TokenType.SEMI);
                this.parseSubExpr(false);
            }
        }

        private void parseDisjunctionWithFlag(boolean isExclusion) throws VCLParseException {
            while (this.current().type == TokenType.SEMI) {
                this.consume(TokenType.SEMI);
                this.parseSubExpr(isExclusion);
            }
        }

        private void parseExclusion() throws VCLParseException {
            this.consume(TokenType.DASH);
            this.parseSubExpr(true);
        }

        private String parseCode() throws VCLParseException {
            if (this.current().type == TokenType.SCODE) {
                String code = this.current().value;
                this.consume(TokenType.SCODE);
                return code;
            }
            if (this.current().type == TokenType.QUOTED_VALUE) {
                String code = this.current().value;
                this.consume(TokenType.QUOTED_VALUE);
                return code;
            }
            throw new VCLParseException("Expected code", this.current().position);
        }

        private String parseQuotedString() throws VCLParseException {
            if (this.current().type == TokenType.QUOTED_VALUE) {
                String value = this.current().value;
                this.consume(TokenType.QUOTED_VALUE);
                return value;
            }
            throw new VCLParseException("Expected quoted string", this.current().position);
        }

        private String parseFilterValue(String systemUri) throws VCLParseException {
            if (this.current().type == TokenType.LCRLY) {
                this.consume(TokenType.LCRLY);
                StringBuilder sb = new StringBuilder();
                sb.append(this.parseCode());
                if (this.isFilterOperator(this.current().type)) {
                    this.parseFilterList(sb);
                    this.consume(TokenType.RCRLY);
                    return Parser.getImplicitVcl(systemUri, sb.toString());
                }
                while (this.current().type == TokenType.COMMA) {
                    this.consume(TokenType.COMMA);
                    sb.append(",").append(this.parseCode());
                }
                this.consume(TokenType.RCRLY);
                return sb.toString();
            }
            if (this.current().type == TokenType.URI) {
                String uri = this.current().value;
                this.consume(TokenType.URI);
                return uri;
            }
            return this.parseCode();
        }

        private void parseFilterList(StringBuilder sb) throws VCLParseException {
            int depth = 1;
            while (depth > 0) {
                TokenType tokenType = this.current().type;
                switch (tokenType) {
                    case LCRLY: {
                        ++depth;
                        break;
                    }
                    case RCRLY: {
                        --depth;
                        break;
                    }
                }
                if (depth <= 0) continue;
                sb.append(this.current().value);
                this.consume(tokenType);
            }
        }

        private ValueSet.ConceptSetComponent createConceptSet(String systemUri, boolean isExclusion) {
            ValueSet.ConceptSetComponent conceptSet = new ValueSet.ConceptSetComponent();
            if (systemUri != null) {
                conceptSet.setSystem(systemUri);
            }
            if (isExclusion) {
                this.compose.addExclude(conceptSet);
            } else {
                this.compose.addInclude(conceptSet);
            }
            return conceptSet;
        }

        private ValueSet.ConceptSetComponent getCurrentConceptSet(boolean isExclusion) {
            if (isExclusion) {
                List<ValueSet.ConceptSetComponent> excludes = this.compose.getExclude();
                return excludes.isEmpty() ? this.createConceptSet(null, true) : excludes.get(excludes.size() - 1);
            }
            List<ValueSet.ConceptSetComponent> includes = this.compose.getInclude();
            return includes.isEmpty() ? this.createConceptSet(null, false) : includes.get(includes.size() - 1);
        }

        private boolean isFilterOperator(TokenType type) {
            return type == TokenType.EQ || type == TokenType.IS_A || type == TokenType.IS_NOT_A || type == TokenType.DESC_OF || type == TokenType.REGEX || type == TokenType.IN || type == TokenType.NOT_IN || type == TokenType.GENERALIZES || type == TokenType.CHILD_OF || type == TokenType.DESC_LEAF || type == TokenType.EXISTS;
        }

        private Token current() {
            return this.pos < this.tokens.size() ? this.tokens.get(this.pos) : new Token(TokenType.EOF, "", -1);
        }

        private Token peek() {
            return this.pos + 1 < this.tokens.size() ? this.tokens.get(this.pos + 1) : new Token(TokenType.EOF, "", -1);
        }

        private void consume(TokenType expected) throws VCLParseException {
            if (this.current().type != expected) {
                throw new VCLParseException("Expected " + String.valueOf((Object)expected) + " but got " + String.valueOf((Object)this.current().type), this.current().position);
            }
            ++this.pos;
        }

        private void expect(TokenType expected) throws VCLParseException {
            if (this.current().type != expected) {
                throw new VCLParseException("Expected " + String.valueOf((Object)expected) + " but got " + String.valueOf((Object)this.current().type), this.current().position);
            }
        }
    }

    private static class Token {
        TokenType type;
        String value;
        int position;

        Token(TokenType type, String value, int position) {
            this.type = type;
            this.value = value;
            this.position = position;
        }

        public String toString() {
            return String.valueOf((Object)this.type) + "(" + this.value + ")";
        }
    }

    private static enum TokenType {
        DASH,
        OPEN,
        CLOSE,
        LCRLY,
        RCRLY,
        SEMI,
        COMMA,
        DOT,
        STAR,
        EQ,
        IS_A,
        IS_NOT_A,
        DESC_OF,
        REGEX,
        IN,
        NOT_IN,
        GENERALIZES,
        CHILD_OF,
        DESC_LEAF,
        EXISTS,
        URI,
        SCODE,
        QUOTED_VALUE,
        EOF;

    }
}

