/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class DefinitionNavigator {
    private IWorkerContext context;
    private StructureDefinition structure;
    private int index;
    private boolean indexMatches;
    private List<DefinitionNavigator> children;
    private List<DefinitionNavigator> typeChildren;
    private List<DefinitionNavigator> slices;
    private List<String> names = new ArrayList<String>();
    private ElementDefinition.TypeRefComponent typeOfChildren;
    private String globalPath;
    private String localPath;
    private boolean diff;
    private boolean followTypes;
    private boolean inlineChildren;
    private ElementDefinition.ElementDefinitionSlicingComponent manualSlice;
    private ElementDefinition.TypeRefComponent manualType;

    public DefinitionNavigator(IWorkerContext context, StructureDefinition structure, boolean diff, boolean followTypes) throws DefinitionException {
        if (!diff && !structure.hasSnapshot()) {
            throw new DefinitionException("Snapshot required");
        }
        this.context = context;
        this.structure = structure;
        this.index = 0;
        this.diff = diff;
        this.followTypes = followTypes;
        if (diff) {
            this.globalPath = structure.getType();
            this.indexMatches = this.globalPath.equals(this.list().get(0).getPath());
        } else {
            this.indexMatches = true;
            this.globalPath = this.current().getPath();
        }
        this.localPath = this.globalPath;
        this.names.add(this.nameTail());
    }

    private DefinitionNavigator(IWorkerContext context, StructureDefinition structure, boolean diff, boolean followTypes, int index, String globalPath, String localPath, List<String> names, String type) {
        this.globalPath = globalPath;
        this.localPath = localPath;
        this.context = context;
        this.structure = structure;
        this.diff = diff;
        this.followTypes = followTypes;
        this.index = index;
        this.indexMatches = true;
        if (type == null) {
            for (String name : names) {
                this.names.add(name + "." + this.nameTail());
            }
        } else {
            this.names.addAll(names);
            this.names.add(type);
        }
    }

    public DefinitionNavigator(DefinitionNavigator other, boolean followTypes) {
        this.context = other.context;
        this.structure = other.structure;
        this.index = other.index;
        this.diff = other.diff;
        this.followTypes = followTypes;
        this.globalPath = other.globalPath;
        this.localPath = other.localPath;
        this.indexMatches = other.indexMatches;
        this.typeOfChildren = other.typeOfChildren;
        this.inlineChildren = other.inlineChildren;
        this.manualSlice = other.manualSlice;
        this.manualType = other.manualType;
    }

    public List<String> getNames() {
        return this.names;
    }

    private List<ElementDefinition> list() {
        if (this.diff) {
            return this.structure.getDifferential().getElement();
        }
        return this.structure.getSnapshot().getElement();
    }

    public ElementDefinition current() {
        return this.indexMatches ? this.list().get(this.index) : null;
    }

    public List<DefinitionNavigator> slices() throws DefinitionException {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.slices != null ? this.slices : Collections.emptyList();
    }

    public List<DefinitionNavigator> children() throws DefinitionException {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.children;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadChildren() throws DefinitionException {
        int i;
        this.children = new ArrayList<DefinitionNavigator>();
        Object prefix = this.localPath + ".";
        HashMap<String, DefinitionNavigator> nameMap = new HashMap<String, DefinitionNavigator>();
        int workingIndex = this.index;
        ElementDefinition curr = this.current();
        if (curr != null && curr.hasContentReference() && (workingIndex >= this.list().size() - 1 || !this.list().get(workingIndex + 1).getPath().startsWith((String)prefix))) {
            String ref = curr.getContentReference();
            if (ref.contains("#")) {
                ref = ref.substring(ref.indexOf("#") + 1);
            }
            prefix = ref;
            workingIndex = this.getById(this.list(), ref);
        }
        DefinitionNavigator last = null;
        String polymorphicRoot = null;
        DefinitionNavigator polymorphicDN = null;
        int n = i = this.indexMatches ? workingIndex + 1 : workingIndex;
        while (i < this.list().size()) {
            String path = this.list().get(i).getPath();
            if (path.startsWith((String)prefix)) {
                if (!path.substring(((String)prefix).length()).contains(".")) {
                    last = dn = new DefinitionNavigator(this.context, this.structure, this.diff, this.followTypes, i, this.globalPath + "." + this.tail(path), path, this.names, null);
                    if (nameMap.containsKey(path)) {
                        DefinitionNavigator master = (DefinitionNavigator)nameMap.get(path);
                        ElementDefinition cm = master.current();
                        if (!this.diff && !cm.hasSlicing()) {
                            boolean isExtension;
                            String cmPath = cm.getPath();
                            boolean bl = isExtension = cmPath.endsWith(".extension") || cmPath.endsWith(".modifierExtension");
                            if (!isExtension) {
                                throw new DefinitionException("Found slices with no slicing details at " + dn.current().getPath());
                            }
                        }
                        if (master.slices == null) {
                            master.slices = new ArrayList<DefinitionNavigator>();
                        }
                        master.slices.add(dn);
                    } else if (polymorphicRoot != null && path.startsWith(polymorphicRoot) && !path.substring(polymorphicRoot.length()).contains(".")) {
                        if (polymorphicDN.slices == null) {
                            polymorphicDN.slices = new ArrayList<DefinitionNavigator>();
                            polymorphicDN.manualSlice = new ElementDefinition.ElementDefinitionSlicingComponent();
                            polymorphicDN.manualSlice.setUserData("DN_TRANSIENT", "true");
                            polymorphicDN.manualSlice.setRules(ElementDefinition.SlicingRules.CLOSED);
                            polymorphicDN.manualSlice.setOrdered(false);
                            polymorphicDN.manualSlice.addDiscriminator().setType(ElementDefinition.DiscriminatorType.TYPE).setPath("$this");
                        }
                        polymorphicDN.slices.add(dn);
                        if (!dn.current().hasType()) {
                            String t = path.substring(polymorphicRoot.length());
                            StructureDefinition sd = this.context.fetchTypeDefinition(t);
                            if (sd == null) {
                                sd = this.context.fetchTypeDefinition(Utilities.uncapitalize((String)t));
                            }
                            if (sd != null) {
                                dn.manualType = new ElementDefinition.TypeRefComponent(sd.getType());
                            }
                        }
                    } else if (dn.current().hasSliceName()) {
                        if (!this.diff || !"extension".equals(dn.current().getName())) throw new DefinitionException(this.context.formatMessage("DN_SLICE_NO_DEFINITION", path));
                        StructureDefinition vsd = new StructureDefinition();
                        vsd.getDifferential().getElement().add(this.makeExtensionDefinitionElement(path));
                        DefinitionNavigator master = new DefinitionNavigator(this.context, vsd, this.diff, this.followTypes, 0, this.globalPath + "." + this.tail(path), path, this.names, null);
                        nameMap.put(path, master);
                        this.children.add(master);
                        master.slices = new ArrayList<DefinitionNavigator>();
                        master.slices.add(dn);
                    } else {
                        nameMap.put(path, dn);
                        this.children.add(dn);
                        if (this.diff && path.endsWith("[x]")) {
                            polymorphicRoot = path.substring(0, path.length() - 3);
                            polymorphicDN = dn;
                        } else {
                            polymorphicRoot = null;
                            polymorphicDN = null;
                        }
                    }
                } else if (last == null || !path.startsWith(last.localPath)) {
                    dn = new DefinitionNavigator(this.context, this.structure, this.diff, this.followTypes, i, this.globalPath + "." + this.tail(path), path, this.names, null);
                    nameMap.put(path, dn);
                    this.children.add(dn);
                }
            } else if (path.length() < ((String)prefix).length()) break;
            ++i;
        }
        if (this.children.isEmpty() && this.current().hasContentReference()) {
            throw new Error("What?");
        }
        boolean bl = this.inlineChildren = !this.children.isEmpty();
        if (!this.children.isEmpty() || !this.followTypes) return;
        ElementDefinition ed = this.current();
        if (ed.getType().size() != 1) {
            return;
        }
        ElementDefinition.TypeRefComponent tr = ed.getTypeFirstRep();
        StructureDefinition sdt = null;
        if (tr.getProfile().size() > 1) {
            return;
        }
        sdt = tr.getProfile().size() == 1 ? this.context.fetchResource(StructureDefinition.class, tr.getProfile().get(0).asStringValue()) : this.context.fetchTypeDefinition(ed.getTypeFirstRep().getWorkingCode());
        if (sdt == null) {
            return;
        }
        List<ElementDefinition> list = this.diff ? sdt.getDifferential().getElement() : sdt.getSnapshot().getElement();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ElementDefinition edt = list.get(i2);
            if (Utilities.charCount((String)edt.getPath(), (char)'.') != 1) continue;
            DefinitionNavigator dn = new DefinitionNavigator(this.context, sdt, this.diff, this.followTypes, i2, this.globalPath + "." + this.tail(edt.getPath()), edt.getPath(), this.names, null);
            this.children.add(dn);
        }
    }

    private int getById(List<ElementDefinition> list, String ref) {
        for (ElementDefinition ed : list) {
            if (!ref.equals(ed.getPath())) continue;
            return list.indexOf(ed);
        }
        return -1;
    }

    private ElementDefinition makeExtensionDefinitionElement(String path) {
        ElementDefinition ed = new ElementDefinition(path);
        ed.setUserData("DN_TRANSIENT", "true");
        ed.getSlicing().setRules(ElementDefinition.SlicingRules.OPEN).setOrdered(false).addDiscriminator().setType(ElementDefinition.DiscriminatorType.VALUE).setPath("url");
        return ed;
    }

    public String globalPath() {
        return this.globalPath;
    }

    public String localPath() {
        return this.localPath;
    }

    private String tail(String p) {
        if (p.contains(".")) {
            return p.substring(p.lastIndexOf(46) + 1);
        }
        return p;
    }

    public String nameTail() {
        return this.tail(this.localPath);
    }

    public boolean hasTypeChildren(ElementDefinition.TypeRefComponent type, Resource res) throws DefinitionException {
        if (this.typeChildren == null || this.typeOfChildren != type) {
            this.loadTypedChildren(type, res);
        }
        return !this.typeChildren.isEmpty();
    }

    private void loadTypedChildren(ElementDefinition.TypeRefComponent type, Resource src) throws DefinitionException {
        this.typeOfChildren = null;
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, type.getWorkingCode(), src);
        if (sd == null) {
            throw new DefinitionException("Unable to find definition for " + type.getWorkingCode() + (String)(type.hasProfile() ? "(" + String.valueOf(type.getProfile()) + ")" : ""));
        }
        DefinitionNavigator dn = new DefinitionNavigator(this.context, sd, this.diff, this.followTypes, 0, this.globalPath, this.localPath, this.names, sd.getType());
        this.typeChildren = dn.children();
        this.typeOfChildren = type;
    }

    public List<DefinitionNavigator> childrenFromType(ElementDefinition.TypeRefComponent type, Resource res) throws DefinitionException {
        if (this.typeChildren == null || this.typeOfChildren != type) {
            this.loadTypedChildren(type, res);
        }
        return this.typeChildren;
    }

    public StructureDefinition getStructure() {
        return this.structure;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.current() == null ? this.localPath : (this.current().hasSliceName() ? this.current().getPath() + ":" + this.current().getSliceName() : this.current().getPath());
    }

    public Base parent() {
        return null;
    }

    public boolean sliced() {
        if (this.manualSlice != null) {
            return true;
        }
        if (this.current() == null) {
            return false;
        }
        return this.current().hasSlicing();
    }

    public DefinitionNavigator childByPath(String path) {
        for (DefinitionNavigator child : this.children()) {
            if (!child.globalPath().equals(path)) continue;
            return child;
        }
        return null;
    }

    public boolean hasChildren() {
        return !this.children().isEmpty();
    }

    public boolean hasSlices() {
        return this.sliced() && this.slices != null && !this.slices.isEmpty();
    }

    public boolean hasInlineChildren() {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.inlineChildren;
    }

    public DefinitionNavigator childByName(String name) {
        for (DefinitionNavigator child : this.children()) {
            if (child.current().getName().equals(name)) {
                return child;
            }
            if (!child.current().getName().startsWith(name + "[x]")) continue;
            return child;
        }
        return null;
    }

    public boolean isManualSliced() {
        return this.manualSlice != null;
    }

    public ElementDefinition.ElementDefinitionSlicingComponent getSlicing() {
        return this.manualSlice != null ? this.manualSlice : this.current().getSlicing();
    }

    public void setManualSliced(ElementDefinition.ElementDefinitionSlicingComponent manualSliced) {
        this.manualSlice = manualSliced;
    }

    public ElementDefinition.TypeRefComponent getManualType() {
        return this.manualType;
    }
}

