/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MarkedToMoveToAdjunctPackage
public class ResourceDependencyWalker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceDependencyWalker.class);
    private IResourceDependencyNotifier notifier = new NullResourceDependencyNotifier();
    private IWorkerContext context;
    private Set<String> processedLinks = new HashSet<String>();
    private Set<Resource> processedResources = new HashSet<Resource>();

    public ResourceDependencyWalker(IWorkerContext context, IResourceDependencyNotifier notifier) {
        this.notifier = notifier;
        this.context = context;
    }

    public ResourceDependencyWalker(IWorkerContext context) {
        this.context = context;
    }

    private void notify(Resource resource, String prefix) {
        Object summary = null;
        summary = resource instanceof CanonicalResource ? ((CanonicalResource)resource).getVersionedUrl() : resource.fhirType() + "/" + resource.getIdPart();
        if (resource.getSourcePackage() != null) {
            summary = (String)summary + " from " + String.valueOf(resource.getSourcePackage());
        }
        this.notifier.seeResource(resource, prefix + (String)summary);
    }

    public void walk(Resource res) {
        this.notify(res, "Find Dependencies for ");
        this.processedResources.add(res);
        this.doWalk(res);
    }

    private void walkIntoLink(String value, CanonicalResource source) {
        if (value != null) {
            String key;
            String string = key = source.getSourcePackage() == null ? value : value + " from " + source.getSourcePackage().getVID();
            if (!this.processedLinks.contains(key)) {
                this.processedLinks.add(key);
                Resource tgt = this.context.fetchResource(Resource.class, value, source);
                if (tgt == null && Utilities.charCount((String)value, (char)'/') == 1) {
                    tgt = this.context.fetchResourceById(value.substring(0, value.indexOf(47)), value.substring(value.indexOf(47) + 1));
                }
                if (tgt == null) {
                    this.notifier.brokenLink(key);
                } else if (!this.processedResources.contains(tgt) && !this.isCore(tgt)) {
                    this.processedResources.add(tgt);
                    this.notify(tgt, "Depends On ");
                    this.doWalk(tgt);
                }
            }
        }
    }

    private boolean isCore(Resource tgt) {
        return tgt.hasSourcePackage() && "hl7.fhir.r5.core".equals(tgt.getSourcePackage().getId());
    }

    private void doWalk(Resource res) {
        if (res instanceof StructureDefinition) {
            this.walkSD((StructureDefinition)res);
        } else if (res instanceof ValueSet) {
            this.walkVS((ValueSet)res);
        } else if (res instanceof CodeSystem) {
            this.walkCS((CodeSystem)res);
        } else if (res instanceof CapabilityStatement) {
            this.walkCS((CapabilityStatement)res);
        } else if (res instanceof ConceptMap) {
            this.walkCM((ConceptMap)res);
        } else if (res instanceof NamingSystem) {
            this.walkNS((NamingSystem)res);
        } else if (res instanceof OperationDefinition) {
            this.walkOD((OperationDefinition)res);
        } else if (res instanceof SearchParameter) {
            this.walkSP((SearchParameter)res);
        } else if (res instanceof Questionnaire) {
            this.walkQ((Questionnaire)res);
        } else {
            throw new Error("Resource " + res.fhirType() + " not Processed yet");
        }
    }

    private void walkSP(SearchParameter sp) {
        this.walkCR(sp);
        this.walkIntoLink(sp.getDerivedFrom(), sp);
        for (SearchParameter.SearchParameterComponentComponent spc : sp.getComponent()) {
            this.walkIntoLink(spc.getDefinition(), sp);
        }
    }

    private void walkQ(Questionnaire q) {
        this.walkCR(q);
        this.walkCT(q.getDerivedFrom(), q);
        for (Questionnaire.QuestionnaireItemComponent item : q.getItem()) {
            this.walkQItem(item, q);
        }
    }

    private void walkQItem(Questionnaire.QuestionnaireItemComponent item, Questionnaire q) {
        this.walkIntoLink(item.getDefinition(), q);
        this.walkIntoLink(item.getAnswerValueSet(), q);
        for (Questionnaire.QuestionnaireItemEnableWhenComponent ew : item.getEnableWhen()) {
            if (!ew.hasAnswerReference()) continue;
            this.walkIntoLink(ew.getAnswerReference().getReference(), q);
        }
        for (Questionnaire.QuestionnaireItemAnswerOptionComponent ao : item.getAnswerOption()) {
            if (!ao.hasValueReference()) continue;
            this.walkIntoLink(ao.getValueReference().getReference(), q);
        }
        for (Questionnaire.QuestionnaireItemInitialComponent iv : item.getInitial()) {
            if (!iv.hasValueReference()) continue;
            this.walkIntoLink(iv.getValueReference().getReference(), q);
        }
        this.walkIntoLink(item.getDefinition(), q);
        for (Questionnaire.QuestionnaireItemComponent child : item.getItem()) {
            this.walkQItem(child, q);
        }
    }

    private void walkOD(OperationDefinition od) {
        this.walkCR(od);
        this.walkIntoLink(od.getBase(), od);
        this.walkIntoLink(od.getInputProfile(), od);
        this.walkIntoLink(od.getOutputProfile(), od);
        for (OperationDefinition.OperationDefinitionParameterComponent p : od.getParameter()) {
            this.walkODP(od, p);
        }
    }

    private void walkODP(OperationDefinition od, OperationDefinition.OperationDefinitionParameterComponent p) {
        this.walkCT(p.getTargetProfile(), od);
        this.walkIntoLink(p.getBinding().getValueSet(), od);
        for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
            this.walkODP(od, pp);
        }
    }

    private void walkNS(NamingSystem ns) {
        this.walkCR(ns);
    }

    private void walkCM(ConceptMap cm) {
        this.walkCR(cm);
        this.walkRA(cm.getRelatedArtifact(), (CanonicalResource)cm);
        for (ConceptMap.PropertyComponent prop : cm.getProperty()) {
            this.walkIntoLink(prop.getUri(), cm);
        }
        for (ConceptMap.AdditionalAttributeComponent attr : cm.getAdditionalAttribute()) {
            this.walkIntoLink(attr.getUri(), cm);
        }
        this.walkIntoLink(cm.getSourceScope().primitiveValue(), cm);
        this.walkIntoLink(cm.getTargetScope().primitiveValue(), cm);
        for (ConceptMap.ConceptMapGroupComponent group : cm.getGroup()) {
            this.walkIntoLink(group.getSource(), cm);
            this.walkIntoLink(group.getTarget(), cm);
            this.walkIntoLink(group.getUnmapped().getValueSet(), cm);
            this.walkIntoLink(group.getUnmapped().getOtherMap(), cm);
            for (ConceptMap.SourceElementComponent elem : group.getElement()) {
                this.walkIntoLink(elem.getValueSet(), cm);
                for (ConceptMap.TargetElementComponent tgt : elem.getTarget()) {
                    this.walkIntoLink(tgt.getValueSet(), cm);
                }
            }
        }
    }

    private void walkCS(CapabilityStatement cs) {
        this.walkCR(cs);
        this.walkCT(cs.getInstantiates(), cs);
        this.walkCT(cs.getImports(), cs);
        this.walkCT(cs.getImplementationGuide(), cs);
        for (CapabilityStatement.CapabilityStatementRestComponent rest : cs.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent res : rest.getResource()) {
                this.walkIntoLink(res.getProfile(), cs);
                this.walkCT(res.getSupportedProfile(), cs);
                for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent srch : res.getSearchParam()) {
                    this.walkIntoLink(srch.getDefinition(), cs);
                }
                for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent op : res.getOperation()) {
                    this.walkIntoLink(op.getDefinition(), cs);
                }
            }
            for (CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent srch : rest.getSearchParam()) {
                this.walkIntoLink(srch.getDefinition(), cs);
            }
            for (CapabilityStatement.CapabilityStatementRestResourceOperationComponent op : rest.getOperation()) {
                this.walkIntoLink(op.getDefinition(), cs);
            }
        }
    }

    private void walkCS(CodeSystem cs) {
        this.walkCR(cs);
        this.walkRA(cs.getRelatedArtifact(), (CanonicalResource)cs);
        if (cs.hasValueSet()) {
            this.walkIntoLink(cs.getValueSet(), cs);
        }
        if (cs.hasSupplements()) {
            this.walkIntoLink(cs.getSupplements(), cs);
        }
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.hasUri()) continue;
            this.walkIntoLink(p.getUri(), cs);
        }
    }

    private void walkVS(ValueSet vs) {
        this.walkCR(vs);
        this.walkRA(vs.getRelatedArtifact(), (CanonicalResource)vs);
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.walkVSInc(inc, vs);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.walkVSInc(inc, vs);
        }
        if (vs.hasExpansion()) {
            ValueSet.ValueSetExpansionComponent exp = vs.getExpansion();
            for (ValueSet.ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : exp.getParameter()) {
                if (!valueSetExpansionParameterComponent.hasValueUriType()) continue;
                this.walkIntoLink(valueSetExpansionParameterComponent.getValueUriType().primitiveValue(), vs);
            }
            for (ValueSet.ValueSetExpansionPropertyComponent valueSetExpansionPropertyComponent : exp.getProperty()) {
                if (!valueSetExpansionPropertyComponent.hasUri()) continue;
                this.walkIntoLink(valueSetExpansionPropertyComponent.getUri(), vs);
            }
            for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : exp.getContains()) {
                this.walkCC(valueSetExpansionContainsComponent, vs);
            }
        }
    }

    private void walkCC(ValueSet.ValueSetExpansionContainsComponent cc, ValueSet vs) {
        this.walkIntoLink(cc.getSystem(), vs);
        for (ValueSet.ValueSetExpansionContainsComponent ccc : cc.getContains()) {
            this.walkCC(ccc, vs);
        }
    }

    private void walkVSInc(ValueSet.ConceptSetComponent inc, ValueSet vs) {
        this.walkCT(inc.getValueSet(), vs);
        this.walkIntoLink(inc.getSystem(), vs);
    }

    private void walkCT(List<CanonicalType> list, CanonicalResource source) {
        for (CanonicalType ct : list) {
            this.walkIntoLink((String)ct.getValue(), source);
        }
    }

    private void walkRA(List<RelatedArtifact> list, CanonicalResource source) {
        for (RelatedArtifact ra : list) {
            this.walkRA(ra, source);
        }
    }

    private void walkRA(RelatedArtifact ra, CanonicalResource source) {
        if (ra.hasResource()) {
            this.walkIntoLink(ra.getResource(), source);
        }
        if (ra.hasResourceReference()) {
            this.walkIntoLink(ra.getResourceReference().getReference(), source);
        }
    }

    private void walkSD(StructureDefinition sd) {
        this.walkCR(sd);
        this.walkIntoLink(sd.getBaseDefinition(), sd);
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            this.walkED(ed, sd);
        }
    }

    private void walkED(ElementDefinition ed, StructureDefinition sd) {
        for (ElementDefinition.TypeRefComponent type : ed.getType()) {
            if (Utilities.isAbsoluteUrl((String)type.getCode())) {
                this.walkIntoLink(type.getCode(), sd);
            }
            this.walkCT(type.getProfile(), sd);
            this.walkCT(type.getTargetProfile(), sd);
        }
        this.walkCT(ed.getValueAlternatives(), sd);
        if (ed.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent b = ed.getBinding();
            if (b.hasValueSet()) {
                this.walkIntoLink(b.getValueSet(), sd);
            }
            for (ElementDefinition.ElementDefinitionBindingAdditionalComponent ab : b.getAdditional()) {
                if (ab.hasValueSet()) {
                    this.walkIntoLink(ab.getValueSet(), sd);
                }
                if (!ab.hasUsage()) continue;
                this.walkUsage(ab.getUsage(), (CanonicalResource)sd);
            }
        }
    }

    private void walkUsage(List<UsageContext> usageList, CanonicalResource source) {
        for (UsageContext usage : usageList) {
            this.walkUsage(usage, source);
        }
    }

    private void walkUsage(UsageContext usage, CanonicalResource source) {
        if (usage.hasValueReference()) {
            this.walkReference(usage.getValueReference(), source);
        }
    }

    private void walkReference(Reference ref, CanonicalResource source) {
        if (ref.hasReference()) {
            this.walkIntoLink(ref.getReference(), source);
        }
    }

    private void walkCR(CanonicalResource cr) {
        this.walkDR(cr);
        this.walkUsage(cr.getUseContext(), cr);
    }

    private void walkDR(DomainResource dr) {
        this.walkRes(dr);
        for (Resource res : dr.getContained()) {
            this.walk(res);
        }
    }

    private void walkRes(Resource res) {
    }

    public class NullResourceDependencyNotifier
    implements IResourceDependencyNotifier {
        @Override
        public void seeResource(Resource resource, String summaryId) {
            log.info(summaryId);
        }

        @Override
        public void brokenLink(String link) {
            log.error("Broken Link: " + link);
        }
    }

    public static interface IResourceDependencyNotifier {
        public void seeResource(Resource var1, String var2);

        public void brokenLink(String var1);
    }
}

