/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.sql;

import java.math.BigDecimal;
import java.util.Date;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;

@MarkedToMoveToAdjunctPackage
public class Value {
    private String valueString;
    private Boolean valueBoolean;
    private Date valueDate;
    private Integer valueInt;
    private BigDecimal valueDecimal;
    private byte[] valueBinary;
    private Base valueComplex;

    private Value() {
    }

    public static Value makeString(String s) {
        Value v = new Value();
        v.valueString = s;
        return v;
    }

    public static Value makeBoolean(String s, Boolean b) {
        Value v = new Value();
        v.valueString = s;
        v.valueBoolean = b;
        return v;
    }

    public static Value makeDate(String s, Date d) {
        Value v = new Value();
        v.valueString = s;
        v.valueDate = d;
        return v;
    }

    public static Value makeInteger(String s, Integer i) {
        Value v = new Value();
        v.valueString = s;
        v.valueInt = i;
        return v;
    }

    public static Value makeDecimal(String s, BigDecimal bigDecimal) {
        Value v = new Value();
        v.valueString = s;
        v.valueDecimal = bigDecimal;
        return v;
    }

    public static Value makeBinary(String s, byte[] b) {
        Value v = new Value();
        v.valueString = s;
        v.valueBinary = b;
        return v;
    }

    public static Value makeComplex(Base b) {
        Value v = new Value();
        v.valueComplex = b;
        return v;
    }

    public String getValueString() {
        return this.valueString;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public Integer getValueInt() {
        return this.valueInt;
    }

    public BigDecimal getValueDecimal() {
        return this.valueDecimal;
    }

    public byte[] getValueBinary() {
        return this.valueBinary;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public Base getValueComplex() {
        return this.valueComplex;
    }

    public boolean hasValueString() {
        return this.valueString != null;
    }

    public boolean hasValueDate() {
        return this.valueDate != null;
    }

    public boolean hasValueInt() {
        return this.valueInt != null;
    }

    public boolean hasValueDecimal() {
        return this.valueDecimal != null;
    }

    public boolean hasValueBinary() {
        return this.valueBinary != null;
    }

    public boolean hasValueBoolean() {
        return this.valueBoolean != null;
    }

    public boolean hasValueComplex() {
        return this.valueComplex != null;
    }
}

