/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.xver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManager;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class XVerExtensionManagerNew
extends XVerExtensionManager {
    private Map<String, JsonObject> lists = new HashMap<String, JsonObject>();
    private final IXverManagerPackageLoader loader;

    public XVerExtensionManagerNew(IWorkerContext context, IXverManagerPackageLoader loader) {
        super(context);
        this.loader = loader;
    }

    @Override
    public XVerExtensionManager.XVerExtensionStatus status(String url) {
        StructureDefinition sd;
        if (url.length() < 54) {
            return XVerExtensionManager.XVerExtensionStatus.Invalid;
        }
        String v = url.substring(20, 23);
        String tv = VersionUtilities.getNameForVersion((String)v).toLowerCase();
        if (tv.contains("?")) {
            return XVerExtensionManager.XVerExtensionStatus.BadVersion;
        }
        String sv = VersionUtilities.getNameForVersion((String)this.context.getVersion()).toLowerCase();
        String pid = "hl7.fhir.uv.xver-" + tv + "." + sv;
        if (!this.context.hasPackage(pid, "dev")) {
            try {
                this.loader.loadPackage(pid + "#dev");
            }
            catch (IOException e) {
                return XVerExtensionManager.XVerExtensionStatus.BadVersion;
            }
        }
        if ((sd = this.context.fetchResource(StructureDefinition.class, url)) == null) {
            if (this.isValidPath(v, url)) {
                return XVerExtensionManager.XVerExtensionStatus.NotAllowed;
            }
            return XVerExtensionManager.XVerExtensionStatus.Unknown;
        }
        return XVerExtensionManager.XVerExtensionStatus.Valid;
    }

    private boolean isValidPath(String v, String url) {
        if (!this.lists.containsKey(v) && this.context.hasBinaryKey("xver-paths-" + v + ".json")) {
            try {
                this.lists.put(v, JsonParser.parseObject((byte[])this.context.getBinaryForKey("xver-paths-" + v + ".json")));
            }
            catch (IOException e1) {
                throw new FHIRException((Throwable)e1);
            }
            url = url.replace("%5Bx%5D", "[x]");
            String e = url.substring(54);
            JsonObject root = this.lists.get(v);
            JsonObject path = root.getJsonObject(e);
            if (path == null) {
                path = root.getJsonObject(e + "[x]");
            }
            if (path != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public StructureDefinition getDefinition(String url) {
        return this.context.fetchResource(StructureDefinition.class, url);
    }

    public static interface IXverManagerPackageLoader {
        public void loadPackage(String var1) throws IOException;
    }
}

