/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.xver;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.PackageHacker;

public class XVerExtensionManagerOld
extends XVerExtensionManager {
    private Map<String, JsonObject> lists = new HashMap<String, JsonObject>();

    public XVerExtensionManagerOld(IWorkerContext context) {
        super(context);
    }

    @Override
    public XVerExtensionManager.XVerExtensionStatus status(String url) throws FHIRException {
        JsonObject root;
        JsonObject path;
        if (url.length() < 54) {
            return XVerExtensionManager.XVerExtensionStatus.Invalid;
        }
        url = url.replace("%5Bx%5D", "[x]");
        String v = url.substring(20, 23);
        String e = url.substring(54);
        if (!this.lists.containsKey(v)) {
            if (this.context.hasBinaryKey("xver-paths-" + v + ".json")) {
                try {
                    this.lists.put(v, JsonParser.parseObject((byte[])this.context.getBinaryForKey("xver-paths-" + v + ".json")));
                }
                catch (IOException e1) {
                    throw new FHIRException(e);
                }
            } else {
                return XVerExtensionManager.XVerExtensionStatus.BadVersion;
            }
        }
        if ((path = (root = this.lists.get(v)).getJsonObject(e)) == null) {
            path = root.getJsonObject(e + "[x]");
        }
        if (path == null) {
            return XVerExtensionManager.XVerExtensionStatus.Unknown;
        }
        if (path.has("elements") || path.has("types")) {
            return XVerExtensionManager.XVerExtensionStatus.Valid;
        }
        return XVerExtensionManager.XVerExtensionStatus.Invalid;
    }

    @Override
    public StructureDefinition getDefinition(String url) {
        url = url.replace("%5Bx%5D", "[x]");
        String verSource = url.substring(20, 23);
        String verTarget = VersionUtilities.getMajMin((String)this.context.getVersion());
        String e = url.substring(54);
        String r = e.contains(".") ? e.substring(0, e.indexOf(".")) : e;
        JsonObject root = this.lists.get(verSource);
        JsonObject path = root.getJsonObject(e);
        if (path == null) {
            path = root.getJsonObject(e + "[x]");
        }
        StructureDefinition sd = new StructureDefinition();
        sd.setUserData("XVER_EXT_MARKER", "true");
        sd.setUserData("XVER_VER_MARKER", verSource);
        if (this.context.getResourceNamesAsSet().contains(r)) {
            sd.setWebPath(Utilities.pathURL((String[])new String[]{this.context.getSpecUrl(), r.toLowerCase() + "-definitions.html#" + e}));
        } else {
            sd.setWebPath(PackageHacker.fixPackageUrl((String)"https://hl7.org/fhir/versions.html#extensions"));
        }
        sd.setUrl(url);
        sd.setVersion(this.context.getVersion());
        sd.setFhirVersion(Enumerations.FHIRVersion.fromCode(this.context.getVersion()));
        sd.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        sd.setType("Extension");
        sd.setDerivation(StructureDefinition.TypeDerivationRule.CONSTRAINT);
        sd.setName("Extension-" + verSource + "-" + e);
        sd.setTitle("Extension Definition for " + e + " for Version " + verSource);
        sd.setStatus(Enumerations.PublicationStatus.ACTIVE);
        sd.setExperimental(false);
        sd.setDate(new Date());
        sd.setPublisher("FHIR Project");
        sd.setPurpose("Defined so the validator can validate cross version extensions (see http://hl7.org/fhir/versions.html#extensions)");
        sd.setAbstract(false);
        sd.addContext().setType(StructureDefinition.ExtensionContextType.ELEMENT).setExpression(this.head(e));
        sd.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Extension");
        if (path.has("types")) {
            sd.getDifferential().addElement().setPath("Extension.extension").setMax("0");
            sd.getDifferential().addElement().setPath("Extension.url").setFixed(new UriType(url));
            ElementDefinition val = sd.getDifferential().addElement().setPath("Extension.value[x]").setMin(1);
            this.populateTypes(path, val, verSource, verTarget);
        } else if (path.has("elements")) {
            for (JsonElement i : path.forceArray("elements").getItems()) {
                String apath = e + "." + i.asString();
                JsonObject elt = root.getJsonObject(apath);
                if (elt == null) continue;
                this.genExtensionContents(root, apath, verSource, verTarget, sd, i, elt, "Extension.extension");
            }
            sd.getDifferential().addElement().setPath("Extension.url").setFixed(new UriType(url));
            sd.getDifferential().addElement().setPath("Extension.value[x]").setMax("0");
        } else {
            throw new FHIRException("Internal error - attempt to define extension for " + url + " when it is invalid");
        }
        if (path.has("modifier") && path.asBoolean("modifier")) {
            ElementDefinition baseDef = new ElementDefinition("Extension");
            sd.getDifferential().getElement().add(0, baseDef);
            baseDef.setIsModifier(true);
        }
        return sd;
    }

    private void genExtensionContents(JsonObject root, String apath, String verSource, String verTarget, StructureDefinition sd, JsonElement i, JsonObject elt, String epath) {
        String s = i.asString().replace("[x]", "");
        sd.getDifferential().addElement().setPath(epath).setSliceName(s);
        if (elt.has("types")) {
            sd.getDifferential().addElement().setPath(epath + ".extension").setMax("0");
            sd.getDifferential().addElement().setPath(epath + ".url").setFixed(new UriType(s));
            ElementDefinition val = sd.getDifferential().addElement().setPath(epath + ".value[x]").setMin(1);
            this.populateTypes(elt, val, verSource, verTarget);
        } else if (elt.has("elements")) {
            for (JsonElement ic : elt.forceArray("elements").getItems()) {
                String apathC = apath + "." + ic.asString();
                JsonObject eltC = root.getJsonObject(apathC);
                if (eltC == null) continue;
                this.genExtensionContents(root, apathC, verSource, verTarget, sd, ic, eltC, epath + ".extension");
            }
            sd.getDifferential().addElement().setPath(epath + ".url").setFixed(new UriType(s));
            sd.getDifferential().addElement().setPath(epath + ".value[x]").setMax("0");
        } else {
            throw new FHIRException("Internal error - unknown element " + apath);
        }
    }

    private void populateTypes(JsonObject path, ElementDefinition val, String verSource, String verTarget) {
        for (JsonElement i : path.forceArray("types").getItems()) {
            String s = i.asString();
            if (s.startsWith("!")) continue;
            if (s.contains("(")) {
                String t = s.substring(0, s.indexOf("("));
                ElementDefinition.TypeRefComponent tr = val.addType().setCode(this.translateDataType(verTarget, t));
                if (!this.hasTargets(tr.getCode())) continue;
                s = s.substring(t.length() + 1);
                for (String p : s.substring(0, s.length() - 1).split("\\|")) {
                    if ("Any".equals(p)) {
                        tr.addTargetProfile("http://hl7.org/fhir/StructureDefinition/Resource");
                        continue;
                    }
                    if (p.contains(",")) {
                        for (String pp : p.split("\\,")) {
                            if (!this.isResource(pp)) continue;
                            tr.addTargetProfile("http://hl7.org/fhir/StructureDefinition/" + pp);
                        }
                        continue;
                    }
                    if (!this.isResource(p)) continue;
                    tr.addTargetProfile("http://hl7.org/fhir/StructureDefinition/" + p);
                }
                continue;
            }
            val.addType().setCode(this.translateDataType(verTarget, s));
        }
    }

    private boolean isResource(String p) {
        return this.context.getResourceNames().contains(p);
    }

    private boolean hasTargets(String dt) {
        return Utilities.existsInList((String)dt, (String[])new String[]{"canonical", "Reference", "CodeableReference"});
    }

    private String translateDataType(String v, String dt) {
        if (VersionUtilities.versionMatches((String)"1.0.x", (String)v) || VersionUtilities.versionMatches((String)"1.4.x", (String)v)) {
            return this.translateToR2(dt);
        }
        if (VersionUtilities.versionMatches((String)"3.0.x", (String)v)) {
            return this.translateToR3(dt);
        }
        return dt;
    }

    private String translateToR3(String dt) {
        if ("canonical".equals(dt)) {
            return "uri";
        }
        if ("url".equals(dt)) {
            return "uri";
        }
        return dt;
    }

    private String translateToR2(String dt) {
        if ("canonical".equals(dt)) {
            return "uri";
        }
        if ("url".equals(dt)) {
            return "uri";
        }
        if ("uuid".equals(dt)) {
            return "id";
        }
        return dt;
    }

    private String head(String id) {
        if (id.contains(".")) {
            return id.substring(0, id.lastIndexOf("."));
        }
        return id;
    }
}

