/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.cache;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonTrackingParser;

public class NpmPackageIndexBuilder {
    private JsonObject index;
    private JsonArray files;

    public void start() {
        this.index = new JsonObject();
        this.index.addProperty("index-version", (Number)1);
        this.files = new JsonArray();
        this.index.add("files", (JsonElement)this.files);
    }

    public void seeFile(String name, byte[] content) {
        if (name.endsWith(".json")) {
            try {
                JsonObject json = JsonTrackingParser.parseJson(content);
                if (json.has("resourceType")) {
                    JsonObject fi = new JsonObject();
                    this.files.add((JsonElement)fi);
                    fi.addProperty("filename", name);
                    fi.addProperty("resourceType", json.get("resourceType").getAsString());
                    if (json.has("id") && json.get("id").isJsonPrimitive()) {
                        fi.addProperty("id", json.get("id").getAsString());
                    }
                    if (json.has("url") && json.get("url").isJsonPrimitive()) {
                        fi.addProperty("url", json.get("url").getAsString());
                    }
                    if (json.has("version") && json.get("version").isJsonPrimitive()) {
                        fi.addProperty("version", json.get("version").getAsString());
                    }
                    if (json.has("kind") && json.get("kind").isJsonPrimitive()) {
                        fi.addProperty("kind", json.get("kind").getAsString());
                    }
                    if (json.has("type") && json.get("type").isJsonPrimitive()) {
                        fi.addProperty("type", json.get("type").getAsString());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error parsing " + name + ": " + e.getMessage());
            }
        }
    }

    public String build() {
        String res = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.index);
        this.index = null;
        this.files = null;
        return res;
    }

    public void executeWithStatus(String folder) throws IOException {
        System.out.print("Index Package " + folder + " ... ");
        this.execute(folder);
        System.out.println("done");
    }

    public void execute(String folder) throws IOException {
        if (this.existsFolder(folder, "package")) {
            folder = Utilities.path(folder, "package");
        }
        if (!this.existsFile(folder, "package.json")) {
            throw new FHIRException("Not a proper package? (can't find package.json)");
        }
        this.start();
        File dir = new File(folder);
        for (File f : dir.listFiles()) {
            this.seeFile(f.getName(), TextFile.fileToBytes(f));
        }
        TextFile.stringToFile(this.build(), Utilities.path(folder, ".index.json"));
    }

    private boolean existsFolder(String ... args) throws IOException {
        File f = new File(Utilities.path(args));
        return f.exists() && f.isDirectory();
    }

    private boolean existsFile(String ... args) throws IOException {
        File f = new File(Utilities.path(args));
        return f.exists() && !f.isDirectory();
    }

    public static void main(String[] args) throws IOException {
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.4.0");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#3.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#4.0.1");
    }
}

