/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Stack;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class JsonTrackingParser {
    private Map<JsonElement, LocationData> map;
    private Lexer lexer;
    private ItemType itemType = ItemType.Object;
    private String itemName;
    private String itemValue;
    private boolean errorOnDuplicates = true;

    public static JsonObject parseJson(String source) throws IOException {
        return JsonTrackingParser.parse(source, null);
    }

    public static JsonObject parseJson(InputStream stream) throws IOException {
        return JsonTrackingParser.parse(TextFile.streamToString(stream), null);
    }

    public static JsonObject parseJson(byte[] stream) throws IOException {
        return JsonTrackingParser.parse(TextFile.bytesToString(stream), null);
    }

    public static JsonObject parseJson(byte[] stream, boolean allowDuplicates) throws IOException {
        return JsonTrackingParser.parse(TextFile.bytesToString(stream), null, allowDuplicates);
    }

    public static JsonObject parseJson(File source) throws IOException {
        return JsonTrackingParser.parse(TextFile.fileToString(source), null);
    }

    public static JsonObject parseJsonFile(String source) throws IOException {
        return JsonTrackingParser.parse(TextFile.fileToString(source), null);
    }

    public static JsonObject parse(String source, Map<JsonElement, LocationData> map) throws IOException {
        return JsonTrackingParser.parse(source, map, false);
    }

    public static JsonObject parse(String source, Map<JsonElement, LocationData> map, boolean allowDuplicates) throws IOException {
        JsonTrackingParser self = new JsonTrackingParser();
        self.map = map;
        self.setErrorOnDuplicates(!allowDuplicates);
        return self.parse(Utilities.stripBOM(source));
    }

    private JsonObject parse(String source) throws IOException {
        this.lexer = new Lexer(source);
        JsonObject result = new JsonObject();
        LocationData loc = this.lexer.location.copy();
        if (this.lexer.getType() != TokenType.Open) {
            throw this.lexer.error("Unexpected content at start of JSON: " + this.lexer.getType().toString());
        }
        this.lexer.next();
        this.lexer.states.push(new State("", false));
        this.parseProperty();
        this.readObject(result, true);
        if (this.map != null) {
            this.map.put((JsonElement)result, loc);
        }
        return result;
    }

    private void readObject(JsonObject obj, boolean root) throws IOException {
        if (this.map != null) {
            this.map.put((JsonElement)obj, this.lexer.location.copy());
        }
        while (this.itemType != ItemType.End || root && this.itemType == ItemType.Eof) {
            switch (this.itemType) {
                case Object: {
                    JsonObject child = new JsonObject();
                    LocationData loc = this.lexer.location.copy();
                    if (!obj.has(this.itemName)) {
                        obj.add(this.itemName, (JsonElement)child);
                    } else if (this.errorOnDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName);
                    }
                    this.next();
                    this.readObject(child, false);
                    if (this.map == null) break;
                    this.map.put((JsonElement)obj, loc);
                    break;
                }
                case Boolean: {
                    JsonPrimitive v = new JsonPrimitive(Boolean.valueOf(this.itemValue));
                    if (!obj.has(this.itemName)) {
                        obj.add(this.itemName, (JsonElement)v);
                    } else if (this.errorOnDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName);
                    }
                    if (this.map == null) break;
                    this.map.put((JsonElement)v, this.lexer.location.copy());
                    break;
                }
                case String: {
                    JsonPrimitive v = new JsonPrimitive(this.itemValue);
                    if (!obj.has(this.itemName)) {
                        obj.add(this.itemName, (JsonElement)v);
                    } else if (this.errorOnDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName);
                    }
                    if (this.map == null) break;
                    this.map.put((JsonElement)v, this.lexer.location.copy());
                    break;
                }
                case Number: {
                    JsonPrimitive v = new JsonPrimitive((Number)new PresentedBigDecimal(this.itemValue));
                    if (!obj.has(this.itemName)) {
                        obj.add(this.itemName, (JsonElement)v);
                    } else if (this.errorOnDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName);
                    }
                    if (this.map == null) break;
                    this.map.put((JsonElement)v, this.lexer.location.copy());
                    break;
                }
                case Null: {
                    JsonNull n = new JsonNull();
                    if (!obj.has(this.itemName)) {
                        obj.add(this.itemName, (JsonElement)n);
                    } else if (this.errorOnDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName);
                    }
                    if (this.map == null) break;
                    this.map.put((JsonElement)n, this.lexer.location.copy());
                    break;
                }
                case Array: {
                    JsonArray arr = new JsonArray();
                    LocationData loc = this.lexer.location.copy();
                    if (!obj.has(this.itemName)) {
                        obj.add(this.itemName, (JsonElement)arr);
                    } else if (this.errorOnDuplicates) {
                        throw this.lexer.error("Duplicated property name: " + this.itemName);
                    }
                    this.next();
                    if (!this.readArray(arr, false)) {
                        this.next(true);
                    }
                    if (this.map == null) break;
                    this.map.put((JsonElement)arr, loc);
                    break;
                }
                case Eof: {
                    throw this.lexer.error("Unexpected End of File");
                }
            }
            this.next();
        }
    }

    private boolean readArray(JsonArray arr, boolean root) throws IOException {
        boolean res = false;
        while (!(this.itemType == ItemType.End || root && this.itemType == ItemType.Eof)) {
            res = true;
            switch (this.itemType) {
                case Object: {
                    JsonObject obj = new JsonObject();
                    LocationData loc = this.lexer.location.copy();
                    arr.add((JsonElement)obj);
                    this.next();
                    this.readObject(obj, false);
                    if (this.map == null) break;
                    this.map.put((JsonElement)obj, loc);
                    break;
                }
                case String: {
                    JsonPrimitive v = new JsonPrimitive(this.itemValue);
                    arr.add((JsonElement)v);
                    if (this.map == null) break;
                    this.map.put((JsonElement)v, this.lexer.location.copy());
                    break;
                }
                case Number: {
                    JsonPrimitive v = new JsonPrimitive((Number)new BigDecimal(this.itemValue));
                    arr.add((JsonElement)v);
                    if (this.map == null) break;
                    this.map.put((JsonElement)v, this.lexer.location.copy());
                    break;
                }
                case Null: {
                    JsonNull n = new JsonNull();
                    arr.add((JsonElement)n);
                    if (this.map == null) break;
                    this.map.put((JsonElement)n, this.lexer.location.copy());
                    break;
                }
                case Array: {
                    JsonArray child = new JsonArray();
                    LocationData loc = this.lexer.location.copy();
                    arr.add((JsonElement)child);
                    this.next();
                    this.readArray(child, false);
                    if (this.map == null) break;
                    this.map.put((JsonElement)arr, loc);
                    break;
                }
                case Eof: {
                    throw this.lexer.error("Unexpected End of File");
                }
            }
            this.next();
        }
        return res;
    }

    private void next() throws IOException {
        this.next(false);
    }

    private void next(boolean noPop) throws IOException {
        switch (this.itemType) {
            case Object: {
                this.lexer.consume(TokenType.Open);
                this.lexer.states.push(new State(this.itemName, false));
                if (this.lexer.getType() == TokenType.Close) {
                    this.itemType = ItemType.End;
                    this.lexer.next();
                    break;
                }
                this.parseProperty();
                break;
            }
            case Boolean: 
            case String: 
            case Number: 
            case Null: 
            case End: {
                if (this.itemType == ItemType.End && !noPop) {
                    this.lexer.states.pop();
                }
                if (this.lexer.getType() == TokenType.Comma) {
                    this.lexer.next();
                    this.parseProperty();
                    break;
                }
                if (this.lexer.getType() == TokenType.Close) {
                    this.itemType = ItemType.End;
                    this.lexer.next();
                    break;
                }
                if (this.lexer.getType() == TokenType.CloseArray) {
                    this.itemType = ItemType.End;
                    this.lexer.next();
                    break;
                }
                if (this.lexer.getType() == TokenType.Eof) {
                    this.itemType = ItemType.Eof;
                    break;
                }
                throw this.lexer.error("Unexpected JSON syntax");
            }
            case Array: {
                this.lexer.next();
                this.lexer.states.push(new State(this.itemName + "[]", true));
                this.parseProperty();
                break;
            }
            case Eof: {
                throw this.lexer.error("JSON Syntax Error - attempt to read past end of json stream");
            }
            default: {
                throw this.lexer.error("not done yet (a): " + this.itemType.toString());
            }
        }
    }

    private void parseProperty() throws IOException {
        if (!((State)this.lexer.states.peek()).isProp) {
            this.itemName = this.lexer.consume(TokenType.String);
            this.itemValue = null;
            this.lexer.consume(TokenType.Colon);
        }
        switch (this.lexer.getType()) {
            case Null: {
                this.itemType = ItemType.Null;
                this.itemValue = this.lexer.value;
                this.lexer.next();
                break;
            }
            case String: {
                this.itemType = ItemType.String;
                this.itemValue = this.lexer.value;
                this.lexer.next();
                break;
            }
            case Boolean: {
                this.itemType = ItemType.Boolean;
                this.itemValue = this.lexer.value;
                this.lexer.next();
                break;
            }
            case Number: {
                this.itemType = ItemType.Number;
                this.itemValue = this.lexer.value;
                this.lexer.next();
                break;
            }
            case Open: {
                this.itemType = ItemType.Object;
                break;
            }
            case OpenArray: {
                this.itemType = ItemType.Array;
                break;
            }
            case CloseArray: {
                this.itemType = ItemType.End;
                break;
            }
            default: {
                throw this.lexer.error("not done yet (b): " + this.lexer.getType().toString());
            }
        }
    }

    public boolean isErrorOnDuplicates() {
        return this.errorOnDuplicates;
    }

    public void setErrorOnDuplicates(boolean errorOnDuplicates) {
        this.errorOnDuplicates = errorOnDuplicates;
    }

    static enum ItemType {
        Object,
        String,
        Number,
        Boolean,
        Array,
        End,
        Eof,
        Null;

    }

    private class Lexer {
        private String source;
        private int cursor;
        private String peek;
        private String value;
        private TokenType type;
        private Stack<State> states = new Stack();
        private LocationData lastLocationBWS;
        private LocationData lastLocationAWS;
        private LocationData location;
        private StringBuilder b = new StringBuilder();

        public Lexer(String source) throws IOException {
            this.source = source;
            this.cursor = -1;
            this.location = new LocationData(1, 1);
            this.start();
        }

        private boolean more() {
            return this.peek != null || this.cursor < this.source.length();
        }

        private String getNext(int length) throws IOException {
            String result = "";
            if (this.peek != null) {
                if (this.peek.length() > length) {
                    result = this.peek.substring(0, length);
                    this.peek = this.peek.substring(length);
                } else {
                    result = this.peek;
                    this.peek = null;
                }
            }
            if (result.length() < length) {
                int len = length - result.length();
                if (this.cursor > this.source.length() - len) {
                    throw this.error("Attempt to read past end of source");
                }
                result = result + this.source.substring(this.cursor + 1, this.cursor + len + 1);
                this.cursor += len;
            }
            for (char ch : result.toCharArray()) {
                if (ch == '\n') {
                    this.location.newLine();
                    continue;
                }
                this.location.col++;
            }
            return result;
        }

        private char getNextChar() throws IOException {
            if (this.peek != null) {
                char ch = this.peek.charAt(0);
                this.peek = this.peek.length() == 1 ? null : this.peek.substring(1);
                return ch;
            }
            ++this.cursor;
            if (this.cursor >= this.source.length()) {
                return '\u0000';
            }
            char ch = this.source.charAt(this.cursor);
            if (ch == '\n') {
                this.location.newLine();
            } else {
                this.location.col++;
            }
            return ch;
        }

        private void push(char ch) {
            this.peek = this.peek == null ? String.valueOf(ch) : String.valueOf(ch) + this.peek;
        }

        private void parseWord(String word, char ch, TokenType type) throws IOException {
            this.type = type;
            this.value = "" + ch + this.getNext(word.length() - 1);
            if (!this.value.equals(word)) {
                throw this.error("Syntax error in json reading special word " + word);
            }
        }

        private IOException error(String msg) {
            return new IOException("Error parsing JSON source: " + msg + " at Line " + Integer.toString(this.location.line) + " (path=[" + this.path() + "])");
        }

        private String path() {
            if (this.states.empty()) {
                return this.value;
            }
            String result = "";
            for (State s : this.states) {
                result = result + '/' + s.getName();
            }
            result = result + this.value;
            return result;
        }

        public void start() throws IOException {
            this.next();
        }

        public TokenType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public LocationData getLastLocationBWS() {
            return this.lastLocationBWS;
        }

        public LocationData getLastLocationAWS() {
            return this.lastLocationAWS;
        }

        public void next() throws IOException {
            char ch;
            this.lastLocationBWS = this.location.copy();
            do {
                ch = this.getNextChar();
            } while (this.more() && Utilities.charInSet(ch, ' ', '\r', '\n', '\t'));
            this.lastLocationAWS = this.location.copy();
            if (!this.more()) {
                this.type = TokenType.Eof;
            } else {
                switch (ch) {
                    case '{': {
                        this.type = TokenType.Open;
                        break;
                    }
                    case '}': {
                        this.type = TokenType.Close;
                        break;
                    }
                    case '\"': {
                        this.type = TokenType.String;
                        this.b.setLength(0);
                        do {
                            if ((ch = this.getNextChar()) == '\\') {
                                ch = this.getNextChar();
                                switch (ch) {
                                    case '\"': {
                                        this.b.append('\"');
                                        break;
                                    }
                                    case '\'': {
                                        this.b.append('\'');
                                        break;
                                    }
                                    case '\\': {
                                        this.b.append('\\');
                                        break;
                                    }
                                    case '/': {
                                        this.b.append('/');
                                        break;
                                    }
                                    case 'n': {
                                        this.b.append('\n');
                                        break;
                                    }
                                    case 'r': {
                                        this.b.append('\r');
                                        break;
                                    }
                                    case 't': {
                                        this.b.append('\t');
                                        break;
                                    }
                                    case 'u': {
                                        this.b.append((char)Integer.parseInt(this.getNext(4), 16));
                                        break;
                                    }
                                    default: {
                                        throw this.error("unknown escape sequence: \\" + ch);
                                    }
                                }
                                ch = ' ';
                                continue;
                            }
                            if (ch == '\"') continue;
                            this.b.append(ch);
                        } while (this.more() && ch != '\"');
                        if (!this.more()) {
                            throw this.error("premature termination of json stream during a string");
                        }
                        this.value = this.b.toString();
                        break;
                    }
                    case ':': {
                        this.type = TokenType.Colon;
                        break;
                    }
                    case ',': {
                        this.type = TokenType.Comma;
                        break;
                    }
                    case '[': {
                        this.type = TokenType.OpenArray;
                        break;
                    }
                    case ']': {
                        this.type = TokenType.CloseArray;
                        break;
                    }
                    case 't': {
                        this.parseWord("true", ch, TokenType.Boolean);
                        break;
                    }
                    case 'f': {
                        this.parseWord("false", ch, TokenType.Boolean);
                        break;
                    }
                    case 'n': {
                        this.parseWord("null", ch, TokenType.Null);
                        break;
                    }
                    default: {
                        if (ch >= '0' && ch <= '9' || ch == '-') {
                            this.type = TokenType.Number;
                            this.b.setLength(0);
                            while (this.more() && (ch >= '0' && ch <= '9' || ch == '-' || ch == '.') || ch == '+' || ch == 'e' || ch == 'E') {
                                this.b.append(ch);
                                ch = this.getNextChar();
                            }
                            this.value = this.b.toString();
                            this.push(ch);
                            break;
                        }
                        throw this.error("Unexpected char '" + ch + "' in json stream");
                    }
                }
            }
        }

        public String consume(TokenType type) throws IOException {
            if (this.type != type) {
                throw this.error("JSON syntax error - found " + type.toString() + " expecting " + type.toString());
            }
            String result = this.value;
            this.next();
            return result;
        }
    }

    private class State {
        private String name;
        private boolean isProp;

        protected State(String name, boolean isProp) {
            this.name = name;
            this.isProp = isProp;
        }

        public String getName() {
            return this.name;
        }

        public boolean isProp() {
            return this.isProp;
        }
    }

    public class LocationData {
        private int line;
        private int col;

        protected LocationData(int line, int col) {
            this.line = line;
            this.col = col;
        }

        public int getLine() {
            return this.line;
        }

        public int getCol() {
            return this.col;
        }

        public void newLine() {
            ++this.line;
            this.col = 1;
        }

        public LocationData copy() {
            return new LocationData(this.line, this.col);
        }
    }

    public static enum TokenType {
        Open,
        Close,
        String,
        Number,
        Colon,
        Comma,
        OpenArray,
        CloseArray,
        Eof,
        Null,
        Boolean;

    }

    public class PresentedBigDecimal
    extends BigDecimal {
        public String presentation;

        public PresentedBigDecimal(String value) {
            super(value);
            this.presentation = value;
        }

        public String getPresentation() {
            return this.presentation;
        }
    }
}

