/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import org.hl7.fhir.utilities.VersionUtilities;

public enum FhirPublication {
    NULL,
    DSTU1,
    DSTU2,
    DSTU2016May,
    STU3,
    R4,
    R4B,
    R5;


    public static FhirPublication fromCode(String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return DSTU2;
        }
        if (VersionUtilities.isR2BVer(v)) {
            return DSTU2016May;
        }
        if (VersionUtilities.isR3Ver(v)) {
            return STU3;
        }
        if (VersionUtilities.isR4Ver(v)) {
            return R4;
        }
        if (VersionUtilities.isR4BVer(v)) {
            return R4B;
        }
        if (VersionUtilities.isR5Ver(v)) {
            return R5;
        }
        return null;
    }

    public String toCode() {
        switch (this) {
            case DSTU1: {
                return "0.01";
            }
            case DSTU2: {
                return "1.0.2";
            }
            case DSTU2016May: {
                return "1.4.0";
            }
            case STU3: {
                return "3.0.1";
            }
            case R4: {
                return "4.0.1";
            }
            case R4B: {
                return "4.3.0";
            }
            case R5: {
                return "5.0.0";
            }
        }
        return "??";
    }
}

