/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.IOException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;

public class PoGetTextProducer
extends LanguageFileProducer {
    private String fileName;
    private StringBuilder po;
    int i = 0;

    public PoGetTextProducer(String folder) {
        super(folder);
    }

    @Override
    public void start(String fileName, String contextId, String contextDesc, String baseLang, String targetLang) {
        this.fileName = fileName;
        this.po = new StringBuilder();
    }

    @Override
    public void makeEntry(String id, String ref, String context, String source, String target) {
        this.ln("#: " + id);
        if (context != null) {
            this.ln("#. " + context);
        }
        this.ln("msgid \"" + source + "\"");
        this.ln("msgstr \"" + target + "\"");
        this.ln("");
    }

    @Override
    public void finish() throws IOException {
        this.ln("");
        TextFile.stringToFile(this.po.toString(), this.fileName);
    }

    protected void ln(String line) {
        this.po.append(line + "\r\n");
    }
}

