/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import com.ibm.icu.text.PluralRules;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;

public abstract class I18nBase {
    public static final String PLURAL_SUFFIX = "PLURAL";
    public static final String KEY_DELIMITER = "_";
    private Locale locale;
    private ResourceBundle i18nMessages;
    private PluralRules pluralRules;
    private boolean warnAboutMissingMessages = true;

    public Locale getLocale() {
        if (Objects.nonNull(this.locale)) {
            return this.locale;
        }
        return Locale.US;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setValidationMessageLanguage(this.getLocale());
    }

    private void checkResourceBundleIsLoaded() {
        if (this.i18nMessages == null) {
            this.setValidationMessageLanguage(this.getLocale());
        }
    }

    private void checkPluralRulesAreLoaded() {
        if (this.pluralRules == null) {
            this.setPluralRules(this.getLocale());
        }
    }

    private boolean messageExistsForLocale(String message, boolean hasArgs) {
        this.checkResourceBundleIsLoaded();
        if (!this.i18nMessages.containsKey(message) && this.warnAboutMissingMessages && (hasArgs || !message.contains(" "))) {
            System.out.println("Attempting to localize message " + message + ", but no such equivalent message exists for the local " + this.getLocale());
        }
        return this.i18nMessages.containsKey(message);
    }

    public String formatMessage(String theMessage, Object ... theMessageArguments) {
        return this.formatMessageForLocale(theMessage, theMessageArguments);
    }

    protected String getPluralKey(Integer number, String baseKey) {
        return baseKey + KEY_DELIMITER + this.pluralRules.select((double)number.intValue());
    }

    private String formatMessageForLocale(String theMessage, Object ... theMessageArguments) {
        String message = theMessage;
        if (this.messageExistsForLocale(theMessage, theMessageArguments != null && theMessageArguments.length > 0)) {
            message = Objects.nonNull(theMessageArguments) && theMessageArguments.length > 0 ? MessageFormat.format(this.i18nMessages.getString(theMessage).trim(), theMessageArguments) : this.i18nMessages.getString(theMessage).trim();
        }
        return message;
    }

    public String formatMessagePlural(Integer plural, String theMessage, Object ... theMessageArguments) {
        Object[] args = new Object[theMessageArguments.length + 1];
        args[0] = plural;
        for (int i = 0; i < theMessageArguments.length; ++i) {
            args[i + 1] = theMessageArguments[i];
        }
        this.checkPluralRulesAreLoaded();
        String pluralKey = this.getPluralKey(plural, theMessage);
        return this.formatMessageForLocale(pluralKey, args);
    }

    public void setValidationMessageLanguage(Locale locale) {
        this.i18nMessages = ResourceBundle.getBundle("Messages", locale);
    }

    public void setPluralRules(Locale locale) {
        this.pluralRules = PluralRules.forLocale((Locale)locale);
    }

    public boolean isWarnAboutMissingMessages() {
        return this.warnAboutMissingMessages;
    }

    public void setWarnAboutMissingMessages(boolean warnAboutMissingMessages) {
        this.warnAboutMissingMessages = warnAboutMissingMessages;
    }
}

