/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.hl7.fhir.utilities.tests.BaseTestingUtilities;

public interface ResourceLoaderTests {
    public static final String PATH_DELIMITER = "/";

    public static InputStream getResourceAsInputStream(Class<?> clazz, String ... resourcePath) {
        return clazz.getClassLoader().getResourceAsStream(String.join((CharSequence)PATH_DELIMITER, resourcePath));
    }

    default public InputStream getResourceAsInputStream(String ... resourcePath) {
        return ResourceLoaderTests.getResourceAsInputStream(this.getClass(), resourcePath);
    }

    default public void copyResourceToFile(Path target, String ... resourcePath) throws IOException {
        ResourceLoaderTests.copyResourceToFile(this.getClass(), target, resourcePath);
    }

    public static void copyResourceToFile(Class<?> clazz, Path target, String ... resourcePath) throws IOException {
        InputStream initialStream = ResourceLoaderTests.getResourceAsInputStream(clazz, resourcePath);
        BaseTestingUtilities.createParentDirIfNotExists(target);
        Files.copy(initialStream, target, StandardCopyOption.REPLACE_EXISTING);
        initialStream.close();
    }
}

