/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class XmlEscaper {
    private InputStream source;
    private OutputStream target;

    protected XmlEscaper(InputStream source, OutputStream target) {
        this.source = source;
        this.target = target;
    }

    public static void convert(InputStream source, OutputStream target) throws IOException {
        XmlEscaper self = new XmlEscaper(source, target);
        self.process();
    }

    public static void convert(String source, String target) throws IOException {
        try (FileOutputStream fs = new FileOutputStream(target);){
            XmlEscaper.convertAndClose(new FileInputStream(source), fs);
        }
    }

    public static void convertAndClose(InputStream source, OutputStream target) throws IOException {
        XmlEscaper self = new XmlEscaper(source, target);
        self.process();
        source.close();
        target.close();
    }

    public InputStream getSource() {
        return this.source;
    }

    public void setSource(InputStream source) {
        this.source = source;
    }

    public OutputStream getTarget() {
        return this.target;
    }

    public void setTarget(OutputStream target) {
        this.target = target;
    }

    public void process() throws IOException {
        BufferedReader buffer = new BufferedReader(new InputStreamReader(this.source));
        int i = 0;
        while ((i = buffer.read()) != -1) {
            char c = (char)i;
            if (c == '<') {
                this.write("&lt;");
                continue;
            }
            if (c == '>') {
                this.write("&gt;");
                continue;
            }
            if (c == '&') {
                this.write("&amp;");
                continue;
            }
            if (c == '\"') {
                this.write("&quot;");
                continue;
            }
            this.target.write((byte)i);
        }
    }

    private void write(String s) throws IOException {
        this.target.write(s.getBytes(StandardCharsets.UTF_8));
    }
}

