/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateTimeUtil {
    private static final FastDateFormat ourHumanDateFormat = FastDateFormat.getDateInstance((int)2);
    private static final FastDateFormat ourHumanDateTimeFormat = FastDateFormat.getDateTimeInstance((int)2, (int)2);

    public static String toHumanDisplay(TimeZone theTimeZone, TemporalPrecisionEnum thePrecision, Date theValue, String theValueAsString) {
        Calendar value = theTimeZone != null ? Calendar.getInstance(theTimeZone) : Calendar.getInstance();
        value.setTime(theValue);
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return theValueAsString;
            }
        }
        return ourHumanDateTimeFormat.format(value);
    }

    public static String toHumanDisplayLocalTimezone(TemporalPrecisionEnum thePrecision, Date theValue, String theValueAsString) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return theValueAsString;
            }
        }
        return ourHumanDateTimeFormat.format(theValue);
    }

    public static String toHumanDisplay(Locale locale, TimeZone theTimeZone, TemporalPrecisionEnum thePrecision, Date theValue) {
        Calendar value = theTimeZone != null ? Calendar.getInstance(theTimeZone) : Calendar.getInstance();
        value.setTime(theValue);
        FastDateFormat dateFormat = FastDateFormat.getDateInstance((int)2, (Locale)locale);
        FastDateFormat dateTimeFormat = FastDateFormat.getDateTimeInstance((int)2, (int)2, (Locale)locale);
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return dateFormat.format(value);
            }
        }
        return dateTimeFormat.format(value);
    }
}

