/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class DirectoryVisitor {
    private IDirectoryVisitorImplementation worker;
    private Set<String> extensions;

    public DirectoryVisitor(IDirectoryVisitorImplementation worker, Set<String> extensions) {
        this.worker = worker;
        this.extensions = extensions;
        if (this.extensions == null) {
            extensions = new HashSet<String>();
        }
    }

    public DirectoryVisitor(IDirectoryVisitorImplementation worker, String ... extensionList) {
        this.worker = worker;
        this.extensions = new HashSet<String>();
        for (String s : extensionList) {
            this.extensions.add(s);
        }
    }

    public DirectoryVisitor(IDirectoryVisitorImplementation worker) {
        this.worker = worker;
        this.extensions = new HashSet<String>();
    }

    public static int visitDirectory(IDirectoryVisitorImplementation worker, String path) throws IOException {
        return new DirectoryVisitor(worker).visit(path);
    }

    public static int visitDirectory(IDirectoryVisitorImplementation worker, String path, Set<String> extensions) throws IOException {
        return new DirectoryVisitor(worker, extensions).visit(path);
    }

    public static int visitDirectory(IDirectoryVisitorImplementation worker, String path, String ... extensionList) throws IOException {
        return new DirectoryVisitor(worker, extensionList).visit(path);
    }

    public int visit(String path) throws IOException {
        return this.visit(ManagedFileAccess.file(path));
    }

    private int visit(File file) throws IOException {
        int count = 0;
        if (file.isDirectory()) {
            if (this.worker.enterDirectory(file)) {
                for (File f : ManagedFileAccess.listFiles(file)) {
                    count += this.visit(f);
                }
            }
        } else {
            String ext = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            if ((this.extensions.isEmpty() || this.extensions.contains(ext)) && this.worker.visitFile(file)) {
                ++count;
            }
        }
        return count;
    }

    public static interface IDirectoryVisitorImplementation {
        public boolean enterDirectory(File var1) throws IOException;

        public boolean visitFile(File var1) throws IOException;
    }
}

