/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.utilities.Utilities;
import org.xml.sax.SAXException;

public abstract class LanguageFileProducer {
    private String rootFolder;
    private String folderName;
    private boolean useLangFolder;

    public LanguageFileProducer(String rootFolder, String folderName, boolean useLangFolder) {
        this.rootFolder = rootFolder;
        this.folderName = folderName;
        this.useLangFolder = useLangFolder;
    }

    public LanguageFileProducer() {
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public boolean isUseLangFolder() {
        return this.useLangFolder;
    }

    protected String getTargetFileName(String targetLang, String filename) throws IOException {
        return Utilities.path(this.getRootFolder(), this.isUseLangFolder() ? targetLang : ".", this.getFolderName(), filename);
    }

    public abstract LanguageProducerSession startSession(String var1, String var2) throws IOException;

    public abstract void finish();

    public abstract List<TranslationUnit> loadSource(InputStream var1) throws IOException, ParserConfigurationException, SAXException;

    public abstract int fileCount();

    public abstract void produce(String var1, String var2, String var3, List<TranslationUnit> var4, String var5) throws IOException;

    public abstract class LanguageProducerSession {
        protected String id;
        protected String baseLang;

        protected LanguageProducerSession(String id, String baseLang) {
            this.id = id;
            this.baseLang = baseLang;
        }

        public abstract LanguageProducerLanguageSession forLang(String var1);

        public abstract void finish() throws IOException;
    }

    public abstract class LanguageProducerLanguageSession {
        protected String id;
        protected String baseLang;
        protected String targetLang;

        protected LanguageProducerLanguageSession(String id, String baseLang, String targetLang) {
            this.id = id;
            this.baseLang = baseLang;
            this.targetLang = targetLang;
        }

        public String getTargetLang() {
            return this.targetLang;
        }

        public String getBaseLang() {
            return this.baseLang;
        }

        public abstract void finish() throws IOException;

        public abstract void entry(TextUnit var1);
    }

    public class Translations {
        private String id;
        private Map<String, String> translations = new HashMap<String, String>();

        protected Translations(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getTranslations() {
            return this.translations;
        }
    }

    public static class TranslationUnit
    extends TextUnit {
        private String language;
        private String original;

        public TranslationUnit(String language, String id, String context, String srcText, String tgtText) {
            super(id, context, srcText, tgtText);
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setSrcText(String srcText) {
            this.srcText = srcText;
        }

        public void setTgtText(String tgtText) {
            this.tgtText = tgtText;
        }

        public String getOriginal() {
            return this.original;
        }

        public TranslationUnit setOriginal(String original) {
            this.original = original;
            return this;
        }
    }

    public static class TextUnit {
        protected String id;
        protected String context;
        protected String srcText;
        protected String tgtText;

        public TextUnit(String id, String context, String srcText, String tgtText) {
            this.id = id;
            this.context = context;
            this.srcText = srcText;
            this.tgtText = tgtText;
        }

        public String getId() {
            return this.id;
        }

        public String getContext1() {
            return this.context;
        }

        public String getSrcText() {
            return this.srcText;
        }

        public String getTgtText() {
            return this.tgtText;
        }
    }
}

