/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CompressionUtilities {
    public static void unzip(InputStream zip, String target) throws IOException {
        CompressionUtilities.unzip(zip, Path.of(target, new String[0]));
    }

    public static void unzip(InputStream zip, Path target) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(zip);){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = false;
                String n = CompressionUtilities.makeOSSafe(zipEntry.getName());
                if (n.endsWith(File.separator)) {
                    isDirectory = true;
                }
                Path newPath = CompressionUtilities.zipSlipProtect(n, target);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    public static Path zipSlipProtect(String zipName, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipName);
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipName);
        }
        return normalizePath;
    }

    public static String makeOSSafe(String name) {
        return name.replace("\\", File.separator).replace("/", File.separator);
    }
}

