/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.CSFile;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class ZipGenerator {
    private Set<String> names = new HashSet<String>();
    FileOutputStream dest;
    ZipOutputStream out;
    static final int BUFFER = 2048;

    public ZipGenerator(String filename) throws IOException {
        this.dest = ManagedFileAccess.outStream(filename);
        this.out = new ZipOutputStream(new BufferedOutputStream(this.dest));
        this.out.setLevel(9);
    }

    public void close() throws IOException {
        this.out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromZip(String zipFilename) throws IOException {
        byte[] buf = new byte[1024];
        try (ZipInputStream zin = new ZipInputStream(ManagedFileAccess.inStream(zipFilename));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                int len;
                String name = entry.getName();
                this.names.add(name);
                this.out.putNextEntry(new ZipEntry(name));
                while ((len = zin.read(buf)) > 0) {
                    this.out.write(buf, 0, len);
                }
                entry = zin.getNextEntry();
            }
        }
    }

    public void addFolder(String actualDir, String statedDir, boolean omitIfExists) throws IOException {
        String[] files;
        CSFile fd = ManagedFileAccess.csfile(actualDir);
        for (String f : files = fd.list()) {
            if (".DS_Store".equals(f)) continue;
            if (ManagedFileAccess.csfile(Utilities.path(actualDir, f)).isDirectory()) {
                this.addFolder(Utilities.path(actualDir, f), Utilities.pathURL(statedDir, f), omitIfExists);
                continue;
            }
            this.addFileName(Utilities.pathURL(statedDir, f), Utilities.path(actualDir, f), omitIfExists);
        }
    }

    public void addFolder(String actualDir, String statedDir, boolean omitIfExists, String noExt) throws IOException {
        String[] files;
        CSFile fd = ManagedFileAccess.csfile(actualDir);
        for (String f : files = fd.list()) {
            if (".DS_Store".equals(f)) continue;
            if (ManagedFileAccess.csfile(Utilities.path(actualDir, f)).isDirectory()) {
                this.addFolder(Utilities.path(actualDir, f), Utilities.pathURL(statedDir, f), omitIfExists, noExt);
                continue;
            }
            if (noExt != null && f.endsWith(noExt)) continue;
            this.addFileName(Utilities.pathURL(statedDir, f), Utilities.path(actualDir, f), omitIfExists);
        }
    }

    public void addFiles(String actualDir, String statedDir, String ext, String noExt) throws FileNotFoundException, IOException {
        byte[] data = new byte[2048];
        statedDir = statedDir.replace("\\", "/");
        CSFile f = ManagedFileAccess.csfile(actualDir);
        String[] files = f.list();
        if (files == null) {
            System.out.println("no files found in " + f.getName());
        } else {
            for (int i = 0; i < files.length; ++i) {
                int count;
                String fn;
                if (".DS_Store".equals(files[i]) || !ManagedFileAccess.csfile(fn = Utilities.path(actualDir, files[i])).isFile() || ext != null && !files[i].endsWith(ext) || noExt != null && files[i].endsWith(noExt)) continue;
                FileInputStream fi = ManagedFileAccess.inStream(fn);
                BufferedInputStream origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(statedDir + files[i]);
                this.names.add(statedDir + files[i]);
                this.out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    this.out.write(data, 0, count);
                }
                origin.close();
            }
        }
    }

    public void addFilesFiltered(String actualDir, String statedDir, String ext, String[] noExt) throws FileNotFoundException, IOException {
        byte[] data = new byte[2048];
        statedDir = statedDir.replace("\\", "/");
        CSFile f = ManagedFileAccess.csfile(actualDir);
        String[] files = f.list();
        for (int i = 0; i < files.length; ++i) {
            int count;
            if (".DS_Store".equals(files[i]) || !ManagedFileAccess.csfile(actualDir + files[i]).isFile() || ext != null && !files[i].endsWith(ext)) continue;
            boolean ok = true;
            for (String n : noExt) {
                ok = ok && !files[i].endsWith(n);
            }
            if (!ok) continue;
            FileInputStream fi = ManagedFileAccess.inStream(actualDir + files[i]);
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(statedDir + files[i]);
            this.names.add(statedDir + files[i]);
            this.out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                this.out.write(data, 0, count);
            }
            origin.close();
        }
    }

    public void addFileSource(String path, String cnt, boolean omitIfExists) throws IOException {
        File tmp = FileUtilities.createTempFile("tmp", ".tmp");
        FileUtilities.stringToFile(cnt, tmp.getAbsolutePath());
        this.addFileName(path, tmp.getAbsolutePath(), omitIfExists);
        tmp.delete();
    }

    public void addFileName(String statedPath, String actualPath, boolean omitIfExists) throws IOException {
        if (!omitIfExists || !this.names.contains(statedPath)) {
            int count;
            byte[] data = new byte[2048];
            FileInputStream fi = ManagedFileAccess.inStream(actualPath);
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(statedPath);
            this.names.add(statedPath);
            this.out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                this.out.write(data, 0, count);
            }
            origin.close();
        }
    }

    public void addBytes(String statedPath, byte[] content, boolean omitIfExists) throws IOException {
        if (!omitIfExists || !this.names.contains(statedPath)) {
            int count;
            byte[] data = new byte[2048];
            ByteArrayInputStream fi = new ByteArrayInputStream(content);
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(statedPath);
            this.names.add(statedPath);
            this.out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                this.out.write(data, 0, count);
            }
            origin.close();
        }
    }

    public void addMimeTypeFile(String statedPath, String actualPath) throws IOException {
        CRC32 crc = new CRC32();
        this.out.setLevel(0);
        ZipEntry entry = new ZipEntry(statedPath);
        entry.setExtra(null);
        this.names.add(statedPath);
        String contents = "application/epub+zip";
        crc.update(contents.getBytes());
        entry.setCompressedSize(contents.length());
        entry.setSize(contents.length());
        entry.setCrc(crc.getValue());
        entry.setMethod(0);
        this.out.putNextEntry(entry);
        this.out.write(contents.getBytes(), 0, contents.length());
        this.out.setLevel(9);
    }

    public void addStream(String statedPath, InputStream fi, boolean omitIfExists) throws IOException {
        if (!omitIfExists || !this.names.contains(statedPath)) {
            int count;
            byte[] data = new byte[2048];
            BufferedInputStream origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(statedPath);
            this.names.add(statedPath);
            this.out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                this.out.write(data, 0, count);
            }
            origin.close();
        }
    }
}

