/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.http.HTTPRequest;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedFhirWebAccessor;
import org.hl7.fhir.utilities.http.ManagedWebAccessor;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public class ManagedWebAccess {
    private static WebAccessPolicy accessPolicy = WebAccessPolicy.DIRECT;
    private static List<String> allowedDomains = new ArrayList<String>();
    private static IWebAccessor accessor;
    private static IFhirWebAccessor fhirWebAccessor;
    private static String userAgent;
    private static List<ServerDetailsPOJO> serverAuthDetails;

    public static WebAccessPolicy getAccessPolicy() {
        return accessPolicy;
    }

    public static void setAccessPolicy(WebAccessPolicy accessPolicy) {
        ManagedWebAccess.accessPolicy = accessPolicy;
    }

    static boolean inAllowedPaths(String pathname) {
        if (allowedDomains.isEmpty()) {
            return true;
        }
        for (String s : allowedDomains) {
            if (!pathname.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static void setUserAgent(String userAgent) {
        ManagedWebAccess.userAgent = userAgent;
    }

    public static ManagedWebAccessor accessor(Iterable<String> serverTypes) {
        return new ManagedWebAccessor(serverTypes, userAgent, serverAuthDetails);
    }

    public static ManagedFhirWebAccessor fhirAccessor() {
        return new ManagedFhirWebAccessor(userAgent, serverAuthDetails);
    }

    public static HTTPResult get(Iterable<String> serverTypes, String url) throws IOException {
        return ManagedWebAccess.accessor(serverTypes).get(url);
    }

    public static HTTPResult get(Iterable<String> serverTypes, String url, String accept) throws IOException {
        return ManagedWebAccess.accessor(serverTypes).get(url, accept);
    }

    public static HTTPResult post(Iterable<String> serverTypes, String url, byte[] content, String contentType, String accept) throws IOException {
        return ManagedWebAccess.accessor(serverTypes).post(url, content, contentType, accept);
    }

    public static HTTPResult put(Iterable<String> serverTypes, String url, byte[] content, String contentType, String accept) throws IOException {
        return ManagedWebAccess.accessor(serverTypes).put(url, content, contentType, accept);
    }

    public static HTTPResult httpCall(HTTPRequest httpRequest) throws IOException {
        return ManagedWebAccess.fhirAccessor().httpCall(httpRequest);
    }

    public static void loadFromFHIRSettings() {
        ManagedWebAccess.setAccessPolicy(FhirSettings.isProhibitNetworkAccess() ? WebAccessPolicy.PROHIBITED : WebAccessPolicy.DIRECT);
        ManagedWebAccess.setUserAgent("hapi-fhir-tooling-client");
        serverAuthDetails = new ArrayList<ServerDetailsPOJO>();
        serverAuthDetails.addAll(FhirSettings.getServers());
    }

    public static void loadFromFHIRSettings(FhirSettings settings) {
        ManagedWebAccess.setAccessPolicy(settings.isProhibitNetworkAccess() ? WebAccessPolicy.PROHIBITED : WebAccessPolicy.DIRECT);
        ManagedWebAccess.setUserAgent("hapi-fhir-tooling-client");
        serverAuthDetails = new ArrayList<ServerDetailsPOJO>();
        serverAuthDetails.addAll(settings.getServers());
    }

    public static IWebAccessor getAccessor() {
        return accessor;
    }

    public static IFhirWebAccessor getFhirWebAccessor() {
        return fhirWebAccessor;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static enum WebAccessPolicy {
        DIRECT,
        MANAGED,
        PROHIBITED;

    }

    public static interface IFhirWebAccessor {
        public HTTPResult httpCall(HTTPRequest var1);
    }

    public static interface IWebAccessor {
        public HTTPResult get(Iterable<String> var1, String var2, String var3, Map<String, String> var4) throws IOException;

        public HTTPResult post(Iterable<String> var1, String var2, byte[] var3, String var4, String var5, Map<String, String> var6) throws IOException;

        public HTTPResult put(Iterable<String> var1, String var2, byte[] var3, String var4, String var5, Map<String, String> var6) throws IOException;
    }
}

