/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;

public class PoGetTextProducer
extends LanguageFileProducer {
    private int filecount;
    private boolean incLangInFilename;

    public PoGetTextProducer(String rootFolder, String folderName, boolean useLangFolder) {
        super(rootFolder, folderName, useLangFolder);
    }

    public PoGetTextProducer() {
    }

    @Override
    public LanguageFileProducer.LanguageProducerSession startSession(String id, String baseLang) throws IOException {
        return new POGetTextProducerSession(id, baseLang);
    }

    @Override
    public void finish() {
    }

    @Override
    public int fileCount() {
        return this.filecount;
    }

    @Override
    public List<LanguageFileProducer.TranslationUnit> loadSource(InputStream source) throws IOException {
        String s;
        ArrayList<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        InputStreamReader r = new InputStreamReader(source, "UTF-8");
        BufferedReader br = new BufferedReader(r);
        String lang = null;
        LanguageFileProducer.TranslationUnit tu = null;
        while ((s = Utilities.stripBOM(br.readLine())) != null) {
            if (Utilities.noString(s)) continue;
            if (s.trim().startsWith("#")) {
                if (lang == null) {
                    String[] p = s.substring(1).trim().split("\\-\\>");
                    if (p.length != 2) {
                        throw new IOException("Encountered unexpected starting line '" + s + "'");
                    }
                    lang = p[1].trim();
                    continue;
                }
                if (s.startsWith("#:")) {
                    tu = new LanguageFileProducer.TranslationUnit(lang, s.substring(2).trim(), null, null, null);
                    continue;
                }
                if (s.startsWith("#.")) {
                    if (tu == null) continue;
                    tu.setContext(s.substring(2).trim());
                    continue;
                }
                throw new IOException("Encountered unexpected line '" + s + "'");
            }
            if (tu != null && s.startsWith("msgid ")) {
                tu.setSrcText(this.stripQuotes(s.substring(5).trim()));
                continue;
            }
            if (tu != null && s.startsWith("msgstr ")) {
                tu.setTgtText(this.stripQuotes(s.substring(6).trim()));
                if (tu.getTgtText() != null) {
                    list.add(tu);
                }
                tu = null;
                continue;
            }
            throw new IOException("Encountered unexpected line '" + s + "'");
        }
        return list;
    }

    private String stripQuotes(String s) {
        if (s.length() <= 2) {
            return null;
        }
        return s.substring(1, s.length() - 1);
    }

    private String getFileName(String id, String baseLang, String targetLang) throws IOException {
        return Utilities.path(this.getRootFolder(), this.getFolderName(), id + (String)(this.incLangInFilename ? "-" + baseLang + "-" + targetLang + ".po" : ""));
    }

    public boolean isIncLangInFilename() {
        return this.incLangInFilename;
    }

    public void setIncLangInFilename(boolean incLangInFilename) {
        this.incLangInFilename = incLangInFilename;
    }

    protected void ln(StringBuilder po, String line) {
        po.append(line + "\r\n");
    }

    @Override
    public void produce(String id, String baseLang, String targetLang, List<LanguageFileProducer.TranslationUnit> translations, String filename) throws IOException {
        StringBuilder po = new StringBuilder();
        this.ln(po, "msgid \"\"");
        this.ln(po, "msgstr \"\"");
        this.ln(po, "\"Language: " + targetLang + "\\n\"");
        this.ln(po, "\"X-Generator: Poedit 3.5\\n\"");
        this.ln(po, "");
        this.ln(po, "# " + baseLang + " -> " + targetLang);
        this.ln(po, "");
        for (LanguageFileProducer.TranslationUnit tu : translations) {
            if (tu.getContext() != null) {
                this.ln(po, "#. " + tu.getContext());
            }
            if (tu.getOriginal() != null) {
                this.ln(po, "#| " + tu.getOriginal());
            }
            this.ln(po, "msgctxt \"" + tu.getId() + "\"");
            this.ln(po, "msgid \"" + this.stripEoln(tu.getSrcText()) + "\"");
            this.ln(po, "msgstr \"" + (tu.getTgtText() == null ? "" : this.stripEoln(tu.getTgtText())) + "\"");
            this.ln(po, "");
        }
        FileUtilities.stringToFile(po.toString(), this.getTargetFileName(targetLang, filename));
    }

    private String stripEoln(String s) {
        s = s.replace("\r\n\r\n", " ").replace("\n\n", " ").replace("\r\r", " ");
        s = s.replace("\r\n", " ").replace("\n", " ").replace("\r", " ");
        return s;
    }

    public class POGetTextLanguageProducerLanguageSession
    extends LanguageFileProducer.LanguageProducerLanguageSession {
        private StringBuilder po;

        public POGetTextLanguageProducerLanguageSession(String id, String baseLang, String targetLang) {
            super(id, baseLang, targetLang);
            this.po = new StringBuilder();
            this.ln("msgid \"\"");
            this.ln("msgstr \"\"");
            this.ln("\"Language: pt\\n\"");
            this.ln("\"X-Generator: Poedit 3.5\\n\"");
            this.ln("");
            this.ln("# " + baseLang + " -> " + targetLang);
            this.ln("");
            this.ln("\"Language: pt\\n\"");
            this.ln("");
        }

        protected void ln(String line) {
            this.po.append(line + "\r\n");
        }

        @Override
        public void finish() throws IOException {
            FileUtilities.stringToFile(this.po.toString(), PoGetTextProducer.this.getFileName(this.id, this.baseLang, this.targetLang));
            ++PoGetTextProducer.this.filecount;
        }

        @Override
        public void entry(LanguageFileProducer.TextUnit unit) {
            if (unit.getContext() != null) {
                this.ln("#. " + unit.getContext());
            }
            this.ln("msgctxt \"" + unit.getId() + "\"");
            this.ln("msgid \"" + unit.getSrcText() + "\"");
            this.ln("msgstr \"" + (unit.getTgtText() == null ? "" : unit.getTgtText()) + "\"");
            this.ln("");
        }
    }

    public class POGetTextProducerSession
    extends LanguageFileProducer.LanguageProducerSession {
        public POGetTextProducerSession(String id, String baseLang) {
            super(id, baseLang);
        }

        @Override
        public LanguageFileProducer.LanguageProducerLanguageSession forLang(String targetLang) {
            return new POGetTextLanguageProducerLanguageSession(this.id, this.baseLang, targetLang);
        }

        @Override
        public void finish() throws IOException {
        }
    }
}

