/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;

public class NpmPackageIndexBuilder {
    public static final Integer CURRENT_INDEX_VERSION = 2;
    private JsonObject index;
    private JsonArray files;
    private Connection conn;
    private PreparedStatement psql;
    private String dbFilename;

    public void start(String filename) {
        this.index = new JsonObject();
        this.index.add("index-version", CURRENT_INDEX_VERSION);
        this.files = new JsonArray();
        this.index.add("files", this.files);
        this.dbFilename = filename;
        if (filename != null) {
            try {
                ManagedFileAccess.file(filename).delete();
                this.conn = DriverManager.getConnection("jdbc:sqlite:" + filename);
                Statement stmt = this.conn.createStatement();
                stmt.execute("CREATE TABLE ResourceList (\r\nFileName       nvarchar NOT NULL,\r\nResourceType   nvarchar NOT NULL,\r\nId             nvarchar NULL,\r\nUrl            nvarchar NULL,\r\nVersion        nvarchar NULL,\r\nKind           nvarchar NULL,\r\nType           nvarchar NULL,\r\nSupplements    nvarchar NULL,\r\nContent        nvarchar NULL,\r\nValueSet       nvarchar NULL,\r\nDerivation     nvarchar NULL,\r\nPRIMARY KEY (FileName))\r\n");
                this.psql = this.conn.prepareStatement("Insert into ResourceList (FileName, ResourceType, Id, Url, Version, Kind, Type, Supplements, Content, ValueSet) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            }
            catch (Exception e) {
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.conn = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean seeFile(String name, byte[] content) {
        if (!name.endsWith(".json")) return true;
        try (JsonParser parser = new JsonFactory().createParser(content);){
            JsonObject fi = new JsonObject();
            int level = 0;
            while (parser.nextToken() != null) {
                if (parser.currentToken() == JsonToken.START_OBJECT || parser.currentToken() == JsonToken.START_ARRAY) {
                    ++level;
                } else if (parser.currentToken() == JsonToken.END_OBJECT || parser.currentToken() == JsonToken.END_ARRAY) {
                    --level;
                }
                if (level != 1) continue;
                String fieldName = parser.currentName();
                if ("resourceType".equals(fieldName)) {
                    parser.nextToken();
                    this.files.add(fi);
                    fi.add("filename", name);
                    fi.add(fieldName, parser.getText());
                }
                if (!"id".equals(fieldName) && !"url".equals(fieldName) && !"version".equals(fieldName) && !"kind".equals(fieldName) && !"type".equals(fieldName) && !"supplements".equals(fieldName) && !"content".equals(fieldName) && !"valueSet".equals(fieldName) && !"derivation".equals(fieldName)) continue;
                parser.nextToken();
                fi.add(fieldName, parser.getText());
            }
            if (!fi.has("resourceType")) {
                boolean bl = true;
                return bl;
            }
            if (this.psql == null) return true;
            this.psql.setString(1, name);
            this.psql.setString(2, fi.asString("resourceType"));
            this.psql.setString(3, fi.asString("id"));
            this.psql.setString(4, fi.asString("url"));
            this.psql.setString(5, fi.asString("version"));
            this.psql.setString(6, fi.asString("kind"));
            this.psql.setString(7, fi.asString("type"));
            this.psql.setString(8, fi.asString("supplements"));
            this.psql.setString(9, fi.asString("content"));
            this.psql.setString(10, fi.asString("valueSet"));
            this.psql.setString(10, fi.asString("derivation"));
            this.psql.execute();
            return true;
        }
        catch (Exception e) {
            if (!name.contains("openapi")) return true;
            return false;
        }
    }

    public String build() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String res = org.hl7.fhir.utilities.json.parser.JsonParser.compose((JsonElement)this.index, true);
        this.index = null;
        this.files = null;
        return res;
    }

    public void executeWithStatus(String folder) throws IOException {
        System.out.print("Index Package " + folder + " ... ");
        this.execute(folder);
        System.out.println("done");
    }

    public void execute(String folder) throws IOException {
        if (this.existsFolder(folder, "package")) {
            folder = Utilities.path(folder, "package");
        }
        if (!this.existsFile(folder, "package.json")) {
            throw new FHIRException("Not a proper package? (can't find package.json)");
        }
        this.start(Utilities.path(folder, ".index.db"));
        File dir = ManagedFileAccess.file(folder);
        for (File f : dir.listFiles()) {
            this.seeFile(f.getName(), FileUtilities.fileToBytes(f));
        }
        FileUtilities.stringToFile(this.build(), Utilities.path(folder, ".index.json"));
    }

    private boolean existsFolder(String ... args) throws IOException {
        File f = ManagedFileAccess.file(Utilities.path(args));
        return f.exists() && f.isDirectory();
    }

    private boolean existsFile(String ... args) throws IOException {
        File f = ManagedFileAccess.file(Utilities.path(args));
        return f.exists() && !f.isDirectory();
    }

    public static void main(String[] args) throws IOException {
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.4.0");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#3.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#4.0.1");
    }

    public String getDbFilename() {
        return this.dbFilename;
    }
}

