/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public abstract class XhtmlFluent {
    protected abstract XhtmlNode addTag(String var1);

    protected abstract XhtmlNode addTag(int var1, String var2);

    protected abstract XhtmlNode addText(String var1);

    protected abstract void addChildren(XhtmlNodeList var1);

    protected abstract int indexOfNode(XhtmlNode var1);

    public XhtmlNode h1() {
        return this.addTag("h1");
    }

    public XhtmlNode h2() {
        return this.addTag("h2");
    }

    public XhtmlNode h(int level) {
        if (level < 1 || level > 6) {
            throw new FHIRException("Illegal Header level " + level);
        }
        return this.addTag("h" + Integer.toString(level));
    }

    public XhtmlNode h(int level, String id) {
        if (level < 1 || level > 6) {
            throw new FHIRException("Illegal Header level " + level);
        }
        XhtmlNode res = this.addTag("h" + Integer.toString(level));
        if (!Utilities.noString(id)) {
            res.attribute("id", id);
        }
        return res;
    }

    public XhtmlNode h3() {
        return this.addTag("h3");
    }

    public XhtmlNode h4() {
        return this.addTag("h4");
    }

    public XhtmlNode table(String clss) {
        return this.table(clss, false);
    }

    public XhtmlNode table(String clss, boolean forPresentation) {
        XhtmlNode res = this.addTag("table");
        if (!Utilities.noString(clss)) {
            res.setAttribute("class", clss);
        }
        if (forPresentation) {
            res.setAttribute("role", "presentation");
        }
        return res;
    }

    public XhtmlNode tr() {
        return this.addTag("tr");
    }

    public XhtmlNode tr(XhtmlNode tr) {
        return this.addTag(this.indexOfNode(tr) + 1, "tr");
    }

    public XhtmlNode th(int index) {
        return this.addTag(index, "th");
    }

    public XhtmlNode th() {
        return this.addTag("th");
    }

    public XhtmlNode td() {
        XhtmlNode x = this.addTag("td");
        return x;
    }

    public XhtmlNode td(String clss) {
        return this.addTag("td").attribute("class", clss);
    }

    public XhtmlNode div() {
        return this.addTag("div");
    }

    public XhtmlNode div(String style) {
        XhtmlNode x = this.addTag("div");
        if (!Utilities.noString(style)) {
            x.attribute("style", style);
        }
        return x;
    }

    public XhtmlNode para() {
        return this.addTag("p");
    }

    public XhtmlNode pre() {
        return this.addTag("pre");
    }

    public XhtmlNode pre(String clss) {
        XhtmlNode res = this.addTag("pre");
        if (clss != null) {
            res.setAttribute("class", clss);
        }
        return res;
    }

    public void br() {
        this.addTag("br");
    }

    public void hr() {
        this.addTag("hr");
    }

    public XhtmlNode ul() {
        return this.addTag("ul");
    }

    public XhtmlNode ol() {
        return this.addTag("ol");
    }

    public XhtmlNode li() {
        return this.addTag("li");
    }

    public XhtmlNode b() {
        return this.addTag("b");
    }

    public XhtmlNode i() {
        return this.addTag("i");
    }

    public XhtmlNode tx(String cnt) {
        return this.addText(cnt);
    }

    public XhtmlNode tx(int cnt) {
        return this.addText(Integer.toString(cnt));
    }

    public XhtmlNode ah(String href) {
        if (href == null) {
            if (this instanceof XhtmlNode) {
                return (XhtmlNode)this;
            }
            return this.addTag("span");
        }
        return this.addTag("a").attribute("href", href);
    }

    public XhtmlNode ah(String href, String title) {
        XhtmlNode x = this.addTag("a").attribute("href", href);
        if (title != null) {
            x.attribute("title", title);
        }
        return x;
    }

    public XhtmlNode ahWithText(String preText, String href, String title, String text, String postText) {
        this.tx(preText);
        XhtmlNode x = this.addTag("a").attribute("href", href);
        if (title != null) {
            x.attribute("title", title);
        }
        x.tx(text);
        this.tx(postText);
        return x;
    }

    public XhtmlNode ahOrCode(String href, String title) {
        if (href != null) {
            return this.ah(href, title);
        }
        if (title != null) {
            return this.code().setAttribute("title", title);
        }
        return this.code();
    }

    public XhtmlNode ahOrCode(String href) {
        return this.ahOrCode(href, null);
    }

    public XhtmlNode img(String src, String alt) {
        if (alt == null) {
            return this.addTag("img").attribute("src", src).attribute("alt", ".");
        }
        return this.addTag("img").attribute("src", src).attribute("alt", alt);
    }

    public XhtmlNode imgT(String src, String alt) {
        if (alt == null) {
            return this.addTag("img").attribute("src", src).attribute("alt", ".");
        }
        return this.addTag("img").attribute("src", src).attribute("alt", alt).attribute("title", alt);
    }

    public XhtmlNode img(String src, String alt, String title) {
        return this.addTag("img").attribute("src", src).attribute("alt", alt).attribute("title", title);
    }

    public XhtmlNode an(String href) {
        return this.an(href, " ");
    }

    public XhtmlNode an(String href, String tx) {
        XhtmlNode a = this.addTag("a").attribute("name", href);
        a.tx(tx);
        return a;
    }

    public XhtmlNode span(String style, String title) {
        XhtmlNode res = this.addTag("span");
        if (!Utilities.noString(style)) {
            res.attribute("style", style);
        }
        if (!Utilities.noString(title)) {
            res.attribute("title", title);
        }
        return res;
    }

    public XhtmlNode span(String style) {
        XhtmlNode res = this.addTag("span");
        if (!Utilities.noString(style)) {
            res.attribute("style", style);
        }
        return res;
    }

    public XhtmlNode span() {
        return this.addTag("span");
    }

    public XhtmlNode spanClss(String clssName) {
        XhtmlNode res = this.addTag("span");
        if (!Utilities.noString(clssName)) {
            res.attribute("class", clssName);
        }
        return res;
    }

    public void codeWithText(String preText, String text, String postText) {
        this.tx(preText);
        XhtmlNode code = this.addTag("code");
        code.tx(text);
        this.tx(postText);
    }

    public XhtmlNode code(String text) {
        XhtmlNode code = this.addTag("code");
        code.tx(text);
        return code;
    }

    public XhtmlNode code() {
        return this.addTag("code");
    }

    public XhtmlNode blockquote() {
        return this.addTag("blockquote");
    }

    public void markdown(String md, String source) throws IOException {
        if (md != null) {
            XhtmlDocument m;
            String s = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK).process(md, source);
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + s + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            this.addChildren(m.getChildNodes());
        }
    }

    public void innerHTML(String html) throws IOException {
        if (html != null) {
            XhtmlDocument m;
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + html + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), e);
            }
            this.addChildren(m.getChildNodes());
        }
    }

    public XhtmlFluent txN(String cnt) {
        this.addText(cnt);
        return this;
    }

    public XhtmlFluent iff(boolean test) {
        if (test) {
            return this;
        }
        return new XhtmlNode(NodeType.Element, "span");
    }
}

