/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.exceptions;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.SourceLocation;
import org.hl7.fhir.utilities.Utilities;

public class PathEngineException
extends FHIRException {
    private static final long serialVersionUID = 31969342112856390L;
    private SourceLocation location;
    private String expression;
    private String id;

    public PathEngineException(String message, Throwable cause) {
        super(message, cause);
    }

    public PathEngineException(String message) {
        super(message);
    }

    public PathEngineException(String message, SourceLocation location, String expression, Throwable cause) {
        super(message + PathEngineException.rep(location, expression), cause);
    }

    public PathEngineException(String message, SourceLocation location, String expression) {
        super(message + PathEngineException.rep(location, expression));
    }

    public PathEngineException(String message, String id, Throwable cause) {
        super(message, cause);
        this.id = id;
    }

    public PathEngineException(String message, String id) {
        super(message);
        this.id = id;
    }

    public PathEngineException(String message, String id, SourceLocation location, String expression, Throwable cause) {
        super(message + PathEngineException.rep(location, expression), cause);
        this.id = id;
    }

    public PathEngineException(String message, String id, SourceLocation location, String expression) {
        super(message + PathEngineException.rep(location, expression));
        this.id = id;
    }

    private static String rep(SourceLocation loc, String expr) {
        if (loc != null) {
            if (loc.getLine() == 1) {
                return " (@char " + loc.getColumn() + ")";
            }
            return " (@line " + loc.getLine() + " char " + loc.getColumn() + ")";
        }
        if (Utilities.noString(expr)) {
            return " (@~" + expr + ")";
        }
        return "";
    }

    public PathEngineException(Throwable cause) {
        super(cause);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public void setLocation(SourceLocation location) {
        this.location = location;
    }

    public String getId() {
        return this.id;
    }
}

