/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.POObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSource {
    private static final Logger log = LoggerFactory.getLogger(POSource.class);
    private String lang;
    private List<POObject> entries = new ArrayList<POObject>();
    private List<String> prefixes = new ArrayList<String>();

    public String getLang() {
        return this.lang;
    }

    public List<POObject> getEntries() {
        return this.entries;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public static POSource loadPOFile(InputStream source) throws FileNotFoundException, IOException {
        return POSource.loadPOFile(FileUtilities.streamToLines(source));
    }

    public static POSource loadPOFile(String dest) throws FileNotFoundException, IOException {
        return POSource.loadPOFile(FileUtilities.fileToLines(new File(dest)));
    }

    private static POSource loadPOFile(String[] lines) throws FileNotFoundException, IOException {
        POSource res = new POSource();
        POObject obj = null;
        for (int i = 0; i < lines.length; ++i) {
            Object s;
            String line = lines[i];
            if (Utilities.noString(line)) continue;
            if (line.startsWith("#:")) {
                if (obj == null || obj.getId() != null) {
                    obj = new POObject();
                    res.entries.add(obj);
                }
                obj.setId(line.substring(2).trim());
                continue;
            }
            if (line.startsWith("# ") && line.contains(" -> ")) {
                res.lang = line.substring(line.indexOf("->") + 2).trim();
                continue;
            }
            if (line.startsWith("# ")) {
                if (obj == null || obj.getComment() != null) {
                    obj = new POObject();
                    res.entries.add(obj);
                }
                obj.setComment(line.substring(1).trim());
                if (!obj.getComment().contains("!!when")) continue;
                obj.setOldMsgId(obj.getComment().substring(obj.getComment().indexOf("!!when")));
                obj.setComment(obj.getComment().substring(0, obj.getComment().indexOf("!!when") - 1));
                obj.setOldMsgId(obj.getOldMsgId().substring(obj.getOldMsgId().indexOf(": ") + 2).trim());
                obj.setOldMsgId(obj.getOldMsgId().substring(0, obj.getOldMsgId().length() - 1));
                continue;
            }
            if (obj == null) {
                res.prefixes.add(line);
                continue;
            }
            if (line.startsWith("#,")) {
                s = line.substring(2).trim();
                for (String f : ((String)s).split("\\,")) {
                    obj.getFlags().add(f.trim());
                }
                continue;
            }
            if (line.startsWith("#|")) {
                s = line.substring(2).trim();
                if (((String)s).startsWith("msgid ")) {
                    s = POSource.trimQuotes(((String)s).substring(6));
                }
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                obj.setOldMsgId((String)s);
                continue;
            }
            if (line.startsWith("msgid ")) {
                s = POSource.trimQuotes(line.substring(5).trim());
                if (((String)s).endsWith("(" + obj.getId() + ")")) {
                    s = ((String)s).substring(0, ((String)s).length() - (obj.getId().length() + 3));
                }
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                obj.setMsgid((String)s);
                continue;
            }
            if (line.startsWith("msgid_plural ")) {
                s = POSource.trimQuotes(line.substring(12).trim());
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                obj.setMsgidPlural((String)s);
                continue;
            }
            if (line.startsWith("msgstr ")) {
                s = POSource.trimQuotes(line.substring(6).trim());
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                obj.getMsgstr().add((String)s);
                continue;
            }
            if (line.startsWith("msgctxt ")) continue;
            if (line.startsWith("msgstr[")) {
                s = line.substring(7);
                int ii = ((String)s).indexOf("]");
                int c = Integer.valueOf(((String)s).substring(0, ii));
                s = POSource.trimQuotes(((String)s).substring(ii + 1).trim());
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                while (((String)s).startsWith("!!")) {
                    s = ((String)s).substring(2);
                }
                if (c != obj.getMsgstr().size()) {
                    log.warn("index issue");
                    continue;
                }
                obj.getMsgstr().add((String)s);
                continue;
            }
            log.warn("unknown line: " + line);
        }
        return res;
    }

    private static String trimQuotes(String s) {
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.trim().replace("\\\"", "\"");
    }

    public int savePOFile(String dest, int count, int noTrans) throws IOException {
        StringBuilder b = new StringBuilder();
        for (String p : this.prefixes) {
            b.append(p);
            b.append("\r\n");
        }
        b.append("\r\n");
        for (POObject o : this.entries) {
            if (o.getOldMsgId() != null) {
                b.append("# " + o.getComment() + " (!!when last translated was: " + o.getOldMsgId() + ")\r\n");
            } else {
                b.append("# " + o.getComment() + "\r\n");
            }
            b.append("#: " + o.getId() + "\r\n");
            if (!o.getFlags().isEmpty()) {
                b.append("#, " + CommaSeparatedStringBuilder.join(",", o.getFlags()));
            }
            if (o.isDuplicate()) {
                b.append("msgctxt \"" + o.getId() + "\"\r\n");
            }
            Object m = Utilities.noString(o.getMsgid()) ? "-- no content: do not translate #" + ++noTrans + " --" : o.getMsgid();
            b.append("msgid \"" + POSource.wrapQuotes((String)m) + "\"\r\n");
            if (o.getMsgidPlural() != null) {
                b.append("msgid_plural \"" + POSource.wrapQuotes(o.getMsgidPlural()) + "\"\r\n");
                while (o.getMsgstr().size() < count) {
                    o.getMsgstr().add("");
                }
                for (int i = 0; i < o.getMsgstr().size(); ++i) {
                    String s = o.getMsgstr().get(i);
                    b.append("msgstr[" + i + "] \"" + POSource.wrapQuotes(s) + "\"\r\n");
                }
            } else if (o.getMsgstr().size() == 0) {
                b.append("msgstr \"\"\r\n");
            } else {
                b.append("msgstr \"" + POSource.wrapQuotes(o.getMsgstr().get(0)) + "\"\r\n");
            }
            b.append("\r\n");
        }
        FileUtilities.stringToFile(b.toString(), dest);
        return noTrans;
    }

    private static String wrapQuotes(String s) {
        return s.replace("\"", "\\\"");
    }
}

