/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemPackageCacheManagerLocks {
    private static final Logger log = LoggerFactory.getLogger(FilesystemPackageCacheManagerLocks.class);
    private static final ConcurrentHashMap<File, FilesystemPackageCacheManagerLocks> cacheFolderLockManagers = new ConcurrentHashMap();
    private final CacheLock cacheLock = new CacheLock();
    private final ConcurrentHashMap<File, PackageLock> packageLocks = new ConcurrentHashMap();
    private final File cacheFolder;
    private static final LockParameters lockParameters = new LockParameters();

    public FilesystemPackageCacheManagerLocks(File cacheFolder) throws IOException {
        this.cacheFolder = cacheFolder;
    }

    public static FilesystemPackageCacheManagerLocks getFilesystemPackageCacheManagerLocks(File cacheFolder) throws IOException {
        return cacheFolderLockManagers.computeIfAbsent(cacheFolder, k -> {
            try {
                return new FilesystemPackageCacheManagerLocks((File)k);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public synchronized PackageLock getPackageLock(String packageName) throws IOException {
        File lockFile = ManagedFileAccess.file(Utilities.path(this.cacheFolder.getAbsolutePath(), packageName + ".lock"));
        return this.packageLocks.computeIfAbsent(lockFile, k -> new PackageLock((File)k, new ReentrantReadWriteLock()));
    }

    public CacheLock getCacheLock() {
        return this.cacheLock;
    }

    public class CacheLock {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        protected CacheLock() {
        }

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public <T> T doWriteWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> f) throws IOException {
            this.lock.writeLock().lock();
            T result = null;
            try {
                result = f.get();
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return result;
        }

        public boolean canLockFileBeHeldByThisProcess(File lockFile) throws IOException {
            return this.doWriteWithLock(() -> {
                try (FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();){
                    FileLock fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
                    if (fileLock != null) {
                        fileLock.release();
                        channel.close();
                        Boolean bl = true;
                        return bl;
                    }
                }
                return false;
            });
        }
    }

    public class PackageLock {
        private final File lockFile;
        private final ReadWriteLock lock;

        protected PackageLock(File lockFile, ReadWriteLock lock) {
            this.lockFile = lockFile;
            this.lock = lock;
        }

        private void checkForLockFileWaitForDeleteIfExists(File lockFile, @Nonnull LockParameters lockParameters) throws IOException {
            if (!lockFile.exists()) {
                return;
            }
            if (lockFile.isFile()) {
                try (FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();){
                    FileLock fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
                    if (fileLock != null) {
                        fileLock.release();
                        channel.close();
                        throw new IOException("Lock file exists, but is not locked by a process: " + lockFile.getName());
                    }
                    log.debug("File is locked ('" + lockFile.getAbsolutePath() + "').");
                }
            }
            try {
                this.waitForLockFileDeletion(lockFile, lockParameters);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted while waiting for lock", e);
            }
        }

        private void waitForLockFileDeletion(File lockFile, @Nonnull LockParameters lockParameters) throws IOException, InterruptedException {
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                Path dir = lockFile.getParentFile().toPath();
                dir.register(watchService, StandardWatchEventKinds.ENTRY_DELETE);
                WatchKey key = watchService.poll(lockParameters.lockTimeoutTime, lockParameters.lockTimeoutTimeUnit);
                if (key == null) {
                    if (lockFile.exists()) {
                        throw new TimeoutException("Timeout waiting for lock file deletion: " + lockFile.getName());
                    }
                } else {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path deletedFilePath;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.ENTRY_DELETE && (deletedFilePath = (Path)event.context()).toString().equals(lockFile.getName())) {
                            return;
                        }
                        key.reset();
                    }
                }
            }
            catch (TimeoutException e) {
                throw new IOException("Package cache timed out waiting for lock.", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T doReadWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> function, @Nullable LockParameters lockParameters) throws IOException {
            LockParameters resolvedLockParameters = lockParameters != null ? lockParameters : FilesystemPackageCacheManagerLocks.lockParameters;
            FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().readLock().lock();
            this.lock.readLock().lock();
            this.checkForLockFileWaitForDeleteIfExists(this.lockFile, resolvedLockParameters);
            T result = null;
            try {
                result = function.get();
            }
            finally {
                this.lock.readLock().unlock();
                FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().readLock().unlock();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T> T doWriteWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> function, @Nullable LockParameters lockParameters) throws IOException {
            LockParameters resolvedLockParameters = lockParameters != null ? lockParameters : FilesystemPackageCacheManagerLocks.lockParameters;
            FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().writeLock().lock();
            this.lock.writeLock().lock();
            try (FileChannel channel = new RandomAccessFile(this.lockFile, "rw").getChannel();){
                FileLock fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
                if (fileLock == null) {
                    this.waitForLockFileDeletion(this.lockFile, resolvedLockParameters);
                    fileLock = channel.tryLock(0L, Long.MAX_VALUE, false);
                }
                if (fileLock == null) {
                    throw new IOException("Failed to acquire lock on file: " + this.lockFile.getName());
                }
                if (!this.lockFile.isFile()) {
                    ByteBuffer buff = ByteBuffer.wrap(String.valueOf(ProcessHandle.current().pid()).getBytes(StandardCharsets.UTF_8));
                    channel.write(buff);
                }
                T result = null;
                try {
                    result = function.get();
                }
                finally {
                    this.lockFile.renameTo(ManagedFileAccess.file(File.createTempFile(this.lockFile.getName(), ".lock-renamed").getAbsolutePath()));
                    fileLock.release();
                    channel.close();
                    if (!this.lockFile.delete()) {
                        this.lockFile.deleteOnExit();
                    }
                    this.lock.writeLock().unlock();
                    FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().writeLock().unlock();
                }
                T t = result;
                return t;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted while waiting for lock", e);
            }
        }

        public File getLockFile() {
            return this.lockFile;
        }
    }

    public static class LockParameters {
        private final long lockTimeoutTime;
        private final TimeUnit lockTimeoutTimeUnit;

        public LockParameters() {
            this(60L, TimeUnit.SECONDS);
        }

        public LockParameters(long lockTimeoutTime, TimeUnit lockTimeoutTimeUnit) {
            this.lockTimeoutTime = lockTimeoutTime;
            this.lockTimeoutTimeUnit = lockTimeoutTimeUnit;
        }

        public long getLockTimeoutTime() {
            return this.lockTimeoutTime;
        }

        public LockParameters withLockTimeoutTime(long lockTimeoutTime) {
            return this.lockTimeoutTime == lockTimeoutTime ? this : new LockParameters(lockTimeoutTime, this.lockTimeoutTimeUnit);
        }

        public TimeUnit getLockTimeoutTimeUnit() {
            return this.lockTimeoutTimeUnit;
        }

        public LockParameters withLockTimeoutTimeUnit(TimeUnit lockTimeoutTimeUnit) {
            return this.lockTimeoutTimeUnit == lockTimeoutTimeUnit ? this : new LockParameters(this.lockTimeoutTime, lockTimeoutTimeUnit);
        }
    }
}

