/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.validation;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.AcceptLanguageHeader;

public class ValidationOptions {
    private AcceptLanguageHeader langs = null;
    private boolean useServer = true;
    private boolean useClient = true;
    private boolean guessSystem = false;
    private boolean membershipOnly = false;
    private boolean displayWarningMode = false;
    private boolean vsAsUrl;
    private boolean versionFlexible = true;
    private boolean useValueSetDisplays;
    private boolean englishOk = true;
    private boolean activeOnly = false;
    private boolean exampleOK = false;
    private FhirPublication fhirVersion;
    private R5BundleRelativeReferencePolicy r5BundleRelativeReferencePolicy = R5BundleRelativeReferencePolicy.DEFAULT;
    private boolean isDefaultLang = false;

    public ValidationOptions() {
        this(FhirPublication.R5);
    }

    public ValidationOptions(FhirPublication fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public ValidationOptions(FhirPublication fhirVersion, String language) {
        if (!Utilities.noString(language)) {
            this.langs = new AcceptLanguageHeader(language, false);
            this.isDefaultLang = false;
        }
    }

    public static ValidationOptions defaults() {
        ValidationOptions vo = new ValidationOptions(FhirPublication.R5, "en, en-US");
        vo.isDefaultLang = true;
        return vo;
    }

    public AcceptLanguageHeader getLanguages() {
        return this.langs;
    }

    public boolean hasLanguages() {
        return this.langs != null && !Utilities.noString(this.langs.getSource());
    }

    public boolean isUseServer() {
        return this.useServer;
    }

    public boolean isUseClient() {
        return this.useClient;
    }

    public boolean isGuessSystem() {
        return this.guessSystem;
    }

    public boolean isActiveOnly() {
        return this.activeOnly;
    }

    public boolean getVsAsUrl() {
        return this.vsAsUrl;
    }

    public boolean isVersionFlexible() {
        return this.versionFlexible;
    }

    public boolean isUseValueSetDisplays() {
        return this.useValueSetDisplays;
    }

    public boolean isMembershipOnly() {
        return this.membershipOnly;
    }

    public boolean isEnglishOk() {
        return this.englishOk;
    }

    public ValidationOptions withLanguage(String language) {
        if (language == null) {
            return this;
        }
        ValidationOptions n = this.copy();
        n.addLanguage(language);
        return n;
    }

    public ValidationOptions withNoServer() {
        ValidationOptions n = this.copy();
        n.useServer = false;
        return n;
    }

    public ValidationOptions withNoClient() {
        ValidationOptions n = this.copy();
        n.useClient = false;
        return n;
    }

    public ValidationOptions withGuessSystem() {
        ValidationOptions n = this.copy();
        n.guessSystem = true;
        return n;
    }

    public ValidationOptions withGuessSystem(boolean value) {
        ValidationOptions n = this.copy();
        n.guessSystem = value;
        return n;
    }

    public ValidationOptions withActiveOnly() {
        ValidationOptions n = this.copy();
        n.activeOnly = true;
        return n;
    }

    public ValidationOptions withCheckValueSetOnly() {
        ValidationOptions n = this.copy();
        n.membershipOnly = true;
        return n;
    }

    public ValidationOptions withVsAsUrl() {
        ValidationOptions n = this.copy();
        n.vsAsUrl = true;
        return n;
    }

    public ValidationOptions withVersionFlexible(boolean value) {
        ValidationOptions n = this.copy();
        n.versionFlexible = value;
        return n;
    }

    public ValidationOptions withUseValueSetDisplays(boolean useValueSetDisplays) {
        ValidationOptions n = this.copy();
        n.useValueSetDisplays = useValueSetDisplays;
        return n;
    }

    public ValidationOptions withEnglishOk(boolean englishOk) {
        ValidationOptions n = this.copy();
        n.englishOk = englishOk;
        return n;
    }

    public ValidationOptions addLanguage(String language) {
        if (this.langs == null || this.isDefaultLang) {
            this.langs = new AcceptLanguageHeader(language, false);
        } else {
            this.langs.add(language);
            this.isDefaultLang = false;
        }
        return this;
    }

    public ValidationOptions setLanguages(String language) {
        this.langs = new AcceptLanguageHeader(language, false);
        this.isDefaultLang = false;
        return this;
    }

    public ValidationOptions setUseServer(boolean useServer) {
        this.useServer = useServer;
        return this;
    }

    public ValidationOptions setUseClient(boolean useClient) {
        this.useClient = useClient;
        return this;
    }

    public ValidationOptions setGuessSystem(boolean guessSystem) {
        this.guessSystem = guessSystem;
        return this;
    }

    public ValidationOptions setActiveOnly(boolean activeOnly) {
        this.activeOnly = activeOnly;
        return this;
    }

    public ValidationOptions setCheckValueSetOnly() {
        this.membershipOnly = true;
        return this;
    }

    public ValidationOptions setVsAsUrl(boolean value) {
        this.vsAsUrl = value;
        return this;
    }

    public ValidationOptions setVersionFlexible(boolean value) {
        this.versionFlexible = value;
        return this;
    }

    public ValidationOptions setUseValueSetDisplays(boolean useValueSetDisplays) {
        this.useValueSetDisplays = useValueSetDisplays;
        return this;
    }

    public ValidationOptions setEnglishOk(boolean englishOk) {
        this.englishOk = englishOk;
        return this;
    }

    public boolean isDisplayWarningMode() {
        return this.displayWarningMode;
    }

    public ValidationOptions setDisplayWarningMode(boolean displayWarningMode) {
        this.displayWarningMode = displayWarningMode;
        return this;
    }

    public boolean isExampleOK() {
        return this.exampleOK;
    }

    public ValidationOptions setExampleOK(boolean exampleOK) {
        this.exampleOK = exampleOK;
        return this;
    }

    public ValidationOptions withExampleOK() {
        return this.setExampleOK(true);
    }

    public R5BundleRelativeReferencePolicy getR5BundleRelativeReferencePolicy() {
        return this.r5BundleRelativeReferencePolicy;
    }

    public void setR5BundleRelativeReferencePolicy(R5BundleRelativeReferencePolicy r5BundleRelativeReferencePolicy) {
        if (r5BundleRelativeReferencePolicy == null) {
            r5BundleRelativeReferencePolicy = R5BundleRelativeReferencePolicy.DEFAULT;
        }
        this.r5BundleRelativeReferencePolicy = r5BundleRelativeReferencePolicy;
    }

    public ValidationOptions withR5BundleRelativeReferencePolicy(R5BundleRelativeReferencePolicy r5BundleRelativeReferencePolicy) {
        this.setR5BundleRelativeReferencePolicy(r5BundleRelativeReferencePolicy);
        return this;
    }

    public ValidationOptions copy() {
        ValidationOptions n = new ValidationOptions(this.fhirVersion);
        n.langs = this.langs == null ? null : this.langs.copy();
        n.isDefaultLang = this.isDefaultLang;
        n.useServer = this.useServer;
        n.useClient = this.useClient;
        n.guessSystem = this.guessSystem;
        n.activeOnly = this.activeOnly;
        n.vsAsUrl = this.vsAsUrl;
        n.versionFlexible = this.versionFlexible;
        n.membershipOnly = this.membershipOnly;
        n.useValueSetDisplays = this.useValueSetDisplays;
        n.displayWarningMode = this.displayWarningMode;
        n.exampleOK = this.exampleOK;
        n.r5BundleRelativeReferencePolicy = this.r5BundleRelativeReferencePolicy;
        return n;
    }

    public String toJson() {
        return "\"langs\":\"" + (this.langs == null ? "" : this.langs.toString()) + "\", \"useServer\":\"" + Boolean.toString(this.useServer) + "\", \"useClient\":\"" + Boolean.toString(this.useClient) + "\", \"guessSystem\":\"" + Boolean.toString(this.guessSystem) + "\", \"activeOnly\":\"" + Boolean.toString(this.activeOnly) + (String)(this.exampleOK ? "\", \"exampleOK\":\"" + Boolean.toString(this.exampleOK) : "") + "\", \"membershipOnly\":\"" + Boolean.toString(this.membershipOnly) + "\", \"displayWarningMode\":\"" + Boolean.toString(this.displayWarningMode) + "\", \"versionFlexible\":\"" + Boolean.toString(this.versionFlexible) + "\"" + (String)(this.r5BundleRelativeReferencePolicy != R5BundleRelativeReferencePolicy.DEFAULT ? ", \"r5BundleRelativeReferencePolicy\":\"" + this.r5BundleRelativeReferencePolicy.toCode() + "\"" : "");
    }

    public String langSummary() {
        if (this.langs == null) {
            return "--";
        }
        String s = this.langs.toString();
        if (Utilities.noString(s)) {
            s = "--";
        }
        return s;
    }

    public FhirPublication getFhirVersion() {
        return this.fhirVersion;
    }

    public static enum R5BundleRelativeReferencePolicy {
        DEFAULT,
        NEVER,
        ALWAYS;


        public String toCode() {
            switch (this) {
                case ALWAYS: {
                    return "always";
                }
                case DEFAULT: {
                    return "default";
                }
                case NEVER: {
                    return "never";
                }
            }
            return null;
        }

        public static R5BundleRelativeReferencePolicy fromCode(String code) {
            switch (code) {
                case "always": {
                    return ALWAYS;
                }
                case "default": {
                    return DEFAULT;
                }
                case "never": {
                    return NEVER;
                }
            }
            throw new FHIRException("bad code " + code);
        }
    }
}

