/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.UUIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

public class HierarchicalTableGenerator {
    public static final String TEXT_ICON_REFERENCE = "Reference to another Resource";
    public static final String TEXT_ICON_PRIMITIVE = "Primitive Data Type";
    public static final String TEXT_ICON_KEY = "JSON Key Value";
    public static final String TEXT_ICON_DATATYPE = "Data Type";
    public static final String TEXT_ICON_RESOURCE = "Resource";
    public static final String TEXT_ICON_ELEMENT = "Element";
    public static final String TEXT_ICON_OBJECT_BOX = "Object";
    public static final String TEXT_ICON_REUSE = "Reference to another Element";
    public static final String TEXT_ICON_EXTENSION = "Extension";
    public static final String TEXT_ICON_CHOICE = "Choice of Types";
    public static final String TEXT_ICON_SLICE = "Slice Definition";
    public static final String TEXT_ICON_SLICE_ITEM = "Slice Item";
    public static final String TEXT_ICON_FIXED = "Fixed Value";
    public static final String TEXT_ICON_EXTENSION_SIMPLE = "Simple Extension";
    public static final String TEXT_ICON_PROFILE = "Profile";
    public static final String TEXT_ICON_EXTENSION_COMPLEX = "Complex Extension";
    public static final int NEW_REGULAR = 0;
    public static final int CONTINUE_REGULAR = 1;
    public static final int NEW_SLICER = 2;
    public static final int CONTINUE_SLICER = 3;
    public static final int NEW_SLICE = 4;
    public static final int CONTINUE_SLICE = 5;
    private static final String BACKGROUND_ALT_COLOR = "#F7F7F7";
    public static boolean ACTIVE_TABLES = false;
    public static String uuid = UUIDUtilities.makeUuidLC();
    private static Set<String> KNOWN_ROLES = Set.of("binding", "constraint", "obligation");
    private static Map<String, String> files = new HashMap<String, String>();
    private String dest;
    private boolean makeTargets;
    private String defPath = "";
    private boolean inLineGraphics;
    private TableGenerationMode mode;
    private RenderingI18nContext i18n;
    private String uniqueLocalPrefix;
    private boolean treelines = true;

    public HierarchicalTableGenerator(RenderingI18nContext i18n) {
        this.i18n = i18n;
    }

    public HierarchicalTableGenerator(RenderingI18nContext i18n, String uniqueLocalPrefix) {
        this.i18n = i18n;
        this.uniqueLocalPrefix = uniqueLocalPrefix;
    }

    public HierarchicalTableGenerator(RenderingI18nContext i18n, String dest, boolean inlineGraphics) {
        this.i18n = i18n;
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = true;
        this.checkSetup();
    }

    public HierarchicalTableGenerator(RenderingI18nContext i18n, String dest, boolean inlineGraphics, String uniqueLocalPrefix) {
        this.i18n = i18n;
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = true;
        this.uniqueLocalPrefix = uniqueLocalPrefix;
        this.checkSetup();
    }

    public HierarchicalTableGenerator(RenderingI18nContext i18n, String dest, boolean inlineGraphics, boolean makeTargets, String defPath, String uniqueLocalPrefix) {
        this.i18n = i18n;
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = makeTargets;
        this.defPath = defPath;
        this.uniqueLocalPrefix = uniqueLocalPrefix;
        this.checkSetup();
    }

    public HierarchicalTableGenerator(RenderingI18nContext i18n, String dest, boolean inlineGraphics, boolean makeTargets, String uniqueLocalPrefix) {
        this.i18n = i18n;
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = makeTargets;
        this.uniqueLocalPrefix = uniqueLocalPrefix;
        this.checkSetup();
    }

    public HierarchicalTableGenerator(RenderingI18nContext i18n, String dest, boolean inlineGraphics, boolean makeTargets) {
        this.i18n = i18n;
        this.dest = dest;
        this.inLineGraphics = inlineGraphics;
        this.makeTargets = makeTargets;
        this.checkSetup();
    }

    private void checkSetup() {
        if (this.dest == null) {
            throw new Error("what");
        }
    }

    public String getDefPath() {
        return this.defPath;
    }

    public TableModel initNormalTable(String prefix, boolean isLogical, boolean alternating, String id, boolean isActive, TableGenerationMode mode) throws IOException {
        this.mode = mode;
        TableModel model = new TableModel(id, isActive);
        model.setAlternating(alternating);
        if (mode == TableGenerationMode.XML) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL(ManagedWebAccess.makeSecureRef(prefix), "help16.png"));
        }
        model.setDocoRef(Utilities.pathURL("https://build.fhir.org/ig/FHIR/ig-guidance", "readingIgs.html#table-views"));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_NAME", new Object[0]), this.i18n.formatPhrase("GENERAL_LOGICAL_NAME", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_FLAGS", new Object[0]), this.i18n.formatPhrase("SD_HEAD_FLAGS_DESC", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_CARD", new Object[0]), this.i18n.formatPhrase("SD_HEAD_CARD_DESC", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_TYPE", new Object[0]), this.i18n.formatPhrase("SD_GRID_HEAD_TYPE_DESC", new Object[0]), null, 100));
        Title t = new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_DESC_CONST", new Object[0]), this.i18n.formatPhrase("SD_HEAD_DESC_DESC", new Object[0]), null, 0);
        t.setFilter(true);
        t.checkboxes.put(this.i18n.formatPhrase("GENERAL_OBLIGATIONS", new Object[0]), "obligation");
        t.checkboxes.put(this.i18n.formatPhrase("GENERAL_CONSTRAINTS", new Object[0]), "constraint");
        t.checkboxes.put(this.i18n.formatPhrase("GENERAL_BINDINGS", new Object[0]), "binding");
        model.getTitles().add(t);
        if (isLogical) {
            model.getTitles().add(new Title(null, prefix + "structuredefinition.html#logical", "Implemented As", "How this logical data item is implemented in a concrete resource", null, 0));
        }
        return model;
    }

    public TableModel initComparisonTable(String prefix, String id) throws IOException {
        TableModel model = new TableModel(id, true);
        model.setAlternating(true);
        if (this.mode == TableGenerationMode.XML) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL(ManagedWebAccess.makeSecureRef(prefix), "help16.png"));
        }
        model.setDocoRef(Utilities.pathURL(ManagedWebAccess.makeSecureRef(prefix), "formats.html#table"));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_NAME", new Object[0]), this.i18n.formatPhrase("GENERAL_LOGICAL_NAME", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_FLAGS_L", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_FLAGS_L_DESC", new Object[0]), null, 0).setStyle("border-left: 1px grey solid"));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_CARD_L", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_CARD_L_DESC", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_TYPE_L", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_TYPE_L_DESC", new Object[0]), null, 100));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_DESC_L", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_DESC_L_DESC", new Object[0]), null, 0).setStyle("border-right: 1px grey solid"));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_FLAGS_R", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_FLAGS_R_DESC", new Object[0]), null, 0).setStyle("border-left: 1px grey solid"));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_CARD_R", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_CARD_R_DESC", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_TYPE_R", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_TYPE_R_DESC", new Object[0]), null, 100));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_COMP_HEAD_DESC_R", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_DESC_R_DESC", new Object[0]), null, 0).setStyle("border-right: 1px grey solid"));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_COMMENTS", new Object[0]), this.i18n.formatPhrase("SD_COMP_HEAD_COMP_DESC", new Object[0]), null, 0));
        return model;
    }

    public TableModel initGridTable(String prefix, String id) {
        TableModel model = new TableModel(id, false);
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_NAME", new Object[0]), this.i18n.formatPhrase("SD_GRID_HEAD_NAME_DESC", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_CARD", new Object[0]), this.i18n.formatPhrase("SD_GRID_HEAD_CARD_DESC", new Object[0]), null, 0));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("GENERAL_TYPE", new Object[0]), this.i18n.formatPhrase("SD_GRID_HEAD_TYPE_DESC", new Object[0]), null, 100));
        model.getTitles().add(new Title(null, model.getDocoRef(), this.i18n.formatPhrase("SD_GRID_HEAD_DESC", new Object[0]), this.i18n.formatPhrase("SD_GRID_HEAD_DESC_DESC", new Object[0]), null, 0));
        return model;
    }

    public String treeFilterJS(String mid, Map<String, String> checkboxes) {
        String js = "  // " + uuid + "\n";
        for (String s : Utilities.sorted(checkboxes.keySet())) {
            String id = "cb" + mid + "-" + checkboxes.get(s);
            js = js + "document.getElementById('" + id + "').checked = 'false' != localStorage.getItem('ht-table-states-" + checkboxes.get(s) + "');\n";
            js = js + "filterDesc(document.getElementById('" + mid + "'), '" + checkboxes.get(s) + "', document.getElementById('cb" + mid + "-" + checkboxes.get(s) + "').checked, document.getElementById('pp" + mid + "'));\n";
        }
        return js;
    }

    public XhtmlNode generate(TableModel model, String imagePath, int border, Set<String> outputTracker) throws IOException, FHIRException {
        this.checkModel(model);
        boolean script = false;
        Map<String, String> checkboxes = null;
        for (Title t : model.getTitles()) {
            boolean bl = script = script || t.isFilter() || t.getCheckboxes().size() > 0;
            if (t.getCheckboxes().size() <= 0) continue;
            checkboxes = t.getCheckboxes();
        }
        XhtmlNode table = new XhtmlNode(NodeType.Element, "table").setAttribute("border", Integer.toString(border)).setAttribute("cellspacing", "0").setAttribute("cellpadding", "0");
        if (model.active) {
            table.setAttribute("fhir", "generated-heirarchy");
            table.setAttribute("data-fhir", "generated-heirarchy");
        }
        if (model.isActive()) {
            table.setAttribute("id", model.getId());
        }
        if (model.isBorder()) {
            table.style("border: 2px black solid; font-size: 11px; font-family: verdana; vertical-align: top;");
        } else {
            table.style("border: " + border + "px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top;");
        }
        if (model.isShowHeadings()) {
            XhtmlNode tr = table.addTag("tr");
            if (model.active) {
                tr.setAttribute("fhir", "generated-heirarchy");
                tr.setAttribute("data-fhir", "generated-heirarchy");
            }
            tr.style("border: " + Integer.toString(1 + border) + "px #F0F0F0 solid; font-size: 11px; font-family: verdana; vertical-align: top");
            Object tc = null;
            for (Title t : model.getTitles()) {
                tc = this.renderCell(tr, t, "th", null, null, null, false, null, "white", 0, imagePath, border, outputTracker, model, null, true, model.active && t.isFilter(), model.getId(), t.getCheckboxes());
                if (t.width == 0) continue;
                ((XhtmlNode)tc).style("width: " + Integer.toString(t.width) + "px");
            }
            if (tc != null && model.getDocoRef() != null) {
                XhtmlNode a = ((XhtmlNode)tc).addTag("span").style("float: right").addTag("a").setAttribute("title", "Legend for this format").setAttribute("href", model.getDocoRef());
                if (this.mode == TableGenerationMode.XHTML) {
                    a.setAttribute("no-external", "true");
                    a.setAttribute("data-no-external", "true");
                }
                XhtmlNode img = a.addTag("img");
                img.setAttribute("alt", "doco").style("background-color: inherit").setAttribute("src", model.getDocoImg());
                if (model.isActive()) {
                    img.setAttribute("onLoad", "fhirTableInit(this)");
                }
            }
        }
        Counter counter = new Counter();
        for (Row r : model.getRows()) {
            this.renderRow(table, r, 0, new ArrayList<Integer>(), imagePath, border, outputTracker, counter, model);
        }
        if (model.getDocoRef() != null) {
            XhtmlNode tr = table.addTag("tr");
            if (model.active) {
                tr.setAttribute("fhir", "generated-heirarchy");
                tr.setAttribute("data-fhir", "generated-heirarchy");
            }
            XhtmlNode tc = tr.addTag("td");
            tc.setAttribute("class", "hierarchy");
            tc.setAttribute("colspan", Integer.toString(model.getTitles().size()));
            tc.addTag("br");
            XhtmlNode a = tc.addTag("a").setAttribute("title", this.i18n.formatPhrase("SD_LEGEND", new Object[0])).setAttribute("href", model.getDocoRef());
            if (model.getDocoImg() != null) {
                a.addTag("img").setAttribute("alt", "doco").style("background-color: inherit").setAttribute("src", model.getDocoImg());
            }
            a.addText(" " + this.i18n.formatPhrase("SD_DOCO", new Object[0]));
        }
        if (model.active && script) {
            table.addTag("script").setAttribute("type", "text/javascript").tx(this.treeFilterJS(model.getId(), checkboxes));
        }
        return table;
    }

    private void renderRow(XhtmlNode table, Row r, int indent, List<Integer> indents, String imagePath, int border, Set<String> outputTracker, Counter counter, TableModel model) throws IOException {
        if (!r.partnerRow) {
            counter.row();
        }
        XhtmlNode tr = table.addTag("tr");
        if (model.active) {
            tr.setAttribute("fhir", "generated-heirarchy");
            tr.setAttribute("data-fhir", "generated-heirarchy");
        }
        String color = "white";
        if (r.getColor() != null) {
            color = r.getColor();
        } else if (model.isAlternating() && counter.isOdd()) {
            color = BACKGROUND_ALT_COLOR;
        }
        String lineStyle = r.getTopLine() == null ? "" : "; border-top: 1px solid " + r.getTopLine();
        tr.style("border: " + border + "px #F0F0F0 solid; padding:0px; vertical-align: top; background-color: " + color + (String)(r.getOpacity() == null ? "" : "; opacity: " + r.getOpacity()) + lineStyle);
        if (model.isActive()) {
            tr.setAttribute("id", r.getId());
        }
        boolean first = true;
        for (Cell t : r.getCells()) {
            this.renderCell(tr, t, "td", first ? r.getIcon() : null, first ? r.getHint() : null, first ? indents : null, !r.getSubRows().isEmpty(), first ? r.getAnchor() : null, color, r.getLineColor(), imagePath, border, outputTracker, model, r, first, false, model.getId(), null);
            first = false;
        }
        table.addText("\r\n");
        for (int i = 0; i < r.getSubRows().size(); ++i) {
            Row c = r.getSubRows().get(i);
            ArrayList<Integer> ind = new ArrayList<Integer>();
            ind.addAll(indents);
            if (i == r.getSubRows().size() - 1) {
                ind.add(r.getLineColor() * 2);
            } else {
                ind.add(r.getLineColor() * 2 + 1);
            }
            this.renderRow(table, c, indent + 1, ind, imagePath, border, outputTracker, counter, model);
        }
    }

    private XhtmlNode renderCell(XhtmlNode tr, Cell c, String name, String icon, String hint, List<Integer> indents, boolean hasChildren, String anchor, String color, int lineColor, String imagePath, int border, Set<String> outputTracker, TableModel table, Row row, boolean suppressExternals, boolean filter, String mid, Map<String, String> checkboxes) throws IOException {
        XhtmlNode tc = tr.addTag(name);
        tc.setAttribute("class", "hierarchy");
        if (c.span > 1) {
            tc.colspan(Integer.toString(c.span));
        }
        if (c.getId() != null) {
            tc.setAttribute("id", c.getId());
        }
        String lineStyle = row != null && row.getTopLine() == null ? "" : "; padding-top: 3px; padding-bottom: 3px";
        XhtmlNode itc = tc;
        XhtmlNode itr = null;
        if (c.innerTable) {
            itr = tc.table("none", true).tr();
            itc = itr.td();
        }
        if (indents != null) {
            itc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_spacer.png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
            tc.style("vertical-align: top; text-align : var(--ig-left,left); " + (String)(c.cellStyle != null && c.cellStyle.contains("background-color") ? "" : "background-color: " + color + "; ") + "border: " + border + "px #F0F0F0 solid; padding:0px 4px 0px 4px; white-space: nowrap" + (String)(this.treelines ? "; background-image: url(" + imagePath + this.checkExists(indents, hasChildren, lineColor, outputTracker) + ")" : "") + (String)(c.cellStyle != null ? ";" + c.cellStyle : "") + lineStyle);
            block14: for (int i = 0; i < indents.size() - 1; ++i) {
                switch (indents.get(i)) {
                    case 0: 
                    case 2: 
                    case 4: {
                        itc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_blank.png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    case 1: {
                        itc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_vline.png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    case 3: {
                        itc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_vline_slicer.png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    case 5: {
                        itc.addTag("img").setAttribute("src", this.srcFor(imagePath, "tbl_vline_slice.png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        continue block14;
                    }
                    default: {
                        throw new Error("Unrecognized indent level: " + String.valueOf(indents.get(i)));
                    }
                }
            }
            if (!indents.isEmpty()) {
                String sfx = table.isActive() && hasChildren ? "-open" : "";
                XhtmlNode img = itc.addTag("img");
                switch (indents.get(indents.size() - 1)) {
                    case 0: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_end" + sfx + ".png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 2: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_end_slicer" + sfx + ".png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 4: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_end_slice" + sfx + ".png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 1: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin" + sfx + ".png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 3: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_slicer" + sfx + ".png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    case 5: {
                        img.setAttribute("src", this.srcFor(imagePath, "tbl_vjoin_slice" + sfx + ".png")).style("background-color: inherit").setAttribute("class", "hierarchy").setAttribute("alt", ".");
                        break;
                    }
                    default: {
                        throw new Error("Unrecognized indent level: " + String.valueOf(indents.get(indents.size() - 1)));
                    }
                }
                if (table.isActive() && hasChildren) {
                    img.setAttribute("onClick", "tableRowAction(this)");
                }
            }
        } else {
            tc.style("vertical-align: top; text-align : var(--ig-left,left); " + (String)(c.cellStyle != null && c.cellStyle.contains("background-color") ? "" : "background-color: " + color + "; ") + "border: " + border + "px #F0F0F0 solid; padding:0px 4px 0px 4px" + (String)(c.cellStyle != null ? ";" + c.cellStyle : "") + lineStyle);
        }
        if (c.innerTable) {
            itc = itr.td();
        }
        if (!Utilities.noString(icon)) {
            XhtmlNode img = itc.addTag("img").setAttribute("alt", "icon").setAttribute("src", this.srcFor(imagePath, icon)).setAttribute("class", "hierarchy").style("background-color: " + color + "; background-color: inherit").setAttribute("alt", ".");
            if (hint != null) {
                img.setAttribute("title", hint);
            }
            itc.addText(" ");
        }
        for (Piece p : c.pieces) {
            XhtmlNode s;
            if (!Utilities.noString(p.getTag())) {
                XhtmlNode tag = itc.addTag(p.getTag());
                if (p.attributes != null) {
                    for (String n : p.attributes.keySet()) {
                        tag.setAttribute(n, p.attributes.get(n));
                    }
                }
                if (p.getHint() != null) {
                    tag.setAttribute("title", p.getHint());
                }
                this.addStyle(tag, p);
                if (!p.hasChildren()) continue;
                tag.addChildNodes(p.getChildren());
                continue;
            }
            if (!Utilities.noString(p.getReference())) {
                XhtmlNode a = this.addStyle(itc.addTag("a"), p);
                if (p.attributes != null) {
                    for (String n : p.attributes.keySet()) {
                        a.setAttribute(n, p.attributes.get(n));
                    }
                }
                a.setAttribute("href", this.prefixLocalHref(p.getReference()));
                if (this.mode == TableGenerationMode.XHTML && suppressExternals) {
                    a.setAttribute("no-external", "true");
                    a.setAttribute("data-no-external", "true");
                }
                if (!Utilities.noString(p.getHint())) {
                    a.setAttribute("title", p.getHint());
                }
                if (p.getText() != null) {
                    a.addText(p.getText());
                } else {
                    a.addChildren(p.getChildren());
                }
                this.addStyle(a, p);
                if (p.getTagImg() != null) {
                    a.tx(" ");
                    a.img(p.getTagImg(), null);
                }
                if (!p.hasChildren()) continue;
                itc.addChildNodes(p.getChildren());
                continue;
            }
            if (!Utilities.noString(p.getHint()) || p.hasAttributes()) {
                s = this.addStyle(itc.addTag("span"), p);
                if (p.attributes != null) {
                    for (String n : p.attributes.keySet()) {
                        s.setAttribute(n, p.attributes.get(n));
                    }
                }
                s.setAttribute("title", p.getHint());
                s.addText(p.getText());
            } else if (p.getStyle() != null) {
                s = this.addStyle(itc.addTag("span"), p);
                if (p.attributes != null) {
                    for (String n : p.attributes.keySet()) {
                        s.setAttribute(n, p.attributes.get(n));
                    }
                }
                s.addText(p.getText());
            } else {
                itc.addText(p.getText());
            }
            if (p.hasChildren()) {
                itc.addChildNodes(p.getChildren());
            }
            if (p.getTagImg() == null) continue;
            itc.tx(" ");
            itc.img(p.getTagImg(), null);
        }
        if (this.makeTargets && !Utilities.noString(anchor)) {
            tc.addTag("a").setAttribute("name", this.prefixAnchor(this.nmTokenize(anchor))).addText(" ");
        }
        if (filter) {
            itc.nbsp();
            itc.nbsp();
            itc.nbsp();
            itc.nbsp();
            XhtmlNode span = itc.span();
            span.style("font-weight: normal");
            span.tx("Filter: ");
            XhtmlNode input = span.input("filter", "text", null, 10);
            input.style("border: 1px #F0F0F0 solid; background-color: rgb(254, 254, 231);");
            input.setAttribute("onInput", "filterTree(document.getElementById('" + mid + "'), event.target.value)");
            if (checkboxes != null) {
                span.tx(" ");
                span.img("tree-filter.png", "Filters").setAttribute("onClick", "showPanel(event.target, document.getElementById('" + mid + "'), document.getElementById('pp" + mid + "'))");
                XhtmlNode popupPanel = span.div();
                popupPanel.attribute("id", "pp" + mid);
                popupPanel.style("display: none; position: fixed; opacity : 1.0; background-color: rgb(254, 254, 231); border: 1px solid #ccc; padding: 10px; boxShadow: 0 2px 5px rgba(0,0,0,0.2); zIndex: 1000; borderRadius: 4px");
                for (String s : Utilities.sorted(checkboxes.keySet())) {
                    String v = checkboxes.get(s);
                    popupPanel.tx(s);
                    popupPanel.tx(" ");
                    input = popupPanel.input(v, "checkbox", null, 1);
                    input.setAttribute("id", "cb" + mid + "-" + checkboxes.get(s));
                    input.setAttribute("checked", "true");
                    input.setAttribute("onClick", "filterDesc(document.getElementById('" + mid + "'), '" + v + "',event.target.checked, document.getElementById('pp" + mid + "'))");
                    popupPanel.br();
                }
            }
        }
        return tc;
    }

    private XhtmlNode addStyle(XhtmlNode node, Piece p) {
        if (p.getStyle() != null) {
            node.style(p.getStyle());
        }
        return node;
    }

    private String nmTokenize(String anchor) {
        return anchor.replace("[", "_").replace("]", "_");
    }

    private String srcFor(String corePrefix, String filename) throws IOException {
        if (!this.treelines && filename.startsWith("tbl")) {
            filename = filename.contains("-open") ? "tbl-open.png" : (filename.contains("-closed") ? "tbl-closed.png" : "tbl_blank.png");
        }
        if (this.inLineGraphics) {
            if (files.containsKey(filename)) {
                return files.get(filename);
            }
            StringBuilder b = new StringBuilder();
            b.append("data:image/png;base64,");
            File file = ManagedFileAccess.file(Utilities.path(this.dest, filename));
            byte[] bytes = !file.exists() ? new byte[]{} : FileUtils.readFileToByteArray((File)file);
            b.append(new String(Base64.encodeBase64((byte[])bytes)));
            return b.toString();
        }
        return corePrefix + filename;
    }

    public static String help16AsData() throws IOException {
        ClassLoader classLoader = HierarchicalTableGenerator.class.getClassLoader();
        InputStream help = classLoader.getResourceAsStream("help16.png");
        StringBuilder b = new StringBuilder();
        b.append("data:image/png;base64,");
        byte[] bytes = FileUtilities.streamToBytes(help);
        b.append(new String(Base64.encodeBase64((byte[])bytes)));
        return b.toString();
    }

    private void checkModel(TableModel model) throws FHIRException {
        this.check(!model.getTitles().isEmpty(), "Must have titles");
        int tc = 0;
        for (Cell cell : model.getTitles()) {
            this.check(cell);
            tc += cell.span;
        }
        int i = 0;
        for (Row r : model.getRows()) {
            this.check(r, "rows", tc, "", i, model.getRows().size());
            ++i;
        }
    }

    private void check(Cell c) throws FHIRException {
        boolean hasText = false;
        for (Piece p : c.pieces) {
            if (Utilities.noString(p.getText())) continue;
            hasText = true;
        }
        this.check(hasText, "Title cells must have text");
    }

    private void check(Row r, String string, int size, String path, int index, int total) throws FHIRException {
        Object id = Integer.toString(index) + ".";
        if (total <= 26) {
            char c = (char)(97 + index);
            id = Character.toString(c);
        }
        path = (String)path + (String)id;
        r.setId((String)path);
        int tc = 0;
        for (Cell c : r.getCells()) {
            tc += c.span;
        }
        if (tc != size) {
            this.check(tc == size, "All rows must have the same number of columns as the titles  (" + Integer.toString(size) + ") but row " + (String)path + " doesn't - it has " + tc + " (" + (r.getCells().size() > 0 ? "??" : r.text()) + "): " + String.valueOf(r.getCells()));
        }
        int i = 0;
        for (Row c : r.getSubRows()) {
            this.check(c, "rows", size, (String)path, i, r.getSubRows().size());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkExists(List<Integer> indents, boolean hasChildren, int lineColor, Set<String> outputTracker) throws IOException {
        String filename = this.makeName(indents);
        StringBuilder b = new StringBuilder();
        if (this.inLineGraphics) {
            if (files.containsKey(filename)) {
                return files.get(filename);
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.genImage(indents, hasChildren, lineColor, bytes);
            b.append("data:image/png;base64,");
            byte[] encodeBase64 = Base64.encodeBase64((byte[])bytes.toByteArray());
            b.append(new String(encodeBase64));
            files.put(filename, b.toString());
            return b.toString();
        }
        if (this.treelines) {
            b.append("tbl_bck");
            for (Integer i : indents) {
                b.append(Integer.toString(i));
            }
            int indent = lineColor * 2 + (hasChildren ? 1 : 0);
            b.append(Integer.toString(indent));
            b.append(".png");
            String file = Utilities.path(this.dest, b.toString());
            if (!ManagedFileAccess.file(file).exists()) {
                File newFile = ManagedFileAccess.file(file);
                if (newFile.getParentFile() == null) {
                    throw new Error("No source directory provided. (" + file + ")");
                }
                newFile.getParentFile().mkdirs();
                newFile.createNewFile();
                try (FileOutputStream stream = ManagedFileAccess.outStream(file);){
                    this.genImage(indents, hasChildren, lineColor, stream);
                    if (outputTracker != null) {
                        outputTracker.add(file);
                    }
                }
            }
            return b.toString();
        }
        return "tbl_bck0.png";
    }

    private void genImage(List<Integer> indents, boolean hasChildren, int lineColor, OutputStream stream) throws IOException {
        BufferedImage bi = new BufferedImage(800, 2, 2);
        Color grey = new Color(99, 99, 99, 0);
        for (int i = 0; i < 800; ++i) {
            bi.setRGB(i, 0, grey.getRGB());
            bi.setRGB(i, 1, grey.getRGB());
        }
        Color black = new Color(0, 0, 0);
        Color green = new Color(14, 209, 69);
        Color gold = new Color(212, 168, 21);
        for (int i = 0; i < indents.size(); ++i) {
            int indent = indents.get(i);
            if (indent == 1) {
                bi.setRGB(12 + i * 16, 0, black.getRGB());
                continue;
            }
            if (indent == 3) {
                bi.setRGB(12 + i * 16, 0, green.getRGB());
                continue;
            }
            if (indent != 5) continue;
            bi.setRGB(12 + i * 16, 0, gold.getRGB());
        }
        if (hasChildren) {
            if (lineColor == 0) {
                bi.setRGB(12 + indents.size() * 16, 0, black.getRGB());
            } else if (lineColor == 1) {
                bi.setRGB(12 + indents.size() * 16, 0, green.getRGB());
            } else if (lineColor == 2) {
                bi.setRGB(12 + indents.size() * 16, 0, gold.getRGB());
            }
        }
        ImageIO.write((RenderedImage)bi, "PNG", stream);
    }

    private String makeName(List<Integer> indents) {
        StringBuilder b = new StringBuilder();
        b.append("indents:");
        for (Integer i : indents) {
            b.append(Integer.toString(i));
        }
        return b.toString();
    }

    private void check(boolean check, String message) throws FHIRException {
        if (!check) {
            throw new FHIRException(message);
        }
    }

    public void emptyRow(TableModel model, int cellCount) {
        Row r = new Row();
        model.rows.add(r);
        for (int i = 0; i < cellCount; ++i) {
            r.getCells().add(new Cell());
        }
    }

    public String getUniqueLocalPrefix() {
        return this.uniqueLocalPrefix;
    }

    public void setUniqueLocalPrefix(String uniqueLocalPrefix) {
        if (Utilities.noString(uniqueLocalPrefix)) {
            throw new Error("what?");
        }
        this.uniqueLocalPrefix = uniqueLocalPrefix;
    }

    public String prefixAnchor(String anchor) {
        return Utilities.noString(this.uniqueLocalPrefix) ? anchor : this.uniqueLocalPrefix + "-" + anchor;
    }

    public String prefixLocalHref(String url) {
        if (url == null || Utilities.noString(this.uniqueLocalPrefix) || !url.startsWith("#")) {
            return url;
        }
        return "#" + this.uniqueLocalPrefix + "-" + url.substring(1);
    }

    public boolean isTreelines() {
        return this.treelines;
    }

    public void setTreelines(boolean treelines) {
        this.treelines = treelines;
    }

    public static void forTesting() {
        uuid = "d5a880ec-5909-47f0-8053-be62dc5dc2b0";
    }

    public static enum TableGenerationMode {
        XML,
        XHTML;

    }

    public class TableModel {
        private String id;
        private boolean active;
        private List<Title> titles = new ArrayList<Title>();
        private List<Row> rows = new ArrayList<Row>();
        private String docoRef;
        private String docoImg;
        private boolean alternating;
        private boolean showHeadings = true;
        private boolean border = false;

        public TableModel(String id, boolean active) {
            this.id = id;
            this.active = active;
        }

        public List<Title> getTitles() {
            return this.titles;
        }

        public List<Row> getRows() {
            return this.rows;
        }

        public String getDocoRef() {
            return this.docoRef;
        }

        public String getDocoImg() {
            return this.docoImg;
        }

        public void setDocoRef(String docoRef) {
            this.docoRef = docoRef;
        }

        public void setDocoImg(String docoImg) {
            this.docoImg = docoImg;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isActive() {
            return this.active && ACTIVE_TABLES;
        }

        public boolean isAlternating() {
            return this.alternating;
        }

        public void setAlternating(boolean alternating) {
            this.alternating = alternating;
        }

        public boolean isShowHeadings() {
            return this.showHeadings;
        }

        public void setShowHeadings(boolean showHeadings) {
            this.showHeadings = showHeadings;
        }

        public boolean isBorder() {
            return this.border;
        }

        public void setBorder(boolean border) {
            this.border = border;
        }
    }

    public class Title
    extends Cell {
        private int width;
        private boolean filter;
        private Map<String, String> checkboxes;

        public Title(String prefix, String reference, String text, String hint, String suffix, int width) {
            super(prefix, reference, text, hint, suffix);
            this.checkboxes = new HashMap<String, String>();
            this.width = width;
        }

        public Title(String prefix, String reference, String text, String hint, String suffix, int width, int span) {
            super(prefix, reference, text, hint, suffix);
            this.checkboxes = new HashMap<String, String>();
            this.width = width;
            this.span = span;
        }

        @Override
        public Title setStyle(String value) {
            super.setStyle(value);
            return this;
        }

        public boolean isFilter() {
            return this.filter;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
        }

        public Map<String, String> getCheckboxes() {
            return this.checkboxes;
        }

        public void setCheckboxes(Map<String, String> checkboxes) {
            this.checkboxes = checkboxes;
        }
    }

    public class Cell {
        private List<Piece> pieces = new ArrayList<Piece>();
        private String cellStyle;
        protected int span = 1;
        private boolean innerTable;
        private TextAlignment alignment = TextAlignment.LEFT;
        private String id;

        public Cell() {
        }

        public Cell(String prefix, String reference, String text, String hint, String suffix) {
            if (!Utilities.noString(prefix)) {
                this.pieces.add(new Piece(null, prefix, null));
            }
            this.pieces.add(new Piece(reference, text, hint));
            if (!Utilities.noString(suffix)) {
                this.pieces.add(new Piece(null, suffix, null));
            }
        }

        public List<Piece> getPieces() {
            return this.pieces;
        }

        public Cell addPiece(Piece piece) {
            this.pieces.add(piece);
            return this;
        }

        public Cell addMarkdown(String md) {
            return this.addMarkdown(md, null);
        }

        public Cell addMarkdown(String md, String style) {
            if (!Utilities.noString(md)) {
                try {
                    Parser parser = Parser.builder().build();
                    Node document = parser.parse(md);
                    HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).build();
                    String html = renderer.render(document);
                    this.pieces.addAll(this.htmlToParagraphPieces(html, style));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this;
        }

        public Cell addMarkdownNoPara(String md) {
            return this.addMarkdownNoPara(md, null);
        }

        public Cell addMarkdownNoPara(String md, String style) {
            try {
                Parser parser = Parser.builder().build();
                Node document = parser.parse(md);
                HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).build();
                String html = renderer.render(document);
                this.pieces.addAll(this.htmlToParagraphPieces(html, style));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public Cell addMarkdownNoPara(String role, String md, String style) {
            try {
                Parser parser = Parser.builder().build();
                Node document = parser.parse(md);
                HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).build();
                String html = renderer.render(document);
                List<Piece> hp = this.htmlToParagraphPieces(html, style);
                while (!hp.isEmpty() && hp.get(hp.size() - 1).getTag() != null && hp.get(hp.size() - 1).getTag().equals("br")) {
                    hp.remove(hp.size() - 1);
                }
                for (Piece p : hp) {
                    p.setRole(role);
                }
                this.pieces.addAll(hp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        private List<Piece> htmlToParagraphPieces(String html, String style) {
            ArrayList<Piece> myPieces = new ArrayList<Piece>();
            try {
                XhtmlNode node = new XhtmlParser().parseFragment("<html>" + html + "</html>");
                boolean first = true;
                for (XhtmlNode c : node.getChildNodes()) {
                    if (first) {
                        first = false;
                    } else {
                        myPieces.add(new Piece("br"));
                        myPieces.add(new Piece("br"));
                    }
                    if (c.getNodeType() == NodeType.Text) {
                        if (StringUtils.isWhitespace((CharSequence)c.getContent())) continue;
                        this.addNode(myPieces, c, style);
                        continue;
                    }
                    if ("p".equals(c.getName())) {
                        for (XhtmlNode g : c.getChildNodes()) {
                            this.addNode(myPieces, g, style);
                        }
                        continue;
                    }
                    Piece x = new Piece(c.getName());
                    x.getChildren().addAll(c.getChildNodes());
                    if (style != null) {
                        x.addStyle(style);
                    }
                    myPieces.add(x);
                }
            }
            catch (Exception e) {
                throw new FHIRException("Exception parsing html: " + e.getMessage() + " for " + html, e);
            }
            return myPieces;
        }

        private List<Piece> htmlFormattingToPieces(String html) throws IOException, FHIRException {
            ArrayList<Piece> myPieces = new ArrayList<Piece>();
            if (html.contains("<")) {
                XhtmlNode node = new XhtmlParser().parseFragment("<p>" + html + "</p>");
                for (XhtmlNode c : node.getChildNodes()) {
                    this.addNode(myPieces, c, null);
                }
            } else {
                myPieces.add(new Piece(null, html, null));
            }
            return myPieces;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addNode(List<Piece> list, XhtmlNode c, String style) {
            if (c.getNodeType() == NodeType.Text) {
                list.add(this.styleIt(new Piece(null, c.getContent(), null), style));
                return;
            } else {
                if (c.getNodeType() != NodeType.Element) throw new Error("Unhandled type " + c.getNodeType().toString());
                if (c.getName().equals("a")) {
                    list.add(this.styleIt(new Piece(c.getAttribute("href"), c.allText(), c.getAttribute("title")), style));
                    return;
                } else if (c.getName().equals("b") || c.getName().equals("em") || c.getName().equals("strong")) {
                    list.add(this.styleIt(new Piece(null, c.allText(), null).setStyle("font-face: bold"), style));
                    return;
                } else if (c.getName().equals("code")) {
                    list.add(this.styleIt(new Piece(null, c.allText(), null).setStyle("padding: 2px 4px; color: #005c00; background-color: #f9f2f4; white-space: nowrap; border-radius: 4px"), style));
                    return;
                } else if (c.getName().equals("i")) {
                    list.add(this.styleIt(new Piece(null, c.allText(), null).setStyle("font-style: italic"), style));
                    return;
                } else if (c.getName().equals("pre")) {
                    Piece p = this.styleIt(new Piece(c.getName()).setStyle("white-space: pre; font-family: courier"), style);
                    list.add(p);
                    p.getChildren().addAll(c.getChildNodes());
                    return;
                } else if (c.getName().equals("ul") || c.getName().equals("ol")) {
                    Piece p = this.styleIt(new Piece(c.getName()), style);
                    list.add(p);
                    p.getChildren().addAll(c.getChildNodes());
                    return;
                } else if (c.getName().equals("i")) {
                    list.add(this.styleIt(new Piece(null, c.allText(), null).setStyle("font-style: italic"), style));
                    return;
                } else if (c.getName().equals("h1") || c.getName().equals("h2") || c.getName().equals("h3") || c.getName().equals("h4")) {
                    Piece p = this.styleIt(new Piece(c.getName()), style);
                    list.add(p);
                    p.getChildren().addAll(c.getChildNodes());
                    return;
                } else {
                    if (!c.getName().equals("br")) throw new Error("Not handled yet: " + c.getName());
                    list.add(this.styleIt(new Piece(c.getName()), style));
                }
            }
        }

        private Piece styleIt(Piece piece, String style) {
            if (style != null) {
                piece.addStyle(style);
            }
            return piece;
        }

        public Cell addStyle(String style) {
            for (Piece p : this.pieces) {
                p.addStyle(style);
            }
            return this;
        }

        public Cell addCellStyle(String style) {
            this.cellStyle = this.cellStyle == null ? style : this.cellStyle + "; " + style;
            return this;
        }

        public void addToHint(String text) {
            for (Piece p : this.pieces) {
                p.addToHint(text);
            }
        }

        public Piece addStyledText(String hint, String alt, String fgColor, String bgColor, String link, boolean border) {
            Piece p = new Piece(link, alt, hint);
            p.addStyle("padding-left: 3px");
            p.addStyle("padding-right: 3px");
            if (border) {
                p.addStyle("border: 1px grey solid");
                p.addStyle("font-weight: bold");
            }
            if (fgColor != null) {
                p.addStyle("color: " + fgColor);
                p.addStyle("background-color: " + bgColor);
            } else {
                p.addStyle("color: black");
                p.addStyle("background-color: " + bgColor != null ? bgColor : "white");
            }
            this.pieces.add(p);
            return p;
        }

        public Piece addText(String text) {
            Piece p = new Piece(null, text, null);
            this.pieces.add(p);
            return p;
        }

        public String text() {
            StringBuilder b = new StringBuilder();
            for (Piece p : this.pieces) {
                b.append(p.text);
            }
            return b.toString();
        }

        public String toString() {
            if (this.span != 1) {
                return this.text() + " {" + this.span + "}";
            }
            return this.text();
        }

        public Cell setStyle(String value) {
            this.cellStyle = value;
            return this;
        }

        public Cell span(int value) {
            this.span = value;
            return this;
        }

        public Cell center() {
            this.alignment = TextAlignment.CENTER;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Piece addImg(String icon, String hint, String link) {
            Piece p = new Piece("img");
            p.attr("src", icon);
            p.hint = hint;
            p.reference = link;
            this.pieces.add(p);
            return p;
        }

        public void addXhtml(XhtmlNode div) {
            Piece p = new Piece(null);
            this.pieces.add(p);
            p.children = div.childNodes;
        }

        public boolean isInnerTable() {
            return this.innerTable;
        }

        public void setInnerTable(boolean innerTable) {
            this.innerTable = innerTable;
        }
    }

    public class Row {
        private List<Row> subRows = new ArrayList<Row>();
        private List<Cell> cells = new ArrayList<Cell>();
        private String icon;
        private String anchor;
        private String hint;
        private String color;
        private int lineColor;
        private String id;
        private String opacity;
        private String topLine;
        private boolean partnerRow;

        public List<Row> getSubRows() {
            return this.subRows;
        }

        public List<Cell> getCells() {
            return this.cells;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon, String hint) {
            this.icon = icon;
            this.hint = hint;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public void setAnchor(String anchor) {
            this.anchor = anchor;
        }

        public String getHint() {
            return this.hint;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public int getLineColor() {
            return this.lineColor;
        }

        public void setLineColor(int lineColor) {
            assert (lineColor >= 0);
            assert (lineColor <= 2);
            this.lineColor = lineColor;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getOpacity() {
            return this.opacity;
        }

        public void setOpacity(String opacity) {
            this.opacity = opacity;
        }

        public String text() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Cell c : this.cells) {
                b.append(c.text());
            }
            return b.toString();
        }

        public String getTopLine() {
            return this.topLine;
        }

        public void setTopLine(String topLine) {
            this.topLine = topLine;
        }
    }

    private class Counter {
        private int count = -1;

        private Counter() {
        }

        private void row() {
            ++this.count;
        }

        private boolean isOdd() {
            return this.count % 2 == 1;
        }
    }

    public class Piece {
        private String tag;
        private String reference;
        private String text;
        private String hint;
        private String style;
        private String tagImg;
        private Map<String, String> attributes;
        private XhtmlNodeList children;

        public Piece(String tag) {
            this.tag = tag;
        }

        public Piece(String reference, String text, String hint) {
            this.reference = reference;
            this.text = text;
            this.hint = hint;
        }

        public Piece(String role, String tag) {
            this.tag = tag;
            this.setRole(role);
        }

        public Piece(String role, String reference, String text, String hint) {
            this.reference = reference;
            this.text = text;
            this.hint = hint;
            this.setRole(role);
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String value) {
            this.reference = value;
        }

        public String getText() {
            return this.text;
        }

        public String getHint() {
            return this.hint;
        }

        public String getTag() {
            return this.tag;
        }

        public String getStyle() {
            return this.style;
        }

        public String getRole() {
            if (this.attributes == null) {
                return null;
            }
            for (String s : this.attributes.get("class").split("\\ ")) {
                if (!KNOWN_ROLES.contains(s)) continue;
                return s;
            }
            return null;
        }

        public Piece setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Piece setText(String text) {
            this.text = text;
            return this;
        }

        public void setHint(String hint) {
            this.hint = hint;
        }

        public void setRole(String role) {
            if (!KNOWN_ROLES.contains(role)) {
                throw new Error("Unknown role " + role);
            }
            this.setClass(role);
        }

        public Piece setClass(String role) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            if (this.attributes.containsKey("class")) {
                this.attributes.put("class", this.attributes.get("class") + " " + role);
            } else {
                this.attributes.put("class", role);
            }
            return this;
        }

        public Piece setStyle(String style) {
            this.style = style;
            return this;
        }

        public Piece addStyle(String style) {
            this.style = this.style != null ? this.style + "; " + style : style;
            return this;
        }

        public void addToHint(String text) {
            this.hint = this.hint == null ? text : this.hint + (this.hint.endsWith(".") || this.hint.endsWith("?") ? " " : ". ") + text;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public XhtmlNodeList getChildren() {
            if (this.children == null) {
                this.children = new XhtmlNodeList();
            }
            return this.children;
        }

        public Piece addHtml(XhtmlNode x) {
            this.getChildren().add(x);
            return this;
        }

        public Piece attr(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, value);
            return this;
        }

        public String getTagImg() {
            return this.tagImg;
        }

        public Piece setTagImg(String tagImg) {
            this.tagImg = tagImg;
            return this;
        }

        public boolean hasAttributes() {
            return this.attributes != null && this.attributes.size() > 0;
        }
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

