/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XhtmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XhtmlUtils.class);

    public static String convertHtmlToText(String source, String desc) {
        try {
            XhtmlDocument doc = new XhtmlParser().parse(source, "html");
            return doc.getDocumentElement().allText();
        }
        catch (Exception e) {
            log.error("XHTML content could not be parsed from " + desc, (Throwable)e);
            log.error(source);
            return "Unparseable HTML";
        }
    }
}

