/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.Utilities;

public class CommaSeparatedStringBuilder {
    boolean first = true;
    String sep = ", ";
    StringBuilder b = new StringBuilder();
    int count = 0;
    String pending = null;
    private String lastSep;

    public CommaSeparatedStringBuilder() {
        this.sep = ", ";
        this.lastSep = ", ";
    }

    public CommaSeparatedStringBuilder(String sep) {
        this.sep = sep;
        this.lastSep = sep;
    }

    public CommaSeparatedStringBuilder(String sep, String lastSep) {
        this.sep = sep;
        this.lastSep = lastSep;
    }

    private void commit(boolean last) {
        if (this.pending != null) {
            if (!this.first) {
                if (last) {
                    this.b.append(this.lastSep);
                } else {
                    this.b.append(this.sep);
                }
            }
            this.b.append(this.pending);
            this.pending = null;
            this.first = false;
        }
    }

    public void append(String value) {
        this.commit(false);
        this.pending = value;
        ++this.count;
    }

    public int length() {
        this.commit(false);
        return this.b.length();
    }

    public int count() {
        return this.count;
    }

    public String toString() {
        this.commit(true);
        return this.b.toString();
    }

    public void appendIfNotNull(String s) {
        if (!Utilities.noString(s)) {
            this.append(s);
        }
    }

    public void addAll(List<String> list) {
        for (String s : list) {
            this.appendIfNotNull(s);
        }
    }

    public static String join(String sep, Collection<String> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        for (String s : list) {
            if (s == null) continue;
            b.append(s);
        }
        return b.toString();
    }

    public static String join2(String sep, String finalSep, Collection<String> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep, finalSep);
        for (String s : list) {
            if (s == null) continue;
            b.append(s);
        }
        return b.toString();
    }

    public static String joinToLimit(String sep, int limit, String overflow, Collection<String> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        int i = 0;
        for (String s : list) {
            if (s == null) continue;
            if (++i == limit) {
                b.append(overflow);
                break;
            }
            b.append(s);
        }
        return b.toString();
    }

    public static String join(String sep, String[] list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        for (String s : list) {
            b.append(s);
        }
        return b.toString();
    }

    public static String build(List<String> list) {
        CommaSeparatedStringBuilder self = new CommaSeparatedStringBuilder();
        for (String s : list) {
            self.append(s);
        }
        return self.toString();
    }

    public static String buildObjects(List<? extends Object> list) {
        CommaSeparatedStringBuilder self = new CommaSeparatedStringBuilder();
        for (Object object : list) {
            self.append(object.toString());
        }
        return self.toString();
    }

    public static Set<String> toSet(String source) {
        if (source == null) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        if (!Utilities.noString(source)) {
            for (String s : source.split("\\,")) {
                res.add(s.trim());
            }
        }
        return res;
    }

    public static String joinWrapped(String sep, String leftWrap, String rightWrap, Collection<String> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        for (String s : list) {
            if (s == null) continue;
            b.append(leftWrap + s + rightWrap);
        }
        return b.toString();
    }

    public static String join(String sep, EnumSet<? extends Enum> set) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        for (Enum enum_ : set) {
            b.append(enum_.toString());
        }
        return b.toString();
    }
}

