/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileNotifier;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.CSFile;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class FileUtilities {
    public static String bytesToString(byte[] bs) throws IOException {
        return new String(bs, StandardCharsets.UTF_8);
    }

    public static String bytesToString(byte[] bs, boolean removeBOM) throws IOException {
        String read = new String(bs, StandardCharsets.UTF_8);
        if (removeBOM) {
            return read.replace("\ufeff", "");
        }
        return read;
    }

    public static void bytesToFile(byte[] bytes, String path) throws IOException {
        try (FileOutputStream sw = ManagedFileAccess.outStream(ManagedFileAccess.csfile(path));){
            ((OutputStream)sw).write(bytes);
        }
    }

    public static void bytesToFile(byte[] bytes, File f) throws IOException {
        try (FileOutputStream sw = ManagedFileAccess.outStream(f);){
            ((OutputStream)sw).write(bytes);
        }
    }

    public static void appendBytesToFile(byte[] bytes, String path) throws IOException {
        byte[] linebreak = new byte[]{13, 10};
        Files.write(Paths.get(path, new String[0]), linebreak, StandardOpenOption.APPEND);
        Files.write(Paths.get(path, new String[0]), bytes, StandardOpenOption.APPEND);
    }

    public static void stringToStream(String content, OutputStream stream) throws IOException {
        stream.write(content.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] stringToBytes(String content) throws IOException {
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static void stringToFile(String content, String path) throws IOException {
        CSFile file = ManagedFileAccess.csfile(path);
        FileUtilities.stringToFile(content, file);
    }

    public static void stringToFile(String content, File file) throws IOException {
        try (OutputStream output = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            output.write(content.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void stringToFileWithBOM(String content, File file) throws IOException {
        try (OutputStream output = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            output.write(new byte[]{-17, -69, -65});
            output.write(content.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void stringToFileWithBOM(String content, String path) throws IOException {
        CSFile file = ManagedFileAccess.csfile(path);
        FileUtilities.stringToFileWithBOM(content, file);
    }

    public static String fileToString(File f) throws FileNotFoundException, IOException {
        return new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
    }

    public static String fileToString(String src) throws FileNotFoundException, IOException {
        CSFile f = ManagedFileAccess.csfile(src);
        if (!f.exists()) {
            throw new IOException("File " + src + " not found");
        }
        return FileUtilities.fileToString(f);
    }

    public static byte[] fileToBytes(String srcFile) throws FileNotFoundException, IOException {
        CSFile f = ManagedFileAccess.csfile(srcFile);
        return Files.readAllBytes(f.toPath());
    }

    public static byte[] fileToBytes(File file) throws FileNotFoundException, IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static byte[] fileToBytesNCS(String srcFile) throws FileNotFoundException, IOException {
        return Files.readAllBytes(Path.of(srcFile, new String[0]));
    }

    public static List<String> fileToLines(String file) throws FileNotFoundException, IOException {
        Pattern LINE_SEP_PATTERN = Pattern.compile("\\R");
        ArrayList<String> res = new ArrayList<String>();
        for (String s : LINE_SEP_PATTERN.split(FileUtilities.fileToString(file))) {
            res.add(s);
        }
        return res;
    }

    public static String[] fileToLines(File file) throws FileNotFoundException, IOException {
        Pattern LINE_SEP_PATTERN = Pattern.compile("\\R");
        return LINE_SEP_PATTERN.split(FileUtilities.fileToString(file));
    }

    public static String[] streamToLines(InputStream stream) throws FileNotFoundException, IOException {
        Pattern LINE_SEP_PATTERN = Pattern.compile("\\R");
        return LINE_SEP_PATTERN.split(FileUtilities.streamToString(stream));
    }

    public static String streamToString(InputStream input) throws IOException {
        return new String(input.readAllBytes(), StandardCharsets.UTF_8).replace("\ufeff", "");
    }

    public static byte[] streamToBytes(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        byte[] read = input.readAllBytes();
        input.close();
        return read;
    }

    public static byte[] streamToBytesNoClose(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        return input.readAllBytes();
    }

    public static void streamToFile(InputStream stream, String filename) throws IOException {
        Files.copy(stream, Path.of(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        stream.close();
    }

    public static void streamToFileNoClose(InputStream stream, String filename) throws IOException {
        Files.copy(stream, Path.of(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void linesToFile(File f, String[] lines) throws IOException {
        Files.write(f.toPath(), List.of(lines), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void linesToFile(String path, String[] lines) throws IOException {
        CSFile file = ManagedFileAccess.csfile(path);
        Files.write(file.toPath(), List.of(lines), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void linesToFile(String path, List<String> lines) throws IOException {
        CSFile file = ManagedFileAccess.csfile(path);
        Files.write(file.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static String fileTitle(String file) throws IOException {
        if (file == null) {
            return null;
        }
        String s = ManagedFileAccess.file(file).getName();
        return s.indexOf(".") == -1 ? s : s.substring(0, s.indexOf("."));
    }

    public static String getDirectoryForFile(String filepath) throws IOException {
        File f = ManagedFileAccess.file(filepath);
        return f.getParent();
    }

    public static String getDirectoryForFile(File file) throws IOException {
        return file.getParent();
    }

    public static String getRelativePath(String root, String path) {
        String res = path.substring(root.length());
        if (res.startsWith(File.separator)) {
            res = res.substring(1);
        }
        return res;
    }

    public static File createDirectory(String path) throws IOException {
        ManagedFileAccess.csfile(path).mkdirs();
        return ManagedFileAccess.file(path);
    }

    public static File createDirectoryNC(String path) throws IOException {
        ManagedFileAccess.file(path).mkdirs();
        return ManagedFileAccess.file(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            if (!ManagedFileAccess.csfile(destFile.getParent()).exists()) {
                FileUtilities.createDirectory(destFile.getParent());
            }
            destFile.createNewFile();
        } else if (!destFile.getCanonicalFile().getName().equals(destFile.getName())) {
            destFile.delete();
            destFile.createNewFile();
        }
        FileInputStream source = null;
        FileOutputStream destination = null;
        try {
            source = ManagedFileAccess.inStream(sourceFile);
            destination = ManagedFileAccess.outStream(destFile);
            destination.getChannel().transferFrom(source.getChannel(), 0L, source.getChannel().size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void copyFile(String source, String dest) throws IOException {
        FileUtilities.copyFile(ManagedFileAccess.file(source), ManagedFileAccess.file(dest));
    }

    public static void copyDirectory(String sourceFolder, String destFolder, FileNotifier notifier) throws IOException, FHIRException {
        String[] files;
        CSFile src = ManagedFileAccess.csfile(sourceFolder);
        if (!src.exists()) {
            throw new FHIRException("Folder " + sourceFolder + " not found");
        }
        File dst = ManagedFileAccess.file(destFolder);
        if (!dst.getCanonicalFile().getName().equals(dst.getName())) {
            File tmp = ManagedFileAccess.file(destFolder + System.currentTimeMillis());
            if (!dst.renameTo(tmp)) {
                throw new IOException("fixing case from " + dst.getCanonicalFile().getName() + " to " + tmp.getName() + " failed");
            }
            if (!tmp.renameTo(dst)) {
                throw new IOException("fixing case from " + tmp.getCanonicalFile().getName() + " to " + dst.getName() + " failed");
            }
        } else if (!dst.exists()) {
            FileUtilities.createDirectory(destFolder);
        }
        for (String f : files = src.list()) {
            if (ManagedFileAccess.csfile(sourceFolder + File.separator + f).isDirectory()) {
                if (f.startsWith(".")) continue;
                FileUtilities.copyDirectory(sourceFolder + File.separator + f, destFolder + File.separator + f, notifier);
                continue;
            }
            if (notifier != null) {
                notifier.copyFile(sourceFolder + File.separator + f, destFolder + File.separator + f);
            }
            FileUtilities.copyFile(ManagedFileAccess.csfile(sourceFolder + File.separator + f), new File(destFolder + File.separator + f));
        }
    }

    public static void copyDirectory2(String sourceFolder, String destFolder, FileNotifier.FileNotifier2 notifier) throws IOException, FHIRException {
        String[] files;
        CSFile src = ManagedFileAccess.csfile(sourceFolder);
        if (!src.exists()) {
            throw new FHIRException("Folder " + sourceFolder + " not found");
        }
        FileUtilities.createDirectory(destFolder);
        for (String f : files = src.list()) {
            boolean doCopy;
            if (ManagedFileAccess.csfile(sourceFolder + File.separator + f).isDirectory()) {
                if (f.startsWith(".")) continue;
                boolean bl = doCopy = notifier != null ? notifier.copyFolder(sourceFolder + File.separator + f, destFolder + File.separator + f) : true;
                if (!doCopy) continue;
                FileUtilities.copyDirectory2(sourceFolder + File.separator + f, destFolder + File.separator + f, notifier);
                continue;
            }
            boolean bl = doCopy = notifier != null ? notifier.copyFile(sourceFolder + File.separator + f, destFolder + File.separator + f) : true;
            if (!doCopy) continue;
            FileUtilities.copyFile(ManagedFileAccess.csfile(sourceFolder + File.separator + f), ManagedFileAccess.csfile(destFolder + File.separator + f));
        }
    }

    public static void copyFileToDirectory(File source, File destDir) throws IOException {
        FileUtilities.copyFile(source, ManagedFileAccess.file(Utilities.path(destDir.getAbsolutePath(), source.getName())));
    }

    public static void renameDirectory(String source, String dest) throws FHIRException, IOException {
        File dst;
        File src = ManagedFileAccess.file(source);
        if (!src.renameTo(dst = ManagedFileAccess.file(dest))) {
            int i = 0;
            do {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.gc();
            } while (!src.renameTo(dst) && ++i < 10);
            if (src.exists()) {
                FileUtilities.copyDirectory(source, dest, null);
                try {
                    src.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static List<String> listAllFiles(String path, List<String> ignoreList) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        FileUtilities.scanForFiles(res, path, ManagedFileAccess.file(path), ignoreList);
        return res;
    }

    private static void scanForFiles(List<String> res, String root, File dir, List<String> ignoreList) {
        for (File f : dir.listFiles()) {
            if (ignoreList != null && ignoreList.contains(f.getAbsolutePath())) continue;
            if (f.isDirectory()) {
                FileUtilities.scanForFiles(res, root, f, ignoreList);
                continue;
            }
            if (f.getName().equals(".DS_Store")) continue;
            res.add(FileUtilities.getRelativePath(root, f.getAbsolutePath()));
        }
    }

    public static void atomicDeleteDirectory(String path) throws IOException {
        String tempDirectoryPath;
        File tempDirectory;
        File directory = ManagedFileAccess.file(path);
        if (!directory.renameTo(tempDirectory = ManagedFileAccess.file(tempDirectoryPath = Utilities.generateUniqueRandomUUIDPath(directory.getParent())))) {
            throw new IOException("Unable to rename directory " + path + " to " + String.valueOf(tempDirectory) + " for atomic delete");
        }
        FileUtilities.clearDirectory(tempDirectory.getAbsolutePath(), new String[0]);
        if (!tempDirectory.delete()) {
            throw new IOException("Unable to delete temp directory " + String.valueOf(tempDirectory) + " when atomically deleting " + path);
        }
    }

    public static void visitFiles(String folder, String extension, FileVisitor visitor) throws FileNotFoundException, IOException {
        FileUtilities.visitFiles(ManagedFileAccess.file(folder), extension, visitor);
    }

    public static void visitFiles(File folder, String extension, FileVisitor visitor) throws FileNotFoundException, IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                FileUtilities.visitFiles(file, extension, visitor);
                continue;
            }
            if (extension != null && !file.getName().endsWith(extension)) continue;
            visitor.visitFile(file);
        }
    }

    public static int countFilesInDirectory(String dirName) throws IOException {
        File dir = ManagedFileAccess.file(dirName);
        if (!dir.exists()) {
            return 0;
        }
        int i = 0;
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) continue;
            ++i;
        }
        return i;
    }

    public static boolean checkFileExists(String purpose, String dir, String file, List<String> errors) throws IOException {
        if (!ManagedFileAccess.csfile(dir + file).exists()) {
            if (errors != null) {
                errors.add("Unable to find " + purpose + " file " + file + " in " + dir);
            }
            return false;
        }
        return true;
    }

    public static boolean checkFolderExists(String dir, List<String> errors) throws IOException {
        if (!ManagedFileAccess.csfile(dir).exists()) {
            errors.add("Unable to find directory " + dir);
            return false;
        }
        return true;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile("ohfu-" + prefix, suffix);
        file.deleteOnExit();
        return file;
    }

    public static void deleteTempFiles() throws IOException {
        File file = FileUtilities.createTempFile("test", "test");
        String folder = FileUtilities.getDirectoryForFile(file.getAbsolutePath());
        String[] list = ManagedFileAccess.file(folder).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ohfu-");
            }
        });
        if (list != null) {
            for (String n : list) {
                ManagedFileAccess.file(Utilities.path(folder, n)).delete();
            }
        }
    }

    public static void clearDirectory(String folder, String ... exemptions) throws IOException {
        File dir = ManagedFileAccess.file(folder);
        if (dir.exists()) {
            if (exemptions.length == 0) {
                FileUtils.cleanDirectory((File)dir);
            } else {
                String[] files = ManagedFileAccess.csfile(folder).list();
                if (files != null) {
                    for (String f : files) {
                        if (Utilities.existsInList(f, exemptions)) continue;
                        CSFile fh = ManagedFileAccess.csfile(folder + File.separatorChar + f);
                        if (fh.isDirectory()) {
                            FileUtilities.clearDirectory(fh.getAbsolutePath(), new String[0]);
                        }
                        fh.delete();
                    }
                }
            }
        }
    }

    public static void deleteAllFiles(String folder, String type) throws IOException {
        String[] files;
        File src = ManagedFileAccess.file(folder);
        for (String f : files = src.list()) {
            if (ManagedFileAccess.file(folder + File.separator + f).isDirectory()) {
                FileUtilities.deleteAllFiles(folder + File.separator + f, type);
                continue;
            }
            if (!f.endsWith(type)) continue;
            ManagedFileAccess.file(folder + File.separator + f).delete();
        }
    }

    public static String changeFileExt(String name, String ext) {
        if (name.lastIndexOf(46) > -1) {
            return name.substring(0, name.lastIndexOf(46)) + ext;
        }
        return name + ext;
    }

    public static boolean isIgnorableFile(File file) {
        return Utilities.existsInList(file.getName(), ".DS_Store");
    }

    public static void deleteEmptyFolders(File df) {
        for (File f : df.listFiles()) {
            if (!f.isDirectory()) continue;
            FileUtilities.deleteEmptyFolders(f);
        }
        boolean empty = true;
        int n = 0;
        File[] fileArray = df.listFiles();
        int n2 = fileArray.length;
        if (n < n2) {
            File f = fileArray[n];
            empty = false;
        }
        if (empty) {
            df.delete();
        }
    }

    public static String cleanFileName(String badFileName) {
        StringBuilder cleanName = new StringBuilder();
        int len = badFileName.codePointCount(0, badFileName.length());
        for (int i = 0; i < len; ++i) {
            int c = badFileName.codePointAt(i);
            if (Arrays.binarySearch(Utilities.illegalChars, c) >= 0) continue;
            cleanName.appendCodePoint(c);
        }
        return cleanName.toString();
    }

    public static void copyFiles(String source, String dest, String ... extensions) throws IOException {
        for (File f : new File(source).listFiles()) {
            boolean copy = false;
            for (String e : extensions) {
                if (!f.getName().endsWith(e)) continue;
                copy = true;
            }
            if (!copy) continue;
            FileUtilities.copyFile(f.getAbsolutePath(), Utilities.path(dest, f.getName()));
        }
    }

    public static boolean isEmptyDirectory(File dst) {
        File[] files = dst.listFiles();
        return files == null || files.length == 0;
    }

    public static interface FileVisitor {
        public void visitFile(File var1) throws FileNotFoundException, IOException;
    }
}

