/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;

public class OIDUtilities {
    private static final String OID_REGEX = "[0-2](\\.(0|[1-9][0-9]*))+";
    private final Map<String, OIDInfo> oidMap = new HashMap<String, OIDInfo>();

    public OIDUtilities() {
        this.loadOIDsFromCSV();
    }

    private void loadOIDsFromCSV() throws FHIRException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("oidregistry.csv");
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            boolean isHeaderProcessed = false;
            while ((line = reader.readLine()) != null) {
                if (!isHeaderProcessed) {
                    isHeaderProcessed = true;
                    continue;
                }
                String[] parts = line.split(",");
                if (parts.length < 4) continue;
                OIDInfo info = new OIDInfo();
                info.setOid(parts[0].trim());
                info.setType(Integer.parseInt(parts[1].trim()));
                info.setName(parts[2].trim());
                info.setCodeSystem(parts[3].trim());
                this.oidMap.put(info.getOid(), info);
            }
        }
        catch (Exception e) {
            throw new FHIRException(e);
        }
    }

    public static String getUriForOid(String r) {
        if (r == null) {
            return null;
        }
        if (r.equals("2.16.840.1.113883.6.96")) {
            return "http://snomed.info/sct";
        }
        if (r.equals("2.16.840.1.113883.6.1")) {
            return "http://loinc.org";
        }
        if (r.equals("2.16.840.1.113883.6.8")) {
            return "http://unitsofmeasure.org";
        }
        if (r.equals("2.16.840.1.113883.6.3")) {
            return "http://hl7.org/fhir/sid/icd-10";
        }
        if (r.equals("2.16.840.1.113883.6.42")) {
            return "http://hl7.org/fhir/sid/icd-9";
        }
        if (r.equals("2.16.840.1.113883.6.104")) {
            return "http://hl7.org/fhir/sid/icd-9";
        }
        if (r.equals("2.16.840.1.113883.6.103")) {
            return "http://hl7.org/fhir/sid/icd-9";
        }
        if (r.equals("2.16.840.1.113883.6.73")) {
            return "http://www.whocc.no/atc";
        }
        if (r.equals("2.16.840.1.113883.3.26.1.1")) {
            return "http://ncimeta.nci.nih.gov";
        }
        if (r.equals("2.16.840.1.113883.3.26.1.1.1")) {
            return "http://ncimeta.nci.nih.gov";
        }
        if (r.equals("2.16.840.1.113883.6.88")) {
            return "http://www.nlm.nih.gov/research/umls/rxnorm";
        }
        if (r.equals("2.16.840.1.113883.6.59")) {
            return "http://hl7.org/fhir/sid/cvx";
        }
        if (r.equals("2.16.840.1.113883.12.292")) {
            return "http://hl7.org/fhir/sid/cvx";
        }
        if (r.equals("2.16.840.1.113883.6.12")) {
            return "http://www.ama-assn.org/go/cpt";
        }
        return null;
    }

    public static String oidTail(String id) {
        if (id == null || !id.contains(".")) {
            return id;
        }
        return id.substring(id.lastIndexOf(".") + 1);
    }

    public static String oidRoot(String id) {
        if (id == null || !id.contains(".")) {
            return id;
        }
        return id.substring(0, id.indexOf("."));
    }

    public static boolean isValidOID(String oid) {
        return oid.matches(OID_REGEX);
    }

    public boolean isKnownOID(String url) {
        if (url == null || !url.startsWith("urn:oid:")) {
            return false;
        }
        return this.oidMap.containsKey(url.substring(8));
    }

    public static class OIDInfo {
        private String oid;
        private String name;
        private String codeSystem;
        private Integer type;

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCodeSystem() {
            return this.codeSystem;
        }

        public void setCodeSystem(String codeSystem) {
            this.codeSystem = codeSystem;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String toString() {
            return "OID: " + this.oid + ", Name: " + this.name + ", CodeSystem: " + this.codeSystem + ", Type: " + this.type;
        }
    }
}

