/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

public class SourceLocation {
    private int line;
    private int column;

    public SourceLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public String toString() {
        return Integer.toString(this.line) + ", " + Integer.toString(this.column);
    }

    public void newLine() {
        this.setLine(this.getLine() + 1);
        this.setColumn(1);
    }

    public boolean checkChar(char ch, boolean last13) {
        if (ch == '\r') {
            this.newLine();
            return true;
        }
        if (ch == '\n') {
            if (!last13) {
                this.newLine();
            }
            return false;
        }
        this.setColumn(this.getColumn() + 1);
        return false;
    }

    public SourceLocation copy() {
        return new SourceLocation(this.line, this.column);
    }

    public void incColumn() {
        this.incColumn(1);
    }

    public void incColumn(int i) {
        this.column += i;
    }
}

