/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.utilities.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(ca.uhn.fhir.util.VersionUtil.class);
    private static String ourVersion;
    private static String ourBuildNumber;
    private static String ourBuildTime;

    public static String getBuildNumber() {
        return ourBuildNumber;
    }

    public static String getBuildTime() {
        return ourBuildTime;
    }

    public static String getVersion() {
        return ourVersion;
    }

    private static void initialize() {
        try (InputStream is = ca.uhn.fhir.util.VersionUtil.class.getResourceAsStream("/fhir-build.properties");){
            Properties p = new Properties();
            if (is != null) {
                p.load(is);
            }
            ourVersion = p.getProperty("orgfhir.version");
            ourVersion = (String)StringUtils.defaultIfBlank((CharSequence)ourVersion, (CharSequence)"(unknown)");
            ourBuildNumber = p.getProperty("orgfhir.buildnumber");
            ourBuildTime = p.getProperty("orgfhir.timestamp");
        }
        catch (Exception e) {
            ourLog.warn("Unable to determine version information", (Throwable)e);
        }
    }

    public static String getVersionString() {
        return "Version " + VersionUtil.getVersion() + " (Git# " + StringUtils.left((String)VersionUtil.getBuildNumber(), (int)12) + "). Built " + VersionUtil.getBuildTime() + " (" + VersionUtil.getDurationSinceBuild() + ")";
    }

    private static String getDurationSinceBuild() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date dt = sdf.parse(ourBuildTime.substring(0, 19));
            return Utilities.describeDuration(Duration.ofMillis(new Date().getTime() - dt.getTime())) + " old";
        }
        catch (Exception e) {
            return "??";
        }
    }

    public static String getBaseVersion() {
        String ver = VersionUtil.getVersion();
        return ver.contains("-") ? ver.substring(0, ver.indexOf("-")) : ver;
    }

    static {
        VersionUtil.initialize();
    }
}

