/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.SemverParser;
import org.hl7.fhir.utilities.Utilities;

public class VersionUtilities {
    public static final String[] SUPPORTED_MAJOR_VERSIONS = new String[]{"1.0", "1.4", "3.0", "4.0", "5.0", "6.0"};
    public static final String[] SUPPORTED_VERSIONS = new String[]{"1.0.2", "1.4.0", "3.0.2", "4.0.1", "4.1.0", "4.3.0", "5.0.0", "6.0.0"};

    @Nonnull
    public static String packageForVersion(@Nonnull String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return "hl7.fhir.r2.core";
        }
        if (VersionUtilities.isR2BVer(v)) {
            return "hl7.fhir.r2b.core";
        }
        if (VersionUtilities.isR3Ver(v)) {
            return "hl7.fhir.r3.core";
        }
        if (VersionUtilities.isR4Ver(v)) {
            return "hl7.fhir.r4.core";
        }
        if (VersionUtilities.isR4BVer(v)) {
            return "hl7.fhir.r4b.core";
        }
        if (VersionUtilities.isR5Ver(v)) {
            return "hl7.fhir.r5.core";
        }
        if (VersionUtilities.isR6Ver(v)) {
            return "hl7.fhir.r6.core";
        }
        if ("current".equals(v)) {
            return "hl7.fhir.r5.core";
        }
        return null;
    }

    public static String getCurrentVersion(String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return "1.0.2";
        }
        if (VersionUtilities.isR2BVer(v)) {
            return "1.4.0";
        }
        if (VersionUtilities.isR3Ver(v)) {
            return "3.0.2";
        }
        if (VersionUtilities.isR4Ver(v)) {
            return "4.0.1";
        }
        if (VersionUtilities.isR5Ver(v)) {
            return "5.0.0";
        }
        if (VersionUtilities.isR6Ver(v)) {
            return "6.0.0";
        }
        return v;
    }

    public static String getCurrentPackageVersion(String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return "1.0";
        }
        if (VersionUtilities.isR2BVer(v)) {
            return "1.4";
        }
        if (VersionUtilities.isR3Ver(v)) {
            return "3.0";
        }
        if (VersionUtilities.isR4Ver(v)) {
            return "4.0";
        }
        if (VersionUtilities.isR5Ver(v)) {
            return "5.0";
        }
        if (VersionUtilities.isR6Ver(v)) {
            return "6.0";
        }
        return v;
    }

    public static boolean isSupportedVersion(@Nonnull String version) {
        version = VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.removeLabels(VersionUtilities.fixForSpecialValue(version)));
        return Utilities.existsInList(version, SUPPORTED_VERSIONS);
    }

    public static String listSupportedVersions() {
        return VersionUtilities.listVersions(SUPPORTED_VERSIONS);
    }

    public static String listSupportedMajorVersions() {
        return VersionUtilities.listVersions(SUPPORTED_MAJOR_VERSIONS);
    }

    private static String listVersions(String[] versions) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String supportedVersion : versions) {
            stringJoiner.add(supportedVersion);
        }
        return stringJoiner.toString();
    }

    public static boolean isR6Plus(String version) {
        return VersionUtilities.isR6Ver(version);
    }

    public static boolean isR6Ver(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && version.startsWith("6.0");
    }

    public static boolean isR5Plus(String version) {
        return VersionUtilities.isR5Ver(version) || VersionUtilities.isR6Plus(version);
    }

    public static boolean isR5Ver(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && (version.startsWith("4.5") || version.startsWith("5.0"));
    }

    public static boolean isR4BVer(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && (version.startsWith("4.1") || version.startsWith("4.3"));
    }

    public static boolean isR4Ver(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && (version.startsWith("4.0") || version.startsWith("3.2") || version.startsWith("3.3") || version.startsWith("3.5") || version.startsWith("3.5a"));
    }

    public static boolean isR4Plus(String version) {
        return VersionUtilities.isR4Ver(version) || VersionUtilities.isR4BVer(version) || VersionUtilities.isR5Plus(version);
    }

    public static boolean isR3Ver(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && version.startsWith("3.0");
    }

    public static boolean isR2BVer(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && version.startsWith("1.4");
    }

    public static boolean isR2Ver(@Nonnull String version) {
        return (version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValidWildcards(VersionUtilities.fixForSpecialValue(version)))) != null && version.startsWith("1.0");
    }

    public static boolean isCorePackage(@Nonnull String s) {
        if (s == null) {
            return false;
        }
        if (s.contains("#")) {
            s = s.substring(0, s.indexOf("#"));
        }
        return Utilities.existsInList(s, "hl7.fhir.core", "hl7.fhir.r2.core", "hl7.fhir.r2b.core", "hl7.fhir.r3.core", "hl7.fhir.r4.core", "hl7.fhir.r4b.core", "hl7.fhir.r5.core", "hl7.fhir.r6.core");
    }

    @Nullable
    public static String versionWithoutLabels(@Nullable String version) {
        version = VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(version));
        return VersionUtilities.removeLabels(version);
    }

    @Nullable
    public static String getMajMin(@Nullable String version) {
        if ((version = VersionUtilities.removeLabels(VersionUtilities.fixForSpecialValue(version))) == null) {
            return null;
        }
        if (!VersionUtilities.isSemVer(version)) {
            return null;
        }
        return VersionUtilities.getMajMinPriv(version);
    }

    private static String getMajMinPriv(String version) {
        String[] p = version.split("\\.");
        return p[0] + "." + p[1];
    }

    public static String getMajMinPatch(@Nullable String version) {
        if ((version = VersionUtilities.removeLabels(VersionUtilities.fixForSpecialValue(version))) == null) {
            return null;
        }
        if (!VersionUtilities.isSemVer(version)) {
            return null;
        }
        String[] p = version.split("\\.");
        return p[0] + "." + p[1] + (String)(p.length >= 3 ? "." + p[2] : ".0");
    }

    public static String getPatch(@Nullable String version) {
        if ((version = VersionUtilities.removeLabels(VersionUtilities.checkVersionValid(VersionUtilities.fixForSpecialValue(version)))) == null) {
            return null;
        }
        return VersionUtilities.getPatchPriv(version);
    }

    private static String getPatchPriv(String version) {
        String[] p = version.split("\\.");
        return p.length >= 3 ? p[2] : "0";
    }

    public static boolean isSemVer(@Nullable String version) {
        if (Utilities.noString(version)) {
            return false;
        }
        SemverParser.ParseResult pr = SemverParser.parseSemver(version, false, false);
        if (!pr.isSuccess()) {
            return false;
        }
        return Utilities.isInteger(pr.getMajor()) && Utilities.isInteger(pr.getMinor()) && (pr.getPatch() == null || Utilities.isInteger(pr.getPatch()));
    }

    public static boolean isSemVerWithWildcards(@Nullable String version) {
        if (Utilities.noString(version)) {
            return false;
        }
        SemverParser.ParseResult pr = SemverParser.parseSemver(version, true, false);
        if (!pr.isSuccess()) {
            return false;
        }
        return Utilities.isInteger(pr.getMajor()) && VersionUtilities.isIntegerOrX(pr.getMinor()) && (pr.getPatch() == null || VersionUtilities.isIntegerOrX(pr.getPatch()));
    }

    private static boolean isIntegerOrX(String p) {
        return Utilities.existsInList(p, "x", "*", "X") || Utilities.isInteger(p);
    }

    public static boolean versionHasWildcards(@Nullable String version) {
        if (Utilities.noString(version)) {
            return false;
        }
        if (version.endsWith("?")) {
            return true;
        }
        if (version.contains("*")) {
            return true;
        }
        String versionPart = version;
        int dashIndex = version.indexOf(45);
        int plusIndex = version.indexOf(43);
        if (dashIndex >= 0 && plusIndex >= 0) {
            versionPart = version.substring(0, Math.min(dashIndex, plusIndex));
        } else if (dashIndex >= 0) {
            versionPart = version.substring(0, dashIndex);
        } else if (plusIndex >= 0) {
            versionPart = version.substring(0, plusIndex);
        }
        return versionPart.contains("x") || versionPart.contains("X");
    }

    public static boolean isThisOrLater(@Nonnull String criteria, @Nonnull String candidate, VersionPrecision precision) {
        SemverParser.ParseResult parsedCriteria;
        criteria = VersionUtilities.checkVersionNotNullAndValidWildcards(VersionUtilities.fixForSpecialValue(criteria), "criteria");
        candidate = VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(candidate), "candidate");
        boolean endsWithQ = false;
        if (criteria.endsWith("?")) {
            endsWithQ = true;
            criteria = criteria.substring(0, criteria.length() - 1);
        }
        if (!(parsedCriteria = SemverParser.parseSemver(criteria, true, false)).isSuccess()) {
            throw new FHIRException("Invalid criteria: " + criteria + ": (" + parsedCriteria.getError() + ")");
        }
        SemverParser.ParseResult parsedCandidate = SemverParser.parseSemver(candidate, false, false);
        if (!parsedCandidate.isSuccess()) {
            throw new FHIRException("Invalid candidate: " + candidate + " (" + parsedCandidate.getError() + ")");
        }
        int thisOrLater = VersionUtilities.partIsThisOrLater(parsedCriteria.getMajor(), parsedCandidate.getMajor(), true);
        if (thisOrLater != 0) {
            return thisOrLater < 0;
        }
        if (endsWithQ && parsedCriteria.getMinor() == null) {
            return true;
        }
        if (precision == VersionPrecision.MAJOR) {
            return true;
        }
        thisOrLater = VersionUtilities.partIsThisOrLater(parsedCriteria.getMinor(), parsedCandidate.getMinor(), true);
        if (thisOrLater != 0) {
            return thisOrLater < 0;
        }
        if (endsWithQ && parsedCriteria.getPatch() == null) {
            return true;
        }
        if (precision == VersionPrecision.MINOR) {
            return true;
        }
        thisOrLater = VersionUtilities.partIsThisOrLater(parsedCriteria.getPatch(), parsedCandidate.getPatch(), true);
        if (thisOrLater != 0) {
            return thisOrLater < 0;
        }
        if (precision == VersionPrecision.PATCH) {
            return true;
        }
        if (endsWithQ && parsedCriteria.getReleaseLabel() == null && parsedCriteria.getBuild() == null) {
            return true;
        }
        thisOrLater = VersionUtilities.partIsThisOrLater(parsedCriteria.getReleaseLabel(), parsedCandidate.getReleaseLabel(), false);
        if (thisOrLater != 0) {
            return thisOrLater < 0;
        }
        thisOrLater = VersionUtilities.partIsThisOrLater(parsedCriteria.getBuild(), parsedCandidate.getBuild(), false);
        if (thisOrLater != 0) {
            return thisOrLater < 0;
        }
        return true;
    }

    private static boolean compareVersionPart(String theTestPart, String theCurrentPart) {
        if (StringUtils.isNumeric((CharSequence)theTestPart) && StringUtils.isNumeric((CharSequence)theCurrentPart)) {
            return Integer.parseInt(theCurrentPart) - Integer.parseInt(theTestPart) >= 0;
        }
        return theCurrentPart.compareTo(theTestPart) >= 0;
    }

    private static int compareVersionPartInt(String theTestPart, String theCurrentPart) {
        if (StringUtils.isNumeric((CharSequence)theTestPart) && StringUtils.isNumeric((CharSequence)theCurrentPart)) {
            return Integer.parseInt(theCurrentPart) - Integer.parseInt(theTestPart);
        }
        return theCurrentPart.compareTo(theTestPart);
    }

    private static String getLabelPart(String s) {
        if (Utilities.noString(s)) {
            return null;
        }
        int p = s.indexOf("+");
        int m = s.indexOf("-");
        if (p >= 0 && m >= 0) {
            int e = Integer.min(p, m);
            return s.substring(e + 1);
        }
        if (p >= 0) {
            return s.substring(p + 1);
        }
        if (m >= 0) {
            return s.substring(m + 1);
        }
        return null;
    }

    public static String incMajorVersion(String v) {
        v = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(v)));
        int[] parts = VersionUtilities.splitParts(VersionUtilities.removeLabels(v));
        return Integer.toString(parts[0] + 1) + ".0.0";
    }

    @Nonnull
    public static String incMinorVersion(@Nonnull String v) {
        v = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(v)));
        int[] parts = VersionUtilities.splitParts(VersionUtilities.removeLabels(v));
        return Integer.toString(parts[0]) + "." + (String)(parts.length == 1 ? "0.0" : Integer.toString(parts[1] + 1) + ".0");
    }

    @Nonnull
    public static String incPatchVersion(@Nonnull String v) {
        v = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(v)));
        int[] parts = VersionUtilities.splitParts(v);
        return Integer.toString(parts[0]) + "." + (parts.length < 2 ? "0" : Integer.toString(parts[1])) + "." + (parts.length < 3 ? "1" : Integer.toString(parts[2] + 1));
    }

    private static int[] splitParts(String v) {
        String[] p = v.split("\\.");
        return Arrays.stream(p).mapToInt(Integer::parseInt).toArray();
    }

    public static String versionFromCode(String version) {
        return VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(version));
    }

    public static VersionURLInfo parseVersionUrl(String url) {
        if (url.length() < 24) {
            return null;
        }
        String v = url.substring(20, 24);
        if (v.endsWith("/")) {
            v = v.substring(0, v.length() - 1);
            if (Utilities.existsInList(v, "1.0", "1.4", "3.0", "4.0", "5.0", "6.0")) {
                return new VersionURLInfo(v, "http://hl7.org/fhir/" + url.substring(24));
            }
        }
        return null;
    }

    public static Set<String> getExtendedCanonicalResourceNames(String version) {
        Set<String> res = VersionUtilities.getCanonicalResourceNames(version);
        if (VersionUtilities.isR4Ver(version)) {
            res.add("ActorDefinition");
            res.add("Requirements");
            res.add("SubscriptionTopic");
            res.add("TestPlan");
        }
        return res;
    }

    public static Set<String> getCanonicalResourceNames(String version) {
        HashSet<String> res = new HashSet<String>();
        if (VersionUtilities.isR2Ver(version) || VersionUtilities.isR2BVer(version)) {
            res.add("ValueSet");
            res.add("ConceptMap");
            res.add("NamingSystem");
            res.add("StructureDefinition");
            res.add("DataElement");
            res.add("Conformance");
            res.add("OperationDefinition");
            res.add("SearchParameter");
            res.add("ImplementationGuide");
            res.add("TestScript");
        }
        if (VersionUtilities.isR3Ver(version)) {
            res.add("CodeSystem");
            res.add("CapabilityStatement");
            res.add("StructureDefinition");
            res.add("ImplementationGuide");
            res.add("SearchParameter");
            res.add("MessageDefinition");
            res.add("OperationDefinition");
            res.add("CompartmentDefinition");
            res.add("StructureMap");
            res.add("GraphDefinition");
            res.add("DataElement");
            res.add("CodeSystem");
            res.add("ValueSet");
            res.add("ConceptMap");
            res.add("ExpansionProfile");
            res.add("Questionnaire");
            res.add("ActivityDefinition");
            res.add("ServiceDefinition");
            res.add("PlanDefinition");
            res.add("Measure");
            res.add("TestScript");
        }
        if (VersionUtilities.isR4Ver(version)) {
            res.add("CodeSystem");
            res.add("ActivityDefinition");
            res.add("CapabilityStatement");
            res.add("ChargeItemDefinition");
            res.add("CodeSystem");
            res.add("CompartmentDefinition");
            res.add("ConceptMap");
            res.add("EffectEvidenceSynthesis");
            res.add("EventDefinition");
            res.add("Evidence");
            res.add("EvidenceVariable");
            res.add("ExampleScenario");
            res.add("GraphDefinition");
            res.add("ImplementationGuide");
            res.add("Library");
            res.add("Measure");
            res.add("MessageDefinition");
            res.add("NamingSystem");
            res.add("OperationDefinition");
            res.add("PlanDefinition");
            res.add("Questionnaire");
            res.add("ResearchDefinition");
            res.add("ResearchElementDefinition");
            res.add("RiskEvidenceSynthesis");
            res.add("SearchParameter");
            res.add("StructureDefinition");
            res.add("StructureMap");
            res.add("TerminologyCapabilities");
            res.add("TestScript");
            res.add("ValueSet");
        }
        if (VersionUtilities.isR4BVer(version)) {
            res.add("ActivityDefinition");
            res.add("CapabilityStatement");
            res.add("ChargeItemDefinition");
            res.add("Citation");
            res.add("CodeSystem");
            res.add("CompartmentDefinition");
            res.add("ConceptMap");
            res.add("EventDefinition");
            res.add("Evidence");
            res.add("EvidenceReport");
            res.add("EvidenceVariable");
            res.add("ExampleScenario");
            res.add("GraphDefinition");
            res.add("ImplementationGuide");
            res.add("Library");
            res.add("Measure");
            res.add("MessageDefinition");
            res.add("NamingSystem");
            res.add("OperationDefinition");
            res.add("PlanDefinition");
            res.add("Questionnaire");
            res.add("ResearchDefinition");
            res.add("ResearchElementDefinition");
            res.add("SearchParameter");
            res.add("SpecimenDefinition");
            res.add("StructureDefinition");
            res.add("StructureMap");
            res.add("SubscriptionTopic");
            res.add("TerminologyCapabilities");
            res.add("TestScript");
            res.add("ValueSet");
        }
        if (VersionUtilities.isR5Ver(version) || VersionUtilities.isR6Ver(version)) {
            res.add("ActorDefinition");
            res.add("ActivityDefinition");
            res.add("CapabilityStatement");
            res.add("ChargeItemDefinition");
            res.add("Citation");
            res.add("ClinicalUseDefinition");
            res.add("CodeSystem");
            res.add("CompartmentDefinition");
            res.add("ConceptMap");
            res.add("ConditionDefinition");
            res.add("EventDefinition");
            res.add("Evidence");
            res.add("EvidenceReport");
            res.add("EvidenceVariable");
            res.add("ExampleScenario");
            res.add("GraphDefinition");
            res.add("ImplementationGuide");
            res.add("Library");
            res.add("Measure");
            res.add("MessageDefinition");
            res.add("NamingSystem");
            res.add("ObservationDefinition");
            res.add("OperationDefinition");
            res.add("PlanDefinition");
            res.add("Questionnaire");
            res.add("Requirements");
            res.add("SearchParameter");
            res.add("SpecimenDefinition");
            res.add("StructureDefinition");
            res.add("StructureMap");
            res.add("SubscriptionTopic");
            res.add("TerminologyCapabilities");
            res.add("TestPlan");
            res.add("TestScript");
            res.add("ValueSet");
        }
        return res;
    }

    public static String getVersionForPackage(@Nonnull String pid) {
        if (pid == null) {
            return null;
        }
        if (pid.startsWith("hl7.fhir.r")) {
            String[] p = pid.split("\\.");
            return VersionUtilities.versionFromCode(p[2]);
        }
        return null;
    }

    public static boolean versionMatches(@Nonnull String criteria, @Nonnull String candidate) {
        SemverParser.ParseResult parsedCriteria;
        if (Utilities.noString(criteria)) {
            throw new FHIRException("Invalid criteria: null / empty");
        }
        if (Utilities.noString(candidate)) {
            throw new FHIRException("Invalid candidate: null / empty");
        }
        criteria = VersionUtilities.fixForSpecialValue(criteria);
        candidate = VersionUtilities.fixForSpecialValue(candidate);
        boolean endsWithQ = false;
        if (criteria.endsWith("?")) {
            endsWithQ = true;
            criteria = criteria.substring(0, criteria.length() - 1);
        }
        if (!(parsedCriteria = SemverParser.parseSemver(criteria, true, false)).isSuccess()) {
            throw new FHIRException("Invalid criteria: " + criteria + ": (" + parsedCriteria.getError() + ")");
        }
        SemverParser.ParseResult parsedCandidate = SemverParser.parseSemver(candidate, false, false);
        if (!parsedCandidate.isSuccess()) {
            throw new FHIRException("Invalid candidate: " + candidate + " (" + parsedCandidate.getError() + ")");
        }
        if (!VersionUtilities.partMatches(parsedCriteria.getMajor(), parsedCandidate.getMajor(), true)) {
            return false;
        }
        if (endsWithQ && parsedCriteria.getMinor() == null) {
            return true;
        }
        if (!VersionUtilities.partMatches(parsedCriteria.getMinor(), parsedCandidate.getMinor(), true)) {
            return false;
        }
        if (endsWithQ && parsedCriteria.getPatch() == null) {
            return true;
        }
        if (!VersionUtilities.partMatches(parsedCriteria.getPatch(), parsedCandidate.getPatch(), true)) {
            return false;
        }
        if (endsWithQ && parsedCriteria.getReleaseLabel() == null && parsedCriteria.getBuild() == null) {
            return true;
        }
        if (!VersionUtilities.partMatches(parsedCriteria.getReleaseLabel(), parsedCandidate.getReleaseLabel(), false)) {
            return false;
        }
        return VersionUtilities.partMatches(parsedCriteria.getBuild(), parsedCandidate.getBuild(), false);
    }

    private static boolean partMatches(String criteria, String candidate, boolean allowX) {
        if (criteria == null) {
            return candidate == null;
        }
        if (allowX ? Utilities.existsInList(criteria, "*", "x", "X") : Utilities.existsInList(criteria, "*")) {
            return candidate != null;
        }
        return criteria.equals(candidate);
    }

    private static int partIsThisOrLater(String criteria, String candidate, boolean allowX) {
        if (criteria == null) {
            if (candidate == null) {
                return 0;
            }
            return allowX ? -1 : 1;
        }
        if (candidate == null) {
            return allowX ? 1 : -1;
        }
        if (allowX ? Utilities.existsInList(criteria, "*", "x", "X") : Utilities.existsInList(criteria, "*")) {
            return -1;
        }
        if (Utilities.isInteger(criteria) && Utilities.isInteger(candidate)) {
            return Integer.parseInt(criteria) - Integer.parseInt(candidate);
        }
        return criteria.compareTo(candidate);
    }

    public static boolean versionMatchesList(@Nonnull String v1, @Nonnull List<String> v2l) {
        for (String v2 : v2l) {
            if (!VersionUtilities.versionMatches(v1, v2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String removeVersionFromCanonical(@Nullable String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("|")) {
            return url.substring(0, url.indexOf("|"));
        }
        return url;
    }

    public static String getSpecUrl(@Nonnull String v) {
        v = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(v)));
        switch (VersionUtilities.getMajMinPriv(v)) {
            case "0.0": {
                return "http://hl7.org/fhir/DSTU1";
            }
            case "1.0": {
                return "http://hl7.org/fhir/DSTU2";
            }
            case "1.4": {
                return "http://hl7.org/fhir/2016May";
            }
            case "3.0": {
                return "http://hl7.org/fhir/STU3";
            }
            case "4.0": {
                return "http://hl7.org/fhir/R4";
            }
            case "4.3": {
                return "http://hl7.org/fhir/R4B";
            }
            case "5.0": {
                return "http://hl7.org/fhir/R5";
            }
            case "6.0": {
                return "http://build.fhir.org";
            }
        }
        return "http://hl7.org/fhir";
    }

    @Nonnull
    public static String getNameForVersion(@Nonnull String v) {
        v = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(v)));
        switch (VersionUtilities.getMajMinPriv(v)) {
            case "1.0": {
                return "R2";
            }
            case "1.4": {
                return "R2B";
            }
            case "3.0": {
                return "R3";
            }
            case "4.0": {
                return "R4";
            }
            case "4.3": {
                return "R4B";
            }
            case "5.0": {
                return "R5";
            }
            case "6.0": {
                return "R6";
            }
        }
        return "R?";
    }

    public static int compareVersions(@Nullable String ver1, @Nullable String ver2) {
        ver1 = VersionUtilities.checkVersionValid(VersionUtilities.fixForSpecialValue(ver1), "ver1");
        ver2 = VersionUtilities.checkVersionValid(VersionUtilities.fixForSpecialValue(ver2), "ver2");
        if (ver1 != null && ver2 != null) {
            SemverParser.ParseResult pr1 = SemverParser.parseSemver(ver1, false, false);
            SemverParser.ParseResult pr2 = SemverParser.parseSemver(ver2, false, false);
            int res = VersionUtilities.compareVersionStrings(pr1.getMajor(), pr2.getMajor(), true, false);
            if (res == 0) {
                res = VersionUtilities.compareVersionStrings(pr1.getMinor(), pr2.getMinor(), true, false);
            }
            if (res == 0) {
                res = VersionUtilities.compareVersionStrings(pr1.getPatch(), pr2.getPatch(), true, false);
            }
            if (res == 0) {
                res = VersionUtilities.compareVersionStrings(pr1.getReleaseLabel(), pr2.getReleaseLabel(), false, true);
            }
            if (res == 0) {
                res = VersionUtilities.compareVersionStrings(pr1.getBuild(), pr2.getBuild(), false, true);
            }
            return res;
        }
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        return 1;
    }

    private static int compareVersionStrings(String v1, String v2, boolean asInteger, boolean inverted) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return inverted ? 1 : -1;
        }
        if (v2 == null) {
            return inverted ? -1 : 1;
        }
        if (asInteger || Utilities.isInteger(v2) && !Utilities.isInteger(v1)) {
            int r = Integer.compare(Integer.parseInt(v1), Integer.parseInt(v2));
            if (r == 0) {
                return 0;
            }
            if (r < 0) {
                return -1;
            }
            return 1;
        }
        int r = v1.compareTo(v2);
        if (r == 0) {
            return 0;
        }
        if (r < 0) {
            return -1;
        }
        return 1;
    }

    public static boolean includedInRange(@Nonnull String startVer, @Nonnull String stopVer, @Nonnull String ver) {
        startVer = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(startVer), "startVer"));
        stopVer = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(stopVer), "stopVer"));
        if ((ver = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(ver), "ver"))).equals(startVer)) {
            return true;
        }
        if (ver.equals(stopVer)) {
            return true;
        }
        return startVer.compareTo(ver) < 0 && stopVer.compareTo(ver) > 0;
    }

    public static String getResourceTypesUrl(@Nonnull String version) {
        if (VersionUtilities.isR5Plus(version)) {
            return "http://hl7.org/fhir/fhir-types";
        }
        return "http://hl7.org/fhir/resource-types";
    }

    public static List<String> iterateCorePublishedVersions(@Nonnull String startVer, @Nonnull String stopVer) {
        startVer = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(startVer), "startVer"));
        stopVer = VersionUtilities.removeLabels(VersionUtilities.checkVersionNotNullAndValid(VersionUtilities.fixForSpecialValue(stopVer), "stopVer"));
        ArrayList<String> result = new ArrayList<String>();
        if (VersionUtilities.isThisOrLater(startVer, "1.0", VersionPrecision.MINOR) && VersionUtilities.isThisOrLater("1.0", stopVer, VersionPrecision.MINOR)) {
            result.add("1.0");
        }
        if (VersionUtilities.isThisOrLater(startVer, "3.0", VersionPrecision.MINOR) && VersionUtilities.isThisOrLater("3.0", stopVer, VersionPrecision.MINOR)) {
            result.add("3.0");
        }
        if (VersionUtilities.isThisOrLater(startVer, "4.0", VersionPrecision.MINOR) && VersionUtilities.isThisOrLater("4.0", stopVer, VersionPrecision.MINOR)) {
            result.add("4.0");
        }
        if (VersionUtilities.isThisOrLater(startVer, "4.3", VersionPrecision.MINOR) && VersionUtilities.isThisOrLater("4.3", stopVer, VersionPrecision.MINOR)) {
            result.add("4.3");
        }
        if (VersionUtilities.isThisOrLater(startVer, "5.0", VersionPrecision.MINOR) && VersionUtilities.isThisOrLater("5.0", stopVer, VersionPrecision.MINOR)) {
            result.add("5.0");
        }
        return result;
    }

    private static String removeLabels(String version) {
        if (Utilities.noString(version)) {
            return null;
        }
        if (version.contains("+")) {
            version = version.substring(0, version.indexOf("+"));
        }
        if (version.contains("-")) {
            version = version.substring(0, version.indexOf("-"));
        }
        return version;
    }

    private static String checkVersionNotNullAndValid(String s) {
        if (s == null) {
            throw new FHIRException("Invalid version: null");
        }
        if (!VersionUtilities.isSemVer(s)) {
            throw new FHIRException("Invalid version: '" + s + "\"");
        }
        return s;
    }

    public static String checkVersionNotNullAndValid(String s, String label) {
        if (s == null) {
            throw new FHIRException("Invalid " + label + " version: null");
        }
        if (!VersionUtilities.isSemVer(s)) {
            throw new FHIRException("Invalid " + label + " version: '" + s + "'");
        }
        return s;
    }

    private static String checkVersionNotNullAndValidWildcards(String s) {
        if (s == null) {
            throw new FHIRException("Invalid version: null");
        }
        if (!VersionUtilities.isSemVerWithWildcards(s)) {
            throw new FHIRException("Invalid version: '" + s + "\"");
        }
        return s;
    }

    private static String checkVersionNotNullAndValidWildcards(String s, String label) {
        if (s == null) {
            throw new FHIRException("Invalid " + label + " version: null");
        }
        if (!VersionUtilities.isSemVerWithWildcards(s)) {
            throw new FHIRException("Invalid " + label + " version: '" + s + "\"");
        }
        return s;
    }

    private static String checkVersionValid(String s) {
        if (s == null) {
            return null;
        }
        if (!VersionUtilities.isSemVer(s)) {
            throw new FHIRException("Invalid version: '" + s + "\"");
        }
        return s;
    }

    private static String checkVersionValidWildcards(String s) {
        if (s == null) {
            return null;
        }
        if (!VersionUtilities.isSemVerWithWildcards(s)) {
            throw new FHIRException("Invalid version: '" + s + "\"");
        }
        return s;
    }

    private static String checkVersionValid(String s, String label) {
        if (s == null) {
            return null;
        }
        if (!VersionUtilities.isSemVer(s)) {
            throw new FHIRException("Invalid " + label + " version: '" + s + "\"");
        }
        return s;
    }

    private static String checkVersionNotNull(String s) {
        if (s == null) {
            throw new FHIRException("Invalid version: null");
        }
        return s;
    }

    private static String checkVersionNotNull(String s, String label) {
        if (s == null) {
            throw new FHIRException("Invalid " + label + " version: null");
        }
        return s;
    }

    public static String fixForSpecialValue(String version) {
        if (Utilities.noString(version)) {
            return null;
        }
        if (version.startsWith("http://hl7.org/fhir/") && (version = version.substring(20)).contains("/")) {
            version = version.substring(0, version.indexOf("/"));
        }
        switch (version.toUpperCase()) {
            case "R2": {
                return "1.0.2";
            }
            case "DSTU2": {
                return "1.0.2";
            }
            case "R2B": {
                return "1.4.0";
            }
            case "R3": {
                return "3.0.2";
            }
            case "STU3": {
                return "3.0.2";
            }
            case "R4": {
                return "4.0.1";
            }
            case "R4B": {
                return "4.3.0";
            }
            case "R5": {
                return "5.0.0";
            }
            case "R6": {
                return "6.0.0-cibuild";
            }
        }
        return version;
    }

    public static enum VersionPrecision {
        MAJOR,
        MINOR,
        PATCH,
        FULL;

    }

    public static class VersionURLInfo {
        private String version;
        private String url;

        public VersionURLInfo(String version, String url) {
            this.version = version;
            this.url = url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class SemVer {
        private String major;
        private String minor;
        private String patch;
        private String label;

        public SemVer(String ver) {
            String[] p = ver.split("\\.");
            if (p.length > 0) {
                this.major = p[0];
            }
            if (p.length > 1) {
                this.minor = p[1];
            }
            if (p.length > 2) {
                this.patch = p[2];
                if (this.patch.contains("-")) {
                    this.label = this.patch.substring(this.patch.indexOf("-") + 1);
                    this.patch = this.patch.substring(0, this.patch.indexOf("-"));
                }
            }
        }

        private int compareString(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            if (s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }

        private int compareInteger(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : 1;
            }
            if (s2 == null) {
                return -1;
            }
            return Integer.compare(Integer.parseInt(s1), Integer.parseInt(s2));
        }

        public int compareTo(SemVer sv2) {
            int c = this.compareInteger(this.major, sv2.major);
            if (c == 0) {
                c = this.compareInteger(this.minor, sv2.minor);
            }
            if (c == 0) {
                c = this.compareInteger(this.patch, sv2.patch);
            }
            if (c == 0) {
                c = this.compareString(this.label, sv2.label);
            }
            return c;
        }
    }

    public static class SemVerSorter
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            return VersionUtilities.compareVersions(s1, s2);
        }
    }
}

