/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.hl7.fhir.utilities.http.HTTPHeader;

public class HTTPRequest {
    @Nullable
    private final URL url;
    private final HttpMethod method;
    @Nullable
    private final byte[] body;
    @Nullable
    private final String contentType;
    @Nonnull
    private final Iterable<HTTPHeader> headers;

    public HTTPRequest() {
        this.url = null;
        this.method = HttpMethod.GET;
        this.body = null;
        this.contentType = null;
        this.headers = Collections.emptyList();
    }

    public HTTPRequest withUrl(URL url) {
        return new HTTPRequest(url, this.method, this.body, this.contentType, this.headers);
    }

    public HTTPRequest withUrl(String url) {
        try {
            return this.withUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    @Generated
    public HTTPRequest(@Nullable URL url, HttpMethod method, @Nullable byte[] body, @Nullable String contentType, @Nonnull Iterable<HTTPHeader> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.url = url;
        this.method = method;
        this.body = body;
        this.contentType = contentType;
        this.headers = headers;
    }

    @Nullable
    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public HTTPRequest withMethod(HttpMethod method) {
        return this.method == method ? this : new HTTPRequest(this.url, method, this.body, this.contentType, this.headers);
    }

    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @Generated
    public HTTPRequest withBody(@Nullable byte[] body) {
        return this.body == body ? this : new HTTPRequest(this.url, this.method, body, this.contentType, this.headers);
    }

    @Nullable
    @Generated
    public byte[] getBody() {
        return this.body;
    }

    @Generated
    public HTTPRequest withContentType(@Nullable String contentType) {
        return this.contentType == contentType ? this : new HTTPRequest(this.url, this.method, this.body, contentType, this.headers);
    }

    @Nullable
    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public HTTPRequest withHeaders(@Nonnull Iterable<HTTPHeader> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return this.headers == headers ? this : new HTTPRequest(this.url, this.method, this.body, this.contentType, headers);
    }

    @Nonnull
    @Generated
    public Iterable<HTTPHeader> getHeaders() {
        return this.headers;
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        PATCH;

    }
}

