/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.nio.file.Paths;
import lombok.Generated;
import org.hl7.fhir.utilities.tests.TestConstants;

public class TestConfig {
    private static final TestConfig INSTANCE = new TestConfig();
    public static final String FHIR_TXCACHE_REBUILD = "fhir.txcache.rebuild";
    public static final String FHIR_TEST_CASES = "FHIR-TEST-CASES";
    private boolean rebuildCache = System.getProperty("fhir.txcache.rebuild") != null && "TRUE".equalsIgnoreCase(System.getProperty("fhir.txcache.rebuild"));
    private String txCacheDirectory = TestConstants.TX_CACHE;
    private String fhirTestCasesDirectory = System.getenv("FHIR-TEST-CASES");

    public static TestConfig getInstance() {
        return INSTANCE;
    }

    public String getTxCacheDirectory(String ... path) {
        return Paths.get(this.txCacheDirectory, path).toString();
    }

    @Generated
    public boolean isRebuildCache() {
        return this.rebuildCache;
    }

    @Generated
    public void setRebuildCache(boolean rebuildCache) {
        this.rebuildCache = rebuildCache;
    }

    @Generated
    public void setTxCacheDirectory(String txCacheDirectory) {
        this.txCacheDirectory = txCacheDirectory;
    }

    @Generated
    public String getFhirTestCasesDirectory() {
        return this.fhirTestCasesDirectory;
    }

    @Generated
    public void setFhirTestCasesDirectory(String fhirTestCasesDirectory) {
        this.fhirTestCasesDirectory = fhirTestCasesDirectory;
    }
}

