/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xml.IXMLWriter;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CDANarrativeFormat {
    public XhtmlNode convert(Element ed) throws FHIRException {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        this.processAttributes(ed, div, "ID", "language", "styleCode");
        this.processChildren(ed, div);
        return div;
    }

    private void processChildren(Element ed, XhtmlNode x) throws FHIRException {
        for (Node n : XMLUtil.children(ed)) {
            this.processChildNode(n, x);
        }
    }

    private void processChildNode(Node n, XhtmlNode xn) throws FHIRException {
        switch (n.getNodeType()) {
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
            case 5: {
                throw new Error("Not handled yet");
            }
            case 8: {
                xn.addComment(n.getTextContent());
                return;
            }
            case 3: {
                if (!StringUtils.isWhitespace((CharSequence)n.getTextContent())) {
                    xn.addText(n.getTextContent());
                }
                return;
            }
            case 1: {
                Element e = (Element)n;
                if (n.getNodeName().equals("br")) {
                    this.processBreak(e, xn);
                    break;
                }
                if (n.getNodeName().equals("caption")) {
                    this.processCaption(e, xn);
                    break;
                }
                if (n.getNodeName().equals("col")) {
                    this.processCol(e, xn);
                    break;
                }
                if (n.getNodeName().equals("colgroup")) {
                    this.processColGroup(e, xn);
                    break;
                }
                if (n.getNodeName().equals("content")) {
                    this.processContent(e, xn);
                    break;
                }
                if (n.getNodeName().equals("footnote")) {
                    this.processFootNote(e, xn);
                    break;
                }
                if (n.getNodeName().equals("footnoteRef")) {
                    this.processFootNodeRef(e, xn);
                    break;
                }
                if (n.getNodeName().equals("item")) {
                    this.processItem(e, xn);
                    break;
                }
                if (n.getNodeName().equals("linkHtml") || n.getNodeName().equals("a")) {
                    this.processlinkHtml(e, xn);
                    break;
                }
                if (n.getNodeName().equals("list")) {
                    this.processList(e, xn);
                    break;
                }
                if (n.getNodeName().equals("paragraph")) {
                    this.processParagraph(e, xn);
                    break;
                }
                if (n.getNodeName().equals("renderMultiMedia")) {
                    this.processRenderMultiMedia(e, xn);
                    break;
                }
                if (n.getNodeName().equals("sub")) {
                    this.processSub(e, xn);
                    break;
                }
                if (n.getNodeName().equals("sup")) {
                    this.processSup(e, xn);
                    break;
                }
                if (n.getNodeName().equals("table")) {
                    this.processTable(e, xn);
                    break;
                }
                if (n.getNodeName().equals("tbody")) {
                    this.processTBody(e, xn);
                    break;
                }
                if (n.getNodeName().equals("td")) {
                    this.processTd(e, xn);
                    break;
                }
                if (n.getNodeName().equals("tfoot")) {
                    this.processTFoot(e, xn);
                    break;
                }
                if (n.getNodeName().equals("th")) {
                    this.processTh(e, xn);
                    break;
                }
                if (n.getNodeName().equals("thead")) {
                    this.processTHead(e, xn);
                    break;
                }
                if (n.getNodeName().equals("tr")) {
                    this.processTr(e, xn);
                    break;
                }
                throw new FHIRException("Unknown element " + n.getNodeName());
            }
        }
    }

    private void processBreak(Element e, XhtmlNode xn) {
        xn.addTag("br");
    }

    private void processCaption(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("caption");
        this.processAttributes(e, xc, "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processCol(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("col");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "span", "width", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processColGroup(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("colgroup");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "span", "width", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processContent(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("span");
        this.processAttributes(e, xc, "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processFootNote(Element e, XhtmlNode xn) {
        XhtmlNode xc = xn.addTag("tfoot");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processFootNodeRef(Element e, XhtmlNode xn) {
        throw new Error("element " + e.getNodeName() + " not handled yet");
    }

    private void processItem(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("li");
        this.processAttributes(e, xc, "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processlinkHtml(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("a");
        this.processAttributes(e, xc, "name", "href", "rel", "rev", "title", "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processList(Element e, XhtmlNode xn) throws FHIRException {
        String lt = e.getAttribute("listType");
        XhtmlNode xc = xn.addTag("ordered".equals(lt) ? "ol" : "ul");
        this.processAttributes(e, xc, "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processParagraph(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("p");
        this.processAttributes(e, xc, "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processRenderMultiMedia(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("img");
        String v = e.getAttribute("referencedObject");
        xc.attribute("src", v);
        this.processAttributes(e, xc, "ID", "language", "styleCode");
        this.processChildren(e, xc);
    }

    private void processSub(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("sub");
        this.processChildren(e, xc);
    }

    private void processSup(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("sup");
        this.processChildren(e, xc);
    }

    private void processTable(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("table");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding");
        this.processChildren(e, xc);
    }

    private void processTBody(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("tbody");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processTd(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("td");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processTFoot(Element e, XhtmlNode xn) {
        XhtmlNode xc = xn.addTag("tfoot");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processTh(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("th");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processTHead(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("thead");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processTr(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("tr");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processLinkHtml(Element e, XhtmlNode xn) throws FHIRException {
        XhtmlNode xc = xn.addTag("linkHtml");
        this.processAttributes(e, xc, "ID", "language", "styleCode", "align", "char", "charoff", "valign");
        this.processChildren(e, xc);
    }

    private void processAttributes(Element element, XhtmlNode xn, String ... names) {
        block44: for (String n : names) {
            if (!element.hasAttribute(n)) continue;
            String v = element.getAttribute(n);
            switch (n) {
                case "ID": {
                    xn.attribute("id", v);
                    continue block44;
                }
                case "styleCode": {
                    String style = v;
                    switch (v) {
                        case "Bold": {
                            style = "font-weight: bold";
                            break;
                        }
                        case "Underline": {
                            style = "text-decoration: underline";
                            break;
                        }
                        case "Italics": {
                            style = "font-style: italic";
                            break;
                        }
                        case "Emphasis": {
                            style = "font-weight: small-caps";
                            break;
                        }
                        case "Lrule": {
                            style = "border-left: 1px";
                            break;
                        }
                        case "Rrule": {
                            style = "border-right: 1px";
                            break;
                        }
                        case "Toprule": {
                            style = "border-top: 1px";
                            break;
                        }
                        case "Botrule": {
                            style = "border-bottom: 1px";
                            break;
                        }
                        case "Arabic": {
                            style = "list-style-type: decimal";
                            break;
                        }
                        case "LittleRoman": {
                            style = "list-style-type: lower-roman";
                            break;
                        }
                        case "BigRoman": {
                            style = "list-style-type: upper-roman";
                            break;
                        }
                        case "LittleAlpha": {
                            style = "list-style-type: lower-alpha";
                            break;
                        }
                        case "BigAlpha": {
                            style = "list-style-type: upper-alpha";
                            break;
                        }
                        case "Disc": {
                            style = "list-style-type: disc";
                            break;
                        }
                        case "Circle": {
                            style = "list-style-type: circle";
                            break;
                        }
                        case "Square": {
                            style = "list-style-type: square";
                        }
                    }
                    xn.attribute("style", style);
                    continue block44;
                }
                default: {
                    xn.attribute(n, v);
                }
            }
        }
    }

    public void convert(IXMLWriter xml, XhtmlNode div) throws IOException, FHIRException {
        this.processAttributes(div, xml, "ID", "language", "styleCode");
        xml.enter("text");
        this.processChildren(xml, div);
        xml.exit("text");
    }

    private void processChildren(IXMLWriter xml, XhtmlNode x) throws IOException, FHIRException {
        for (XhtmlNode n : x.getChildNodes()) {
            this.processChildNode(xml, n);
        }
    }

    private void processChildNode(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        switch (n.getNodeType()) {
            case DocType: 
            case Document: 
            case Instruction: {
                return;
            }
            case Comment: {
                xml.comment(n.getContent(), true);
                return;
            }
            case Text: {
                xml.text(n.getContent());
                return;
            }
            case Element: {
                if (n.getName().equals("br")) {
                    this.processBreak(xml, n);
                    break;
                }
                if (n.getName().equals("h2") || n.getName().equals("caption")) {
                    this.processCaption(xml, n);
                    break;
                }
                if (n.getName().equals("col")) {
                    this.processCol(xml, n);
                    break;
                }
                if (n.getName().equals("colgroup")) {
                    this.processColGroup(xml, n);
                    break;
                }
                if (n.getName().equals("span")) {
                    this.processContent(xml, n);
                    break;
                }
                if (n.getName().equals("footnote")) {
                    this.processFootNote(xml, n);
                    break;
                }
                if (n.getName().equals("footnoteRef")) {
                    this.processFootNodeRef(xml, n);
                    break;
                }
                if (n.getName().equals("li")) {
                    this.processItem(xml, n);
                    break;
                }
                if (n.getName().equals("linkHtml")) {
                    this.processlinkHtml(xml, n);
                    break;
                }
                if (n.getName().equals("ul") || n.getName().equals("ol")) {
                    this.processList(xml, n);
                    break;
                }
                if (n.getName().equals("p")) {
                    this.processParagraph(xml, n);
                    break;
                }
                if (n.getName().equals("img")) {
                    this.processRenderMultiMedia(xml, n);
                    break;
                }
                if (n.getName().equals("sub")) {
                    this.processSub(xml, n);
                    break;
                }
                if (n.getName().equals("sup")) {
                    this.processSup(xml, n);
                    break;
                }
                if (n.getName().equals("table")) {
                    this.processTable(xml, n);
                    break;
                }
                if (n.getName().equals("tbody")) {
                    this.processTBody(xml, n);
                    break;
                }
                if (n.getName().equals("td")) {
                    this.processTd(xml, n);
                    break;
                }
                if (n.getName().equals("tfoot")) {
                    this.processTFoot(xml, n);
                    break;
                }
                if (n.getName().equals("th")) {
                    this.processTh(xml, n);
                    break;
                }
                if (n.getName().equals("thead")) {
                    this.processTHead(xml, n);
                    break;
                }
                if (n.getName().equals("a")) {
                    this.processA(xml, n);
                    break;
                }
                if (n.getName().equals("tr")) {
                    this.processTr(xml, n);
                    break;
                }
                throw new FHIRException("Unknown element " + n.getName());
            }
        }
    }

    private void processBreak(IXMLWriter xml, XhtmlNode n) throws IOException {
        xml.element("br");
    }

    private void processCaption(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode");
        xml.enter("caption");
        this.processChildren(xml, n);
        xml.exit("caption");
    }

    private void processCol(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "span", "width", "align", "char", "charoff", "valign");
        xml.enter("col");
        this.processChildren(xml, n);
        xml.exit("col");
    }

    private void processColGroup(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "span", "width", "align", "char", "charoff", "valign");
        xml.enter("colgroup");
        this.processChildren(xml, n);
        xml.exit("colgroup");
    }

    private void processContent(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode");
        xml.enter("content");
        this.processChildren(xml, n);
        xml.exit("content");
    }

    private void processFootNote(IXMLWriter xml, XhtmlNode n) {
        throw new Error("element " + n.getName() + " not handled yet");
    }

    private void processFootNodeRef(IXMLWriter xml, XhtmlNode n) {
        throw new Error("element " + n.getName() + " not handled yet");
    }

    private void processItem(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode");
        xml.enter("item");
        this.processChildren(xml, n);
        xml.exit("item");
    }

    private void processlinkHtml(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        String v = n.getAttribute("src");
        xml.attribute("referencedObject", v);
        this.processAttributes(n, xml, "name", "href", "rel", "rev", "title", "id", "language", "styleCode");
        xml.enter("linkHtml");
        this.processChildren(xml, n);
        xml.exit("linkHtml");
    }

    private void processList(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        if (n.getName().equals("ol")) {
            xml.attribute("listType", "ordered");
        } else {
            xml.attribute("listType", "unordered");
        }
        this.processAttributes(n, xml, "id", "language", "styleCode");
        xml.enter("list");
        this.processChildren(xml, n);
        xml.exit("list");
    }

    private void processParagraph(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode");
        xml.enter("paragraph");
        this.processChildren(xml, n);
        xml.exit("paragraph");
    }

    private void processRenderMultiMedia(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        String v = n.getAttribute("src");
        xml.attribute("referencedObject", v);
        this.processAttributes(n, xml, "id", "language", "styleCode");
        xml.enter("renderMultiMedia");
        this.processChildren(xml, n);
        xml.exit("renderMultiMedia");
    }

    private void processSub(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        xml.enter("sub");
        this.processChildren(xml, n);
        xml.exit("sub");
    }

    private void processSup(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        xml.enter("sup");
        this.processChildren(xml, n);
        xml.exit("sup");
    }

    private void processTable(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "summary", "width", "border", "frame", "rules", "cellspacing", "cellpadding");
        xml.enter("table");
        this.processChildren(xml, n);
        xml.exit("table");
    }

    private void processTBody(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "align", "char", "charoff", "valign");
        xml.enter("tbody");
        this.processChildren(xml, n);
        xml.exit("tbody");
    }

    private void processTd(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign");
        xml.enter("td");
        this.processChildren(xml, n);
        xml.exit("td");
    }

    private void processTFoot(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "align", "char", "charoff", "valign");
        xml.enter("tfoot");
        this.processChildren(xml, n);
        xml.exit("tfoot");
    }

    private void processTh(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "abbr", "axis", "headers", "scope", "rowspan", "colspan", "align", "char", "charoff", "valign");
        xml.enter("th");
        this.processChildren(xml, n);
        xml.exit("th");
    }

    private void processTHead(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "align", "char", "charoff", "valign");
        xml.enter("thead");
        this.processChildren(xml, n);
        xml.exit("thead");
    }

    private void processTr(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "align", "char", "charoff", "valign");
        xml.enter("tr");
        this.processChildren(xml, n);
        xml.exit("tr");
    }

    private void processA(IXMLWriter xml, XhtmlNode n) throws IOException, FHIRException {
        this.processAttributes(n, xml, "id", "language", "styleCode", "align", "char", "charoff", "valign");
        xml.enter("linkHtml");
        this.processChildren(xml, n);
        xml.exit("linkHtml");
    }

    private void processAttributes(XhtmlNode xn, IXMLWriter xml, String ... names) throws IOException {
        block44: for (String n : names) {
            if (!xn.hasAttribute(n)) continue;
            String v = xn.getAttribute(n);
            switch (n) {
                case "id": {
                    xml.attribute("ID", v);
                    continue block44;
                }
                case "style": {
                    String style = v;
                    switch (v) {
                        case "font-weight: bold": {
                            style = "Bold";
                            break;
                        }
                        case "text-decoration: underline": {
                            style = "Underline";
                            break;
                        }
                        case "font-style: italic": {
                            style = "Italics";
                            break;
                        }
                        case "font-weight: small-caps": {
                            style = "Emphasis";
                            break;
                        }
                        case "border-left: 1px": {
                            style = "Lrule";
                            break;
                        }
                        case "border-right: 1px": {
                            style = "Rrule";
                            break;
                        }
                        case "border-top: 1px": {
                            style = "Toprule";
                            break;
                        }
                        case "border-bottom: 1px": {
                            style = "Botrule";
                            break;
                        }
                        case "List-style-type: decimal": {
                            style = "Arabic";
                            break;
                        }
                        case "list-style-type: lower-roman": {
                            style = "LittleRoman";
                            break;
                        }
                        case "list-style-type: upper-roman": {
                            style = "BigRoman";
                            break;
                        }
                        case "list-style-type: lower-alpha": {
                            style = "LittleAlpha";
                            break;
                        }
                        case "list-style-type: upper-alpha": {
                            style = "BigAlpha";
                            break;
                        }
                        case "list-style-type: disc": {
                            style = "Disc";
                            break;
                        }
                        case "list-style-type: circle": {
                            style = "Circle";
                            break;
                        }
                        case "list-style-type: square": {
                            style = "Square";
                        }
                    }
                    xml.attribute("styleCode", style);
                    continue block44;
                }
                default: {
                    xml.attribute(n, v);
                }
            }
        }
    }
}

