/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class XhtmlToMarkdownConverter {
    public String convert(XhtmlNode x) {
        StringBuilder b = new StringBuilder();
        this.convert(b, x);
        return b.toString();
    }

    private void convert(StringBuilder b, XhtmlNode x) {
        for (XhtmlNode c : x.getChildNodes()) {
            if (c.getNodeType() == NodeType.Text) {
                this.paragraph(b, c, true, false);
                continue;
            }
            if (c.getName() == null) continue;
            this.convertNode(b, c);
        }
    }

    public void convertNode(StringBuilder b, XhtmlNode c) throws Error {
        switch (c.getName()) {
            case "p": {
                this.paragraph(b, c, true, false);
                break;
            }
            case "hr": {
                b.append("-------\r\n");
                break;
            }
            case "a": {
                this.paragraph(b, c, true, false);
                break;
            }
            case "h1": {
                b.append("# " + c.allText());
                break;
            }
            case "h2": {
                b.append("## " + c.allText());
                break;
            }
            case "h3": {
                b.append("### " + c.allText());
                break;
            }
            case "h4": {
                b.append("#### " + c.allText());
                break;
            }
            case "h5": {
                b.append("##### " + c.allText());
                break;
            }
            case "h6": {
                b.append("###### " + c.allText());
                break;
            }
            case "strong": 
            case "em": 
            case "i": 
            case "span": 
            case "img": 
            case "br": 
            case "wbr": 
            case "code": 
            case "del": 
            case "sup": 
            case "sub": 
            case "u": 
            case "b": {
                this.paragraph(b, c, true, false);
                break;
            }
            case "div": {
                this.convert(b, c);
                break;
            }
            case "ul": {
                this.convertUL(b, c);
                break;
            }
            case "li": {
                this.convertLI(b, c);
                break;
            }
            case "ol": {
                this.convertOL(b, c);
                break;
            }
            case "table": 
            case "tbody": {
                this.convertTable(b, c);
                break;
            }
            case "iframe": {
                this.convertIFrame(b, c);
                break;
            }
            case "form": 
            case "select": 
            case "input": 
            case "textarea": 
            case "option": {
                this.convertForm(b, c);
                break;
            }
            case "label": 
            case "cite": {
                this.convertLabel(b, c);
                break;
            }
            case "figure": 
            case "figcaption": {
                this.convert(b, c);
                break;
            }
            case "dl": 
            case "tt": {
                this.convertDL(b, c);
                break;
            }
            case "blockquote": {
                b.append("\r\n");
                b.append("> ");
                this.paragraph(b, c, false, true);
                b.append("\r\n");
                break;
            }
            case "pre": {
                b.append("````\r\n");
                this.convert(b, c);
                b.append("\r\n````\r\n");
                break;
            }
            default: {
                throw new Error("not done yet: " + c.getName());
            }
        }
    }

    private void convertDL(StringBuilder b, XhtmlNode c) {
    }

    private void convertIFrame(StringBuilder b, XhtmlNode c) {
        b.append(c.toString());
    }

    private void convertForm(StringBuilder b, XhtmlNode c) {
        b.append(c.toString());
    }

    private void convertLabel(StringBuilder b, XhtmlNode c) {
        this.convert(b, c);
    }

    private void convertTable(StringBuilder b, XhtmlNode x) {
        boolean first = true;
        for (XhtmlNode c : x.getChildNodes()) {
            if ("tbody".equals(c.getName())) {
                this.convertTable(b, c);
                continue;
            }
            if (!"tr".equals(c.getName())) continue;
            if (first) {
                first = false;
                b.append("\r\n");
            }
            boolean header = false;
            for (XhtmlNode g : c.getChildNodes()) {
                if (!Utilities.existsInList(g.getName(), "td", "th")) continue;
                if ("th".equals(g.getName())) {
                    header = true;
                }
                b.append("|");
                this.paragraph(b, g, false, true);
            }
            b.append("\r\n");
            if (!header) continue;
            for (XhtmlNode g : c.getChildNodes()) {
                if (!Utilities.existsInList(g.getName(), "td", "th")) continue;
                b.append("|---");
            }
            b.append("\r\n");
        }
    }

    private void convertUL(StringBuilder b, XhtmlNode x) {
        for (XhtmlNode c : x.getChildNodes()) {
            if (!"li".equals(c.getName())) continue;
            b.append("* ");
            this.paragraph(b, c, true, true);
        }
    }

    private void convertLI(StringBuilder b, XhtmlNode x) {
        b.append("* ");
        this.paragraph(b, x, true, true);
    }

    private void convertOL(StringBuilder b, XhtmlNode x) {
        for (XhtmlNode c : x.getChildNodes()) {
            if (!"li".equals(c.getName())) continue;
            b.append("1. ");
            this.paragraph(b, c, true, true);
        }
    }

    private void paragraph(StringBuilder b, XhtmlNode x, boolean mark, boolean trim) {
        if (x.getNodeType() == NodeType.Text) {
            this.addText(b, trim, x.getContent());
        } else if (x.getName() != null && !Utilities.existsInList(x.getName(), "p", "li", "td", "th", "blockquote")) {
            this.part(b, x, trim);
        } else {
            for (XhtmlNode c : x.getChildNodes()) {
                if (c.getNodeType() == NodeType.Text) {
                    this.addText(b, trim, c.getContent());
                    continue;
                }
                this.part(b, c, trim);
            }
            if (mark) {
                b.append("\r\n");
            }
        }
    }

    private void addText(StringBuilder b, boolean trim, String content) {
        if (trim) {
            content = content.trim();
        }
        if (!Utilities.noString(content)) {
            b.append(content);
        }
    }

    public void part(StringBuilder b, XhtmlNode c, boolean trim) throws Error {
        switch (c.getName()) {
            case "a": {
                b.append("[");
                this.process(b, c, trim);
                b.append("](");
                b.append(c.getAttribute("href"));
                b.append(")");
                break;
            }
            case "img": {
                b.append("![");
                b.append(c.allText());
                b.append("](");
                b.append(c.getAttribute("src"));
                b.append(")");
                break;
            }
            case "code": 
            case "pre": {
                b.append("```");
                this.process(b, c, trim);
                b.append("```");
            }
            case "strong": 
            case "em": 
            case "b": {
                b.append("**");
                this.process(b, c, trim);
                b.append("**");
                break;
            }
            case "u": {
                b.append("_");
                this.process(b, c, trim);
                b.append("_");
                break;
            }
            case "i": {
                b.append("*");
                this.process(b, c, trim);
                b.append("*");
                break;
            }
            case "span": 
            case "sup": 
            case "sub": 
            case "s": {
                this.process(b, c, trim);
                break;
            }
            case "div": 
            case "h1": 
            case "h2": 
            case "h3": 
            case "h4": 
            case "h5": 
            case "h6": 
            case "table": 
            case "cite": {
                b.append("\r\n");
                this.convertNode(b, c);
                break;
            }
            case "p": {
                if (!trim) {
                    b.append("\r\n\r\n");
                }
                this.process(b, c, trim);
                break;
            }
            case "ul": {
                b.append("\r\n");
                this.convertUL(b, c);
                break;
            }
            case "li": {
                b.append("\r\n");
                this.convertLI(b, c);
                break;
            }
            case "ol": {
                b.append("\r\n");
                this.convertOL(b, c);
                break;
            }
            case "blockquote": {
                b.append("\r\n");
                b.append("> ");
                this.paragraph(b, c, false, trim);
                b.append("\r\n");
                break;
            }
            case "del": 
            case "dl": 
            case "dd": 
            case "tt": {
                this.process(b, c, trim);
            }
            case "br": {
                b.append("\r\n");
                this.process(b, c, trim);
                break;
            }
            case "wbr": {
                b.append("\r\n");
                break;
            }
            default: {
                throw new Error("part not done yet: " + c.getName());
            }
        }
    }

    private void process(StringBuilder b, XhtmlNode x, boolean trim) {
        for (XhtmlNode c : x.getChildNodes()) {
            if (c.getNodeType() == NodeType.Text) {
                b.append(c.getContent());
                continue;
            }
            if (c.getName() == null) continue;
            this.part(b, c, trim);
        }
    }
}

