/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractPrimitiveTypeRule;
import java.util.regex.Pattern;

public class TrimLeadingWhitespace
extends AbstractPrimitiveTypeRule {
    private static final Pattern LEADING_WHITESPACE = Pattern.compile("^\\s+");

    @Override
    public String correct(String value) {
        return value != null ? LEADING_WHITESPACE.matcher(value).replaceAll("") : null;
    }

    @Override
    public ValidationException[] apply(String value) {
        return this.passed();
    }

    @Override
    public String getDescription() {
        return "Leading whitespace removed";
    }
}

