/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.store.CodeStore;
import ca.uhn.hl7v2.conf.store.RegisteredPattern;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeStore
implements CodeStore {
    private static final Logger log = LoggerFactory.getLogger(AbstractCodeStore.class);
    private static final RegisteredPattern[] WILDCARDS = new RegisteredPattern[]{new RegisteredPattern("ISOnnnn", "ISO\\d\\d\\d\\d"), new RegisteredPattern("HL7nnnn", "HL7\\d\\d\\d\\d"), new RegisteredPattern("99zzz", "99[\\w]*"), new RegisteredPattern("NNxxx", "99[\\w]*")};

    @Override
    public boolean isValidCode(String codeSystem, String code) {
        try {
            for (String validCode : this.getValidCodes(codeSystem)) {
                if (!this.checkCode(code, validCode)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("Error checking code " + code + " in code system " + codeSystem, (Throwable)e);
            return false;
        }
    }

    private boolean checkCode(String code, String pattern) {
        if (code.equals(pattern)) {
            return true;
        }
        if (pattern.indexOf(32) >= 0 || pattern.indexOf(44) >= 0) {
            StringTokenizer tok = new StringTokenizer(pattern, ", ", false);
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                if (t.equalsIgnoreCase("or") || !this.checkCode(code, t)) continue;
                return true;
            }
        } else {
            for (RegisteredPattern wildcard : WILDCARDS) {
                if (!wildcard.matches(pattern, code)) continue;
                return true;
            }
        }
        return false;
    }
}

