/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Field;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Variable;
import ca.uhn.hl7v2.model.Visitable;
import ca.uhn.hl7v2.parser.Parser;
import java.io.IOException;

public final class Unmodifiable {
    private Unmodifiable() {
    }

    public static Message unmodifiableMessage(Message msg) {
        return Unmodifiable.isUnmodifiable(msg) ? msg : new UnmodifiableMessage(msg);
    }

    public static Message unmodifiableMessage(HapiContext context, String s) throws HL7Exception {
        Message msg = context.getGenericParser().parse(s);
        return new UnmodifiableMessage(msg, s);
    }

    public static boolean isUnmodifiable(Object o) {
        return o instanceof UnmodifiableModel;
    }

    private static <T extends Type> T unmodifiableType(T type) {
        if (Unmodifiable.isUnmodifiable(type)) {
            return type;
        }
        if (type instanceof Primitive) {
            return (T)new UnmodifiablePrimitive((Primitive)type);
        }
        if (type instanceof Composite) {
            return (T)new UnmodifiableComposite((Composite)type);
        }
        return (T)new UnmodifiableVaries((Variable)type);
    }

    private static <T extends Structure> T unmodifiableStructure(T structure) {
        if (Unmodifiable.isUnmodifiable(structure)) {
            return structure;
        }
        if (structure instanceof Message) {
            return (T)new UnmodifiableMessage((Message)structure);
        }
        if (structure instanceof Group) {
            return (T)new UnmodifiableGroup<Group>((Group)structure);
        }
        return (T)new UnmodifiableSegment<Segment>((Segment)structure);
    }

    private static <T extends MessageVisitor> T unmodifiableVisitor(T visitor) {
        return (T)(Unmodifiable.isUnmodifiable(visitor) ? visitor : new UnmodifiableMessageVisitor(visitor));
    }

    private static ExtraComponents unmodifiableExtraComponents(ExtraComponents ec) {
        return Unmodifiable.isUnmodifiable(ec) ? ec : new UnmodifiableExtraComponents(ec);
    }

    private static class UnmodifiableMessage
    extends UnmodifiableGroup<Message>
    implements Message {
        private String originalMessage;

        public UnmodifiableMessage(Message delegate, String originalMessage) {
            this(delegate);
            this.originalMessage = originalMessage;
        }

        public UnmodifiableMessage(Message delegate) {
            super(delegate);
        }

        @Override
        public String getVersion() {
            return ((Message)this.getDelegate()).getVersion();
        }

        @Override
        public Character getFieldSeparatorValue() throws HL7Exception {
            return ((Message)this.getDelegate()).getFieldSeparatorValue();
        }

        @Override
        public String getEncodingCharactersValue() throws HL7Exception {
            return ((Message)this.getDelegate()).getEncodingCharactersValue();
        }

        @Override
        public void setParser(Parser parser) {
            throw new UnsupportedOperationException("This message is unmodifiable");
        }

        @Override
        public Parser getParser() {
            return ((Message)this.getDelegate()).getParser();
        }

        @Override
        public void parse(String string) {
            throw new UnsupportedOperationException("This message is unmodifiable");
        }

        @Override
        public String encode() throws HL7Exception {
            return this.originalMessage != null ? this.originalMessage : ((Message)this.getDelegate()).encode();
        }

        @Override
        public Message generateACK() throws HL7Exception, IOException {
            return ((Message)this.getDelegate()).generateACK();
        }

        @Override
        public Message generateACK(String theAcknowlegementCode, HL7Exception theException) throws HL7Exception, IOException {
            return ((Message)this.getDelegate()).generateACK(theAcknowlegementCode, theException);
        }

        @Override
        public Message generateACK(AcknowledgmentCode theAcknowlegementCode, HL7Exception theException) throws HL7Exception, IOException {
            return ((Message)this.getDelegate()).generateACK(theAcknowlegementCode, theException);
        }

        @Override
        public String printStructure() throws HL7Exception {
            return ((Message)this.getDelegate()).printStructure();
        }
    }

    private static interface UnmodifiableModel {
    }

    private static class UnmodifiablePrimitive
    extends UnmodifiableType<Primitive>
    implements Primitive {
        public UnmodifiablePrimitive(Primitive delegate) {
            super(delegate);
        }

        @Override
        public String getValue() {
            return ((Primitive)this.getDelegate()).getValue();
        }

        @Override
        public void setValue(String value) {
            throw new UnsupportedOperationException("This Primitive is unmodifiable");
        }
    }

    private static class UnmodifiableComposite
    extends UnmodifiableType<Composite>
    implements Composite {
        public UnmodifiableComposite(Composite delegate) {
            super(delegate);
        }

        @Override
        public Type[] getComponents() {
            Type[] types = ((Composite)this.getDelegate()).getComponents();
            Type[] unmodifiableTypes = new Type[types.length];
            if (types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    unmodifiableTypes[i] = Unmodifiable.unmodifiableType(types[i]);
                }
            }
            return unmodifiableTypes;
        }

        @Override
        public Type getComponent(int number) throws DataTypeException {
            Type type = ((Composite)this.getDelegate()).getComponent(number);
            return Unmodifiable.unmodifiableType(type);
        }
    }

    private static class UnmodifiableVaries
    extends UnmodifiableType<Variable>
    implements Variable {
        public UnmodifiableVaries(Variable delegate) {
            super(delegate);
        }

        @Override
        public Type getData() {
            return Unmodifiable.unmodifiableType(((Variable)this.getDelegate()).getData());
        }

        @Override
        public void setData(Type data) {
            throw new UnsupportedOperationException("This Varies is unmodifiable");
        }
    }

    private static class UnmodifiableGroup<S extends Group>
    extends UnmodifiableStructure<S>
    implements Group {
        public UnmodifiableGroup(S delegate) {
            super(delegate);
        }

        @Override
        public Structure[] getAll(String name) throws HL7Exception {
            Structure[] structures = ((Group)this.getDelegate()).getAll(name);
            Structure[] unmodifiableStructures = new Structure[structures.length];
            if (structures.length > 0) {
                for (int i = 0; i < structures.length; ++i) {
                    unmodifiableStructures[i] = Unmodifiable.unmodifiableStructure(structures[i]);
                }
            }
            return unmodifiableStructures;
        }

        @Override
        public Structure get(String name) throws HL7Exception {
            return this.get(name, 0);
        }

        @Override
        public Structure get(String name, int rep) throws HL7Exception {
            return this.getAll(name)[rep];
        }

        @Override
        public boolean isRequired(String name) throws HL7Exception {
            return ((Group)this.getDelegate()).isRequired(name);
        }

        @Override
        public boolean isRepeating(String name) throws HL7Exception {
            return ((Group)this.getDelegate()).isRepeating(name);
        }

        @Override
        public boolean isChoiceElement(String name) throws HL7Exception {
            return ((Group)this.getDelegate()).isChoiceElement(name);
        }

        @Override
        public boolean isGroup(String name) throws HL7Exception {
            return ((Group)this.getDelegate()).isGroup(name);
        }

        @Override
        public String[] getNames() {
            return ((Group)this.getDelegate()).getNames();
        }

        @Override
        public Class<? extends Structure> getClass(String name) {
            return ((Group)this.getDelegate()).getClass(name);
        }

        @Override
        public String addNonstandardSegment(String name) {
            throw new UnsupportedOperationException("This group is unmodifiable");
        }

        @Override
        public String addNonstandardSegment(String name, int theIndex) {
            throw new UnsupportedOperationException("This group is unmodifiable");
        }
    }

    private static class UnmodifiableSegment<S extends Segment>
    extends UnmodifiableStructure<S>
    implements Segment {
        public UnmodifiableSegment(S delegate) {
            super(delegate);
        }

        @Override
        public String encode() throws HL7Exception {
            return ((Segment)this.getDelegate()).encode();
        }

        @Override
        public Type[] getField(int number) throws HL7Exception {
            if (number < 1 || number > this.numFields()) {
                throw new IllegalArgumentException(String.format("Cannot add field with index %d to unmodifiable segment %s  - there are currently only %d fields.", number, this.getName(), this.numFields()));
            }
            Type[] types = ((Segment)this.getDelegate()).getField(number);
            Type[] unmodifiableTypes = new Type[types.length];
            if (types.length > 0) {
                for (int i = 0; i < types.length; ++i) {
                    unmodifiableTypes[i] = Unmodifiable.unmodifiableType(types[i]);
                }
            }
            return unmodifiableTypes;
        }

        @Override
        public Type getField(int number, int rep) throws HL7Exception {
            Type[] types = this.getField(number);
            if (rep >= types.length) {
                throw new IllegalArgumentException(String.format("Cannot add repetition with index %d to unmodifiable field %d  - there are currently only %d fields.", rep, number, types.length));
            }
            return types[rep];
        }

        @Override
        public int getLength(int number) throws HL7Exception {
            return ((Segment)this.getDelegate()).getLength(number);
        }

        @Override
        public int getMaxCardinality(int number) throws HL7Exception {
            return ((Segment)this.getDelegate()).getMaxCardinality(number);
        }

        @Override
        public String[] getNames() {
            return ((Segment)this.getDelegate()).getNames();
        }

        @Override
        public boolean isRequired(int number) throws HL7Exception {
            return ((Segment)this.getDelegate()).isRequired(number);
        }

        @Override
        public int numFields() {
            return ((Segment)this.getDelegate()).numFields();
        }

        @Override
        public void parse(String string) {
            throw new UnsupportedOperationException("This segment is unmodifiable");
        }
    }

    private static class UnmodifiableMessageVisitor
    extends Delegating<MessageVisitor>
    implements MessageVisitor,
    UnmodifiableModel {
        public UnmodifiableMessageVisitor(MessageVisitor delegate) {
            super(delegate);
        }

        @Override
        public boolean start(Message message) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).start(Unmodifiable.unmodifiableMessage(message));
        }

        @Override
        public boolean end(Message message) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).end(Unmodifiable.unmodifiableMessage(message));
        }

        @Override
        public boolean start(Group group, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).start(Unmodifiable.unmodifiableStructure(group), location);
        }

        @Override
        public boolean end(Group group, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).end(Unmodifiable.unmodifiableStructure(group), location);
        }

        @Override
        public boolean start(Segment segment, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).start(Unmodifiable.unmodifiableStructure(segment), location);
        }

        @Override
        public boolean end(Segment segment, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).end(Unmodifiable.unmodifiableStructure(segment), location);
        }

        @Override
        public boolean start(Field field, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).start(field, location);
        }

        @Override
        public boolean end(Field field, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).end(field, location);
        }

        @Override
        public boolean start(Composite type, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).start(Unmodifiable.unmodifiableType(type), location);
        }

        @Override
        public boolean end(Composite type, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).end(Unmodifiable.unmodifiableType(type), location);
        }

        @Override
        public boolean visit(Primitive type, Location location) throws HL7Exception {
            return ((MessageVisitor)this.getDelegate()).visit(Unmodifiable.unmodifiableType(type), location);
        }
    }

    private static class UnmodifiableExtraComponents
    extends ExtraComponents {
        private final ExtraComponents delegate;

        public UnmodifiableExtraComponents(ExtraComponents delegate) {
            super(delegate.getMessage());
            this.delegate = delegate;
        }

        @Override
        public int numComponents() {
            return this.delegate.numComponents();
        }

        @Override
        public boolean isEmpty() throws HL7Exception {
            return this.delegate.isEmpty();
        }

        @Override
        public Message getMessage() {
            return Unmodifiable.unmodifiableMessage(this.delegate.getMessage());
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public Variable getComponent(int comp) {
            if (comp >= this.numComponents()) {
                throw new IllegalArgumentException(String.format("Extra Component with index %d is not available and cannot be added to unmodifiable type", comp));
            }
            return Unmodifiable.unmodifiableType(this.delegate.getComponent(comp));
        }

        @Override
        void clear() {
            throw new UnsupportedOperationException("This ExtraComponents is unmodifiable");
        }
    }

    private static abstract class UnmodifiableType<T extends Type>
    extends UnmodifiableVisitable<T>
    implements Type {
        public UnmodifiableType(T delegate) {
            super(delegate);
        }

        @Override
        public String getName() {
            return ((Type)this.getDelegate()).getName();
        }

        @Override
        public ExtraComponents getExtraComponents() {
            return Unmodifiable.unmodifiableExtraComponents(((Type)this.getDelegate()).getExtraComponents());
        }

        @Override
        public Message getMessage() {
            return Unmodifiable.unmodifiableMessage(((Type)this.getDelegate()).getMessage());
        }

        @Override
        public void parse(String string) {
            throw new UnsupportedOperationException("This type is unmodifiable");
        }

        @Override
        public String encode() throws HL7Exception {
            return ((Type)this.getDelegate()).encode();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("This type is unmodifiable");
        }

        @Override
        public Location provideLocation(Location parentLocation, int index, int repetition) {
            return ((Type)this.getDelegate()).provideLocation(parentLocation, index, repetition);
        }
    }

    private static abstract class UnmodifiableStructure<S extends Structure>
    extends UnmodifiableVisitable<S>
    implements Structure {
        private UnmodifiableStructure(S delegate) {
            super(delegate);
        }

        @Override
        public Message getMessage() {
            return ((Structure)this.getDelegate()).getMessage();
        }

        @Override
        public String getName() {
            return ((Structure)this.getDelegate()).getName();
        }

        @Override
        public Group getParent() {
            return Unmodifiable.unmodifiableStructure(((Structure)this.getDelegate()).getParent());
        }
    }

    private static class UnmodifiableVisitable<S extends Visitable>
    extends Delegating<S>
    implements Visitable,
    UnmodifiableModel {
        public UnmodifiableVisitable(S delegate) {
            super(delegate);
        }

        @Override
        public boolean accept(MessageVisitor visitor, Location currentLocation) throws HL7Exception {
            return ((Visitable)this.getDelegate()).accept(Unmodifiable.unmodifiableVisitor(visitor), currentLocation);
        }

        @Override
        public Location provideLocation(Location parentLocation, int index, int repetition) {
            return ((Visitable)this.getDelegate()).provideLocation(parentLocation, index, repetition);
        }

        @Override
        public boolean isEmpty() throws HL7Exception {
            return ((Visitable)this.getDelegate()).isEmpty();
        }
    }

    private static class Delegating<S> {
        private final S delegate;

        protected Delegating(S delegate) {
            this.delegate = delegate;
        }

        public S getDelegate() {
            return this.delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Delegating) {
                Delegating that = (Delegating)o;
                return this.delegate.equals(that.delegate);
            }
            if (o.getClass().isAssignableFrom(this.delegate.getClass())) {
                return this.delegate.equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

