/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.util.XMLUtils;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXMLParser
extends XMLParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultXMLParser.class);
    private static final Set<String> ourForceGroupNames = new HashSet<String>();

    public DefaultXMLParser() {
    }

    public DefaultXMLParser(HapiContext context) {
        super(context);
    }

    public DefaultXMLParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    @Override
    public Document encodeDocument(Message source) throws HL7Exception {
        String messageClassName = source.getClass().getName();
        String messageName = messageClassName.substring(messageClassName.lastIndexOf(46) + 1);
        if (source instanceof GenericMessage) {
            messageName = messageName.replaceAll("\\$", "");
        }
        try {
            Document doc = XMLUtils.emptyDocument(messageName);
            this.encode((Group)source, doc.getDocumentElement());
            return doc;
        }
        catch (Exception e) {
            throw new HL7Exception("Can't create XML document - " + e.getClass().getName(), e);
        }
    }

    private void encode(Group groupObject, Element groupElement) throws HL7Exception {
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        try {
            for (String name : childNames) {
                Structure[] reps;
                for (Structure rep : reps = groupObject.getAll(name)) {
                    Element childElement;
                    String elementName = DefaultXMLParser.makeGroupElementName(messageName, name);
                    try {
                        childElement = groupElement.getOwnerDocument().createElementNS("urn:hl7-org:v2xml", elementName);
                    }
                    catch (DOMException e) {
                        throw new HL7Exception("Can't encode element " + elementName + " in group " + groupObject.getClass().getName(), e);
                    }
                    groupElement.appendChild(childElement);
                    if (rep instanceof Group) {
                        this.encode((Group)rep, childElement);
                        continue;
                    }
                    if (!(rep instanceof Segment)) continue;
                    this.encode((Segment)rep, childElement);
                }
            }
        }
        catch (DOMException e) {
            throw new HL7Exception("Can't encode group " + groupObject.getClass().getName(), e);
        }
    }

    @Override
    public Message parseDocument(Document xmlMessage, String version) throws HL7Exception {
        this.assertNamespaceURI(xmlMessage.getDocumentElement().getNamespaceURI());
        Message message = this.instantiateMessage(xmlMessage.getDocumentElement().getLocalName(), version, true);
        message.setParser(this);
        this.parse((Group)message, xmlMessage.getDocumentElement());
        return message;
    }

    private void parse(Group groupObject, Element groupElement) throws HL7Exception {
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        NodeList allChildNodes = groupElement.getChildNodes();
        ArrayList<String> unparsedElementList = new ArrayList<String>();
        for (int i = 0; i < allChildNodes.getLength(); ++i) {
            Node node = allChildNodes.item(i);
            String name = node.getLocalName();
            if (node.getNodeType() != 1 || unparsedElementList.contains(name)) continue;
            this.assertNamespaceURI(node.getNamespaceURI());
            unparsedElementList.add(name);
        }
        String[] stringArray = childNames;
        int node = stringArray.length;
        for (int name = 0; name < node; ++name) {
            String nextChildName;
            String childName = nextChildName = stringArray[name];
            if (groupObject.isGroup(nextChildName)) {
                childName = DefaultXMLParser.makeGroupElementName(groupObject.getMessage().getName(), nextChildName);
            }
            unparsedElementList.remove(childName);
            if (nextChildName.length() == 4 && Character.isDigit(nextChildName.charAt(3))) {
                log.trace("Skipping rep segment: {}", (Object)nextChildName);
                continue;
            }
            this.parseReps(groupElement, groupObject, messageName, nextChildName, nextChildName);
        }
        for (String segName : unparsedElementList) {
            String segIndexName = groupObject.addNonstandardSegment(segName);
            this.parseReps(groupElement, groupObject, messageName, segName, segIndexName);
        }
    }

    private void parseReps(Element groupElement, Group groupObject, String messageName, String childName, String childIndexName) throws HL7Exception {
        block7: {
            List<Element> reps;
            block6: {
                String groupName = DefaultXMLParser.makeGroupElementName(messageName, childName);
                reps = this.getChildElementsByTagName(groupElement, groupName);
                log.trace("# of elements matching {}: {}", (Object)groupName, (Object)reps.size());
                if (!groupObject.isRepeating(childIndexName)) break block6;
                for (int i = 0; i < reps.size(); ++i) {
                    this.parseRep(reps.get(i), groupObject.get(childIndexName, i));
                }
                break block7;
            }
            if (reps.size() > 0) {
                this.parseRep(reps.get(0), groupObject.get(childIndexName, 0));
            }
            if (reps.size() <= 1) break block7;
            int i = 1;
            try {
                for (i = 1; i < reps.size(); ++i) {
                    String newIndexName = childName + (i + 1);
                    Structure st = groupObject.get(newIndexName);
                    this.parseRep(reps.get(i), st);
                }
            }
            catch (Throwable t) {
                log.info("Issue Parsing: " + t);
                String newIndexName = groupObject.addNonstandardSegment(childName);
                for (int j = i; j < reps.size(); ++j) {
                    this.parseRep(reps.get(j), groupObject.get(newIndexName, j - i));
                }
            }
        }
    }

    private void parseRep(Element theElem, Structure theObj) throws HL7Exception {
        if (theObj instanceof Group) {
            this.parse((Group)theObj, theElem);
        } else if (theObj instanceof Segment) {
            this.parse((Segment)theObj, theElem);
        }
        log.trace("Parsed element: {}", (Object)theElem.getNodeName());
    }

    private List<Element> getChildElementsByTagName(Element theElement, String theName) throws HL7Exception {
        ArrayList<Element> result = new ArrayList<Element>(10);
        NodeList children = theElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getLocalName().equals(theName)) continue;
            this.assertNamespaceURI(child.getNamespaceURI());
            result.add((Element)child);
        }
        return result;
    }

    protected static String makeGroupElementName(String messageName, String className) {
        Object ret = className.length() > 4 || ourForceGroupNames.contains(className) ? messageName + "." + className : (className.length() == 4 ? className.substring(0, 3) : className);
        return ret;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: DefaultXMLParser pipe_encoded_file");
            System.exit(1);
        }
        try {
            File messageFile = new File(args[0]);
            long fileLength = messageFile.length();
            FileReader r = new FileReader(messageFile);
            char[] cbuf = new char[(int)fileLength];
            System.out.println("Reading message file ... " + r.read(cbuf) + " of " + fileLength + " chars");
            r.close();
            String messString = String.valueOf(cbuf);
            Parser inParser = null;
            Parser outParser = null;
            PipeParser pp = new PipeParser();
            DefaultXMLParser xp = new DefaultXMLParser();
            System.out.println("Encoding: " + pp.getEncoding(messString));
            if (pp.getEncoding(messString) != null) {
                inParser = pp;
                outParser = xp;
            } else if (xp.getEncoding(messString) != null) {
                inParser = xp;
                outParser = pp;
            }
            Message mess = ((Parser)inParser).parse(messString);
            System.out.println("Got message of type " + mess.getClass().getName());
            String otherEncoding = outParser.encode(mess);
            System.out.println(otherEncoding);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void parse(Message theMessage, String theString) throws HL7Exception {
        theMessage.setParser(this);
        Document doc = this.parseStringIntoDocument(theString);
        this.parse((Group)theMessage, doc.getDocumentElement());
        this.applySuperStructureName(theMessage);
    }

    public static XMLParser getInstanceWithNoValidation() {
        DefaultHapiContext context = new DefaultHapiContext(ValidationContextFactory.noValidation());
        return context.getXMLParser();
    }

    static {
        ourForceGroupNames.add("DIET");
    }
}

