/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseChecker {
    private static final Logger log = LoggerFactory.getLogger(ParseChecker.class);

    public static void checkParse(String originalMessageText, Message parsedMessage, Parser parser) throws HL7Exception {
        log.info("ParseChecker is checking parse integrity (turn this off if you are not testing)");
        String newMessageText = parser.encode(parsedMessage);
        log.info("******************* Comparing Messages ****************\r\n");
        log.info("Original:           {}", (Object)originalMessageText);
        log.info("Parsed and Encoded: {}", (Object)newMessageText);
        if (!originalMessageText.equals(newMessageText)) {
            StringTokenizer tok = new StringTokenizer(originalMessageText, "\r");
            ArrayList<String> one = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg.length() <= 4) continue;
                one.add(seg);
            }
            tok = new StringTokenizer(newMessageText, "\r");
            ArrayList<String> two = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg.length() <= 4) continue;
                two.add(ParseChecker.stripExtraDelimiters(seg, seg.charAt(3)));
            }
            if (one.size() != two.size()) {
                log.info("Warning: inbound and parsed messages have different numbers of segments: \r\n");
                log.info("Original: {}", (Object)originalMessageText);
                log.info("Parsed:   {}", (Object)newMessageText);
            } else {
                for (int i = 0; i < one.size(); ++i) {
                    String newSeg;
                    String origSeg = (String)one.get(i);
                    if (origSeg.equals(newSeg = (String)two.get(i))) continue;
                    log.info("Warning: inbound and parsed message segment differs: \r\n");
                    log.info("Original: {}", (Object)origSeg);
                    log.info("Parsed:   {}", (Object)newSeg);
                }
            }
        } else {
            log.info("No differences found");
        }
        log.info("********************  End Comparison  ******************\r\n");
    }

    private static String stripExtraDelimiters(String in, char delim) {
        char[] chars = in.toCharArray();
        int c = chars.length - 1;
        boolean found = false;
        while (c >= 0 && !found) {
            if (chars[c--] == delim) continue;
            found = true;
        }
        String ret = "";
        if (found) {
            ret = String.valueOf(chars, 0, c + 2);
        }
        return ret;
    }
}

