/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Predicate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public abstract class BuilderSupport
implements Serializable {
    protected BuilderSupport() {
    }

    public Predicate isEqual(Object expected) {
        return new EqualsPredicate(expected);
    }

    public Predicate isEqualIgnoreCase(Object expected) {
        return new EqualsPredicate(expected, true);
    }

    public Predicate empty() {
        return new EmptyPredicate();
    }

    public Predicate emptyOr(Predicate predicate) {
        return this.anyOf(this.empty(), predicate);
    }

    public Predicate matches(String regex) {
        return new MatchesPredicate(regex);
    }

    public Predicate matches(String regex, String description) {
        return new MatchesPredicate(regex, description);
    }

    public Predicate startsWith(String prefix) {
        return this.matches("^" + prefix + ".*", "starts with " + prefix);
    }

    public Predicate nonNegativeInteger() {
        return this.matches("\\d*", "a non-negative integer (0,1,2,...)");
    }

    public Predicate number() {
        return this.matches("(\\+|\\-)?\\d*\\.?\\d*", "a number with optional decimal digits");
    }

    public Predicate date() {
        return this.matches("(\\d{4}([01]\\d(\\d{2})?)?)?", "a date string (YYYY[MM[DD]])");
    }

    public Predicate time() {
        return this.matches("([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?([\\+\\-]\\d{4})?", "a HL7 time string");
    }

    public Predicate dateTime() {
        return this.matches("(\\d{4}([01]\\d(\\d{2}([012]\\d[0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?", "a HL7 datetime string");
    }

    public Predicate dateTime25() {
        return this.matches("(\\d{4}([01]\\d(\\d{2}([012]\\d([0-5]\\d([0-5]\\d(\\.\\d(\\d(\\d(\\d)?)?)?)?)?)?)?)?)?)?([\\+\\-]\\d{4})?", "a HL7 datetime string");
    }

    public Predicate usPhoneNumber() {
        return this.matches("(\\d{1,2} )?(\\(\\d{3}\\))?\\d{3}-\\d{4}(X\\d{1,5})?(B\\d{1,5})?(C.*)?", "a US phone number");
    }

    public Predicate oid() {
        return this.matches("[0-2](\\.(0|([1-9][0-9]*)))+", "an Object Identifier (OID)");
    }

    public Predicate uuid() {
        return this.matches("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}", "a Unique Universal Identifier (UUID)");
    }

    public Predicate matches(String regex, int flags) {
        return new MatchesPredicate(regex, flags);
    }

    public Predicate in(Object ... allowed) {
        return new InPredicate(Arrays.asList(allowed));
    }

    public Predicate in(Collection<?> allowed) {
        return new InPredicate(allowed);
    }

    public Predicate anyOf(Iterable<Predicate> predicates) {
        return new AnyOfPredicate(predicates);
    }

    public Predicate allOf(Iterable<Predicate> predicates) {
        return new AllOfPredicate(predicates);
    }

    public Predicate anyOf(Predicate ... predicates) {
        return this.anyOf(Arrays.asList(predicates));
    }

    public Predicate allOf(Predicate ... predicates) {
        return this.allOf(Arrays.asList(predicates));
    }

    public Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public Predicate maxLength(int maxSize) {
        return new MaxLengthPredicate(maxSize);
    }

    public Predicate withdrawn() {
        return new WithdrawnPredicate();
    }

    public Predicate always(boolean b) {
        return new AlwaysPredicate(b);
    }

    public Predicate alwaysFails() {
        return this.always(false);
    }

    private static String join(Iterable<?> list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    private static class EqualsPredicate
    implements Predicate {
        private final Object expected;
        private final boolean ignoresCase;

        public EqualsPredicate(Object expected) {
            this(expected, false);
        }

        EqualsPredicate(Object expected, boolean ignoresCase) {
            this.expected = expected;
            this.ignoresCase = ignoresCase;
        }

        @Override
        public boolean evaluate(Object data) {
            if (this.ignoresCase) {
                return data == null && this.expected == null || data != null && data.toString().equalsIgnoreCase(this.expected.toString());
            }
            return data == null && this.expected == null || data != null && data.equals(this.expected);
        }

        @Override
        public String getDescription() {
            return "equal to " + this.expected;
        }
    }

    private static class EmptyPredicate
    implements Predicate {
        @Override
        public boolean evaluate(Object data) {
            return data == null || "".equals(data) || "\"\"".equals(data);
        }

        @Override
        public String getDescription() {
            return "empty";
        }
    }

    private static class MatchesPredicate
    implements Predicate {
        private final Pattern p;
        private final String description;

        public MatchesPredicate(String regex) {
            this(regex, "matching with " + regex);
        }

        public MatchesPredicate(String regex, String description) {
            this.p = Pattern.compile(regex);
            this.description = description;
        }

        public MatchesPredicate(String regex, int flags) {
            this(regex, flags, "matching with " + regex);
        }

        public MatchesPredicate(String regex, int flags, String description) {
            this.p = Pattern.compile(regex);
            this.description = description;
        }

        @Override
        public boolean evaluate(Object data) {
            return data != null && this.p.matcher(data.toString()).matches();
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class InPredicate
    implements Predicate {
        private final Collection<?> allowed;

        InPredicate(Collection<?> allowed) {
            this.allowed = allowed;
        }

        @Override
        public boolean evaluate(Object data) {
            return this.allowed.contains(data);
        }

        @Override
        public String getDescription() {
            return "in [" + BuilderSupport.join(this.allowed, ",") + "]";
        }
    }

    private static class AnyOfPredicate
    implements Predicate {
        private final Iterable<Predicate> predicates;

        public AnyOfPredicate(Iterable<Predicate> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean evaluate(Object data) throws ValidationException {
            for (Predicate p : this.predicates) {
                if (!p.evaluate(data)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            String or = " or ";
            StringBuilder b = new StringBuilder();
            for (Predicate p : this.predicates) {
                b.append(p.getDescription()).append(or);
            }
            return b.substring(0, b.length() - or.length());
        }
    }

    private static class AllOfPredicate
    implements Predicate {
        private final Iterable<Predicate> predicates;

        public AllOfPredicate(Iterable<Predicate> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean evaluate(Object data) throws ValidationException {
            for (Predicate p : this.predicates) {
                if (p.evaluate(data)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getDescription() {
            String and = " and ";
            StringBuilder b = new StringBuilder();
            for (Predicate p : this.predicates) {
                b.append(p.getDescription()).append(and);
            }
            return b.substring(0, b.length() - and.length());
        }
    }

    private static class NotPredicate
    implements Predicate {
        private final Predicate delegate;

        public NotPredicate(Predicate delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean evaluate(Object data) {
            try {
                return !this.delegate.evaluate(data);
            }
            catch (ValidationException e) {
                return true;
            }
        }

        @Override
        public String getDescription() {
            return "not " + this.delegate.getDescription();
        }
    }

    private static class MaxLengthPredicate
    implements Predicate {
        private final int maxLength;

        public MaxLengthPredicate(int maxSize) {
            this.maxLength = maxSize;
        }

        @Override
        public boolean evaluate(Object data) {
            return data == null || data.toString().length() <= this.maxLength;
        }

        @Override
        public String getDescription() {
            return "shorter than " + this.maxLength + " characters";
        }
    }

    private static class WithdrawnPredicate
    extends MaxLengthPredicate {
        public WithdrawnPredicate() {
            super(0);
        }

        @Override
        public String getDescription() {
            return "empty because it is withdrawn from the current HL7 version and should not be used";
        }
    }

    private static class AlwaysPredicate
    implements Predicate {
        private final boolean b;

        AlwaysPredicate(boolean b) {
            this.b = b;
        }

        @Override
        public boolean evaluate(Object data) {
            return this.b;
        }

        @Override
        public String getDescription() {
            return this.b ? "anything" : "nothing";
        }
    }
}

