/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.util.Terser;

public abstract class AbstractHL7Exception
extends Exception {
    private Location location;
    private ErrorCode errorCode = ErrorCode.APPLICATION_INTERNAL_ERROR;
    private Severity severity = Severity.ERROR;
    private Message responseMessage;

    public AbstractHL7Exception() {
    }

    public AbstractHL7Exception(String message, Throwable cause) {
        super(message, cause);
    }

    public AbstractHL7Exception(String message) {
        super(message);
    }

    public AbstractHL7Exception(Throwable cause) {
        super(cause);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setFieldPosition(int pos) {
        if (this.location == null) {
            this.location = new Location();
        }
        this.location.withField(pos);
    }

    public void setSegmentName(String segmentName) {
        if (this.location == null) {
            this.location = new Location();
        }
        this.location.withSegmentName(segmentName);
    }

    public void setSegmentRepetition(int segmentRepetition) {
        if (this.location == null) {
            this.location = new Location();
        }
        this.location.withSegmentRepetition(segmentRepetition);
    }

    public int getErrorCode() {
        return this.errorCode.getCode();
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = ErrorCode.errorCodeFor(errorCode);
    }

    public ErrorCode getError() {
        return this.errorCode;
    }

    public void setError(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(Message responseMessage) {
        this.responseMessage = responseMessage;
    }

    public Message populateResponse(Message emptyResponse, AcknowledgmentCode acknowledgmentCode, int repetition) throws HL7Exception {
        if (this.responseMessage == null) {
            if (acknowledgmentCode == null) {
                acknowledgmentCode = AcknowledgmentCode.AA;
            }
            this.responseMessage = Version.V25.isGreaterThan(Version.versionOf(emptyResponse.getVersion())) ? this.populateResponseBefore25(emptyResponse, acknowledgmentCode, repetition) : this.populateResponseAsOf25(emptyResponse, acknowledgmentCode, repetition);
        }
        return this.responseMessage;
    }

    private Message populateResponseAsOf25(Message response, AcknowledgmentCode acknowledgmentCode, int repetition) throws HL7Exception {
        Segment msa = (Segment)response.get("MSA");
        Terser.set(msa, 1, 0, 1, 1, acknowledgmentCode.name());
        Segment err = (Segment)response.get("ERR", repetition);
        if (this.location != null) {
            if (this.location.getSegmentName() != null) {
                Terser.set(err, 2, 0, 1, 1, this.location.getSegmentName());
            }
            if (this.location.getField() > 0) {
                Terser.set(err, 2, 0, 3, 1, Integer.toString(this.location.getField()));
            }
            if (this.location.getFieldRepetition() > 0) {
                Terser.set(err, 2, 0, 4, 1, Integer.toString(this.location.getFieldRepetition()));
            }
            if (this.location.getComponent() > 0) {
                Terser.set(err, 2, 0, 5, 1, Integer.toString(this.location.getComponent()));
            }
            if (this.location.getSubcomponent() > 0) {
                Terser.set(err, 2, 0, 6, 1, Integer.toString(this.location.getSubcomponent()));
            }
        }
        Terser.set(err, 3, 0, 1, 1, Integer.toString(this.errorCode.getCode()));
        Terser.set(err, 3, 0, 2, 1, this.errorCode.getMessage());
        Terser.set(err, 3, 0, 3, 1, ErrorCode.codeTable());
        Terser.set(err, 3, 0, 9, 1, this.getMessage());
        Terser.set(err, 4, 0, 1, 1, "E");
        return response;
    }

    private Message populateResponseBefore25(Message response, AcknowledgmentCode acknowledgmentCode, int repetition) throws HL7Exception {
        Segment msa = (Segment)response.get("MSA");
        Terser.set(msa, 1, 0, 1, 1, acknowledgmentCode.name());
        Terser.set(msa, 3, 0, 1, 1, this.errorCode.getMessage());
        Segment err = (Segment)response.get("ERR");
        if (this.location != null) {
            if (this.location.getSegmentName() != null) {
                Terser.set(err, 1, repetition, 1, 1, this.location.getSegmentName());
            }
            if (this.location.getField() > 0) {
                Terser.set(err, 1, repetition, 3, 1, Integer.toString(this.location.getField()));
            }
        }
        Terser.set(err, 1, repetition, 4, 1, Integer.toString(this.errorCode.getCode()));
        Terser.set(err, 1, repetition, 4, 2, this.errorCode.getMessage());
        Terser.set(err, 1, repetition, 4, 3, ErrorCode.codeTable());
        Terser.set(err, 1, repetition, 4, 5, this.getMessage());
        return response;
    }

    public String getMessage() {
        String message = this.getMessageWithoutLocation();
        StringBuilder msg = new StringBuilder(message);
        if (this.getLocation() != null && !this.getLocation().isUnknown()) {
            msg.append(" at ").append(this.getLocation().toString());
        }
        return msg.toString();
    }

    public String getMessageWithoutLocation() {
        String message = super.getMessage();
        if (message == null) {
            message = "Exception";
        }
        return message;
    }
}

